-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Servidor: 127.0.0.1:3306
-- Tiempo de generación: 22-01-2026 a las 15:54:47
-- Versión del servidor: 9.1.0
-- Versión de PHP: 8.3.14

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de datos: `efac`
--

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `areas`
--

DROP TABLE IF EXISTS `areas`;
CREATE TABLE IF NOT EXISTS `areas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_escuela` int NOT NULL,
  `codigo` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `codigo` (`codigo`),
  KEY `id_escuela` (`id_escuela`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `areas`
--

INSERT INTO `areas` (`id`, `id_escuela`, `codigo`, `nombre`, `created_at`) VALUES
(32, 20, '1', 'musica', '2026-01-08 16:58:42'),
(33, 21, '2', 'MURALISMO', '2026-01-22 12:58:03'),
(34, 21, '3', 'DIBUJO', '2026-01-22 12:58:09');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `asistencia_cursos`
--

DROP TABLE IF EXISTS `asistencia_cursos`;
CREATE TABLE IF NOT EXISTS `asistencia_cursos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `documento` varchar(20) NOT NULL COMMENT 'Documento del usuario',
  `nompa` varchar(100) DEFAULT NULL COMMENT 'Nombre del usuario',
  `apepa` varchar(100) DEFAULT NULL COMMENT 'Apellido del usuario',
  `idcurso` int NOT NULL COMMENT 'ID del curso',
  `fecha` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `tipo` enum('ENTRADA','SALIDA') NOT NULL DEFAULT 'ENTRADA',
  `motivo` text,
  PRIMARY KEY (`id`),
  KEY `idx_documento` (`documento`),
  KEY `idx_idcurso` (`idcurso`),
  KEY `idx_fecha` (`fecha`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Tabla de asistencia exclusiva para cursos';

--
-- Volcado de datos para la tabla `asistencia_cursos`
--

INSERT INTO `asistencia_cursos` (`id`, `documento`, `nompa`, `apepa`, `idcurso`, `fecha`, `tipo`, `motivo`) VALUES
(19, '7777777', 'ANDRES', 'FELIPE MERCHAN SEGUNDO', 64, '2026-01-08 17:12:09', 'ENTRADA', ''),
(18, '7777777', 'ANDRES', 'FELIPE MERCHAN SEGUNDO', 64, '2026-01-08 17:11:43', 'ENTRADA', ''),
(17, '1007863612', 'DIYER ALEXIS', 'ROJAS CUBILLOS', 64, '2026-01-08 17:11:24', 'SALIDA', ''),
(16, '1007863612', 'DIYER ALEXIS', 'ROJAS CUBILLOS', 64, '2026-01-08 17:08:03', 'ENTRADA', ''),
(20, '489484454', 'DANIELA SAD', 'SED SADD SADD', 65, '2026-01-22 15:17:36', 'ENTRADA', '');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `asistencia_qr`
--

DROP TABLE IF EXISTS `asistencia_qr`;
CREATE TABLE IF NOT EXISTS `asistencia_qr` (
  `id` int NOT NULL AUTO_INCREMENT,
  `documento` varchar(20) NOT NULL,
  `nompa` varchar(100) DEFAULT NULL,
  `apepa` varchar(100) DEFAULT NULL,
  `fecha` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `tipo` enum('ENTRADA','SALIDA') NOT NULL DEFAULT 'ENTRADA',
  `motivo` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Volcado de datos para la tabla `asistencia_qr`
--

INSERT INTO `asistencia_qr` (`id`, `documento`, `nompa`, `apepa`, `fecha`, `tipo`, `motivo`) VALUES
(54, '489484454', 'DANIELA SAD', 'SED SADD SADD', '2026-01-22 15:21:52', 'ENTRADA', ''),
(53, '6666666', 'FABIAN CAMILO', 'MARENTES FLORES', '2026-01-08 17:25:24', 'ENTRADA', ''),
(52, '6666666', 'FABIAN CAMILO', 'MARENTES FLORES', '2026-01-08 17:18:53', 'ENTRADA', ''),
(51, '6666666', 'FABIAN CAMILO', 'MARENTES FLORES', '2026-01-08 17:18:35', 'ENTRADA', '');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `base`
--

DROP TABLE IF EXISTS `base`;
CREATE TABLE IF NOT EXISTS `base` (
  `idb` int NOT NULL AUTO_INCREMENT,
  `base` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`idb`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `base`
--

INSERT INTO `base` (`idb`, `base`) VALUES
(1, 'citas_medicas.sql');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `cart`
--

DROP TABLE IF EXISTS `cart`;
CREATE TABLE IF NOT EXISTS `cart` (
  `idv` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `idprcd` int NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  PRIMARY KEY (`idv`),
  KEY `user_id` (`user_id`),
  KEY `idprcd` (`idprcd`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `category`
--

DROP TABLE IF EXISTS `category`;
CREATE TABLE IF NOT EXISTS `category` (
  `idcat` int NOT NULL AUTO_INCREMENT,
  `nomcat` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idcat`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `category`
--

INSERT INTO `category` (`idcat`, `nomcat`, `state`, `fere`) VALUES
(2, 'Excipientes', '1', '2022-10-25 07:19:44'),
(3, 'Analgésicos', '1', '2022-10-25 07:28:01'),
(4, 'Antiinflamatorios', '1', '2022-10-25 07:19:58'),
(5, 'Antipiréticos', '1', '2022-10-25 07:20:04'),
(6, 'Laxantes', '1', '2022-10-25 07:27:56'),
(7, 'Antiinfecciosos', '1', '2022-10-25 07:20:18'),
(8, 'Antitusivos', '1', '2022-10-25 07:20:27');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `ciclo_vital`
--

DROP TABLE IF EXISTS `ciclo_vital`;
CREATE TABLE IF NOT EXISTS `ciclo_vital` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre_ciclo` varchar(100) COLLATE utf8mb4_spanish_ci NOT NULL,
  `min_edad` int NOT NULL,
  `max_edad` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_spanish_ci;

--
-- Volcado de datos para la tabla `ciclo_vital`
--

INSERT INTO `ciclo_vital` (`id`, `nombre_ciclo`, `min_edad`, `max_edad`) VALUES
(1, 'Primera infancia', 0, 5),
(2, 'Infancia', 6, 11),
(3, 'Adolescencia temprana', 12, 13),
(4, 'Adolescencia', 14, 17),
(5, 'Juventud', 18, 28),
(6, 'Adulto', 29, 50),
(7, 'Adulto maduro', 51, 59),
(8, 'Adulto mayor', 60, 150);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `consult`
--

DROP TABLE IF EXISTS `consult`;
CREATE TABLE IF NOT EXISTS `consult` (
  `idconslt` int NOT NULL AUTO_INCREMENT,
  `mtcl` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `idpa` int NOT NULL,
  `nompa` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `signo_vital` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `SV` varchar(22) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `FC` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `FR` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TMP` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `T` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `P` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `IMC` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `PA` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `PC` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `GL` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TV` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TA` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `CB_CL` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `NEU` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TRX` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `DOR` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ABD` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `PIE` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `GUN` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `EXT` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `LIM` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`idconslt`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `consult`
--

INSERT INTO `consult` (`idconslt`, `mtcl`, `idpa`, `nompa`, `state`, `fere`, `signo_vital`, `SV`, `FC`, `FR`, `TMP`, `T`, `P`, `IMC`, `PA`, `PC`, `GL`, `TV`, `TA`, `CB_CL`, `NEU`, `TRX`, `DOR`, `ABD`, `PIE`, `GUN`, `EXT`, `LIM`) VALUES
(1, '12132', 12, 'admin', '1', '2025-12-22 17:02:02', '', '123', '123123', '132', '132', '132', '132', '132321', '321', '321', '321', '321', '321321', '', '321', '321', '132', '321321', 'q132', '321', '321', '321');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `cursos`
--

DROP TABLE IF EXISTS `cursos`;
CREATE TABLE IF NOT EXISTS `cursos` (
  `idcurso` int NOT NULL AUTO_INCREMENT,
  `codigo` varchar(50) DEFAULT NULL,
  `id_area` int DEFAULT NULL,
  `nombre` varchar(100) NOT NULL,
  `cupos` int NOT NULL DEFAULT '0' COMMENT 'Número máximo de estudiantes permitidos',
  `quien_lo_da` varchar(100) NOT NULL,
  `es_titulado` enum('sí','no') NOT NULL,
  `en_que` varchar(150) DEFAULT NULL,
  `dias_clase` varchar(255) DEFAULT NULL,
  `horario_clase` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`idcurso`),
  KEY `fk_curso_area` (`id_area`)
) ENGINE=MyISAM AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Volcado de datos para la tabla `cursos`
--

INSERT INTO `cursos` (`idcurso`, `codigo`, `id_area`, `nombre`, `cupos`, `quien_lo_da`, `es_titulado`, `en_que`, `dias_clase`, `horario_clase`) VALUES
(65, '2', 33, 'Boceto', 20, 'Fontecha Fontecha', 'sí', '', NULL, NULL),
(64, '1', 32, 'guitarra', 20, 'Catalina Suarez', 'sí', '', NULL, NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `cursos_grupos`
--

DROP TABLE IF EXISTS `cursos_grupos`;
CREATE TABLE IF NOT EXISTS `cursos_grupos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_curso` int NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `horario` varchar(100) DEFAULT NULL,
  `dias_clase` varchar(255) DEFAULT NULL,
  `cupos` int DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_curso` (`id_curso`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Volcado de datos para la tabla `cursos_grupos`
--

INSERT INTO `cursos_grupos` (`id`, `id_curso`, `nombre`, `horario`, `dias_clase`, `cupos`) VALUES
(24, 65, 'Grupo Ad', '09:21 AM - 02:21 PM', 'Lunes, Miércoles, Jueves, Viernes', 5);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `curso_contenido`
--

DROP TABLE IF EXISTS `curso_contenido`;
CREATE TABLE IF NOT EXISTS `curso_contenido` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_curso` int NOT NULL,
  `id_modulo` int NOT NULL,
  `titulo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'Nuevo Contenido',
  `tipo` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT 'html',
  `contenido` longtext COLLATE utf8mb4_unicode_ci,
  `fecha_limite` datetime DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `curso_contenido`
--

INSERT INTO `curso_contenido` (`id`, `id_curso`, `id_modulo`, `titulo`, `tipo`, `contenido`, `fecha_limite`, `updated_at`) VALUES
(24, 65, 15, 'Foro', 'recurso', '', NULL, '2026-01-22 13:27:47');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `curso_entregas`
--

DROP TABLE IF EXISTS `curso_entregas`;
CREATE TABLE IF NOT EXISTS `curso_entregas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_contenido` int NOT NULL,
  `id_estudiante` int NOT NULL,
  `archivo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `fecha_entrega` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `calificacion` decimal(4,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_contenido` (`id_contenido`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `curso_foros`
--

DROP TABLE IF EXISTS `curso_foros`;
CREATE TABLE IF NOT EXISTS `curso_foros` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_contenido` int NOT NULL,
  `id_usuario` int NOT NULL,
  `comentario` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_contenido` (`id_contenido`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `curso_modulos`
--

DROP TABLE IF EXISTS `curso_modulos`;
CREATE TABLE IF NOT EXISTS `curso_modulos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_curso` int NOT NULL,
  `titulo` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `orden` int DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `curso_modulos`
--

INSERT INTO `curso_modulos` (`id`, `id_curso`, `titulo`, `orden`, `created_at`) VALUES
(1, 33, 'BIENVENIDA', 0, '2025-12-17 18:51:03'),
(2, 33, 'CASA', 0, '2025-12-17 18:51:08'),
(3, 33, 'PERRO', 0, '2025-12-17 18:51:12'),
(4, 33, 'CARROS', 0, '2025-12-17 18:54:23'),
(5, 34, 'BIENVENIDA', 0, '2025-12-17 18:56:26'),
(6, 34, 'SEMANA 1 CLASE 1', 0, '2025-12-17 18:57:02'),
(7, 45, 'CASA', 0, '2025-12-18 13:29:41'),
(8, 49, 'dsa', 0, '2025-12-18 14:50:42'),
(9, 56, 'PRUEBA', 0, '2025-12-18 19:19:49'),
(10, 58, 'binvenida', 0, '2025-12-18 19:37:04'),
(11, 61, 'BIENVENIDA', 0, '2025-12-23 15:42:15'),
(12, 61, 'MODULO 1 ESTAMPADO', 0, '2025-12-23 15:42:23'),
(13, 63, 'Bienvenida', 0, '2025-12-29 19:31:02'),
(14, 63, 'MODULO 1', 0, '2025-12-29 19:31:10'),
(15, 65, 'bienvenida', 0, '2026-01-22 13:27:16');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `doctor`
--

DROP TABLE IF EXISTS `doctor`;
CREATE TABLE IF NOT EXISTS `doctor` (
  `idodc` int NOT NULL AUTO_INCREMENT,
  `ceddoc` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `nodoc` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `apdoc` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `nomesp` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `direcd` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `sexd` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `phd` char(13) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `nacd` date NOT NULL,
  `corr` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `username` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `password` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `rol` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idodc`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `doctor`
--

INSERT INTO `doctor` (`idodc`, `ceddoc`, `nodoc`, `apdoc`, `nomesp`, `direcd`, `sexd`, `phd`, `nacd`, `corr`, `username`, `password`, `rol`, `state`, `fere`) VALUES
(45, '8888888', 'Catalina', 'Suarez', 'Cardiología', 'cra sibate', 'Femenino', '3102994157', '1996-01-01', 'Csuarez@gmail.com', 'Csuarez', '0e0294cf314f080436b5ecf5a426fb1b', '1', '1', '2026-01-08 14:28:32'),
(53, '9999999', 'jhon', 'rubiano', 'Dermatología', 'cra sibate', 'Masculino', '3102994157', '2026-01-20', 'jhon@gmail.com', 'jhon', '4d2ff2f945883e090ac4de4fb9e23fab', '4', '1', '2026-01-08 16:22:40'),
(54, '777777', 'Fontecha', 'Fontecha', 'Gastroenterología', 'cra sibate', 'Masculino', '31029941574', '1996-01-08', 'fontecha@gmail.com', 'Fontecha', 'bf4431385ed90c368c0381ada44cd71a', '2', '1', '2026-01-08 16:27:20'),
(55, '5555555', 'Pablo', 'Vanegas', 'Gastroenterología', 'cr', 'Masculino', '31029941573', '1995-01-19', 'Pablo@gmail.com', 'Pablo', '2e6edb52fa0ea8167a5a621d31937c41', '2', '1', '2026-01-08 16:29:06'),
(58, '444444444', 'rojas', 'rojas', 'Dermatología', 'aaaa', 'Masculino', '545454', '2026-01-29', 'rojas@gmail.com', 'rojas', '8f15160f3cdfbdd3d71d12263a1b9f2f', '4', '1', '2026-01-08 16:57:14');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `document`
--

DROP TABLE IF EXISTS `document`;
CREATE TABLE IF NOT EXISTS `document` (
  `iddoc` int NOT NULL AUTO_INCREMENT,
  `nomfi` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `foto` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `idpa` int NOT NULL,
  `nompa` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`iddoc`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `document`
--

INSERT INTO `document` (`iddoc`, `nomfi`, `foto`, `idpa`, `nompa`, `state`, `fere`) VALUES
(6, 'JUNTA', '233259.jpeg', 644, 'JUAN EVANGELISTA', '1', '2025-12-17 20:34:38'),
(7, '', '640848.pdf', 486, 'ROBERTO', '1', '2025-12-17 20:35:12'),
(8, 'DOCUMENTO DE IDENTIDAD ', '222250.pdf', 644, 'JUAN EVANGELISTA', '1', '2025-12-23 14:52:53'),
(9, 'Documento de identidad', '948144.pdf', 644, 'JUAN EVANGELISTA', '1', '2025-12-23 14:36:11'),
(10, 'Certificado de la EPS', '303298.pdf', 644, 'JUAN EVANGELISTA', '1', '2025-12-23 14:36:11'),
(11, 'Certificado de VCA o Discapacidad', '881512.pdf', 644, 'JUAN EVANGELISTA', '1', '2025-12-23 14:36:11'),
(12, 'Carnet de la Institución educativa', '893700.pdf', 644, 'JUAN EVANGELISTA', '1', '2025-12-23 14:36:11'),
(13, 'Documento de identidad', '490253.pdf', 644, 'JUAN EVANGELISTA', '1', '2025-12-23 14:39:26'),
(14, 'Certificado de la EPS', '684419.pdf', 644, 'JUAN EVANGELISTA', '1', '2025-12-23 14:39:26'),
(15, 'Certificado de VCA o Discapacidad', '51791.pdf', 644, 'JUAN EVANGELISTA', '1', '2025-12-23 14:39:26'),
(16, 'Carnet de la Institución educativa', '89505.pdf', 644, 'JUAN EVANGELISTA', '1', '2025-12-23 14:39:26'),
(17, 'Documento de identidad', '481455.pdf', 644, 'JUAN EVANGELISTA', '1', '2025-12-23 14:43:51'),
(18, 'Certificado de la EPS', '190631.pdf', 644, 'JUAN EVANGELISTA', '1', '2025-12-23 14:43:51'),
(19, 'Carnet de la Institución educativa', '167088.pdf', 644, 'JUAN EVANGELISTA', '1', '2025-12-23 14:43:51'),
(20, 'Documento de identidad', '212912.pdf', 75, 'SADSAD SADAS SADD ASD', '1', '2025-12-23 14:59:57'),
(21, 'Documento de identidad', '869511.pdf', 69, 'ANDRES FELIPE MERCHAN ARIZA', '1', '2025-12-23 15:06:51'),
(22, 'Certificado de la EPS', '559887.pdf', 69, 'ANDRES FELIPE MERCHAN ARIZA', '1', '2025-12-23 15:26:10'),
(23, 'Documento de identidad', '274720.pdf', 83, 'CARLOS PEREZ PEREZ PEREZ', '1', '2025-12-29 19:37:40'),
(24, 'Documento de identidad', '183831.pdf', 107, 'NICOLAS SEGUNDO ROJAS CUBILLOS', '1', '2026-01-22 13:29:49'),
(25, 'Certificado de la EPS', '339800.pdf', 107, 'NICOLAS SEGUNDO ROJAS CUBILLOS', '1', '2026-01-22 13:29:49'),
(26, 'Certificado de VCA o Discapacidad', '580783.pdf', 107, 'NICOLAS SEGUNDO ROJAS CUBILLOS', '1', '2026-01-22 13:29:49'),
(27, 'Carnet de la Institución educativa', '307897.png', 107, 'NICOLAS SEGUNDO ROJAS CUBILLOS', '1', '2026-01-22 13:29:49');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `escuelas_formacion`
--

DROP TABLE IF EXISTS `escuelas_formacion`;
CREATE TABLE IF NOT EXISTS `escuelas_formacion` (
  `id` int NOT NULL AUTO_INCREMENT,
  `codigo` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `codigo` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `escuelas_formacion`
--

INSERT INTO `escuelas_formacion` (`id`, `codigo`, `nombre`, `descripcion`, `created_at`) VALUES
(20, '1', 'artes', '', '2026-01-08 16:58:32'),
(21, '2', 'ARTES', 'ARTES', '2026-01-22 12:57:47'),
(22, '3', 'Instituto Tecnico laboral la Quinta', '', '2026-01-22 13:02:08');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `events`
--

DROP TABLE IF EXISTS `events`;
CREATE TABLE IF NOT EXISTS `events` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `idpa` int NOT NULL,
  `idodc` int NOT NULL,
  `idlab` int NOT NULL,
  `color` char(14) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `start` datetime NOT NULL,
  `end` datetime DEFAULT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `monto` decimal(10,2) NOT NULL,
  `chec` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idpa` (`idpa`),
  KEY `idodc` (`idodc`),
  KEY `idlab` (`idlab`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `fisioterapia`
--

DROP TABLE IF EXISTS `fisioterapia`;
CREATE TABLE IF NOT EXISTS `fisioterapia` (
  `id` int NOT NULL AUTO_INCREMENT,
  `idpa` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nompa` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fere` datetime NOT NULL,
  `sentarse_levantarse` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `flexiones_brazo` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `flexion_tronco` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `juntar_manos_atras` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `romberg` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ipaq` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `alcance_funcional` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `barthel` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `funcionalidad` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `state` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idpa` (`idpa`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `fisioterapia`
--

INSERT INTO `fisioterapia` (`id`, `idpa`, `nompa`, `fere`, `sentarse_levantarse`, `flexiones_brazo`, `flexion_tronco`, `juntar_manos_atras`, `romberg`, `ipaq`, `alcance_funcional`, `barthel`, `funcionalidad`, `state`) VALUES
(2, '12', 'admin', '2025-12-22 12:01:11', '465', '21315', '132', '5', 'sadas', '54', '5123', '123', '123', 1),
(3, '12', 'admin', '2025-12-22 12:01:19', 'khghj', 'j', 'jh', 'hj', 'h', 'hh', 'k', 'hk', 'hjkkj', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `genogram`
--

DROP TABLE IF EXISTS `genogram`;
CREATE TABLE IF NOT EXISTS `genogram` (
  `idge` int NOT NULL AUTO_INCREMENT,
  `detage` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `idpa` int NOT NULL,
  `nompa` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idge`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `genogram`
--

INSERT INTO `genogram` (`idge`, `detage`, `idpa`, `nompa`, `state`, `fere`) VALUES
(18, 'asdasdas', 12, 'admin', '1', '2025-12-22 17:01:41'),
(19, 'sdasdas', 12, 'admin', '1', '2025-12-22 17:01:49');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `idiom`
--

DROP TABLE IF EXISTS `idiom`;
CREATE TABLE IF NOT EXISTS `idiom` (
  `idoma` int NOT NULL AUTO_INCREMENT,
  `nomidi` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`idoma`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `idiom`
--

INSERT INTO `idiom` (`idoma`, `nomidi`) VALUES
(1, 'Spanish');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `inscripciones`
--

DROP TABLE IF EXISTS `inscripciones`;
CREATE TABLE IF NOT EXISTS `inscripciones` (
  `idins` int NOT NULL AUTO_INCREMENT,
  `documento` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL COMMENT 'Relacionado con patients.numhs',
  `idcurso` int NOT NULL COMMENT 'Relacionado con cursos.idcurso',
  `fecha_inscripcion` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '1' COMMENT '1=Activo, 0=Inactivo',
  `id_grupo` int DEFAULT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idins`),
  KEY `idx_documento` (`documento`),
  KEY `idx_idcurso` (`idcurso`)
) ENGINE=InnoDB AUTO_INCREMENT=116 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `inscripciones`
--

INSERT INTO `inscripciones` (`idins`, `documento`, `idcurso`, `fecha_inscripcion`, `state`, `id_grupo`, `fere`) VALUES
(110, '1007863612', 64, '2026-01-08 17:02:27', '1', NULL, '2026-01-08 17:02:27'),
(111, '7777777', 64, '2026-01-08 17:06:37', '1', NULL, '2026-01-08 17:06:37'),
(112, '7878787878', 64, '2026-01-22 13:07:06', '1', NULL, '2026-01-22 13:07:06'),
(113, '14244444112', 65, '2026-01-22 13:15:12', '1', 24, '2026-01-22 13:22:55'),
(114, '14244444112', 64, '2026-01-22 13:17:51', '1', NULL, '2026-01-22 13:17:51'),
(115, '489484454', 65, '2026-01-22 15:15:02', '1', NULL, '2026-01-22 15:15:02');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `laboratory`
--

DROP TABLE IF EXISTS `laboratory`;
CREATE TABLE IF NOT EXISTS `laboratory` (
  `idlab` int NOT NULL AUTO_INCREMENT,
  `nomlab` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idlab`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `medicamentos`
--

DROP TABLE IF EXISTS `medicamentos`;
CREATE TABLE IF NOT EXISTS `medicamentos` (
  `id_medicamentos` int NOT NULL,
  `idpa` int NOT NULL,
  `nompa` varchar(30) NOT NULL,
  `fere` timestamp NOT NULL,
  `state` varchar(30) NOT NULL,
  `tomam` varchar(30) NOT NULL,
  `cualm` varchar(30) NOT NULL,
  `prescripcion` varchar(30) NOT NULL,
  `automedicacion` varchar(30) NOT NULL,
  `quirurgicos` varchar(30) NOT NULL,
  `hospitalizacion` varchar(30) NOT NULL,
  `traumaticos` varchar(30) NOT NULL,
  `hipertencion` varchar(30) NOT NULL,
  `toxico` varchar(30) NOT NULL,
  `alergico` varchar(30) NOT NULL,
  `infeccioso` varchar(30) NOT NULL,
  `enfermedadr` varchar(30) NOT NULL,
  `ulcera` varchar(30) NOT NULL,
  `lepra` varchar(30) NOT NULL,
  `diabetes` varchar(30) NOT NULL,
  `asma` varchar(30) NOT NULL,
  `cancer` varchar(30) NOT NULL,
  `epoc` varchar(30) NOT NULL,
  `epilepsia` varchar(30) NOT NULL,
  `autoinmunes` varchar(30) NOT NULL,
  `ingresourgencias` varchar(30) NOT NULL,
  `otrom` varchar(30) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `menu_permissions`
--

DROP TABLE IF EXISTS `menu_permissions`;
CREATE TABLE IF NOT EXISTS `menu_permissions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `dashboard` tinyint(1) DEFAULT '1',
  `remisiones` tinyint(1) DEFAULT '0',
  `usuarios` tinyint(1) DEFAULT '0',
  `cursos` tinyint(1) DEFAULT '0',
  `asistencia` tinyint(1) DEFAULT '0',
  `profesionales` tinyint(1) DEFAULT '0',
  `recursos` tinyint(1) DEFAULT '0',
  `ajustes` tinyint(1) DEFAULT '0',
  `acerca` tinyint(1) DEFAULT '1',
  `reportes` tinyint(1) DEFAULT '0',
  `remisiones_todas` tinyint(1) DEFAULT '0',
  `remisiones_nueva` tinyint(1) DEFAULT '0',
  `remisiones_calendario` tinyint(1) DEFAULT '0',
  `usuarios_lista` tinyint(1) DEFAULT '0',
  `usuarios_historial` tinyint(1) DEFAULT '0',
  `usuarios_documentos` tinyint(1) DEFAULT '0',
  `cursos_registro` tinyint(1) DEFAULT '0',
  `cursos_inscripcion` tinyint(1) DEFAULT '0',
  `cursos_asistencia` tinyint(1) DEFAULT '0',
  `cursos_area_virtual` tinyint(1) DEFAULT '0',
  `profesionales_lista` tinyint(1) DEFAULT '0',
  `profesionales_historial` tinyint(1) DEFAULT '0',
  `recursos_enfermera` tinyint(1) DEFAULT '0',
  `recursos_laboratorios` tinyint(1) DEFAULT '0',
  `ajustes_config` tinyint(1) DEFAULT '0',
  `ajustes_idioma` tinyint(1) DEFAULT '0',
  `ajustes_base_datos` tinyint(1) DEFAULT '0',
  `historia_riesgo_social_ver` tinyint(1) DEFAULT '0',
  `historia_riesgo_social_modificar` tinyint(1) DEFAULT '0',
  `historia_salud_oral_ver` tinyint(1) DEFAULT '0',
  `historia_salud_oral_modificar` tinyint(1) DEFAULT '0',
  `historia_salud_mental_ver` tinyint(1) DEFAULT '0',
  `historia_salud_mental_modificar` tinyint(1) DEFAULT '0',
  `historia_medicamentos_ver` tinyint(1) DEFAULT '0',
  `historia_medicamentos_modificar` tinyint(1) DEFAULT '0',
  `historia_signos_vitales_ver` tinyint(1) DEFAULT '0',
  `historia_signos_vitales_modificar` tinyint(1) DEFAULT '0',
  `historia_diagnostico_ver` tinyint(1) DEFAULT '0',
  `historia_diagnostico_modificar` tinyint(1) DEFAULT '0',
  `historia_antecedentes_ver` tinyint(1) DEFAULT '0',
  `historia_antecedentes_modificar` tinyint(1) DEFAULT '0',
  `historia_examenes_ver` tinyint(1) DEFAULT '0',
  `historia_examenes_modificar` tinyint(1) DEFAULT '0',
  `historia_fisioterapia_ver` tinyint(1) DEFAULT '0',
  `historia_fisioterapia_modificar` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Volcado de datos para la tabla `menu_permissions`
--

INSERT INTO `menu_permissions` (`id`, `user_id`, `dashboard`, `remisiones`, `usuarios`, `cursos`, `asistencia`, `profesionales`, `recursos`, `ajustes`, `acerca`, `reportes`, `remisiones_todas`, `remisiones_nueva`, `remisiones_calendario`, `usuarios_lista`, `usuarios_historial`, `usuarios_documentos`, `cursos_registro`, `cursos_inscripcion`, `cursos_asistencia`, `cursos_area_virtual`, `profesionales_lista`, `profesionales_historial`, `recursos_enfermera`, `recursos_laboratorios`, `ajustes_config`, `ajustes_idioma`, `ajustes_base_datos`, `historia_riesgo_social_ver`, `historia_riesgo_social_modificar`, `historia_salud_oral_ver`, `historia_salud_oral_modificar`, `historia_salud_mental_ver`, `historia_salud_mental_modificar`, `historia_medicamentos_ver`, `historia_medicamentos_modificar`, `historia_signos_vitales_ver`, `historia_signos_vitales_modificar`, `historia_diagnostico_ver`, `historia_diagnostico_modificar`, `historia_antecedentes_ver`, `historia_antecedentes_modificar`, `historia_examenes_ver`, `historia_examenes_modificar`, `historia_fisioterapia_ver`, `historia_fisioterapia_modificar`) VALUES
(16, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(20, 85, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(28, 98, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(29, 99, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(30, 100, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(33, 103, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `nurse`
--

DROP TABLE IF EXISTS `nurse`;
CREATE TABLE IF NOT EXISTS `nurse` (
  `idnur` int NOT NULL AUTO_INCREMENT,
  `numide` char(14) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `nomnur` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `apenur` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `nacinur` date NOT NULL,
  `sexnur` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idnur`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `orders`
--

DROP TABLE IF EXISTS `orders`;
CREATE TABLE IF NOT EXISTS `orders` (
  `idord` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `nomcl` varchar(70) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `method` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `total_products` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `total_price` decimal(10,2) NOT NULL,
  `placed_on` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `payment_status` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tipc` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`idord`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `patients`
--

DROP TABLE IF EXISTS `patients`;
CREATE TABLE IF NOT EXISTS `patients` (
  `idpa` int NOT NULL AUTO_INCREMENT,
  `numhs` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `nompa` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `apepa` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `direc` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `sex` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `grup` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `phon` char(13) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tiene_whatsapp` varchar(2) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'NO',
  `cump` date NOT NULL,
  `corr` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `username` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `password` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `rol` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `modalidad` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tusuario` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tdocumento` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fexpedicion` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `lexpedicion` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ecivil` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `zona` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `barrio` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `correo` varchar(70) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `rbono` varchar(39) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `sisben` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `pensionado` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tsudadera` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tchaqueta` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tzapatos` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `talentof` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `observacionsalida` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `vivecomp` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `redapoyo` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `cuidador` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `pcuidador` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `zcuidador` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `bvccuidador` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `dcuidador` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tcuidador` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `sgsss` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `eps` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `etnia` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `educacion` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `leer` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `utecnologia` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `poblaciond` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `poblacionoficio` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `qrInput` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `fotoperfil` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`idpa`)
) ENGINE=InnoDB AUTO_INCREMENT=744 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `product`
--

DROP TABLE IF EXISTS `product`;
CREATE TABLE IF NOT EXISTS `product` (
  `idprcd` int NOT NULL AUTO_INCREMENT,
  `codpro` char(14) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `nompro` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `idcat` int NOT NULL,
  `preprd` decimal(10,2) NOT NULL,
  `stock` char(3) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idprcd`),
  KEY `idcat` (`idcat`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `registro_estudiantes`
--

DROP TABLE IF EXISTS `registro_estudiantes`;
CREATE TABLE IF NOT EXISTS `registro_estudiantes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `modalidad` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tipo_usuario` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tipo_documento` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero_documento` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombres` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `apellidos` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fecha_expedicion` date DEFAULT NULL,
  `lugar_expedicion` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_nacimiento` date NOT NULL,
  `genero` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `direccion` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` varchar(13) COLLATE utf8mb4_unicode_ci NOT NULL,
  `grupo_sanguineo` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado_civil` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tiene_whatsapp` varchar(2) COLLATE utf8mb4_unicode_ci DEFAULT 'NO',
  `correo` varchar(70) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zona` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `barrio` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sisben` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recibe_bono` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pensionado` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `talla_sudadera` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `talla_chaqueta` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `talla_zapatos` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `talento_fortaleza` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `observacion_salida` text COLLATE utf8mb4_unicode_ci,
  `vive_con` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `red_apoyo` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nombre_cuidador` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parentesco_cuidador` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zona_cuidador` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `barrio_cuidador` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `direccion_cuidador` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono_cuidador` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sgsss` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `grupo_poblacional` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT 'Ninguno',
  `poblacion_oficio` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `eps` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `etnia` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nivel_educativo` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sabe_leer_escribir` varchar(2) COLLATE utf8mb4_unicode_ci DEFAULT 'SI',
  `uso_tecnologia` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `institucion_educativa` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `grado_actual` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `foto_perfil` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int DEFAULT NULL COMMENT 'ID del usuario en la tabla users',
  `fecha_registro` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `estado` enum('activo','inactivo','pendiente') COLLATE utf8mb4_unicode_ci DEFAULT 'pendiente',
  `sexo` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `numero_documento` (`numero_documento`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `registro_estudiantes`
--

INSERT INTO `registro_estudiantes` (`id`, `modalidad`, `tipo_usuario`, `tipo_documento`, `numero_documento`, `nombres`, `apellidos`, `fecha_expedicion`, `lugar_expedicion`, `fecha_nacimiento`, `genero`, `direccion`, `telefono`, `grupo_sanguineo`, `estado_civil`, `tiene_whatsapp`, `correo`, `zona`, `barrio`, `sisben`, `recibe_bono`, `pensionado`, `talla_sudadera`, `talla_chaqueta`, `talla_zapatos`, `talento_fortaleza`, `observacion_salida`, `vive_con`, `red_apoyo`, `nombre_cuidador`, `parentesco_cuidador`, `zona_cuidador`, `barrio_cuidador`, `direccion_cuidador`, `telefono_cuidador`, `sgsss`, `grupo_poblacional`, `poblacion_oficio`, `eps`, `etnia`, `nivel_educativo`, `sabe_leer_escribir`, `uso_tecnologia`, `institucion_educativa`, `grado_actual`, `foto_perfil`, `user_id`, `fecha_registro`, `estado`, `sexo`) VALUES
(33, '', 'Nuevo', 'C.C', '1007863612', 'DIYER ALEXIS', 'ROJAS CUBILLOS', '2020-07-17', 'SIBATE', '2000-02-08', 'MASCULINO', 'AAAA', '3027294894', 'AB+', NULL, 'NO', 'delicias@gmail.com', 'Urbano', 'delicias', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Víctima del conflicto armado', NULL, 'SALUD TOTAL', 'INDIGENA', 'SECUNDARIA', 'SI', NULL, 'Departamental', 'Universitario', 'profile_admin_695fc6c8cbb0b.jpg', 88, '2026-01-08 15:01:28', '', NULL),
(34, '', 'Nuevo', 'C.C', '7777777', 'ANDRES', 'FELIPE MERCHAN SEGUNDO', '2026-01-02', 'BUCARAMANGA', '2026-01-13', 'MASCULINO', 'CRA SIBATE', '3132421072', 'A-', 'SOLTERO', 'SI', 'merchan@gmail.com', 'Urbano', 'García', '', '', '', '', '', '', 'CANTO', 'SI', 'SOLO', 'SI', 'JHONY', 'Hijo', 'Rural', 'Bradamonte', 'AAAA', '321545445', 'Contributivo', 'situacion_especial', 'Reciclador', 'SANITAS', 'AFRO COLOMBIANO', 'PRIMARIA', 'SI', 'SI', 'COLEGIO LICEO SAMPER URIBE', 'DéCIMO', 'profile_admin_695fc8547f7cd.jpg', 89, '2026-01-08 15:07:19', 'pendiente', NULL),
(35, '', 'Nuevo', 'R.C', '6666666', 'FABIAN CAMILO', 'MARENTES FLORES', '2000-02-08', 'LETICIA', '2001-12-14', 'MASCULINO', 'AAAA', '5214545454', 'A+', 'SOLTERO', 'SI', 'camilo@gmail.com', 'Urbano', 'García', '', '', '', '', '', '', 'CANTO', 'SI', 'SOLO', 'SI', 'JHONYM', 'Hijo', 'Urbano', 'Villas de Santa Ana', 'AAAA', '544654564', 'Contributivo', 'desplazada', 'Reciclador', 'SANITAS', 'INDIGENA', 'PRIMARIA', 'SI', 'SI', 'LICEO CRISTIANO KYRIOS', 'TéCNICO PROFESIONAL', 'profile_admin_695fc98c6e790.jpg', 90, '2026-01-08 15:11:44', 'pendiente', NULL),
(39, 'Centro día La paz', 'Antiguo', 'C.C', '', '', '', NULL, '', '0000-00-00', '', '', '', '', '', 'NO', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Ninguno', 'Ninguno', '', '', '', 'SI', '', '', '', NULL, NULL, '2026-01-22 12:43:33', 'pendiente', NULL),
(40, '', 'Nuevo', 'C.C', '1012410715', 'JHONR ALEX', 'RUBIANO CRUZ', '2026-01-22', 'BOGOTA', '2026-01-22', 'MASCULINO', 'HJKHKJH', '7777', 'B-', NULL, 'SI', 'JHONN@GMAIL.COM', 'Urbano', 'BO', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Discapacidad', NULL, 'COMPENSAR', 'AFROCOLOMBIANO', 'SECUNDARIA', 'SI', NULL, 'JKJKJKLLKJKLJ', 'Noveno', 'profile_admin_69721e38ae43d.jpeg', 106, '2026-01-22 12:55:20', '', NULL),
(41, '', 'Nuevo', 'TI', '7878787878', 'FRE', 'FA EDWE SAD', NULL, '', '2026-01-07', 'MASCULINO', 'AAAA', '3132421072', 'A-', 'CASADO', 'SI', 'merchan@gmail.com', '', '', '', '', '', '', '', '', '', 'wdad', '', '', '', '', '', '', '', '', '', 'Ninguno', 'Ninguno', '', '', '', 'SI', '', '', '', 'profile_69721e748fcd9.webp', 104, '2026-01-22 12:56:20', 'pendiente', NULL),
(42, '', 'Nuevo', 'C.C', '14244444112', 'NICOLAS', 'SEGUNDO ROJAS CUBILLOS', NULL, '', '2009-06-05', 'MASCULINO', 'CRA 1-10', '3027294894', 'A+', 'SOLTERO', 'SI', 'nicolas@gmail.com', '', '', '', '', '', '', '', '', '', 'dsadas', '', '', '', '', '', '', '', '', '', 'Ninguno', 'Ninguno', '', '', '', 'SI', '', '', '', NULL, 107, '2026-01-22 13:14:24', 'pendiente', NULL),
(43, '', 'Nuevo', 'T.I', '15415115115', 'ANDRESSA', 'SAD SAD DSAS', '2026-01-06', 'APARTADó', '2026-01-04', 'MASCULINO', 'FREEC', '5645614', 'A+', 'SOLTERO', 'NO', 'merchan@gmail.com', 'Rural', 'Bradamonte', '', '', '', '', '', '', 'CANTO', 'SI', 'SOLO', 'SI', 'JHONY', 'Hijo', 'Urbano', 'Villas de Santa Ana', 'AAAA', '2121121', 'Subsidiado', 'situacion_especial', 'ninguno', 'SANITAS', 'INDIGENA', 'PRIMARIA', 'SI', 'SI', 'GIMNASIO LOS ÁNGELES', 'TECNóLOGO', NULL, 108, '2026-01-22 15:00:38', 'pendiente', NULL),
(44, '', 'Nuevo', 'R.C', '489484454', 'DANIELA SAD', 'SED SADD SADD', '2026-01-01', 'LA PLATA', '2025-12-30', 'FEMENINO', 'AAAA', '3132421072', 'A-', 'CASADO', 'SI', 'merchan@gmail.com', 'Urbano', 'El Mirador', '', '', '', '', '', '', 'CANTO', 'NO', 'SOLO', 'SI', 'JHONY', 'CÓNYUGE y/o COMPAÑERO', 'Urbano', 'Santa Teresa', 'AAAA', '2121121', 'Contributivo', 'discapacidad', 'ninguno', 'SANITAS', 'INDIGENA', 'PRIMARIA', 'SI', 'SI', 'I.E.D GENERAL SANTANDER', 'CUARTO', 'profile_admin_69723f61cabaa.png', 109, '2026-01-22 15:14:56', 'pendiente', NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `saludmental`
--

DROP TABLE IF EXISTS `saludmental`;
CREATE TABLE IF NOT EXISTS `saludmental` (
  `id_saludmental` int NOT NULL,
  `idpa` varchar(30) NOT NULL,
  `nompa` varchar(30) NOT NULL,
  `fere` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `maltrato` varchar(30) NOT NULL,
  `problemas` varchar(30) NOT NULL,
  `sentidomal` varchar(30) NOT NULL,
  `arrepentido` varchar(30) NOT NULL,
  `abandono` varchar(30) NOT NULL,
  `obligado` varchar(30) NOT NULL,
  `cuerpo` varchar(30) NOT NULL,
  `subido` varchar(30) NOT NULL,
  `vomito` varchar(30) NOT NULL,
  `apetito` varchar(30) NOT NULL,
  `reconocimiento` varchar(30) NOT NULL,
  `emborracho` varchar(30) NOT NULL,
  `sustancia` varchar(30) NOT NULL,
  `bebida` varchar(30) NOT NULL,
  `cigarrillo` varchar(30) NOT NULL,
  `aconsejado` varchar(30) NOT NULL,
  `bebidaalta` varchar(30) NOT NULL,
  `beberpodido` varchar(30) NOT NULL,
  `aburrido` varchar(30) NOT NULL,
  `frecuencia` varchar(30) NOT NULL,
  `actividadesf` varchar(30) NOT NULL,
  `tomardecisiones` varchar(30) NOT NULL,
  `agresividad` varchar(30) NOT NULL,
  `ptriste` varchar(30) NOT NULL,
  `ptemeroso` varchar(30) NOT NULL,
  `muerte` varchar(30) NOT NULL,
  `dano` varchar(30) NOT NULL,
  `aislado` varchar(30) NOT NULL,
  `motiva1` varchar(30) NOT NULL,
  `sentimiento` varchar(30) NOT NULL,
  `dificil` varchar(30) NOT NULL,
  `habilidad` varchar(30) NOT NULL,
  `alegreyanimo` varchar(30) NOT NULL,
  `relajadotranquilidad` varchar(30) NOT NULL,
  `activoenergia` varchar(30) NOT NULL,
  `biendescanso` varchar(30) NOT NULL,
  `momentointeresante` varchar(30) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Volcado de datos para la tabla `saludmental`
--

INSERT INTO `saludmental` (`id_saludmental`, `idpa`, `nompa`, `fere`, `state`, `maltrato`, `problemas`, `sentidomal`, `arrepentido`, `abandono`, `obligado`, `cuerpo`, `subido`, `vomito`, `apetito`, `reconocimiento`, `emborracho`, `sustancia`, `bebida`, `cigarrillo`, `aconsejado`, `bebidaalta`, `beberpodido`, `aburrido`, `frecuencia`, `actividadesf`, `tomardecisiones`, `agresividad`, `ptriste`, `ptemeroso`, `muerte`, `dano`, `aislado`, `motiva1`, `sentimiento`, `dificil`, `habilidad`, `alegreyanimo`, `relajadotranquilidad`, `activoenergia`, `biendescanso`, `momentointeresante`) VALUES
(0, '42', 'admin', '2026-01-22 10:25:45', '1', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
(0, '42', 'admin', '2026-01-22 10:34:27', '1', 'J', 'JKHKJ', 'HJK', 'HKJ', 'HKJ', 'HKJ', 'HKJ', 'HKJ', 'HKJ', 'HKJ', 'HKJ', 'H', 'KJH', 'JKH', 'JK', 'H', 'KJH', 'KJH', 'KJH', 'KJH', 'KJH', 'KJH', 'KJ', 'H', 'KJH', 'KJH', 'KJH', 'KJH', 'KJH', 'KJH', 'KJHK', 'JHK', 'JHK', 'JHKJ', 'SS', 'KJH', 'KJH');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `settings`
--

DROP TABLE IF EXISTS `settings`;
CREATE TABLE IF NOT EXISTS `settings` (
  `idse` int NOT NULL AUTO_INCREMENT,
  `nomem` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `foto` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`idse`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `settings`
--

INSERT INTO `settings` (`idse`, `nomem`, `foto`) VALUES
(1, 'PROGRAMA PERSONA MAYOR', '692192.png');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `toral`
--

DROP TABLE IF EXISTS `toral`;
CREATE TABLE IF NOT EXISTS `toral` (
  `id_oral` int NOT NULL,
  `idpa` varchar(30) NOT NULL,
  `nompa` varchar(30) NOT NULL,
  `fere` timestamp NOT NULL,
  `state` varchar(300) NOT NULL,
  `lavadientes` varchar(300) NOT NULL,
  `golpeb` varchar(300) NOT NULL,
  `sangred` varchar(300) NOT NULL,
  `protesisd` varchar(300) NOT NULL,
  `comesonrie` varchar(300) NOT NULL,
  `limpiab` varchar(300) NOT NULL,
  `dolorc` varchar(300) NOT NULL,
  `malolor` varchar(300) NOT NULL,
  `perdidadientes` varchar(300) NOT NULL,
  `maltratoprotesis` varchar(300) NOT NULL,
  `cicatriz` varchar(300) NOT NULL,
  `bocabano` varchar(300) NOT NULL,
  `consultaodont` varchar(300) NOT NULL,
  `observaciones` varchar(300) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Volcado de datos para la tabla `toral`
--

INSERT INTO `toral` (`id_oral`, `idpa`, `nompa`, `fere`, `state`, `lavadientes`, `golpeb`, `sangred`, `protesisd`, `comesonrie`, `limpiab`, `dolorc`, `malolor`, `perdidadientes`, `maltratoprotesis`, `cicatriz`, `bocabano`, `consultaodont`, `observaciones`) VALUES
(0, '644', 'JUAN EVANGELISTA', '2025-12-18 16:22:17', '1', 'das', 'ads', 'dsa', 'ds', 'jk', 'jkh', 'kj', 'hk', '', 'hk', 'hkj', 'hk', 'kj', 'hjhk'),
(0, '9', 'admin', '2025-12-22 16:41:07', '1', '13321', '132', '123', '132', '132213', '321', '123', '312', '213', '132', '132123', '213', '132', '1231'),
(0, '9', 'admin', '2025-12-22 16:41:19', '1', 'kj', 'j', '', 'kh', 'hk', 'hk', 'jkh', 'k', 'jk', 'adsdsa', 'h', 'hk', 'asdsadasd', 'k'),
(0, '42', 'admin', '2026-01-22 15:44:18', '1', 'DSADDSFDS', 'JKHDFSDSFDSF', 'KHDSFSDF', 'JKHSDFSDF', 'KJHDSFSDF', 'KJHDSFSD', 'KJHDSFSDF', 'KJHDSFSDF', 'KJHDSFSDF', 'KJHSDF', 'KJHSDFSDFSD', 'KJHDSFSDF', 'KJHDSFDS', 'DSFSDFSD');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `treatment`
--

DROP TABLE IF EXISTS `treatment`;
CREATE TABLE IF NOT EXISTS `treatment` (
  `idtra` int NOT NULL AUTO_INCREMENT,
  `nomtra` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `idpa` int NOT NULL,
  `nompa` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idtra`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `treatment`
--

INSERT INTO `treatment` (`idtra`, `nomtra`, `idpa`, `nompa`, `state`, `fere`) VALUES
(16, 'ASD', 42, 'admin', '1', '2026-01-22 15:43:34');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `ubicaciones_completas`
--

DROP TABLE IF EXISTS `ubicaciones_completas`;
CREATE TABLE IF NOT EXISTS `ubicaciones_completas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nompa` varchar(100) DEFAULT NULL,
  `documento` varchar(20) DEFAULT NULL,
  `correo` varchar(100) DEFAULT NULL,
  `latitud` decimal(9,6) DEFAULT NULL,
  `longitud` decimal(9,6) DEFAULT NULL,
  `fecha_registro` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=103 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE IF NOT EXISTS `users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `username` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `name` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `email` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tipo_documento` varchar(10) COLLATE utf8mb3_unicode_ci DEFAULT 'C.C',
  `password` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `rol` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `aprobado` enum('pendiente','aprobado','rechazado') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'pendiente',
  `fecha_aprobacion` datetime DEFAULT NULL,
  `aprobado_por` int DEFAULT NULL,
  `motivo_rechazo` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `users`
--

INSERT INTO `users` (`id`, `username`, `name`, `email`, `tipo_documento`, `password`, `rol`, `created_at`, `aprobado`, `fecha_aprobacion`, `aprobado_por`, `motivo_rechazo`) VALUES
(1, 'admin', 'Administrador', 'adrianlujam91@gmail.com', 'C.C', 'e99a18c428cb38d5f260853678922e03', '1', '2026-01-08 14:11:49', 'aprobado', NULL, NULL, NULL),
(85, 'Csuarez', 'Catalina Suarez', 'Csuarez@gmail.com', 'C.C', '0e0294cf314f080436b5ecf5a426fb1b', '1', '2026-01-08 14:28:32', 'pendiente', NULL, NULL, NULL),
(88, 'alexis', 'DIYER ALEXIS ROJAS CUBILLOS', '1007863612', 'C.C', 'e807f1fcf82d132f9bb018ca6738a19f', '3', '2026-01-08 15:01:28', 'aprobado', NULL, NULL, NULL),
(89, 'merchan', 'ANDRES FELIPE MERCHAN SEGUNDO', '7777777', 'C.C', 'e807f1fcf82d132f9bb018ca6738a19f', '3', '2026-01-08 20:49:14', 'aprobado', '2026-01-08 15:49:14', 1, NULL),
(90, 'camilo', 'CAMILO S MARENTES F', '6666666', 'R.C', 'e807f1fcf82d132f9bb018ca6738a19f', '3', '2026-01-08 20:49:11', 'aprobado', '2026-01-08 15:49:11', 1, NULL),
(98, 'jhon', 'jhon rubiano', 'jhon@gmail.com', 'C.C', '4d2ff2f945883e090ac4de4fb9e23fab', '4', '2026-01-21 21:53:17', 'pendiente', NULL, NULL, NULL),
(99, 'Fontecha', 'Fontecha Fontecha', 'fontecha@gmail.com', 'C.C', 'bf4431385ed90c368c0381ada44cd71a', '2', '2026-01-08 16:27:20', 'pendiente', NULL, NULL, NULL),
(100, 'Pablo', 'Pablo Vanegas', 'Pablo@gmail.com', 'C.C', '2e6edb52fa0ea8167a5a621d31937c41', '2', '2026-01-08 16:29:06', 'pendiente', NULL, NULL, NULL),
(103, 'rojas', 'rojas rojas', 'rojas@gmail.com', 'C.C', '8f15160f3cdfbdd3d71d12263a1b9f2f', '4', '2026-01-08 16:57:14', 'pendiente', NULL, NULL, NULL),
(104, 'pepe', 'FRE FA EDWE SAD', '7878787878', 'T.I', '7edede46f596b580cd10469463987280', '3', '2026-01-22 12:43:11', 'pendiente', NULL, NULL, NULL),
(105, 'Federico', 'FEDERICO ROJAS CC CC', '12121213455', 'T.I', '4db11d0506ccd501ea38078c3705d72c', '3', '2026-01-22 12:48:32', 'pendiente', NULL, NULL, NULL),
(106, 'jrubianoc', 'JHONR ALEX RUBIANO CRUZ', '1012410715', 'C.C', '959165d01cf6e5cac2a05666978ec1dd', '3', '2026-01-22 12:55:20', 'aprobado', NULL, NULL, NULL),
(107, 'nicolas', 'NICOLAS SEGUNDO ROJAS CUBILLOS', '14244444112', 'C.C', '36d1fafa3445f87b23d7646607275d3c', '3', '2026-01-22 13:12:13', 'pendiente', NULL, NULL, NULL),
(108, 'freec', 'ANDRESSA SAD SAD DSAS', '15415115115', 'T.I', '5b7afeaf08194a0f9f518d9c7e4fcf9e', '3', '2026-01-22 14:58:58', 'pendiente', NULL, NULL, NULL),
(109, 'daniela', 'DANIELA SED SADD SADD', '489484454', 'R.C', 'd068373cf52adee2d54d7eda5bc6eca3', '3', '2026-01-22 15:13:30', 'pendiente', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `user_permissions`
--

DROP TABLE IF EXISTS `user_permissions`;
CREATE TABLE IF NOT EXISTS `user_permissions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `view_valoracion_riesgo` tinyint(1) DEFAULT '0',
  `edit_valoracion_riesgo` tinyint(1) DEFAULT '0',
  `view_signos_vitales` tinyint(1) DEFAULT '0',
  `edit_signos_vitales` tinyint(1) DEFAULT '0',
  `view_medicamentos` tinyint(1) DEFAULT '0',
  `edit_medicamentos` tinyint(1) DEFAULT '0',
  `view_diagnostico` tinyint(1) DEFAULT '0',
  `edit_diagnostico` tinyint(1) DEFAULT '0',
  `view_antecedentes` tinyint(1) DEFAULT '0',
  `edit_antecedentes` tinyint(1) DEFAULT '0',
  `view_examenes` tinyint(1) DEFAULT '0',
  `edit_examenes` tinyint(1) DEFAULT '0',
  `view_salud_oral` tinyint(1) DEFAULT '0',
  `edit_salud_oral` tinyint(1) DEFAULT '0',
  `view_salud_mental` tinyint(1) DEFAULT '0',
  `edit_salud_mental` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Volcado de datos para la tabla `user_permissions`
--

INSERT INTO `user_permissions` (`id`, `user_id`, `view_valoracion_riesgo`, `edit_valoracion_riesgo`, `view_signos_vitales`, `edit_signos_vitales`, `view_medicamentos`, `edit_medicamentos`, `view_diagnostico`, `edit_diagnostico`, `view_antecedentes`, `edit_antecedentes`, `view_examenes`, `edit_examenes`, `view_salud_oral`, `edit_salud_oral`, `view_salud_mental`, `edit_salud_mental`) VALUES
(1, 9, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(2, 10, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(11, 39, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(12, 93, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(13, 97, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(14, 98, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(15, 101, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(16, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(17, 103, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `valoracionriesgo`
--

DROP TABLE IF EXISTS `valoracionriesgo`;
CREATE TABLE IF NOT EXISTS `valoracionriesgo` (
  `id_valoracion` int NOT NULL,
  `id_estudiante` int DEFAULT NULL,
  `enfermedadd` varchar(30) NOT NULL,
  `fuma` varchar(30) NOT NULL,
  `humo` varchar(30) NOT NULL,
  `consumo` varchar(30) NOT NULL,
  `sal` varchar(30) NOT NULL,
  `cocina` varchar(30) NOT NULL,
  `vestir` varchar(30) NOT NULL,
  `diahoy` varchar(30) NOT NULL,
  `meshoy` varchar(30) NOT NULL,
  `anohoy` varchar(30) NOT NULL,
  `municipio` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  KEY `idx_id_estudiante` (`id_estudiante`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Volcado de datos para la tabla `valoracionriesgo`
--

INSERT INTO `valoracionriesgo` (`id_valoracion`, `id_estudiante`, `enfermedadd`, `fuma`, `humo`, `consumo`, `sal`, `cocina`, `vestir`, `diahoy`, `meshoy`, `anohoy`, `municipio`, `state`, `fere`) VALUES
(0, NULL, 'ALTO', 'SOLIDO', 'PREVIOS ', 'ASDA', 'KJK', 'HKJ', 'HJK', 'HKJ', 'HKJH', 'KJH', 'KH', '1', '2025-12-18 21:14:52'),
(0, NULL, 'bajo', 'ss', 'uyhguyh', 'hkjh', 'kjhjk', 'hjk', 'hjk', 'hkj', 'hkj', 'hkj', 'hkj', '1', '2025-12-18 21:31:15'),
(0, 14, 'mediop', 'sdf', 'sdf', 'sdf', 'ds', 'fdsf', 'sdf', 'sdfsdf', 'sdf', 'sdf', 'sdf', '1', '2025-12-18 21:32:44'),
(0, 6, 'ALTO', 'DA', 'JHGJH', 'G', 'HG', 'JHG', 'JHG', 'JHG', 'JHG', 'JH', 'GJJH', '1', '2025-12-18 21:43:30'),
(0, 9, 'MEDIO', 'ASKJDHJAKSH', 'KJH', 'KJHJK', 'H', 'KJH', 'KJHKJ', 'H', 'KJH', 'KJH', 'KJH', '1', '2025-12-18 21:44:18'),
(0, 9, 'MEDIO-BASICO', 'WDA', 'AWD', 'KJH', 'JKH', 'JK', 'HKJ', 'HKJ', 'HKJ', 'HK', 'JHKJH', '1', '2025-12-18 21:45:20'),
(0, 5, 'CASI', 'JKHAS', 'JKHH', 'KJH', 'KJH', 'KJH', 'KJHKJ', 'H', 'KJH', 'KJHKJH', 'KH', '1', '2025-12-18 21:46:49'),
(0, 17, 'ALTO', '', '', '', '', '', '', '', '', '', '', '1', '2025-12-18 21:48:53'),
(0, NULL, '132', '132', '132', '123132', '132', '132', '132', '132', '132', '132132', '132', '1', '2025-12-22 16:40:40'),
(0, NULL, 'MEDIO', '1123', '132', '321', '132', '132', '132\n321', '132', '132', '132', '132', '1', '2025-12-22 17:00:38'),
(0, NULL, 'MEDIO', 'JHJH', 'JH', 'JH', 'HHJ', 'H', 'HK', 'HK', 'HK', 'K', 'K', '1', '2025-12-22 17:00:51'),
(0, 12, 'MEDIO', '465', '564', '654465', '465', '645', '654', '654', '465', '645', '465', '1', '2025-12-22 17:03:02'),
(0, 12, 'MEDIO', '5', '564', '465465', '546', '546', 'q546', 'q465', '654546', '564', '654', '1', '2025-12-22 17:03:11'),
(0, 12, 'MEDIO', '5', '564', '465465', '546', '546', 'q546', 'q465', '654546', '564', '654', '1', '2025-12-22 17:03:13'),
(0, 7, 'ALTO', 'ALTO', 'ALTO321', '231', '123', '123', '213', '132213', '132', '12332', 'SADDSA', '1', '2025-12-22 17:09:40'),
(0, 9, 'MEDIO', 'sdad', 'asd', 'asd', 'sda', 'dsa', 'dsad', 'asd', 'asd', 'asdsad', 'gfdgdf', '1', '2025-12-29 19:24:44'),
(0, 42, 'MEDIO', 'bien', 'buensos', 'cantar ', 'fdd', 'fd', 'd', 'fd', 'fd', 'f', 'df', '1', '2026-01-22 13:24:47'),
(0, 42, 'ALTO', 'JKH', 'JKHK', 'HKJ', 'HJK', 'HKJ', 'HKJ', 'HKJ', 'HKJ', 'HKJ', 'HKJ', '1', '2026-01-22 15:37:12'),
(0, 42, 'MEDIO', 'HJGHJG', 'HJGJH', 'GJH', 'GJH', 'G', 'JHGJHGJHGJ', 'HGJHGJH', 'GJH', 'GJHG', 'JHGJ', '1', '2026-01-22 15:40:08');

--
-- Restricciones para tablas volcadas
--

--
-- Filtros para la tabla `areas`
--
ALTER TABLE `areas`
  ADD CONSTRAINT `areas_ibfk_1` FOREIGN KEY (`id_escuela`) REFERENCES `escuelas_formacion` (`id`) ON DELETE CASCADE;

--
-- Filtros para la tabla `cart`
--
ALTER TABLE `cart`
  ADD CONSTRAINT `cart_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  ADD CONSTRAINT `cart_ibfk_2` FOREIGN KEY (`idprcd`) REFERENCES `product` (`idprcd`);

--
-- Filtros para la tabla `curso_entregas`
--
ALTER TABLE `curso_entregas`
  ADD CONSTRAINT `curso_entregas_ibfk_1` FOREIGN KEY (`id_contenido`) REFERENCES `curso_contenido` (`id`) ON DELETE CASCADE;

--
-- Filtros para la tabla `curso_foros`
--
ALTER TABLE `curso_foros`
  ADD CONSTRAINT `curso_foros_ibfk_1` FOREIGN KEY (`id_contenido`) REFERENCES `curso_contenido` (`id`) ON DELETE CASCADE;

--
-- Filtros para la tabla `events`
--
ALTER TABLE `events`
  ADD CONSTRAINT `events_ibfk_1` FOREIGN KEY (`idpa`) REFERENCES `patients` (`idpa`),
  ADD CONSTRAINT `events_ibfk_2` FOREIGN KEY (`idodc`) REFERENCES `doctor` (`idodc`),
  ADD CONSTRAINT `events_ibfk_3` FOREIGN KEY (`idlab`) REFERENCES `laboratory` (`idlab`);

--
-- Filtros para la tabla `menu_permissions`
--
ALTER TABLE `menu_permissions`
  ADD CONSTRAINT `menu_permissions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Filtros para la tabla `product`
--
ALTER TABLE `product`
  ADD CONSTRAINT `product_ibfk_1` FOREIGN KEY (`idcat`) REFERENCES `category` (`idcat`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
