<?php
require 'backend/bd/Conexion.php';

echo "<h2>Agregar Sistema de Aprobación de Ciudadanos</h2>";

echo "<div style='background: #f8f9fa; padding: 20px; border-radius: 8px; margin: 20px 0;'>";
echo "<h3>Agregando columnas...</h3>";

$errores = [];
$exitosas = 0;

// Agregar columna de estado de aprobación a users
try {
    $sql = "ALTER TABLE users ADD COLUMN aprobado ENUM('pendiente', 'aprobado', 'rechazado') DEFAULT 'pendiente'";
    $connect->exec($sql);
    echo "<p style='color: #28a745;'>✅ Columna <strong>aprobado</strong> agregada a tabla users</p>";
    $exitosas++;
} catch(PDOException $e) {
    if(strpos($e->getMessage(), 'Duplicate column') !== false) {
        echo "<p style='color: #ffc107;'>⚠️ Columna <strong>aprobado</strong> ya existe en users</p>";
    } else {
        echo "<p style='color: #dc3545;'>❌ Error: " . $e->getMessage() . "</p>";
        $errores[] = 'aprobado en users';
    }
}

// Agregar columna de fecha de aprobación
try {
    $sql = "ALTER TABLE users ADD COLUMN fecha_aprobacion DATETIME NULL";
    $connect->exec($sql);
    echo "<p style='color: #28a745;'>✅ Columna <strong>fecha_aprobacion</strong> agregada a tabla users</p>";
    $exitosas++;
} catch(PDOException $e) {
    if(strpos($e->getMessage(), 'Duplicate column') !== false) {
        echo "<p style='color: #ffc107;'>⚠️ Columna <strong>fecha_aprobacion</strong> ya existe en users</p>";
    } else {
        echo "<p style='color: #dc3545;'>❌ Error: " . $e->getMessage() . "</p>";
        $errores[] = 'fecha_aprobacion en users';
    }
}

// Agregar columna de quien aprobó
try {
    $sql = "ALTER TABLE users ADD COLUMN aprobado_por INT(11) NULL";
    $connect->exec($sql);
    echo "<p style='color: #28a745;'>✅ Columna <strong>aprobado_por</strong> agregada a tabla users</p>";
    $exitosas++;
} catch(PDOException $e) {
    if(strpos($e->getMessage(), 'Duplicate column') !== false) {
        echo "<p style='color: #ffc107;'>⚠️ Columna <strong>aprobado_por</strong> ya existe en users</p>";
    } else {
        echo "<p style='color: #dc3545;'>❌ Error: " . $e->getMessage() . "</p>";
        $errores[] = 'aprobado_por en users';
    }
}

// Agregar columna de motivo de rechazo
try {
    $sql = "ALTER TABLE users ADD COLUMN motivo_rechazo TEXT NULL";
    $connect->exec($sql);
    echo "<p style='color: #28a745;'>✅ Columna <strong>motivo_rechazo</strong> agregada a tabla users</p>";
    $exitosas++;
} catch(PDOException $e) {
    if(strpos($e->getMessage(), 'Duplicate column') !== false) {
        echo "<p style='color: #ffc107;'>⚠️ Columna <strong>motivo_rechazo</strong> ya existe en users</p>";
    } else {
        echo "<p style='color: #dc3545;'>❌ Error: " . $e->getMessage() . "</p>";
        $errores[] = 'motivo_rechazo en users';
    }
}

echo "</div>";

// Actualizar usuarios existentes
echo "<div style='background: #e7f3ff; padding: 20px; border-radius: 8px; margin: 20px 0;'>";
echo "<h3>Actualizando usuarios existentes...</h3>";

try {
    // Aprobar automáticamente a todos los administradores y profesionales
    $sql = "UPDATE users SET aprobado = 'aprobado' WHERE rol IN (1, 2, 4, 5, 6) AND (aprobado IS NULL OR aprobado = 'pendiente')";
    $stmt = $connect->prepare($sql);
    $stmt->execute();
    $count = $stmt->rowCount();
    echo "<p style='color: #28a745;'>✅ Se aprobaron automáticamente <strong>$count</strong> funcionarios/administradores</p>";
    
    // Contar ciudadanos pendientes
    $sql = "SELECT COUNT(*) as total FROM users WHERE rol = 3 AND (aprobado IS NULL OR aprobado = 'pendiente')";
    $stmt = $connect->query($sql);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $pendientes = $result['total'];
    
    echo "<p style='color: #ffc107;'>⚠️ Hay <strong>$pendientes</strong> ciudadanos pendientes de aprobación</p>";
    
} catch(PDOException $e) {
    echo "<p style='color: #dc3545;'>❌ Error al actualizar: " . $e->getMessage() . "</p>";
}

echo "</div>";

if(count($errores) == 0) {
    echo "<div style='background: #d4edda; padding: 20px; border-radius: 8px; border-left: 4px solid #28a745;'>";
    echo "<h3 style='color: #155724; margin-top: 0;'>🎉 ¡Sistema de Aprobación Instalado!</h3>";
    echo "<p style='color: #155724;'>El sistema de aprobación está listo. Ahora:</p>";
    echo "<ul style='color: #155724;'>";
    echo "<li>Los ciudadanos nuevos se registran con estado <strong>'pendiente'</strong></li>";
    echo "<li>Los funcionarios pueden aprobar o rechazar ciudadanos</li>";
    echo "<li>Los ciudadanos pendientes/rechazados no pueden acceder al sistema</li>";
    echo "</ul>";
    echo "</div>";
    
    echo "<div style='margin-top: 20px;'>";
    echo "<a href='frontend/admin/escritorio.php' style='padding: 12px 24px; background: #667eea; color: white; text-decoration: none; border-radius: 8px; display: inline-block; margin-right: 10px;'>Ir al Dashboard</a>";
    echo "<a href='frontend/pacientes/aprobar_ciudadanos.php' style='padding: 12px 24px; background: #28a745; color: white; text-decoration: none; border-radius: 8px; display: inline-block;'>Ver Ciudadanos Pendientes</a>";
    echo "</div>";
} else {
    echo "<div style='background: #f8d7da; padding: 20px; border-radius: 8px; border-left: 4px solid #dc3545;'>";
    echo "<h3 style='color: #721c24; margin-top: 0;'>⚠️ Hubo algunos errores</h3>";
    echo "<p style='color: #721c24;'>Columnas con error: " . implode(', ', $errores) . "</p>";
    echo "</div>";
}
?>
