<?php
require 'Conexion.php';

try {
    // Table: curso_modulos (The tabs)
    $sql1 = "CREATE TABLE IF NOT EXISTS curso_modulos (
        id INT AUTO_INCREMENT PRIMARY KEY,
        id_curso INT NOT NULL,
        titulo VARCHAR(100) NOT NULL,
        orden INT DEFAULT 0,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
    $connect->exec($sql1);
    echo "Table 'curso_modulos' created.<br>";

    // Update Table: curso_contenido (The content)
    // We will recreate it to use id_modulo instead of modulo_key for better consistency
    // WARNING: This drops existing content. Since it's development phase, this is likely acceptable.
    $sql2 = "DROP TABLE IF EXISTS curso_contenido;";
    $connect->exec($sql2);

    $sql3 = "CREATE TABLE IF NOT EXISTS curso_contenido (
        id INT AUTO_INCREMENT PRIMARY KEY,
        id_curso INT NOT NULL,
        id_modulo INT NOT NULL,
        contenido LONGTEXT,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        UNIQUE KEY unique_content (id_modulo)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
    $connect->exec($sql3);
    echo "Table 'curso_contenido' recreated with id_modulo support.<br>";

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>
