<?php
require 'Conexion.php';

try {
    // 1. Drop the unique key
    // We try-catch this individually in case it doesn't exist or was already dropped
    try {
        $connect->exec("ALTER TABLE curso_contenido DROP INDEX unique_content");
        echo "Unique index dropped.<br>";
    } catch (PDOException $e) {
        echo "Index might not exist or already dropped: " . $e->getMessage() . "<br>";
    }

    // 2. Add 'titulo' column if it doesn't exist
    try {
        $connect->exec("ALTER TABLE curso_contenido ADD COLUMN titulo VARCHAR(255) DEFAULT 'Nuevo Contenido' AFTER id_modulo");
        echo "Column 'titulo' added.<br>";
    } catch (PDOException $e) {
        echo "Column 'titulo' might already exist: " . $e->getMessage() . "<br>";
    }

    // 3. Add 'tipo' column if it doesn't exist (useful for future video/text distinction)
    try {
        $connect->exec("ALTER TABLE curso_contenido ADD COLUMN tipo VARCHAR(50) DEFAULT 'html' AFTER titulo");
        echo "Column 'tipo' added.<br>";
    } catch (PDOException $e) {
        echo "Column 'tipo' might already exist: " . $e->getMessage() . "<br>";
    }
    
    echo "Table 'curso_contenido' updated for multiple items.";

} catch (PDOException $e) {
    echo "General Error: " . $e->getMessage();
}
?>
