<?php
require 'Conexion.php';

try {
    // 1. Add 'tipo' if not exists (might have been added by auto-fix)
    try {
        $connect->exec("ALTER TABLE curso_contenido ADD COLUMN tipo VARCHAR(50) DEFAULT 'recurso' AFTER titulo");
        echo "Column 'tipo' added.<br>";
    } catch (PDOException $e) { /* Ignore */ }

    // 2. Add 'fecha_limite'
    try {
        $connect->exec("ALTER TABLE curso_contenido ADD COLUMN fecha_limite DATETIME NULL AFTER contenido");
        echo "Column 'fecha_limite' added.<br>";
    } catch (PDOException $e) { /* Ignore */ }

    // 3. Create 'curso_entregas' table
    $sql = "CREATE TABLE IF NOT EXISTS curso_entregas (
        id INT AUTO_INCREMENT PRIMARY KEY,
        id_contenido INT NOT NULL,
        id_estudiante INT NOT NULL,
        archivo VARCHAR(255),
        comentario TEXT,
        fecha_entrega TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        calificacion DECIMAL(4,2) NULL,
        FOREIGN KEY (id_contenido) REFERENCES curso_contenido(id) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
    
    $connect->exec($sql);
    echo "Table 'curso_entregas' created.<br>";
    
    echo "Database updated for Advanced Content Types.";

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>
