$(document).ready(function() {
    // Manejar el cambio de estado del checkbox
    $('input[type="checkbox"]').change(function() {
        var id = $(this).attr('id');
        var state = $(this).is(':checked') ? '1' : '0';
        
        $.ajax({
            url: '../../backend/php/upd_state_patiens.php',
            type: 'POST',
            data: {
                id: id,
                state: state
            },
            dataType: 'json',
            success: function(response) {
                if(response.status === 'success') {
                    // El estado se actualizó correctamente
                    console.log('Estado actualizado');
                } else {
                    // Hubo un error al actualizar el estado
                    console.error('Error:', response.message);
                    // Revertir el checkbox a su estado anterior
                    $(this).prop('checked', !$(this).is(':checked'));
                }
            },
            error: function(xhr, status, error) {
                console.error('Error:', error);
                // Revertir el checkbox a su estado anterior
                $(this).prop('checked', !$(this).is(':checked'));
            }
        });
    });
});