<?php
// Archivo para actualizar datos del ciudadano en la nueva tabla registro_estudiantes
if(!isset($_SESSION['user_type']) || $_SESSION['user_type'] != 'ciudadano'){
    exit;
}

require_once('../../backend/bd/Conexion.php'); 
global $connect;

if(isset($_POST['actualizar_datos'])) {
    // Recibir datos del formulario (mapeo con registro_estudiantes)
    $numero_documento = trim($_POST['numero_documento']);
    $nombres = strtoupper(trim($_POST['nombres']));
    $apellidos = strtoupper(trim($_POST['apellidos']));  
    $direccion = strtoupper(trim($_POST['direccion']));
    $telefono = trim($_POST['telefono']);
    $genero = strtoupper(trim($_POST['genero']));
    $grupo_sanguineo = strtoupper(trim($_POST['grupo_sanguineo']));
    $tiene_whatsapp = strtoupper(trim($_POST['tiene_whatsapp'] ?? 'NO'));
    $fecha_nacimiento = trim($_POST['fecha_nacimiento']);
    $correo = trim($_POST['correo']);
    
    // Otros campos
    $tipo_usuario = trim($_POST['tipo_usuario'] ?? '');
    $fecha_expedicion = trim($_POST['fecha_expedicion'] ?? '');
    $lugar_expedicion = strtoupper(trim($_POST['lugar_expedicion'] ?? ''));
    
    // Campos nuevos agregados
    $zona = trim($_POST['zona'] ?? '');
    $barrio = trim($_POST['barrio'] ?? ''); // Ya no es strtoupper forzado, se deja como usuario escriba o se puede estandarizar
    $grupo_poblacional = trim($_POST['grupo_poblacional'] ?? 'Ninguno');
    $uso_tecnologia = trim($_POST['uso_tecnologia'] ?? '');
    $eps = strtoupper(trim($_POST['eps'] ?? ''));
    $nivel_educativo = strtoupper(trim($_POST['nivel_educativo'] ?? ''));
    $institucion_educativa = trim($_POST['institucion_educativa'] ?? '');
    if ($institucion_educativa === 'OTRA' && !empty($_POST['otra_institucion'])) {
        $institucion_educativa = strtoupper(trim($_POST['otra_institucion']));
    }
    $grado_actual = trim($_POST['grado_actual'] ?? '');
    $uso_tecnologia = trim($_POST['uso_tecnologia'] ?? '');

    // Campos del Acudiente
    $nombre_cuidador = strtoupper(trim($_POST['nombre_cuidador'] ?? ''));
    $parentesco_cuidador = trim($_POST['parentesco_cuidador'] ?? '');
    $zona_cuidador = trim($_POST['zona_cuidador'] ?? '');
    $barrio_cuidador = trim($_POST['barrio_cuidador'] ?? '');
    $direccion_cuidador = strtoupper(trim($_POST['direccion_cuidador'] ?? ''));
    $telefono_cuidador = trim($_POST['telefono_cuidador'] ?? '');
    
    // Manejo de la foto de perfil
    $upload_dir = '../../uploads/fotos_perfil/';
    $foto_perfil = null;
    $actualizar_foto = false;

    if (isset($_FILES['foto_perfil']) && $_FILES['foto_perfil']['error'] === UPLOAD_ERR_OK) {
        $file_tmp_name = $_FILES['foto_perfil']['tmp_name'];
        $file_name = $_FILES['foto_perfil']['name'];
        $file_extension = pathinfo($file_name, PATHINFO_EXTENSION);
        
        $new_file_name = uniqid('profile_') . '.' . $file_extension;
        $destination = $upload_dir . $new_file_name;

        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }

        if (move_uploaded_file($file_tmp_name, $destination)) {
            $foto_perfil = $new_file_name;
            $actualizar_foto = true;
        }
    }

    // Actualizar en la base de datos registro_estudiantes
    try {
        if($actualizar_foto) {
            $query = "UPDATE registro_estudiantes SET
                nombres=:nombres, apellidos=:apellidos, direccion=:direccion, genero=:genero, 
                grupo_sanguineo=:grupo_sanguineo, telefono=:telefono, tiene_whatsapp=:tiene_whatsapp, 
                fecha_nacimiento=:fecha_nacimiento, correo=:correo, tipo_usuario=:tipo_usuario, 
                fecha_expedicion=:fecha_expedicion, lugar_expedicion=:lugar_expedicion, foto_perfil=:foto_perfil,
                zona=:zona, barrio=:barrio, grupo_poblacional=:grupo_poblacional, eps=:eps,
                nivel_educativo=:nivel_educativo, institucion_educativa=:institucion_educativa, grado_actual=:grado_actual, uso_tecnologia=:uso_tecnologia,
                nombre_cuidador=:nombre_cuidador, parentesco_cuidador=:parentesco_cuidador, zona_cuidador=:zona_cuidador,
                barrio_cuidador=:barrio_cuidador, direccion_cuidador=:direccion_cuidador, telefono_cuidador=:telefono_cuidador
                WHERE numero_documento=:numero_documento LIMIT 1";
                
            $data = [
                ':nombres' => $nombres,
                ':apellidos' => $apellidos,
                ':direccion' => $direccion,
                ':genero' => $genero,
                ':grupo_sanguineo' => $grupo_sanguineo,
                ':telefono' => $telefono,
                ':tiene_whatsapp' => $tiene_whatsapp,
                ':fecha_nacimiento' => $fecha_nacimiento,
                ':correo' => $correo,
                ':tipo_usuario' => $tipo_usuario,
                ':fecha_expedicion' => $fecha_expedicion,
                ':lugar_expedicion' => $lugar_expedicion,
                ':foto_perfil' => $foto_perfil,
                ':zona' => $zona,
                ':barrio' => $barrio,
                ':grupo_poblacional' => $grupo_poblacional,
                ':eps' => $eps,
                ':nivel_educativo' => $nivel_educativo,
                ':institucion_educativa' => $institucion_educativa,
                ':grado_actual' => $grado_actual,
                ':uso_tecnologia' => $uso_tecnologia,
                ':nombre_cuidador' => $nombre_cuidador,
                ':parentesco_cuidador' => $parentesco_cuidador,
                ':zona_cuidador' => $zona_cuidador,
                ':barrio_cuidador' => $barrio_cuidador,
                ':direccion_cuidador' => $direccion_cuidador,
                ':telefono_cuidador' => $telefono_cuidador,
                ':numero_documento' => $numero_documento
            ];
        } else {
            $query = "UPDATE registro_estudiantes SET
                nombres=:nombres, apellidos=:apellidos, direccion=:direccion, genero=:genero, 
                grupo_sanguineo=:grupo_sanguineo, telefono=:telefono, tiene_whatsapp=:tiene_whatsapp, 
                fecha_nacimiento=:fecha_nacimiento, correo=:correo, tipo_usuario=:tipo_usuario, 
                fecha_expedicion=:fecha_expedicion, lugar_expedicion=:lugar_expedicion,
                zona=:zona, barrio=:barrio, grupo_poblacional=:grupo_poblacional, eps=:eps,
                nivel_educativo=:nivel_educativo, institucion_educativa=:institucion_educativa, grado_actual=:grado_actual, uso_tecnologia=:uso_tecnologia,
                nombre_cuidador=:nombre_cuidador, parentesco_cuidador=:parentesco_cuidador, zona_cuidador=:zona_cuidador,
                barrio_cuidador=:barrio_cuidador, direccion_cuidador=:direccion_cuidador, telefono_cuidador=:telefono_cuidador
                WHERE numero_documento=:numero_documento LIMIT 1";
                
            $data = [
                ':nombres' => $nombres,
                ':apellidos' => $apellidos,
                ':direccion' => $direccion,
                ':genero' => $genero,
                ':grupo_sanguineo' => $grupo_sanguineo,
                ':telefono' => $telefono,
                ':tiene_whatsapp' => $tiene_whatsapp,
                ':fecha_nacimiento' => $fecha_nacimiento,
                ':correo' => $correo,
                ':tipo_usuario' => $tipo_usuario,
                ':fecha_expedicion' => $fecha_expedicion,
                ':lugar_expedicion' => $lugar_expedicion,
                ':zona' => $zona,
                ':barrio' => $barrio,
                ':grupo_poblacional' => $grupo_poblacional,
                ':eps' => $eps,
                ':nivel_educativo' => $nivel_educativo,
                ':institucion_educativa' => $institucion_educativa,
                ':grado_actual' => $grado_actual,
                ':uso_tecnologia' => $uso_tecnologia,
                ':nombre_cuidador' => $nombre_cuidador,
                ':parentesco_cuidador' => $parentesco_cuidador,
                ':zona_cuidador' => $zona_cuidador,
                ':barrio_cuidador' => $barrio_cuidador,
                ':direccion_cuidador' => $direccion_cuidador,
                ':telefono_cuidador' => $telefono_cuidador,
                ':numero_documento' => $numero_documento
            ];
        }

        $statement = $connect->prepare($query);
        $query_execute = $statement->execute($data);

        if($query_execute) {
            echo '<div class="alert alert-success">
                <strong>¡Éxito!</strong> Tus datos han sido actualizados correctamente.
            </div>';
            
            // Recargar los datos
            echo '<script>
                setTimeout(function() {
                    window.location.href = "mi_informacion.php";
                }, 2000);
            </script>';
        } else {
            $errorInfo = $statement->errorInfo();
            echo '<div class="alert alert-error">
                <strong>Error!</strong> No se pudieron actualizar tus datos. ' . $errorInfo[2] . '
            </div>';
        }

    } catch (PDOException $e) {
        echo '<div class="alert alert-error"><strong>Error!</strong> ' . $e->getMessage() . '</div>';
    }
}
?>
