<?php 
require_once('../../backend/bd/Conexion.php'); 

if(isset($_POST['add_docu'])){
    $idpa = $_POST['docidpa'];
    $nompa = $_POST['docnopa'];
    $upload_dir = '../../backend/img/subidas/';
    $valid_extensions = array('jpeg', 'jpg', 'png', 'gif', 'pdf');
    
    $files = [
        'doc_identidad' => 'Documento de identidad',
        'doc_eps' => 'Certificado de la EPS',
        'doc_vca' => 'Certificado de VCA o Discapacidad',
        'doc_carnet' => 'Carnet de la Institución educativa'
    ];

    $success_count = 0;
    $processed_count = 0;
    $error_messages = [];

    foreach ($files as $input_name => $doc_label) {
        if (isset($_FILES[$input_name]) && $_FILES[$input_name]['error'] == 0) {
            $processed_count++;
            $imgFile = $_FILES[$input_name]['name'];
            $tmp_dir = $_FILES[$input_name]['tmp_name'];
            $imgSize = $_FILES[$input_name]['size'];
            
            $imgExt = strtolower(pathinfo($imgFile, PATHINFO_EXTENSION));
            $foto = rand(1000, 1000000) . "." . $imgExt;

            if (in_array($imgExt, $valid_extensions)) {
                if ($imgSize < 5000000) {
                    // Verificar si ya existe un documento con ese nombre para ese paciente
                    $stmt_check = $connect->prepare("SELECT iddoc, foto FROM document WHERE idpa = ? AND nomfi = ?");
                    $stmt_check->execute([$idpa, $doc_label]);
                    $existing = $stmt_check->fetch(PDO::FETCH_ASSOC);

                    if (move_uploaded_file($tmp_dir, $upload_dir . $foto)) {
                        if ($existing) {
                            // Reemplazar: Eliminar archivo viejo y actualizar registro
                            $old_file = $upload_dir . $existing['foto'];
                            if (file_exists($old_file)) {
                                unlink($old_file);
                            }
                            $sql = "UPDATE document SET foto = ?, state = '1' WHERE iddoc = ?";
                            $stmt = $connect->prepare($sql);
                            $result = $stmt->execute([$foto, $existing['iddoc']]);
                        } else {
                            // Nuevo: Insertar registro
                            $sql = "INSERT INTO document(nomfi, foto, idpa, nompa, state) VALUES(:nomfi, :foto, :idpa, :nompa, '1')";
                            $stmt = $connect->prepare($sql);
                            $stmt->bindParam(':nomfi', $doc_label);
                            $stmt->bindParam(':foto', $foto);
                            $stmt->bindParam(':idpa', $idpa);
                            $stmt->bindParam(':nompa', $nompa);
                            $result = $stmt->execute();
                        }
                        
                        if ($result) {
                            $success_count++;
                        } else {
                            $error_messages[] = "Error al guardar en BD: $doc_label";
                        }
                    } else {
                        $error_messages[] = "Error al mover archivo: $doc_label";
                    }
                } else {
                    $error_messages[] = "Archivo demasiado grande: $doc_label";
                }
            } else {
                $error_messages[] = "Extensión no permitida: $doc_label ($imgExt)";
            }
        }
    }

    if ($processed_count == 0) {
        echo '<script type="text/javascript">
        swal("Información", "No se seleccionaron archivos nuevos para cargar", "info").then(function() {
            window.location = "documentos_nuevo.php?id=' . $idpa . '";
        });
        </script>';
    } else if ($success_count == $processed_count) {
        echo '<script type="text/javascript">
        swal("¡Éxito!", "Los documentos han sido procesados correctamente", "success").then(function() {
            window.location = "documentos_nuevo.php?id=' . $idpa . '";
        });
        </script>';
    } else {
        $msg = "Se procesaron $success_count de $processed_count documentos. " . implode("\\n", $error_messages);
        echo '<script type="text/javascript">
        swal("Atención", "' . $msg . '", "warning").then(function() {
            window.location = "documentos_nuevo.php?id=' . $idpa . '";
        });
        </script>';
    }
}
?>