<?php  
if(isset($_POST['add_profileM']))
{
    $idodc = $_POST['mid'];
    $corr = $_POST['come'];
    $username = $_POST['namedc'];
    $password=MD5($_POST['pwdm']);
    $rol = $_POST['rlm'];
    
    try {
        // Primero verificar si el username ya existe en users
        $check = $connect->prepare("SELECT id FROM users WHERE username = :username");
        $check->execute([':username' => $username]);
        
        if($check->rowCount() > 0) {
            echo '<div class="alert-error">
  <strong>Error!</strong> El nombre de usuario ya existe &nbsp;<span class="badge-warning">*</span>
</div>';
            exit(0);
        }
        
        // Obtener el nombre del doctor
        $doctorInfo = $connect->prepare("SELECT nodoc, apdoc FROM doctor WHERE idodc = :idodc");
        $doctorInfo->execute([':idodc' => $idodc]);
        $doctor = $doctorInfo->fetch(PDO::FETCH_ASSOC);
        $fullName = $doctor['nodoc'] . ' ' . $doctor['apdoc'];

        // Actualizar tabla doctor
        $query = "UPDATE doctor SET corr=:corr, username=:username, password=:password, rol=:rol WHERE idodc=:idodc LIMIT 1";
        $statement = $connect->prepare($query);

        $data = [
            ':corr' => $corr,
            ':username' => $username,
            ':password' => $password,
            ':rol' => $rol,
            ':idodc' => $idodc
        ];
        $query_execute = $statement->execute($data);

        if($query_execute)
        {
            // Insertar en tabla users para permitir login
            $insertUser = $connect->prepare("INSERT INTO users (username, name, email, password, rol) VALUES (:username, :name, :email, :password, :rol)");
            $insertUser->execute([
                ':username' => $username,
                ':name' => $fullName,
                ':email' => $corr,
                ':password' => $password,
                ':rol' => $rol
            ]);
            
            // Obtener el ID del usuario recién creado
            $newUserId = $connect->lastInsertId();
            
            // Guardar permisos granulares si es rol 4, 5 o 6
            if($rol == 4 || $rol == 5 || $rol == 6) {
                // Verificar si la tabla existe y crearla/actualizarla
                try {
                    // Intentar crear la tabla
                    $createTable = "CREATE TABLE IF NOT EXISTS `user_permissions` (
                        `id` INT(11) NOT NULL AUTO_INCREMENT,
                        `user_id` INT(11) NOT NULL,
                        `view_valoracion_riesgo` TINYINT(1) DEFAULT 0,
                        `edit_valoracion_riesgo` TINYINT(1) DEFAULT 0,
                        `view_signos_vitales` TINYINT(1) DEFAULT 0,
                        `edit_signos_vitales` TINYINT(1) DEFAULT 0,
                        `view_medicamentos` TINYINT(1) DEFAULT 0,
                        `edit_medicamentos` TINYINT(1) DEFAULT 0,
                        `view_diagnostico` TINYINT(1) DEFAULT 0,
                        `edit_diagnostico` TINYINT(1) DEFAULT 0,
                        `view_antecedentes` TINYINT(1) DEFAULT 0,
                        `edit_antecedentes` TINYINT(1) DEFAULT 0,
                        `view_examenes` TINYINT(1) DEFAULT 0,
                        `edit_examenes` TINYINT(1) DEFAULT 0,
                        PRIMARY KEY (`id`),
                        UNIQUE KEY `user_id` (`user_id`)
                    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
                    $connect->exec($createTable);
                } catch(PDOException $e) {
                    // Tabla ya existe, intentar agregar columnas faltantes
                }
                
                // Verificar y agregar columnas faltantes (MySQL no soporta IF NOT EXISTS en ALTER)
                $columnsToCheck = [
                    'view_examenes' => "ALTER TABLE user_permissions ADD COLUMN view_examenes TINYINT(1) DEFAULT 0",
                    'edit_examenes' => "ALTER TABLE user_permissions ADD COLUMN edit_examenes TINYINT(1) DEFAULT 0"
                ];
                
                foreach($columnsToCheck as $columnName => $alterSQL) {
                    try {
                        // Verificar si la columna existe
                        $checkColumn = $connect->query("SHOW COLUMNS FROM user_permissions LIKE '$columnName'")->rowCount();
                        if($checkColumn == 0) {
                            // La columna no existe, agregarla
                            $connect->exec($alterSQL);
                        }
                    } catch(PDOException $e) {
                        // Error al verificar/agregar columna, continuar
                    }
                }
                
                // Insertar permisos
                $insertPerms = $connect->prepare("INSERT INTO user_permissions (
                    user_id, 
                    view_valoracion_riesgo, 
                    edit_valoracion_riesgo,
                    view_salud_oral,
                    edit_salud_oral,
                    view_salud_mental,
                    edit_salud_mental,
                    view_medicamentos,
                    edit_medicamentos,
                    view_signos_vitales,
                    edit_signos_vitales,
                    view_diagnostico,
                    edit_diagnostico,
                    view_antecedentes,
                    edit_antecedentes,
                    view_examenes,
                    edit_examenes
                ) VALUES (
                    :user_id,
                    :view_valoracion,
                    :edit_valoracion,
                    :view_salud_oral,
                    :edit_salud_oral,
                    :view_salud_mental,
                    :edit_salud_mental,
                    :view_medicamentos,
                    :edit_medicamentos,
                    :view_signos,
                    :edit_signos,
                    :view_diagnostico,
                    :edit_diagnostico,
                    :view_antecedentes,
                    :edit_antecedentes,
                    :view_examenes,
                    :edit_examenes
                )");
                
                $insertPerms->execute([
                    ':user_id' => $newUserId,
                    ':view_valoracion' => isset($_POST['perm_view_valoracion']) ? 1 : 0,
                    ':edit_valoracion' => isset($_POST['perm_edit_valoracion']) ? 1 : 0,
                    ':view_salud_oral' => isset($_POST['perm_view_salud_oral']) ? 1 : 0,
                    ':edit_salud_oral' => isset($_POST['perm_edit_salud_oral']) ? 1 : 0,
                    ':view_salud_mental' => isset($_POST['perm_view_salud_mental']) ? 1 : 0,
                    ':edit_salud_mental' => isset($_POST['perm_edit_salud_mental']) ? 1 : 0,
                    ':view_medicamentos' => isset($_POST['perm_view_medicamentos']) ? 1 : 0,
                    ':edit_medicamentos' => isset($_POST['perm_edit_medicamentos']) ? 1 : 0,
                    ':view_signos' => isset($_POST['perm_view_signos']) ? 1 : 0,
                    ':edit_signos' => isset($_POST['perm_edit_signos']) ? 1 : 0,
                    ':view_diagnostico' => isset($_POST['perm_view_diagnostico']) ? 1 : 0,
                    ':edit_diagnostico' => isset($_POST['perm_edit_diagnostico']) ? 1 : 0,
                    ':view_antecedentes' => isset($_POST['perm_view_antecedentes']) ? 1 : 0,
                    ':edit_antecedentes' => isset($_POST['perm_edit_antecedentes']) ? 1 : 0,
                    ':view_examenes' => isset($_POST['perm_view_examenes']) ? 1 : 0,
                    ':edit_examenes' => isset($_POST['perm_edit_examenes']) ? 1 : 0
                ]);
            }
            
            echo '<div class="alert-success">
  <strong>Success!</strong> Perfil creado correctamente con permisos personalizados. El usuario ya puede iniciar sesión &nbsp;<span class="badge-warning">*</span>
</div>';
            exit(0);
        }
        else
        {
           echo '<div class="alert-error">
  
  <strong>Error!</strong> No creado &nbsp;<span class="badge-warning">*</span>
</div>';
            exit(0);
        }

    } catch (PDOException $e) {
        echo $e->getMessage();
    }
}
?>



