<?php
// Archivo para procesar la creación de estudiantes desde el panel administrativo
// Combina la lógica de registro (users) e inscripción (registro_estudiantes)

require_once('../../backend/bd/Conexion.php'); 
global $connect;

// Habilitar reporte de errores para debugging (quitar en producción)
error_reporting(E_ALL);
ini_set('display_errors', 1);

$response = ['status' => 'error', 'message' => 'Error desconocido'];

if(isset($_POST['add_student_admin'])) {
    
    // ==========================================
    // 1. RECOLECCIÓN DE DATOS
    // ==========================================
    
    // Datos de Cuenta (users)
    $username = trim($_POST['username']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];
    $tipo_documento = trim($_POST['tdocumento']);
    $numero_documento = trim($_POST['nhi']); // Se usa como email/identificador en users
    
    // Nombres y Apellidos Desglosados
    $primer_nombre = strtoupper(trim($_POST['primer_nombre']));
    $segundo_nombre = strtoupper(trim($_POST['segundo_nombre'] ?? ''));
    $primer_apellido = strtoupper(trim($_POST['primer_apellido']));
    $segundo_apellido = strtoupper(trim($_POST['segundo_apellido'] ?? ''));
    
    // Concatenación para almacenamiento en DB (según esquema previo)
    $nombres = trim($primer_nombre . ' ' . $segundo_nombre);
    $apellidos = trim($primer_apellido . ' ' . $segundo_apellido);
    
    $tipo_estudiante = trim($_POST['tusuario'] ?? 'Nuevo'); // Tipo estudiante
    
    // Datos Personales (registro_estudiantes)
    $fecha_expedicion = trim($_POST['fexpedicion'] ?? null);
    $lugar_expedicion = strtoupper(trim($_POST['lexpedicion'] ?? ''));
    $fecha_nacimiento = trim($_POST['cump']);
    $genero = strtoupper(trim($_POST['gep']));
    $direccion = strtoupper(trim($_POST['dip']));
    $telefono = trim($_POST['telp']);
    
    // Datos Sociales (registro_estudiantes)
    $grupo_sanguineo = strtoupper(trim($_POST['grp'] ?? ''));
    $tiene_whatsapp = strtoupper(trim($_POST['tiene_whatsapp'] ?? 'NO'));
    $correo = trim($_POST['correo']);
    $zona = trim($_POST['zona'] ?? '');
    $barrio = trim($_POST['barrio'] ?? '');
    $grupo_poblacional = trim($_POST['grupo_poblacional'] ?? 'Ninguno');
    $etnia = strtoupper(trim($_POST['etnia'] ?? ''));
    
    // Datos Educativos/Institucionales (registro_estudiantes)
    $modalidad = strtoupper(trim($_POST['modalidad'] ?? '')); // Dato extra del admin
    $eps = strtoupper(trim($_POST['eps'] ?? ''));
    $nivel_educativo = strtoupper(trim($_POST['educacion'] ?? ''));
    $institucion_educativa = trim($_POST['institucion_educativa'] ?? '');
    $grado_actual = trim($_POST['grado_actual'] ?? '');
    
    // Validación de contraseñas
    if ($password !== $confirm_password) {
        echo "<script>alert('Las contraseñas no coinciden'); window.history.back();</script>";
        exit;
    }

    try {
        $connect->beginTransaction();

        // ==========================================
        // 2. CREACIÓN DE USUARIO (Tabla `users`)
        // ==========================================
        
        // Verificar si existe usuario o documento
        $stmt = $connect->prepare("SELECT COUNT(*) FROM users WHERE username = ? OR email = ?");
        $stmt->execute([$username, $numero_documento]);
        if ($stmt->fetchColumn() > 0) {
            throw new Exception("El usuario o documento ya se encuentra registrado en el sistema (Tabla Users).");
        }

        $password_hash = md5($password); // Usando MD5 como en el sistema actual
        $fullName = $nombres . " " . $apellidos;
        $rol = 3; // Estudiante/Ciudadano
        
        $sqlUser = "INSERT INTO users (username, name, email, tipo_documento, password, rol, aprobado) 
                    VALUES (:username, :name, :email, :tipo_documento, :password, :rol, 'aprobado')"; // Aprobado directo por ser admin
        
        $stmtUser = $connect->prepare($sqlUser);
        $stmtUser->execute([
            ':username' => $username,
            ':name' => $fullName,
            ':email' => $numero_documento, // Cédula como email (patrón existente)
            ':tipo_documento' => $tipo_documento,
            ':password' => $password_hash,
            ':rol' => $rol
        ]);
        
        $user_id = $connect->lastInsertId();

        // ==========================================
        // 3. PROCESAMIENTO DE FOTO
        // ==========================================
        $foto_perfil = null;
        $upload_dir = '../../uploads/fotos_perfil/';
        
        if (isset($_FILES['fotoperfil']) && $_FILES['fotoperfil']['error'] === UPLOAD_ERR_OK) {
            $file_extension = pathinfo($_FILES['fotoperfil']['name'], PATHINFO_EXTENSION);
            $new_file_name = uniqid('profile_admin_') . '.' . $file_extension;
            
            if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);
            
            if (move_uploaded_file($_FILES['fotoperfil']['tmp_name'], $upload_dir . $new_file_name)) {
                $foto_perfil = $new_file_name;
            }
        }

        // ==========================================
        // 4. CREACIÓN DE PERFIL (Tabla `registro_estudiantes`)
        // ==========================================
        
        // Verificar duplicados en registro_estudiantes
        $stmtCheck = $connect->prepare("SELECT COUNT(*) FROM registro_estudiantes WHERE numero_documento = ?");
        $stmtCheck->execute([$numero_documento]);
        if ($stmtCheck->fetchColumn() > 0) {
            // Nota: Podría existir en registro_estudiantes pero no en users si hubo un error previo, 
            // pero asumiremos consistencia. Si falla users, rollbback.
            throw new Exception("El estudiante ya tiene un registro de inscripción activo.");
        }

        $sqlEst = "INSERT INTO registro_estudiantes (
            modalidad, tipo_usuario, tipo_documento, numero_documento, nombres, apellidos,
            fecha_expedicion, lugar_expedicion, fecha_nacimiento, genero, direccion, telefono,
            grupo_sanguineo, tiene_whatsapp, correo, zona, barrio, grupo_poblacional,
            eps, etnia, nivel_educativo, institucion_educativa, grado_actual,
            foto_perfil, user_id, estado
        ) VALUES (
            :modalidad, :tipo_usuario, :tipo_documento, :numero_documento, :nombres, :apellidos,
            :fecha_expedicion, :lugar_expedicion, :fecha_nacimiento, :genero, :direccion, :telefono,
            :grupo_sanguineo, :tiene_whatsapp, :correo, :zona, :barrio, :grupo_poblacional,
            :eps, :etnia, :nivel_educativo, :institucion_educativa, :grado_actual,
            :foto_perfil, :user_id, 'aprobado'
        )";

        $stmtEst = $connect->prepare($sqlEst);
        $stmtEst->execute([
            ':modalidad' => $modalidad,
            ':tipo_usuario' => $tipo_estudiante,
            ':tipo_documento' => $tipo_documento,
            ':numero_documento' => $numero_documento,
            ':nombres' => $nombres,
            ':apellidos' => $apellidos,
            ':fecha_expedicion' => $fecha_expedicion,
            ':lugar_expedicion' => $lugar_expedicion,
            ':fecha_nacimiento' => $fecha_nacimiento,
            ':genero' => $genero,
            ':direccion' => $direccion,
            ':telefono' => $telefono,
            ':grupo_sanguineo' => $grupo_sanguineo,
            ':tiene_whatsapp' => $tiene_whatsapp,
            ':correo' => $correo,
            ':zona' => $zona,
            ':barrio' => $barrio,
            ':grupo_poblacional' => $grupo_poblacional,
            ':eps' => $eps,
            ':etnia' => $etnia,
            ':nivel_educativo' => $nivel_educativo,
            ':institucion_educativa' => $institucion_educativa,
            ':grado_actual' => $grado_actual,
            ':foto_perfil' => $foto_perfil,
            ':user_id' => $user_id
        ]);

        $connect->commit();
        
        // Éxito con SweetAlert
        echo '<script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/6.6.9/sweetalert2.min.js"></script>';
        echo "<script>
            setTimeout(function() {
                swal({
                    title: 'Guardado exitosamente',
                    text: 'Redirigiendo...',
                    type: 'success',
                    timer: 2000,
                    showConfirmButton: false
                }).then(function() {
                    window.location = '../../frontend/pacientes/mostrar.php';
                }, function (dismiss) {
                    if (dismiss === 'timer') {
                        window.location = '../../frontend/pacientes/mostrar.php';
                    }
                });
            }, 100);
        </script>";

    } catch (Exception $e) {
        $connect->rollBack();
        echo '<script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/6.6.9/sweetalert2.min.js"></script>';
        echo "<script>
            setTimeout(function() {
                swal({
                    title: 'Error',
                    text: '" . addslashes($e->getMessage()) . "',
                    type: 'error',
                    confirmButtonText: 'Cerrar'
                }).then(function() {
                    window.history.back();
                });
            }, 100);
        </script>";
    }
}
?>
