<?php
// backend/php/admin_update_student.php
require_once('../../backend/bd/Conexion.php'); 
global $connect;

// Habilitar reporte de errores para debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

if(isset($_POST['update_student_admin'])) {
    
    // ID del registro a actualizar
    $id_estudiante = $_POST['id_estudiante'];
    // Validar ID
    if(empty($id_estudiante)) {
        echo "<script>alert('ID de estudiante no proporcionado'); window.history.back();</script>";
        exit;
    }

    // ==========================================
    // 1. RECOLECCIÓN DE DATOS
    // ==========================================
    
    // Datos de Cuenta (users) - Update username/password logic if needed (Optional for now, let's focus on profile)
    // Assuming we might update password if provided, but for now specific request is about "info".
    // Let's stick to profile updates first. 

    // Nombres y Apellidos Desglosados
    $primer_nombre = strtoupper(trim($_POST['primer_nombre']));
    $segundo_nombre = strtoupper(trim($_POST['segundo_nombre'] ?? ''));
    $primer_apellido = strtoupper(trim($_POST['primer_apellido']));
    $segundo_apellido = strtoupper(trim($_POST['segundo_apellido'] ?? ''));
    
    // Concatenación
    $nombres = trim($primer_nombre . ' ' . $segundo_nombre);
    $apellidos = trim($primer_apellido . ' ' . $segundo_apellido);
    
    $tipo_estudiante = trim($_POST['tusuario'] ?? 'Nuevo'); 
    
    // Datos Personales
    $tipo_documento = trim($_POST['tdocumento']);
    $numero_documento = trim($_POST['nhi']); // Should likely not change for link integrity, but editable if error
    $fecha_expedicion = trim($_POST['fexpedicion'] ?? null);
    $lugar_expedicion = strtoupper(trim($_POST['lexpedicion'] ?? ''));
    $fecha_nacimiento = trim($_POST['cump']);
    $genero = strtoupper(trim($_POST['gep']));
    $direccion = strtoupper(trim($_POST['dip']));
    $telefono = trim($_POST['telp']);
    
    // Datos Sociales
    $grupo_sanguineo = strtoupper(trim($_POST['grp'] ?? ''));
    $tiene_whatsapp = strtoupper(trim($_POST['tiene_whatsapp'] ?? 'NO'));
    $correo = trim($_POST['correo']);
    $zona = trim($_POST['zona'] ?? '');
    $barrio = trim($_POST['barrio'] ?? '');
    $grupo_poblacional = trim($_POST['grupo_poblacional'] ?? 'Ninguno');
    $etnia = strtoupper(trim($_POST['etnia'] ?? ''));
    
    // Datos Educativos/Institucionales
    $modalidad = strtoupper(trim($_POST['modalidad'] ?? '')); 
    $eps = strtoupper(trim($_POST['eps'] ?? ''));
    $nivel_educativo = strtoupper(trim($_POST['educacion'] ?? ''));
    $institucion_educativa = trim($_POST['institucion_educativa'] ?? '');
    $grado_actual = trim($_POST['grado_actual'] ?? '');
    
    try {
        $connect->beginTransaction();

        // ==========================================
        // 2. PROCESAMIENTO DE FOTO
        // ==========================================
        $upload_dir = '../../uploads/fotos_perfil/';
        $foto_sql_part = "";
        $params = [
            ':modalidad' => $modalidad, ':tipo_usuario' => $tipo_estudiante, ':tipo_documento' => $tipo_documento, 
            ':numero_documento' => $numero_documento, ':nombres' => $nombres, ':apellidos' => $apellidos,
            ':fecha_expedicion' => $fecha_expedicion, ':lugar_expedicion' => $lugar_expedicion, ':fecha_nacimiento' => $fecha_nacimiento,
            ':genero' => $genero, ':direccion' => $direccion, ':telefono' => $telefono,
            ':grupo_sanguineo' => $grupo_sanguineo, ':tiene_whatsapp' => $tiene_whatsapp, ':correo' => $correo,
            ':zona' => $zona, ':barrio' => $barrio, ':grupo_poblacional' => $grupo_poblacional,
            ':eps' => $eps, ':etnia' => $etnia, ':nivel_educativo' => $nivel_educativo, 
            ':institucion_educativa' => $institucion_educativa, ':grado_actual' => $grado_actual,
            ':id' => $id_estudiante
        ];
        
        if (isset($_FILES['fotoperfil']) && $_FILES['fotoperfil']['error'] === UPLOAD_ERR_OK) {
            $file_extension = pathinfo($_FILES['fotoperfil']['name'], PATHINFO_EXTENSION);
            $new_file_name = uniqid('profile_admin_') . '.' . $file_extension;
            
            if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);
            
            if (move_uploaded_file($_FILES['fotoperfil']['tmp_name'], $upload_dir . $new_file_name)) {
                $foto_sql_part = ", foto_perfil = :foto_perfil";
                $params[':foto_perfil'] = $new_file_name;
            }
        }

        // ==========================================
        // 3. ACTUALIZACIÓN (registro_estudiantes)
        // ==========================================
        
        $sql = "UPDATE registro_estudiantes SET 
            modalidad = :modalidad, tipo_usuario = :tipo_usuario, tipo_documento = :tipo_documento, numero_documento = :numero_documento,
            nombres = :nombres, apellidos = :apellidos, fecha_expedicion = :fecha_expedicion, lugar_expedicion = :lugar_expedicion,
            fecha_nacimiento = :fecha_nacimiento, genero = :genero, direccion = :direccion, telefono = :telefono,
            grupo_sanguineo = :grupo_sanguineo, tiene_whatsapp = :tiene_whatsapp, correo = :correo, zona = :zona,
            barrio = :barrio, grupo_poblacional = :grupo_poblacional, eps = :eps, etnia = :etnia,
            nivel_educativo = :nivel_educativo, institucion_educativa = :institucion_educativa, grado_actual = :grado_actual
            $foto_sql_part
            WHERE id = :id";

        $stmt = $connect->prepare($sql);
        $stmt->execute($params);

        // Optional: Update `users` table name/email if linked (Assuming one-to-one manual link by admin via document)
        // This part is skipped for now to avoid complexity unless requested, but name update is good practice.
        // For now, only updating the record itself.

        $connect->commit();
        
        
        ?>
        <!DOCTYPE html>
        <html>
        <head>
            <script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/6.6.9/sweetalert2.min.js"></script>
            <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/6.6.9/sweetalert2.min.css">
        </head>
        <body>
            <script>
                swal({
                    title: "Información Actualizada",
                    text: "Los datos del estudiante han sido guardados correctamente.",
                    type: "success",
                    confirmButtonText: "OK",
                    closeOnConfirm: false
                }).then(function(){
                    window.location = "../../frontend/pacientes/mostrar.php";
                }, function(dismiss) {
                    // handle timer dismissal or click outside
                    window.location = "../../frontend/pacientes/mostrar.php";
                });
                
                // Fallback for older swal versions if .then isn't supported the same way
                // sweetalert2 v6 uses promises.
            </script>
        </body>
        </html>
        <?php
        exit();

    } catch (Exception $e) {
        $connect->rollBack();
        echo "<script>alert('Error: " . addslashes($e->getMessage()) . "'); window.history.back();</script>";
        exit();
    }
}
?>
