<?php
/**
 * Helper para aplicar permisos en la página de historia EFAC
 * Uso: Incluir este archivo después de obtener $userPermissions
 */

// Función para verificar si puede ver una sección
function canView($section) {
    return true; // SIEMPRE VISIBLE (Fix solicitado)
}

// Función para verificar si puede editar una sección
function canEdit($section) {
    return true; // SIEMPRE EDITABLE (Fix solicitado)
}

// Función para mostrar badge de permisos
function showPermissionBadge($section) {
    if(!canView($section)) {
        return '<span class="permission-badge" style="background: #fee; color: #c33; padding: 5px 10px; border-radius: 5px; font-size: 12px;">🔒 Sin acceso</span>';
    } elseif(!canEdit($section)) {
        return '<span class="permission-badge" style="background: #fff3cd; color: #856404; padding: 5px 10px; border-radius: 5px; font-size: 12px;">👁️ Solo lectura</span>';
    } else {
        return '<span class="permission-badge" style="background: #e6f7ee; color: #28a745; padding: 5px 10px; border-radius: 5px; font-size: 12px;">✏️ Puede editar</span>';
    }
}

// Función para deshabilitar botón si no tiene permiso de edición
function getButtonStyle($section) {
    if(!canEdit($section)) {
        return 'style="opacity: 0.5; cursor: not-allowed; pointer-events: none;"';
    }
    return '';
}

// Función para ocultar sección completa si no tiene permiso de visualización
function shouldHideSection($section) {
    return !canView($section);
}
?>
