<?php
// Archivo para inscribir al ciudadano en un curso
if(!isset($_SESSION['user_type']) || $_SESSION['user_type'] != 'ciudadano'){
    exit;
}

require_once('../../backend/bd/Conexion.php'); 
global $connect;

if(isset($_POST['inscribir_curso'])) {
    $cedula = $_SESSION['email']; // La cédula está guardada en el campo email
    $idcurso = trim($_POST['idcurso']);
    
    try {
        // Verificar si ya está inscrito
        $check = $connect->prepare("SELECT COUNT(*) FROM inscripciones WHERE documento = :cedula AND idcurso = :idcurso");
        $check->execute([':cedula' => $cedula, ':idcurso' => $idcurso]);
        $existe = $check->fetchColumn();
        
        if($existe > 0) {
            echo '<div class="alert alert-error">
                <strong>¡Atención!</strong> Ya estás inscrito en este curso.
            </div>';
        } else {
            // Validar límite de 3 cursos
            $check_limit = $connect->prepare("SELECT COUNT(*) FROM inscripciones WHERE documento = :cedula AND state = '1'");
            $check_limit->execute([':cedula' => $cedula]);
            $total_inscritos = $check_limit->fetchColumn();

            if ($total_inscritos >= 3) {
                echo '<div class="alert alert-error">
                    <strong>¡Límite alcanzado!</strong> No puedes inscribirte en más de 3 cursos simultáneamente.
                </div>';
                return;
            }

            // Validar Cupos Disponibles
            $check_cupos = $connect->prepare("SELECT cupos, (SELECT COUNT(*) FROM inscripciones WHERE idcurso = :idcurso AND state = '1') as inscritos FROM cursos WHERE idcurso = :idcurso");
            $check_cupos->execute([':idcurso' => $idcurso]);
            $data_cupos = $check_cupos->fetch(PDO::FETCH_ASSOC);

            if ($data_cupos) {
                $cupos_totales = intval($data_cupos['cupos']);
                $inscritos_actuales = intval($data_cupos['inscritos']);
                
                // Si cupos > 0 (tiene límite) y ya se llenaron
                if ($cupos_totales > 0 && $inscritos_actuales >= $cupos_totales) {
                    echo '<div class="alert alert-error">
                        <strong>¡Sin cupos!</strong> Lo sentimos, este curso ya ha alcanzado el límite máximo de estudiantes.
                    </div>';
                    return;
                }
            }

            // Realizar la inscripción (state = 1 por defecto)
            $insertar = $connect->prepare("INSERT INTO inscripciones (documento, idcurso, state) VALUES (:cedula, :idcurso, '1')");
            $resultado = $insertar->execute([':cedula' => $cedula, ':idcurso' => $idcurso]);
            
            if($resultado) {
                // Obtener el nombre del curso
                $curso_stmt = $connect->prepare("SELECT nombre FROM cursos WHERE idcurso = :idcurso");
                $curso_stmt->execute([':idcurso' => $idcurso]);
                $curso = $curso_stmt->fetch(PDO::FETCH_ASSOC);
                
                echo '<div class="alert alert-success">
                    <strong>¡Inscripción Exitosa!</strong><br>
                    Te has inscrito correctamente en el curso: <strong>' . htmlspecialchars($curso['nombre']) . '</strong>
                </div>';
                
                // Recargar la página después de 2 segundos
                echo '<script>
                    setTimeout(function() {
                        window.location.reload();
                    }, 2000);
                </script>';
            } else {
                echo '<div class="alert alert-error">
                    <strong>Error!</strong> No se pudo completar la inscripción. Por favor, intenta nuevamente.
                </div>';
            }
        }
    } catch(PDOException $e) {
        echo '<div class="alert alert-error">
            <strong>Error!</strong> ' . $e->getMessage() . '
        </div>';
    }
}
?>
