<?php
// Archivo para procesar inscripción de ciudadanos autenticados
if(!isset($_SESSION['user_type']) || $_SESSION['user_type'] != 'ciudadano'){
    exit;
}

require_once('../../backend/bd/Conexion.php'); 
global $connect;

if(isset($_POST['inscripcion_ciudadano'])) {
    
    // === PASO 1: INFORMACIÓN BÁSICA ===
    $modalidad = trim($_POST['modalidad'] ?? ''); // Opcional
    $tipo_usuario = trim($_POST['tusuario'] ?? 'Nuevo');
    $tipo_documento = trim($_POST['tdocumento'] ?? 'C.C');
    $numero_documento = trim($_POST['nhi']);
    $nombres = strtoupper(trim($_POST['namp']));
    $apellidos = strtoupper(trim($_POST['apep']));
    
    // === PASO 2: DATOS PERSONALES ===
    $fecha_expedicion_input = trim($_POST['fexpedicion'] ?? '');
    // Convertir fecha de YYYY-MM-DD (HTML) a formato de base de datos
    $fecha_expedicion = (!empty($fecha_expedicion_input)) ? $fecha_expedicion_input : null;
    
    $lugar_expedicion = strtoupper(trim($_POST['lexpedicion'] ?? ''));
    $fecha_nacimiento = trim($_POST['cump']);
    $genero = strtoupper(trim($_POST['gep']));
    $direccion = strtoupper(trim($_POST['dip']));
    $telefono = trim($_POST['telp']);
    
    // === PASO 3: INFORMACIÓN SOCIAL ===
    $grupo_sanguineo = strtoupper(trim($_POST['grp'] ?? ''));
    $estado_civil = strtoupper(trim($_POST['ecivil'] ?? '')); // Nuevo campo
    $tiene_whatsapp = strtoupper(trim($_POST['tiene_whatsapp'] ?? 'NO'));
    $correo = trim($_POST['correo']);
    $zona = trim($_POST['zona'] ?? '');
    $barrio = trim($_POST['barrio'] ?? '');
    
    // Otros campos sociales
    $sisben = trim($_POST['sisben'] ?? '');
    $recibe_bono = trim($_POST['rbono'] ?? '');
    $pensionado = trim($_POST['pensionado'] ?? '');
    $talla_sudadera = trim($_POST['tsudadera'] ?? '');
    $talla_chaqueta = trim($_POST['tchaqueta'] ?? '');
    $talla_zapatos = trim($_POST['tzapatos'] ?? '');
    $talento_fortaleza = strtoupper(trim($_POST['talentof'] ?? ''));
    $observacion_salida = trim($_POST['observacionsalida'] ?? '');
    $vive_con = strtoupper(trim($_POST['vivecomp'] ?? ''));
    $red_apoyo = trim($_POST['redapoyo'] ?? '');

    // === PASO 5: CUIDADOR ===
    $nombre_cuidador = strtoupper(trim($_POST['cuidador'] ?? ''));
    $parentesco_cuidador = trim($_POST['pcuidador'] ?? '');
    $zona_cuidador = trim($_POST['zcuidador'] ?? '');
    $barrio_cuidador = trim($_POST['bvccuidador'] ?? '');
    $direccion_cuidador = strtoupper(trim($_POST['dcuidador'] ?? ''));
    $telefono_cuidador = trim($_POST['tcuidador'] ?? '');

    // === PASO 6: SALUD Y EDUCACIÓN ===
    $sgsss = trim($_POST['sgsss'] ?? '');
    $eps = strtoupper(trim($_POST['eps'] ?? ''));
    $etnia = strtoupper(trim($_POST['etnia'] ?? ''));
    $nivel_educativo = strtoupper(trim($_POST['educacion'] ?? ''));
    $institucion_educativa = strtoupper(trim($_POST['institucion_educativa'] ?? ''));
    if ($institucion_educativa === 'OTRA' && !empty($_POST['otra_institucion'])) {
        $institucion_educativa = strtoupper(trim($_POST['otra_institucion']));
    }
    $grado_actual = strtoupper(trim($_POST['grado_actual'] ?? ''));
    $sabe_leer_escribir = strtoupper(trim($_POST['leer'] ?? 'SI'));
    $uso_tecnologia = trim($_POST['utecnologia'] ?? '');

    // === PASO 7: POBLACIÓN ===
    $grupo_poblacional = trim($_POST['poblaciond'] ?? 'Ninguno'); // Corregido nombre del campo
    $poblacion_oficio = trim($_POST['poblacionoficio'] ?? 'Ninguno');
    
    // === MANEJO DE FOTO DE PERFIL ===
    $upload_dir = '../../uploads/fotos_perfil/';
    $foto_perfil = null;

    if (isset($_FILES['fotoperfil']) && $_FILES['fotoperfil']['error'] === UPLOAD_ERR_OK) {
        $file_tmp_name = $_FILES['fotoperfil']['tmp_name'];
        $file_name = $_FILES['fotoperfil']['name'];
        $file_extension = pathinfo($file_name, PATHINFO_EXTENSION);
        
        $new_file_name = uniqid('profile_') . '.' . $file_extension;
        $destination = $upload_dir . $new_file_name;

        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }

        if (move_uploaded_file($file_tmp_name, $destination)) {
            $foto_perfil = $new_file_name;
        }
    }
    
    // === OBTENER USER_ID DEL USUARIO AUTENTICADO ===
    $user_id = null;
    try {
        $stmt_user = $connect->prepare("SELECT id FROM users WHERE email = :cedula");
        $stmt_user->execute([':cedula' => $numero_documento]);
        $user_data = $stmt_user->fetch(PDO::FETCH_ASSOC);
        if($user_data) {
            $user_id = $user_data['id'];
        }
    } catch(PDOException $e) {
        error_log("Error obteniendo user_id: " . $e->getMessage());
    }

    // === VERIFICAR SI EL DOCUMENTO YA EXISTE ===
    try {
        $stmt_check = $connect->prepare("SELECT COUNT(*) FROM registro_estudiantes WHERE numero_documento = :numero_documento");
        $stmt_check->execute([':numero_documento' => $numero_documento]);
        $count = $stmt_check->fetchColumn();

        if ($count > 0) {
            echo '<div class="alert alert-error"><strong>Error!</strong> Este número de documento ya está registrado en el sistema.</div>';
            exit(0);
        }
    } catch (PDOException $e) {
        echo '<div class="alert alert-error"><strong>Error!</strong> ' . $e->getMessage() . '</div>';
        exit(0);
    }

    // === VERIFICACIÓN FINAL: Asegurar que la columna existe ===
    try {
        $check = $connect->query("SHOW COLUMNS FROM registro_estudiantes LIKE 'estado_civil'");
        if ($check->rowCount() == 0) {
            $connect->exec("ALTER TABLE registro_estudiantes ADD estado_civil VARCHAR(50) NULL AFTER grupo_sanguineo");
        }
    } catch (Exception $e) {
        // Ignorar error si ya existe
    }

    // === DEBUG ===
    // die("Llegamos al bloque de inserción. Estado Civil: " . $estado_civil);

    // === INSERTAR EN LA BASE DE DATOS ===
    try {
        $query = "INSERT INTO registro_estudiantes (modalidad, tipo_usuario, tipo_documento, numero_documento, nombres, apellidos, fecha_expedicion, lugar_expedicion, fecha_nacimiento, genero, direccion, telefono, grupo_sanguineo, estado_civil, tiene_whatsapp, correo, zona, barrio, sisben, recibe_bono, pensionado, talla_sudadera, talla_chaqueta, talla_zapatos, talento_fortaleza, observacion_salida, vive_con, red_apoyo, nombre_cuidador, parentesco_cuidador, zona_cuidador, barrio_cuidador, direccion_cuidador, telefono_cuidador, sgsss, eps, etnia, nivel_educativo, institucion_educativa, grado_actual, sabe_leer_escribir, uso_tecnologia, grupo_poblacional, poblacion_oficio, foto_perfil, user_id, estado) VALUES (:modalidad, :tipo_usuario, :tipo_documento, :numero_documento, :nombres, :apellidos, :fecha_expedicion, :lugar_expedicion, :fecha_nacimiento, :genero, :direccion, :telefono, :grupo_sanguineo, :estado_civil, :tiene_whatsapp, :correo, :zona, :barrio, :sisben, :recibe_bono, :pensionado, :talla_sudadera, :talla_chaqueta, :talla_zapatos, :talento_fortaleza, :observacion_salida, :vive_con, :red_apoyo, :nombre_cuidador, :parentesco_cuidador, :zona_cuidador, :barrio_cuidador, :direccion_cuidador, :telefono_cuidador, :sgsss, :eps, :etnia, :nivel_educativo, :institucion_educativa, :grado_actual, :sabe_leer_escribir, :uso_tecnologia, :grupo_poblacional, :poblacion_oficio, :foto_perfil, :user_id, 'pendiente')";

        $statement = $connect->prepare($query);

        $data = [
            ':modalidad' => $modalidad,
            ':tipo_usuario' => $tipo_usuario,
            ':tipo_documento' => $tipo_documento,
            ':numero_documento' => $numero_documento,
            ':nombres' => $nombres,
            ':apellidos' => $apellidos,
            ':fecha_expedicion' => $fecha_expedicion,
            ':lugar_expedicion' => $lugar_expedicion,
            ':fecha_nacimiento' => $fecha_nacimiento,
            ':genero' => $genero,
            ':direccion' => $direccion,
            ':telefono' => $telefono,
            ':grupo_sanguineo' => $grupo_sanguineo,
            ':estado_civil' => $estado_civil,
            ':tiene_whatsapp' => $tiene_whatsapp,
            ':correo' => $correo,
            ':zona' => $zona,
            ':barrio' => $barrio,
            ':sisben' => $sisben,
            ':recibe_bono' => $recibe_bono,
            ':pensionado' => $pensionado,
            ':talla_sudadera' => $talla_sudadera,
            ':talla_chaqueta' => $talla_chaqueta,
            ':talla_zapatos' => $talla_zapatos,
            ':talento_fortaleza' => $talento_fortaleza,
            ':observacion_salida' => $observacion_salida,
            ':vive_con' => $vive_con,
            ':red_apoyo' => $red_apoyo,
            ':nombre_cuidador' => $nombre_cuidador,
            ':parentesco_cuidador' => $parentesco_cuidador,
            ':zona_cuidador' => $zona_cuidador,
            ':barrio_cuidador' => $barrio_cuidador,
            ':direccion_cuidador' => $direccion_cuidador,
            ':telefono_cuidador' => $telefono_cuidador,
            ':sgsss' => $sgsss,
            ':eps' => $eps,
            ':etnia' => $etnia,
            ':nivel_educativo' => $nivel_educativo,
            ':institucion_educativa' => $institucion_educativa,
            ':grado_actual' => $grado_actual,
            ':sabe_leer_escribir' => $sabe_leer_escribir,
            ':uso_tecnologia' => $uso_tecnologia,
            ':grupo_poblacional' => $grupo_poblacional,
            ':poblacion_oficio' => $poblacion_oficio,
            ':foto_perfil' => $foto_perfil,
            ':user_id' => $user_id
        ];

        $query_execute = $statement->execute($data);

        if($query_execute) {
            echo '<div class="alert alert-success" style="position: relative; z-index: 10000;">
                <strong>¡Inscripción Completada!</strong><br>
                Tu inscripción al programa ha sido enviada correctamente.<br>
                <strong>Nombre:</strong> ' . $nombres . ' ' . $apellidos . '<br>
                <strong>Documento:</strong> ' . $numero_documento . '<br><br>
                Serás redirigido al dashboard en 3 segundos...
            </div>';
            
            echo '<script>
                setTimeout(function() {
                    window.location.href = "dashboard.php";
                }, 3000);
            </script>';
        } else {
            $errorInfo = $statement->errorInfo();
            echo '<div class="alert alert-error" style="position: relative; z-index: 10000;">
                <strong>Error!</strong> No se pudo procesar tu inscripción.<br>
                Error SQL: ' . $errorInfo[2] . '
            </div>';
            error_log("Error SQL: " . print_r($errorInfo, true));
        }

    } catch (PDOException $e) {
        echo '<div class="alert alert-error" style="position: relative; z-index: 10000;">
            <strong>Error PDO!</strong> ' . $e->getMessage() . '<br>
            <strong>Código:</strong> ' . $e->getCode() . '
        </div>';
        error_log("Error PDO: " . $e->getMessage());
    }
}
?>
