<?php
/**
 * Cargar permisos del usuario en la sesión
 * Este archivo debe ser incluido después del login exitoso
 */

if(!isset($_SESSION['id'])) {
    return;
}

try {
    require_once __DIR__ . '/../bd/Conexion.php';
    
    // Cargar permisos de menú
    $stmt = $connect->prepare("SELECT * FROM menu_permissions WHERE user_id = ?");
    $stmt->execute([$_SESSION['id']]);
    $menuPerms = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if($menuPerms !== false) {
        // Guardar en sesión que tiene permisos personalizados
        $_SESSION['has_custom_permissions'] = true;
        $_SESSION['menu_permissions'] = $menuPerms;
    } else {
        $_SESSION['has_custom_permissions'] = false;
        $_SESSION['menu_permissions'] = [];
    }
    
} catch(PDOException $e) {
    $_SESSION['has_custom_permissions'] = false;
    $_SESSION['menu_permissions'] = [];
}
?>
