<?php 
    require '../backend/bd/Conexion.php';

    if(isset($_POST['login'])) {
    $errMsg = '';

    // Get data from FORM
    $username = $_POST['username'];
    $password = MD5($_POST['password']);

    if($username == '')
      $errMsg = 'Digite su usuario o documento';
    if($password == '')
      $errMsg = 'Digite su contraseña';

    if($errMsg == '') {
      try {
        // Primero buscar en la tabla users (funcionarios Y ciudadanos registrados)
        // Intentar obtener columnas de aprobación si existen
        try {
            $stmt = $connect->prepare('SELECT id, username, name, email, password, rol, aprobado, motivo_rechazo FROM users WHERE username = :username');
            $stmt->execute([':username' => $username]);
            $dataUser = $stmt->fetch(PDO::FETCH_ASSOC);
        } catch(PDOException $e) {
            // Si la columna aprobado no existe, usar consulta sin ella
            $stmt = $connect->prepare('SELECT id, username, name, email, password, rol FROM users WHERE username = :username');
            $stmt->execute([':username' => $username]);
            $dataUser = $stmt->fetch(PDO::FETCH_ASSOC);
            if($dataUser) {
                $dataUser['aprobado'] = 'aprobado'; // Por defecto aprobado si no existe la columna
            }
        }

        // Si no se encuentra en users, buscar en patients (ciudadanos antiguos sin registro)
        if($dataUser == false) {
            $stmtPatient = $connect->prepare('SELECT idpa, numhs, nompa, apepa, password FROM patients WHERE numhs = :documento');
            $stmtPatient->execute([':documento' => $username]);
            $dataPatient = $stmtPatient->fetch(PDO::FETCH_ASSOC);
            
            if($dataPatient == false) {
                $errMsg = "El usuario o documento: $username no se encuentra en el sistema.";
            } else {
                // Es un ciudadano
                // Si no tiene password configurado o está vacío, usar el documento como password
                $patientPassword = !empty($dataPatient['password']) ? $dataPatient['password'] : MD5($dataPatient['numhs']);
                
                // Debug
                error_log("Login ciudadano - Documento: " . $dataPatient['numhs']);
                error_log("Password BD: " . $dataPatient['password']);
                error_log("Password calculado: " . $patientPassword);
                error_log("Password ingresado: " . $password);
                
                if($password == $patientPassword) {
                    $_SESSION['id'] = $dataPatient['idpa'];
                    $_SESSION['username'] = $dataPatient['numhs'];
                    $_SESSION['name'] = $dataPatient['nompa'] . ' ' . $dataPatient['apepa'];
                    $_SESSION['email'] = $dataPatient['numhs'];
                    $_SESSION['password'] = $patientPassword;
                    $_SESSION['rol'] = 3; // Rol de ciudadano
                    $_SESSION['user_type'] = 'ciudadano';
                    
                    error_log("Login exitoso, redirigiendo a ciudadano/dashboard.php");
                    header('Location: ciudadano/dashboard.php');
                    exit;
                } else {
                    $errMsg = 'Contraseña incorrecta. Si no has configurado una contraseña, usa tu documento.';
                    error_log("Contraseña incorrecta para ciudadano");
                }
            }
        } else {
          // Usuario encontrado en tabla users
          if($password == $dataUser['password']) {
            
            // Verificar estado de aprobación para ciudadanos (rol 3)
            if($dataUser['rol'] == 3) {
                $estadoAprobacion = $dataUser['aprobado'] ?? 'pendiente';
                
                // Permitir login pero guardar estado de aprobación
                $_SESSION['id'] = $dataUser['id'];
                $_SESSION['username'] = $dataUser['username'];
                $_SESSION['name'] = $dataUser['name'];
                $_SESSION['email'] = $dataUser['email'];
                $_SESSION['password'] = $dataUser['password'];
                $_SESSION['rol'] = $dataUser['rol'];
                $_SESSION['user_type'] = 'ciudadano';
                $_SESSION['estado_aprobacion'] = $estadoAprobacion;
                $_SESSION['motivo_rechazo'] = $dataUser['motivo_rechazo'] ?? null;
                
                header('Location: ciudadano/dashboard.php');
                exit;
            } else {
                // Es un funcionario - no requiere aprobación
                $_SESSION['id'] = $dataUser['id'];
                $_SESSION['username'] = $dataUser['username'];
                $_SESSION['name'] = $dataUser['name'];
                $_SESSION['email'] = $dataUser['email'];
                $_SESSION['password'] = $dataUser['password'];
                $_SESSION['rol'] = $dataUser['rol'];
                // Es un funcionario
                $_SESSION['user_type'] = 'funcionario';
                
                // Cargar permisos personalizados en la sesión
                try {
                    $permsStmt = $connect->prepare("SELECT * FROM menu_permissions WHERE user_id = ?");
                    $permsStmt->execute([$dataUser['id']]);
                    $menuPerms = $permsStmt->fetch(PDO::FETCH_ASSOC);
                    
                    if($menuPerms !== false) {
                        $_SESSION['has_custom_permissions'] = true;
                        $_SESSION['menu_permissions'] = $menuPerms;
                    } else {
                        // Si no tiene permisos configurados, crear permisos por defecto
                        $createPerms = $connect->prepare("INSERT INTO menu_permissions (user_id, dashboard) VALUES (?, 1)");
                        $createPerms->execute([$dataUser['id']]);
                        
                        // Cargar los permisos recién creados
                        $permsStmt->execute([$dataUser['id']]);
                        $menuPerms = $permsStmt->fetch(PDO::FETCH_ASSOC);
                        
                        $_SESSION['has_custom_permissions'] = true;
                        $_SESSION['menu_permissions'] = $menuPerms;
                    }
                } catch(PDOException $e) {
                    // Si hay error, dar acceso solo al dashboard
                    $_SESSION['has_custom_permissions'] = true;
                    $_SESSION['menu_permissions'] = ['dashboard' => 1];
                    error_log("Error cargando permisos: " . $e->getMessage());
                }
                
                // Redirigir según el rol del funcionario
                switch($_SESSION['rol']) {
                  case 1: // Administrador
                  case 2: // Auxiliar
                    header('Location: admin/escritorio.php');
                    break;
                  case 3: // Profesor
                    header('Location: profesionales/dashboard_profesor.php');
                    break;
                  case 4: // Profesor
                    header('Location: profesionales/dashboard_profesor.php');
                    break;
                  case 5: // Fisioterapeuta
                    header('Location: profesionales/dashboard_fisioterapeuta.php');
                    break;
                  case 6: // Enfermería
                    header('Location: profesionales/dashboard_enfermeria.php');
                    break;
                  default:
                    $errMsg = 'Rol no autorizado.';
                    exit;
                }
                exit;
            }
          } else {
            $errMsg = 'Contraseña incorrecta.';
          }
        }
      }
      catch(PDOException $e) {
        $errMsg = $e->getMessage();
      }
    }
  }
 ?>