<?php
// Archivo para procesar registro de ciudadanos
require_once('../../backend/bd/Conexion.php'); 
global $connect;

if(isset($_POST['register_ciudadano'])) {
    $errMsg = '';
    
    // Recibir datos del formulario
    $tipo_documento = trim($_POST['tipo_documento']);
    $cedula = trim($_POST['cedula']);
    $primer_nombre = strtoupper(trim($_POST['primer_nombre']));
    $segundo_nombre = strtoupper(trim($_POST['segundo_nombre'] ?? ''));
    $primer_apellido = strtoupper(trim($_POST['primer_apellido']));
    $segundo_apellido = strtoupper(trim($_POST['segundo_apellido'] ?? ''));
    $tipo_estudiante = trim($_POST['tipo_estudiante']);
    $username = trim($_POST['username']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];
    
    // Concatenar nombres y apellidos
    $nombres = trim($primer_nombre . ' ' . $segundo_nombre);
    $apellidos = trim($primer_apellido . ' ' . $segundo_apellido);
    
    // Validaciones
    if(empty($tipo_documento)) {
        $errMsg = 'Por favor seleccione el tipo de documento';
    } elseif(empty($cedula)) {
        $errMsg = 'Por favor ingrese su número de documento';
    } elseif(!preg_match('/^[0-9]+$/', $cedula)) {
        $errMsg = 'El número de documento solo debe contener números';
    } elseif(empty($primer_nombre)) {
        $errMsg = 'Por favor ingrese su primer nombre';
    } elseif(empty($primer_apellido)) {
        $errMsg = 'Por favor ingrese su primer apellido';
    } elseif(empty($tipo_estudiante)) {
        $errMsg = 'Por favor seleccione el tipo de estudiante';
    } elseif(empty($username)) {
        $errMsg = 'Por favor ingrese un nombre de usuario';
    } elseif(strlen($username) < 4) {
        $errMsg = 'El nombre de usuario debe tener al menos 4 caracteres';
    } elseif(empty($password)) {
        $errMsg = 'Por favor ingrese una contraseña';
    } elseif(strlen($password) < 6) {
        $errMsg = 'La contraseña debe tener al menos 6 caracteres';
    } elseif($password !== $confirm_password) {
        $errMsg = 'Las contraseñas no coinciden';
    }
    
    if($errMsg == '') {
        try {
            // Verificar si el username ya existe
            $stmt_check_user = $connect->prepare("SELECT COUNT(*) FROM users WHERE username = :username");
            $stmt_check_user->execute([':username' => $username]);
            $user_exists = $stmt_check_user->fetchColumn();
            
            if($user_exists > 0) {
                $errMsg = 'El nombre de usuario ya está en uso. Por favor elija otro.';
            } else {
                // Verificar si la cédula ya existe en users
                $stmt_check_cedula = $connect->prepare("SELECT COUNT(*) FROM users WHERE email = :cedula");
                $stmt_check_cedula->execute([':cedula' => $cedula]);
                $cedula_exists = $stmt_check_cedula->fetchColumn();
                
                if($cedula_exists > 0) {
                    $errMsg = 'Esta cédula ya está registrada en el sistema.';
                } else {
                    // Crear el usuario
                    $password_hash = MD5($password);
                    $name = $nombres . ' ' . $apellidos;
                    $rol = 3; // Rol para ciudadanos (cambiado de 7 a 3)
                    
                    $stmt_insert = $connect->prepare("INSERT INTO users (username, name, email, tipo_documento, password, rol, aprobado) VALUES (:username, :name, :email, :tipo_documento, :password, :rol, 'pendiente')");
                    
                    $result = $stmt_insert->execute([
                        ':username' => $username,
                        ':name' => $name,
                        ':email' => $cedula, // Guardamos la cédula en el campo email
                        ':tipo_documento' => $tipo_documento,
                        ':password' => $password_hash,
                        ':rol' => $rol
                    ]);
                    
                    if($result) {
                        echo '<div class="alert alert-success">
                            <strong>¡Registro Exitoso!</strong><br>
                            Tu cuenta ha sido creada correctamente.<br>
                            <strong>Usuario:</strong> ' . $username . '<br>
                            <strong>Nombre:</strong> ' . $name . '<br><br>
                            <strong style="color: #856404;">⚠️ Tu cuenta está pendiente de aprobación.</strong><br>
                            Un funcionario del programa debe aprobar tu acceso antes de que puedas ingresar al sistema.<br>
                            Recibirás una notificación cuando tu cuenta sea aprobada.<br><br>
                            <a href="../login.php" style="color: #155724; text-decoration: underline;"><strong>Volver al inicio de sesión</strong></a>
                        </div>';
                        
                        // Limpiar formulario
                        echo '<script>
                            setTimeout(function() {
                                window.location.href = "../login.php";
                            }, 3000);
                        </script>';
                    } else {
                        $errMsg = 'Error al crear la cuenta. Por favor intente nuevamente.';
                    }
                }
            }
            
        } catch(PDOException $e) {
            $errMsg = 'Error en la base de datos: ' . $e->getMessage();
        }
    }
    
    if($errMsg != '') {
        echo '<div class="alert alert-error">
            <strong>Error!</strong> ' . $errMsg . '
        </div>';
    }
}
?>
