<?php
/**
 * Menú lateral dinámico según rol del usuario
 * Incluir este archivo en lugar del sidebar estático
 */

// Asegurarse de que check_access.php esté incluido
if (!function_exists('hasModulePermission')) {
    require_once '../../backend/php/check_access.php';
}

// Usar dashboard.php que hace el routing automático
$dashboardUrl = '../dashboard.php';
$isAdmin = isAdmin();
$isProfessional = isProfessional();
?>

<!-- SIDEBAR -->
<section id="sidebar">
    <a href="<?php echo $dashboardUrl; ?>" class="brand">
        <i class='bx bxs-heart icon'></i> EFAC
    </a>
    <ul class="side-menu">
        
        <li><a href="<?php echo $dashboardUrl; ?>"><i class='bx bxs-dashboard icon'></i> Dashboard</a></li>
        <li class="divider" data-text="main">Main</li>
        
        <?php if(hasModulePermission('remisiones')): ?>
        <li>
            <a href="#"><i class='bx bxs-book-alt icon'></i> Agenda con Profesores <i class='bx bx-chevron-right icon-right'></i></a>
            <ul class="side-dropdown">
                <?php if($isAdmin || hasSubmenuPermission('remisiones_todas')): ?>
                <li><a href="../citas/mostrar.php">Agenda con Profesores</a></li>
                <?php endif; ?>
                <?php if($isAdmin || hasSubmenuPermission('remisiones_nueva')): ?>
                <li><a href="../citas/nuevo.php">Nueva</a></li>
                <?php endif; ?>
                <?php if($isAdmin || hasSubmenuPermission('remisiones_calendario')): ?>
                <li><a href="../citas/calendario.php">Calendario</a></li>
                <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>

        <?php if(hasModulePermission('usuarios')): ?>
        <li>
            <a href="#"><i class='bx bxs-user icon'></i> Estudiantes <i class='bx bx-chevron-right icon-right'></i></a>
            <ul class="side-dropdown">
                <?php if($isAdmin || hasSubmenuPermission('usuarios_lista')): ?>
                <li><a href="../pacientes/mostrar.php">Lista de Estudiantes</a></li>
                <?php endif; ?>
                <?php if($isAdmin || hasSubmenuPermission('usuarios_historial')): ?>
                <li><a href="../pacientes/historial.php">Informe Estudiantes</a></li>
                <?php endif; ?>
                <?php if($isAdmin || hasSubmenuPermission('usuarios_documentos')): ?>
                <li><a href="../pacientes/documentos.php">Documentos</a></li>
                <?php endif; ?>
                <?php if($isAdmin || $isProfessional): ?>
                <li><a href="../pacientes/aprobar_ciudadanos.php">Aprobar Ciudadanos</a></li>
                <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>

        <?php if(hasModulePermission('cursos')): ?>
        <li>
            <a href="#"><i class='bx bxs-id-card icon'></i> Escuelas de Formacion <i class='bx bx-chevron-right icon-right'></i></a>
            <ul class="side-dropdown">
                <?php if($isAdmin || hasSubmenuPermission('cursos_registro')): ?>
                <li><a href="../cursos/registro_esc_formacion.php">Registro Cursos</a></li>
                <?php endif; ?>
                <?php if($isAdmin || hasSubmenuPermission('cursos_inscripcion')): ?>
                <li><a href="../cursos/inscribir_curso.php">Inscripción Cursos</a></li>
                <?php endif; ?>
                <?php if($isAdmin || hasSubmenuPermission('cursos_asistencia')): ?>
                <li><a href="../cursos/Asistencia.php">Asistencia</a></li>
                <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>

        <?php if($isAdmin || hasSubmenuPermission('cursos_area_virtual')): ?>
        <li>
            <a href="../cursos/area_virtual.php"><i class='bx bx-grid-alt icon'></i> Área Virtual</a>
        </li>
        <?php endif; ?>

        <?php if(hasModulePermission('asistencia')): ?>
        <li>
            <li><a href="../asistencia/Asistencia.php"><i class='bx bxs-info-circle icon'></i> Asistencia</a></li>
        </li>
        <?php endif; ?>

        <?php if(hasModulePermission('profesionales')): ?>
        <li>
            <a href="#"><i class='bx bxs-briefcase icon'></i> Profesionales <i class='bx bx-chevron-right icon-right'></i></a>
            <ul class="side-dropdown">
                <?php if($isAdmin || hasSubmenuPermission('profesionales_lista')): ?>
                <li><a href="../medicos/mostrar.php">Lista de Profesionales</a></li>
                <?php endif; ?>
                <?php if($isAdmin || hasSubmenuPermission('profesionales_historial')): ?>
                <li><a href="../medicos/historial.php">Historial de los Profesionales</a></li>
                <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>

        <?php if(hasModulePermission('ajustes')): ?>
        <li>
            <a href="#"><i class='bx bxs-cog icon'></i> Ajustes <i class='bx bx-chevron-right icon-right'></i></a>
            <ul class="side-dropdown">
                <?php if($isAdmin || hasSubmenuPermission('ajustes_config')): ?>
                <li><a href="../ajustes/mostrar.php">Ajustes</a></li>
                <?php endif; ?>
                <?php if($isAdmin || hasSubmenuPermission('ajustes_idioma')): ?>
                <li><a href="../ajustes/idioma.php">Idioma</a></li>
                <?php endif; ?>
                <?php if($isAdmin || hasSubmenuPermission('ajustes_base_datos')): ?>
                <li><a href="../ajustes/base.php">Base de datos</a></li>
                <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>

        <?php if(hasModulePermission('acerca')): ?>
        <li><a href="../acerca/mostrar.php"><i class='bx bxs-info-circle icon'></i> Acerca de</a></li>
        <?php endif; ?>
        
    </ul>
</section>
<!-- SIDEBAR -->
