<?php
/**
 * Script para copiar el formulario completo del administrador
 * y adaptarlo para el portal del ciudadano
 */

echo "<h1>Copiando Formulario Completo...</h1>";

// Leer el archivo del administrador
$archivoAdmin = file_get_contents('frontend/pacientes/nuevo.php');

// Extraer solo la parte del formulario (desde <form hasta </form>)
preg_match('/<form action="".*?<\/form>/s', $archivoAdmin, $matches);

if(empty($matches)) {
    die("No se pudo encontrar el formulario en nuevo.php");
}

$formularioCompleto = $matches[0];

// Hacer las adaptaciones necesarias
$formularioAdaptado = $formularioCompleto;

// Cambiar el nombre del botón submit
$formularioAdaptado = str_replace('name="add_patiens"', 'name="inscripcion_ciudadano"', $formularioAdaptado);

// Cambiar el título
$formularioAdaptado = str_replace('<h1>Nuevo Usuario</h1>', '<h1>Formulario de Inscripción al Programa</h1>', $formularioAdaptado);

// Pre-llenar campos con datos del usuario logueado
$formularioAdaptado = str_replace(
    '<input type="text" placeholder="ejm: Juan Raul" name="namp" required>',
    '<input type="text" value="<?php echo $nombres; ?>" placeholder="ejm: Juan Raul" name="namp" required>',
    $formularioAdaptado
);

$formularioAdaptado = str_replace(
    '<input type="text" placeholder="ejm: Ramirez Requena" name="apep" required>',
    '<input type="text" value="<?php echo $apellidos; ?>" placeholder="ejm: Ramirez Requena" name="apep" required>',
    $formularioAdaptado
);

$formularioAdaptado = str_replace(
    '<input type="text" placeholder="ejm: 77114578" name="nhi" maxlength="10" required>',
    '<input type="text" value="<?php echo $cedula; ?>" placeholder="ejm: 77114578" name="nhi" maxlength="10" required disabled>
    <input type="hidden" name="nhi" value="<?php echo $cedula; ?>">',
    $formularioAdaptado
);

// Crear el contenido completo del archivo inscripcion.php
$contenidoCompleto = '<?php
    ob_start();
    session_start();
    
    if(!isset($_SESSION[\'user_type\']) || $_SESSION[\'user_type\'] != \'ciudadano\'){
        header(\'location: ../login.php\');
        exit;
    }
    
    require_once(\'../../backend/bd/Conexion.php\');
    global $connect;
    
    $username = $_SESSION[\'username\'];
    $name = $_SESSION[\'name\'];
    $cedula = $_SESSION[\'email\']; // La cédula está guardada en el campo email
    
    // Verificar si ya completó la inscripción
    try {
        $stmt = $connect->prepare("SELECT * FROM patients WHERE numhs = :cedula");
        $stmt->execute([\':cedula\' => $cedula]);
        $datos_paciente = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if($datos_paciente) {
            // Ya completó la inscripción, redirigir al dashboard
            header(\'location: dashboard.php\');
            exit;
        }
    } catch(PDOException $e) {
        // Error al consultar
    }
    
    // Separar nombre y apellido
    $nombre_completo = explode(\' \', $name, 2);
    $nombres = $nombre_completo[0] ?? \'\';
    $apellidos = $nombre_completo[1] ?? \'\';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href=\'https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css\' rel=\'stylesheet\'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/6.6.9/sweetalert2.min.css">
    <title>Inscripción - EFAC</title>
    
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
        }
        .containerss {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        .btn-back {
            display: inline-block;
            padding: 12px 25px;
            background: #667eea;
            color: white;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            margin-bottom: 20px;
        }
        .btn-back:hover {
            background: #764ba2;
        }
    </style>
</head>
<body>
    <div class="containerss">
        <a href="dashboard.php" class="btn-back">
            <i class=\'bx bx-arrow-back\'></i> Volver al Dashboard
        </a>
        
        <?php include_once \'../../backend/php/inscripcion_ciudadano.php\'; ?>
        
        ' . $formularioAdaptado . '
    </div>
    
    <script src="../../backend/js/jquery.min.js"></script>
    <script src="../../backend/js/script.js"></script>
    <script src="../../backend/js/multistep.js"></script>
    <script src="../../backend/js/vpat.js"></script>
    
    <!-- Script para previsualizar la imagen -->
    <script>
    document.getElementById(\'fotoperfil\').addEventListener(\'change\', function(e) {
        const file = e.target.files[0];
        const preview = document.getElementById(\'img-preview\');
        
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                preview.src = e.target.result;
                preview.style.display = \'block\';
            }
            reader.readAsDataURL(file);
        } else {
            preview.style.display = \'none\';
        }
    });
    </script>
</body>
</html>';

// Guardar el archivo
file_put_contents('frontend/ciudadano/inscripcion_completa.php', $contenidoCompleto);

echo "<h2 style=\'color: green;\'>✅ Formulario copiado exitosamente!</h2>";
echo "<p>El archivo se guardó en: <strong>frontend/ciudadano/inscripcion_completa.php</strong></p>";
echo "<p>Ahora puedes:</p>";
echo "<ol>";
echo "<li>Renombrar <code>inscripcion.php</code> a <code>inscripcion_simple.php</code> (backup)</li>";
echo "<li>Renombrar <code>inscripcion_completa.php</code> a <code>inscripcion.php</code></li>";
echo "</ol>";
echo "<br><a href=\'frontend/ciudadano/inscripcion_completa.php\' style=\'padding: 10px 20px; background: blue; color: white; text-decoration: none; border-radius: 5px;\'>Ver Formulario Completo</a>";
?>
