<?php
// Script de debug para verificar usuarios ciudadanos
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'backend/bd/Conexion.php';

echo "<h1>Debug: Verificación de Usuarios Ciudadanos</h1>";
echo "<style>
    body { font-family: Arial, sans-serif; margin: 20px; }
    table { border-collapse: collapse; width: 100%; margin: 20px 0; }
    th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
    th { background-color: #4CAF50; color: white; }
    tr:nth-child(even) { background-color: #f2f2f2; }
    .info { background: #e7f3ff; padding: 15px; margin: 10px 0; border-left: 4px solid #2196F3; }
    .error { background: #ffe7e7; padding: 15px; margin: 10px 0; border-left: 4px solid #f44336; }
</style>";

try {
    // 1. Verificar conexión
    echo "<div class='info'><strong>✓ Conexión a la base de datos exitosa</strong></div>";
    
    // 2. Contar todos los usuarios
    $stmtTotal = $connect->query("SELECT COUNT(*) as total FROM users");
    $total = $stmtTotal->fetch(PDO::FETCH_ASSOC);
    echo "<div class='info'>Total de usuarios en la tabla 'users': <strong>" . $total['total'] . "</strong></div>";
    
    // 3. Contar usuarios por rol
    $stmtRoles = $connect->query("SELECT rol, COUNT(*) as cantidad FROM users GROUP BY rol");
    echo "<h2>Usuarios por Rol</h2>";
    echo "<table><tr><th>Rol</th><th>Cantidad</th></tr>";
    while ($r = $stmtRoles->fetch(PDO::FETCH_ASSOC)) {
        echo "<tr><td>" . htmlspecialchars($r['rol']) . "</td><td>" . $r['cantidad'] . "</td></tr>";
    }
    echo "</table>";
    
    // 4. Buscar usuarios con rol = 3
    $stmtRol3 = $connect->prepare("SELECT * FROM users WHERE rol = 3 ORDER BY id DESC LIMIT 10");
    $stmtRol3->execute();
    $usuariosRol3 = $stmtRol3->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h2>Usuarios con rol = 3 (Ciudadanos) - Últimos 10</h2>";
    if (count($usuariosRol3) > 0) {
        echo "<div class='info'>Se encontraron <strong>" . count($usuariosRol3) . "</strong> usuarios con rol = 3</div>";
        echo "<table>";
        echo "<tr>";
        foreach (array_keys($usuariosRol3[0]) as $key) {
            echo "<th>" . htmlspecialchars($key) . "</th>";
        }
        echo "</tr>";
        foreach ($usuariosRol3 as $user) {
            echo "<tr>";
            foreach ($user as $val) {
                echo "<td>" . htmlspecialchars($val ?? 'NULL') . "</td>";
            }
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<div class='error'><strong>⚠ No se encontraron usuarios con rol = 3</strong></div>";
    }
    
    // 5. Probar la consulta exacta de aprobar_ciudadanos.php
    echo "<h2>Prueba de Consulta de Aprobar Ciudadanos</h2>";
    $sentenciaTest = $connect->prepare("
        SELECT u.id, u.username, u.name, u.email, u.aprobado, 
               u.motivo_rechazo, u.created_at,
               re.nombres, re.apellidos, re.telefono, re.genero,
               re.numero_documento,
               aprobador.name as nombre_aprobador
        FROM users u
        LEFT JOIN registro_estudiantes re ON u.id = re.user_id
        LEFT JOIN users aprobador ON u.aprobado_por = aprobador.id
        WHERE u.rol = 3
        ORDER BY 
            CASE COALESCE(u.aprobado, 'pendiente')
                WHEN 'pendiente' THEN 1
                WHEN 'aprobado' THEN 2
                WHEN 'rechazado' THEN 3
            END,
            u.created_at DESC
    ");
    $sentenciaTest->execute();
    $resultadosTest = $sentenciaTest->fetchAll(PDO::FETCH_ASSOC);
    
    if (count($resultadosTest) > 0) {
        echo "<div class='info'>La consulta devolvió <strong>" . count($resultadosTest) . "</strong> resultados</div>";
        echo "<table>";
        echo "<tr>";
        foreach (array_keys($resultadosTest[0]) as $key) {
            echo "<th>" . htmlspecialchars($key) . "</th>";
        }
        echo "</tr>";
        foreach ($resultadosTest as $row) {
            echo "<tr>";
            foreach ($row as $val) {
                echo "<td>" . htmlspecialchars($val ?? 'NULL') . "</td>";
            }
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<div class='error'><strong>⚠ La consulta no devolvió resultados</strong></div>";
    }
    
    // 6. Verificar estructura de la tabla users
    echo "<h2>Columnas de la tabla 'users'</h2>";
    $stmtColumns = $connect->query("DESCRIBE users");
    echo "<table><tr><th>Campo</th><th>Tipo</th><th>Null</th><th>Key</th><th>Default</th></tr>";
    while ($col = $stmtColumns->fetch(PDO::FETCH_ASSOC)) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($col['Field']) . "</td>";
        echo "<td>" . htmlspecialchars($col['Type']) . "</td>";
        echo "<td>" . htmlspecialchars($col['Null']) . "</td>";
        echo "<td>" . htmlspecialchars($col['Key']) . "</td>";
        echo "<td>" . htmlspecialchars($col['Default'] ?? 'NULL') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
    
} catch (Exception $e) {
    echo "<div class='error'><strong>ERROR:</strong> " . htmlspecialchars($e->getMessage()) . "</div>";
    echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
}
?>
