<?php
// Debug script to check enrollment data with ciclo vital
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'backend/bd/Conexion.php';

echo "<h1>Debug: Datos de Inscritos con Ciclo Vital</h1>";
echo "<style>
    body { font-family: Arial, sans-serif; margin: 20px; }
    table { border-collapse: collapse; width: 100%; margin: 20px 0; }
    th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
    th { background-color: #4CAF50; color: white; }
    .info { background: #e7f3ff; padding: 15px; margin: 10px 0; border-left: 4px solid #2196F3; }
</style>";

// Test query for a specific course
$idcurso = 50; // Change this to test different courses

echo "<div class='info'><strong>Testing query for idcurso = $idcurso</strong></div>";

$sql = "SELECT DISTINCT 
            COALESCE(re.nombres, u.name, p.nompa) as nombres,
            COALESCE(re.apellidos, '', p.apepa) as apellidos,
            i.documento,
            c.nombre as curso_nombre,
            re.fecha_nacimiento,
            TIMESTAMPDIFF(YEAR, re.fecha_nacimiento, CURDATE()) as edad,
            cv.nombre_ciclo,
            cv.min_edad,
            cv.max_edad
        FROM inscripciones i
        LEFT JOIN cursos c ON i.idcurso = c.idcurso
        LEFT JOIN registro_estudiantes re ON i.documento = re.numero_documento
        LEFT JOIN users u ON i.documento = u.email OR i.documento = u.username
        LEFT JOIN patients p ON i.documento = p.numhs
        LEFT JOIN ciclo_vital cv ON TIMESTAMPDIFF(YEAR, re.fecha_nacimiento, CURDATE()) BETWEEN cv.min_edad AND cv.max_edad
        WHERE i.idcurso = ? AND i.state = '1'
        ORDER BY nombres, apellidos";

$stmt = $connect->prepare($sql);
$stmt->execute([$idcurso]);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<h2>Resultados</h2>";
if (count($rows) > 0) {
    echo "<table>";
    echo "<tr><th>Nombre</th><th>Doc</th><th>Fecha Nac</th><th>Edad</th><th>Ciclo Vital</th><th>Min-Max Edad</th></tr>";
    foreach ($rows as $row) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($row['nombres'] . ' ' . $row['apellidos']) . "</td>";
        echo "<td>" . htmlspecialchars($row['documento']) . "</td>";
        echo "<td>" . htmlspecialchars($row['fecha_nacimiento'] ?? 'NULL') . "</td>";
        echo "<td>" . htmlspecialchars($row['edad'] ?? 'NULL') . "</td>";
        echo "<td>" . htmlspecialchars($row['nombre_ciclo'] ?? 'NULL') . "</td>";
        echo "<td>" . htmlspecialchars(($row['min_edad'] ?? '?') . '-' . ($row['max_edad'] ?? '?')) . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>No hay resultados</p>";
}

// Also check registro_estudiantes data
echo "<h2>Datos en registro_estudiantes</h2>";
$stmt2 = $connect->query("SELECT numero_documento, nombres, apellidos, fecha_nacimiento FROM registro_estudiantes LIMIT 10");
$students = $stmt2->fetchAll(PDO::FETCH_ASSOC);

if (count($students) > 0) {
    echo "<table>";
    echo "<tr><th>Documento</th><th>Nombres</th><th>Apellidos</th><th>Fecha Nac</th></tr>";
    foreach ($students as $s) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($s['numero_documento']) . "</td>";
        echo "<td>" . htmlspecialchars($s['nombres']) . "</td>";
        echo "<td>" . htmlspecialchars($s['apellidos']) . "</td>";
        echo "<td>" . htmlspecialchars($s['fecha_nacimiento'] ?? 'NULL') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}
?>
