<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

$conn_file = __DIR__ . '/backend/bd/Conexion.php';
if (file_exists($conn_file)) {
    require_once($conn_file);
    echo "Archivo de conexión encontrado.<br>";
} else {
    die("Error: No se encontró el archivo de conexión en $conn_file");
}

global $connect;
if (!isset($connect)) {
    die("Error: La variable \$connect no está definida.");
}

try {
    echo "<h2>Tablas en la base de datos:</h2>";
    $stmt = $connect->query("SHOW TABLES");
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
    if (empty($tables)) {
        echo "No se encontraron tablas.";
    } else {
        foreach ($tables as $table) {
            echo $table . "<br>";
        }
    }
    
    if (in_array('registro_estudiantes', $tables)) {
        echo "<h2>Estructura de 'registro_estudiantes':</h2>";
        $stmt = $connect->query("DESCRIBE registro_estudiantes");
        echo "<table border='1'><tr><th>Campo</th><th>Tipo</th></tr>";
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            echo "<tr><td>{$row['Field']}</td><td>{$row['Type']}</td></tr>";
        }
        echo "</table>";
    } else {
        echo "<h2>La tabla 'registro_estudiantes' NO existe.</h2>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}
?>
