<?php
session_start();
require 'backend/bd/Conexion.php';

echo "<h1>Diagnóstico de Permisos - Usuario crubiano</h1>";

// Buscar el usuario crubiano
try {
    $stmt = $connect->prepare("SELECT id, username, rol FROM usuarios WHERE username = ?");
    $stmt->execute(['crubiano']);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if($user) {
        echo "<h2>✅ Usuario encontrado:</h2>";
        echo "<p><strong>ID:</strong> {$user['id']}</p>";
        echo "<p><strong>Username:</strong> {$user['username']}</p>";
        echo "<p><strong>Rol:</strong> {$user['rol']} (Profesor)</p>";
        
        // Buscar permisos personalizados
        $permsStmt = $connect->prepare("SELECT * FROM menu_permissions WHERE user_id = ?");
        $permsStmt->execute([$user['id']]);
        $perms = $permsStmt->fetch(PDO::FETCH_ASSOC);
        
        echo "<hr>";
        echo "<h2>Permisos en Base de Datos:</h2>";
        
        if($perms !== false) {
            echo "<p style='color: green;'>✅ Tiene permisos personalizados en la tabla menu_permissions</p>";
            echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
            echo "<tr style='background: #667eea; color: white;'><th>Campo</th><th>Valor</th><th>Estado</th></tr>";
            
            foreach($perms as $key => $value) {
                if($key != 'id' && $key != 'user_id') {
                    $estado = $value == 1 ? '✅ HABILITADO' : '❌ DESHABILITADO';
                    $color = $value == 1 ? 'lightgreen' : 'lightcoral';
                    echo "<tr style='background: $color;'>";
                    echo "<td><strong>$key</strong></td>";
                    echo "<td>$value</td>";
                    echo "<td>$estado</td>";
                    echo "</tr>";
                }
            }
            echo "</table>";
        } else {
            echo "<p style='color: orange;'>⚠️ NO tiene permisos personalizados en la tabla</p>";
            echo "<p>Esto significa que usará los permisos por defecto del rol 3 (Profesor)</p>";
        }
        
    } else {
        echo "<p style='color: red;'>❌ Usuario 'crubiano' no encontrado</p>";
    }
    
} catch(PDOException $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<h2>Sesión Actual (si está logueado):</h2>";

if(isset($_SESSION['id']) && isset($_SESSION['username'])) {
    echo "<p><strong>Usuario en sesión:</strong> {$_SESSION['username']}</p>";
    echo "<p><strong>ID:</strong> {$_SESSION['id']}</p>";
    echo "<p><strong>Rol:</strong> {$_SESSION['rol']}</p>";
    
    if(isset($_SESSION['has_custom_permissions'])) {
        echo "<p><strong>has_custom_permissions:</strong> " . ($_SESSION['has_custom_permissions'] ? 'true ✅' : 'false ❌') . "</p>";
        
        if($_SESSION['has_custom_permissions'] && isset($_SESSION['menu_permissions'])) {
            echo "<h3>Permisos cargados en sesión:</h3>";
            echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
            echo "<tr style='background: #667eea; color: white;'><th>Módulo</th><th>Valor</th></tr>";
            foreach($_SESSION['menu_permissions'] as $key => $value) {
                if($key != 'id' && $key != 'user_id') {
                    $color = $value == 1 ? 'lightgreen' : 'lightcoral';
                    echo "<tr style='background: $color;'><td>$key</td><td>$value</td></tr>";
                }
            }
            echo "</table>";
        }
    } else {
        echo "<p style='color: red;'>⚠️ NO tiene 'has_custom_permissions' en sesión</p>";
        echo "<p>Está usando permisos por defecto del rol</p>";
    }
} else {
    echo "<p style='color: orange;'>⚠️ No hay sesión activa</p>";
}

echo "<hr>";
echo "<h2>Permisos por defecto del Rol 3 (Profesor):</h2>";
echo "<ul>";
echo "<li>dashboard: ✅ true</li>";
echo "<li>remisiones: ❌ false</li>";
echo "<li>usuarios: ✅ true</li>";
echo "<li>cursos: ✅ true</li>";
echo "<li>asistencia: ✅ true</li>";
echo "<li>profesionales: ❌ false</li>";
echo "<li>recursos: ❌ false</li>";
echo "<li>ajustes: ❌ false</li>";
echo "<li>acerca: ✅ true</li>";
echo "<li>reportes: ❌ false</li>";
echo "</ul>";

echo "<hr>";
echo "<p><a href='recargar_permisos_sesion.php'>🔄 Recargar permisos en sesión</a></p>";
?>
