<?php
session_start();
require '../backend/php/check_access.php';

// Si no hay sesión, redirigir al login
if(!isset($_SESSION['rol'])) {
    header('location: login.php');
    exit();
}

$roleName = getRoleName($_SESSION['rol']);
$dashboard = getDashboardByRole($_SESSION['rol']);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Acceso Denegado | EFAC</title>
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .container {
            background: white;
            border-radius: 24px;
            padding: 60px 50px;
            max-width: 600px;
            width: 100%;
            text-align: center;
            box-shadow: 0 30px 80px rgba(102, 126, 234, 0.3);
            animation: slideIn 0.6s ease;
        }

        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateY(-30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .icon-container {
            width: 120px;
            height: 120px;
            margin: 0 auto 30px;
            background: linear-gradient(135deg, #fee 0%, #fdd 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.05);
            }
        }

        .icon-container i {
            font-size: 64px;
            color: #c33;
        }

        h1 {
            font-size: 32px;
            font-weight: 700;
            color: #1a1a1a;
            margin-bottom: 15px;
        }

        .error-code {
            font-size: 18px;
            color: #c33;
            font-weight: 600;
            margin-bottom: 25px;
        }

        p {
            font-size: 16px;
            color: #666;
            line-height: 1.8;
            margin-bottom: 15px;
        }

        .user-info {
            background: #f8f9fc;
            padding: 20px;
            border-radius: 12px;
            margin: 30px 0;
            border-left: 4px solid #667eea;
        }

        .user-info p {
            margin: 8px 0;
            color: #333;
        }

        .user-info strong {
            color: #667eea;
        }

        .btn-container {
            display: flex;
            gap: 15px;
            justify-content: center;
            margin-top: 35px;
            flex-wrap: wrap;
        }

        .btn {
            padding: 15px 35px;
            border-radius: 12px;
            font-size: 15px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            transition: all 0.3s ease;
            border: none;
            cursor: pointer;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        }

        .btn-primary:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.6);
        }

        .btn-secondary {
            background: #6c757d;
            color: white;
            box-shadow: 0 4px 12px rgba(108, 117, 125, 0.3);
        }

        .btn-secondary:hover {
            background: #5a6268;
            transform: translateY(-2px);
        }

        @media (max-width: 480px) {
            .container {
                padding: 40px 30px;
            }

            h1 {
                font-size: 24px;
            }

            .btn-container {
                flex-direction: column;
            }

            .btn {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="icon-container">
            <i class='bx bx-block'></i>
        </div>

        <h1>Acceso Denegado</h1>
        <p class="error-code">Error 403 - Forbidden</p>

        <p>Lo sentimos, no tienes permisos para acceder a esta sección del sistema.</p>
        <p>Tu rol actual no tiene autorización para ver este contenido.</p>

        <div class="user-info">
            <p><strong>Usuario:</strong> <?php echo htmlspecialchars($_SESSION['username']); ?></p>
            <p><strong>Nombre:</strong> <?php echo htmlspecialchars($_SESSION['name']); ?></p>
            <p><strong>Rol:</strong> <?php echo htmlspecialchars($roleName); ?></p>
        </div>

        <p>Si crees que esto es un error, contacta al administrador del sistema.</p>

        <div class="btn-container">
            <a href="<?php echo $dashboard; ?>" class="btn btn-primary">
                <i class='bx bx-home'></i>
                Ir al Dashboard
            </a>
            <a href="salir.php" class="btn btn-secondary">
                <i class='bx bx-log-out'></i>
                Cerrar Sesión
            </a>
        </div>
    </div>
</body>
</html>
