<?php
    ob_start();
     session_start();
    
    if(!isset($_SESSION['rol']) || ($_SESSION['rol'] != 1 && $_SESSION['rol'] != 2)){
    header('location: ../login.php');

    $id=$_SESSION['id'];
  }
?>
    <?php 
    require_once('../../backend/bd/Conexion.php');
$req = $connect->prepare("SELECT id, title, start, end, color FROM events");
$req->execute();
$events = $req->fetchAll();

$totalPatients = (int) $connect->query("SELECT COUNT(*) FROM patients")->fetchColumn();
$totalProfessionals = (int) $connect->query("SELECT COUNT(*) FROM doctor")->fetchColumn();
$totalUsers = (int) $connect->query("SELECT COUNT(*) FROM users")->fetchColumn();
$totalAppointments = (float) $connect->query("SELECT COALESCE(SUM(monto),0) FROM events")->fetchColumn();



$latestPatientsStmt = $connect->prepare("SELECT nompa, apepa, modalidad FROM patients ORDER BY idpa DESC LIMIT 6");
$latestPatientsStmt->execute();
$latestPatients = $latestPatientsStmt->fetchAll(PDO::FETCH_OBJ);

$statCards = [
    [
        'label' => 'Estudiantes inscritos',
        'value' => number_format($totalPatients),
        'icon'  => 'bx-user',
        'description' => 'Registros activos',
        'accent' => '#f1c40f'
    ],
    [
        'label' => 'Profesionales',
        'value' => number_format($totalProfessionals),
        'icon'  => 'bx-user-voice',
        'description' => 'Especialistas vinculados',
        'accent' => '#00cec9'
    ],
    [
        'label' => 'Usuarios',
        'value' => number_format($totalUsers),
        'icon'  => 'bx-group',
        'description' => 'Cuentas creadas',
        'accent' => '#ff7675'
    ],
    [
        'label' => 'Citas agendadas',
        'value' => 'S/. ' . number_format($totalAppointments, 2),
        'icon'  => 'bx-calendar-check',
        'description' => 'Monto total registrado',
        'accent' => '#6c5ce7'
    ],
];

$engagementScore = 72;
$engagementCircumference = 2 * M_PI * 54;
$engagementOffset = $engagementCircumference * (1 - ($engagementScore / 100));
$todayLabel = date('d M Y');
     ?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">

    <!-- Data Tables -->
        <link rel="stylesheet" href="../../backend/vendor/datatables/dataTables.bs4.css" />
        <link rel="stylesheet" href="../../backend/vendor/datatables/dataTables.bs4-custom.css" />
        <link href="../../backend/vendor/datatables/buttons.bs.css" rel="stylesheet" />

        <!-- FullCalendar -->
    <link href='../../backend/css/fullcalendar.css' rel='stylesheet' />
        <style type="text/css">
            :root {
                --neo-bg: #050505;
                --neo-panel: #0f1014;
                --neo-card: #181a1f;
                --neo-muted: #b0b3c1;
                --neo-text: #f5f6fb;
                --neo-border: rgba(255,255,255,0.08);
                --neo-accent: #ff8c32;
            }
            body,
            #content {
                background: var(--neo-bg);
                color: var(--neo-text);
            }
            #calendar {
                max-width: 800px;
            }
            .col-centered{
                float: none;
                margin: 0 auto;
            }
            main.neo-dashboard {
                background: var(--neo-panel);
                padding: 30px;
                border-radius: 18px;
                box-shadow: 0 40px 80px rgba(0,0,0,0.45);
                margin: 30px;
            }
            .neo-hero {
                display: flex;
                justify-content: space-between;
                align-items: flex-start;
                gap: 30px;
            }
            .neo-hero h1 {
                margin: 5px 0 10px;
                font-size: 2.2rem;
                color: #fff;
            }
            .neo-hero__actions {
                display: flex;
                gap: 15px;
                align-items: center;
            }
            .neo-search {
                position: relative;
            }
            .neo-search input {
                background: #1c1f26;
                border: 1px solid var(--neo-border);
                color: var(--neo-text);
                padding: 12px 45px 12px 18px;
                width: 260px;
                border-radius: 999px;
            }
            .neo-search i {
                position: absolute;
                right: 18px;
                top: 50%;
                transform: translateY(-50%);
                color: var(--neo-muted);
            }
            .neo-btn {
                background: linear-gradient(135deg, #ff8c32, #f44336);
                border: none;
                color: white;
                padding: 12px 26px;
                border-radius: 999px;
                font-weight: 600;
                cursor: pointer;
                transition: transform .2s ease;
            }
            .neo-btn:hover {
                transform: translateY(-2px);
            }
            .neo-grid {
                display: grid;
                gap: 20px;
                margin-top: 30px;
            }
            .neo-grid--primary {
                grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            }
            .neo-grid--secondary {
                grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
            }
            .neo-grid--tertiary {
                grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            }
            .neo-card {
                background: var(--neo-card);
                border-radius: 18px;
                padding: 20px;
                border: 1px solid var(--neo-border);
                box-shadow: inset 0 0 0 1px rgba(255,255,255,0.01);
            }
            .neo-card__header {
                display: flex;
                justify-content: space-between;
                align-items: center;
                margin-bottom: 18px;
            }
            .neo-card__header h3 {
                margin: 0;
                font-size: 1rem;
                letter-spacing: 0.04em;
                text-transform: uppercase;
                color: var(--neo-muted);
            }
            .neo-card--progress {
                grid-row: span 2;
                display: flex;
                flex-direction: column;
                justify-content: space-between;
            }
            .neo-progress {
                width: 150px;
                height: 150px;
                margin: 0 auto 20px;
            }
            .neo-progress circle {
                fill: transparent;
                stroke-width: 12;
                transform: rotate(-90deg);
                transform-origin: 50% 50%;
            }
            .neo-progress .bg {
                stroke: rgba(255,255,255,0.08);
            }
            .neo-progress .meter {
                stroke: var(--neo-accent);
                stroke-linecap: round;
                transition: stroke-dashoffset .6s ease;
            }
            .neo-progress__value {
                text-align: center;
                font-size: 2rem;
                margin-top: -112px;
                color: #fff;
            }
            .neo-progress__label {
                text-align: center;
                color: var(--neo-muted);
                font-size: .9rem;
            }
            .neo-stat {
                display: flex;
                align-items: center;
                gap: 18px;
                padding: 12px;
                border-radius: 16px;
                background: rgba(255,255,255,0.02);
                border: 1px solid var(--neo-border);
                position: relative;
                overflow: hidden;
            }
            .neo-stat::after {
                content: '';
                position: absolute;
                inset: 0;
                background: linear-gradient(135deg, transparent, rgba(255,255,255,0.04));
                opacity: 0;
                transition: opacity .3s ease;
            }
            .neo-stat:hover::after {
                opacity: 1;
            }
            .neo-stat__icon {
                width: 48px;
                height: 48px;
                border-radius: 12px;
                display: grid;
                place-items: center;
                background: rgba(255,255,255,0.08);
                color: var(--accent, var(--neo-accent));
            }
            .neo-stat__icon i {
                font-size: 1.4rem;
            }
            .neo-stat__value {
                font-size: 1.6rem;
                font-weight: 700;
                margin: 0;
            }
            .neo-stat__label {
                margin: 2px 0 0;
                color: var(--neo-muted);
                font-size: .85rem;
            }
            .neo-color-bar {
                height: 4px;
                border-radius: 999px;
                margin-top: 12px;
                background: linear-gradient(90deg, rgba(255,255,255,0.05), var(--accent, var(--neo-accent)));
            }
            .neo-mini-cards {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
                gap: 12px;
            }
            .neo-mini-card {
                background: rgba(255,255,255,0.05);
                border-radius: 12px;
                padding: 15px;
                border: 1px solid var(--neo-border);
                display: flex;
                flex-direction: column;
                gap: 6px;
            }
            .neo-mini-card span {
                color: var(--neo-muted);
                font-size: 0.8rem;
            }
            .neo-mini-card strong {
                font-size: 1.2rem;
                color: #fff;
            }
            .neo-chart {
                background: var(--neo-card);
                border-radius: 18px;
                padding: 20px 24px;
                border: 1px solid var(--neo-border);
            }
            .neo-chart__body {
                margin-top: 18px;
                height: 180px;
                background: radial-gradient(circle at top, rgba(255,255,255,0.04), transparent),
                            linear-gradient(135deg, rgba(255,140,50,0.25), rgba(0,206,201,0.15));
                border-radius: 12px;
                position: relative;
                overflow: hidden;
            }
            .neo-chart__body::before,
            .neo-chart__body::after{
                content: '';
                position: absolute;
                inset: 20px 10px;
                border-radius: 999px;
                border: 2px solid rgba(255,255,255,0.15);
                transform: rotate(-6deg);
            }
            .neo-chart__body::after{
                inset: 40px 60px;
                border-color: rgba(0,206,201,0.4);
                transform: rotate(4deg);
            }
            .neo-table table {
                width: 100%;
                border-collapse: collapse;
                color: var(--neo-text);
            }
            .neo-table thead th {
                text-transform: uppercase;
                font-size: .75rem;
                letter-spacing: 0.05em;
                color: var(--neo-muted);
                padding-bottom: 10px;
            }
            .neo-table tbody td {
                padding: 10px 0;
                border-bottom: 1px solid rgba(255,255,255,0.06);
                font-size: .95rem;
            }
            .neo-empty {
                color: var(--neo-muted);
                font-size: .9rem;
                margin: 0;
            }
            #calendar {
                background: #111319;
                padding: 10px;
                border-radius: 16px;
                border: 1px solid var(--neo-border);
            }
            #calendar .fc-toolbar h2,
            #calendar .fc-widget-content,
            #calendar td,
            #calendar th {
                color: var(--neo-text);
                border-color: rgba(255,255,255,0.08);
            }
            #calendar .fc-day-header {
                background: rgba(255,255,255,0.03);
            }
            #calendar .fc-event {
                border: none;
                border-radius: 8px;
                padding: 3px 6px;
            }
            @media (max-width: 992px) {
                main.neo-dashboard {
                    margin: 20px 10px;
                    padding: 20px;
                }
                .neo-hero {
                    flex-direction: column;
                    align-items: flex-start;
                }
                .neo-hero__actions {
                    width: 100%;
                    flex-direction: column;
                }
                .neo-search input {
                    width: 100%;
                }
            }
        </style>

    <title>EFAC| Panel administrativo</title>
</head>
<body>
    
   
      <!-- SIDEBAR -->
    <!-- SIDEBAR -->
    <?php include '../../backend/php/sidebar_menu.php'; ?>
    <!-- SIDEBAR -->
 <!-- SIDEBAR -->
    <!-- NAVBAR -->
    <section id="content">
        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar' ></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Search...">
                    <i class='bx bx-search icon' ></i>
                </div>
            </form>
            
           
            <span class="divider"></span>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
                    <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon' ></i> Profile</a></li>
                    
                    <li>
                     <a href="../salir.php"><i class='bx bxs-log-out-circle' ></i> Logout</a>
                    </li>
                   
                </ul>
            </div>
        </nav>
        <!-- NAVBAR -->

        <!-- MAIN -->
        <main class="neo-dashboard">
            <section class="neo-hero">
                <div>
                    <p class="eyebrow" style="color: var(--neo-muted); text-transform: uppercase; letter-spacing: 0.35em; font-size: 0.75rem;">Panel principal</p>
                    <h1>Hola, <?php echo htmlspecialchars($_SESSION['username']); ?></h1>
                    <span style="color: var(--neo-muted); font-size: 0.95rem;">Resumen general del programa EFAC Salud • <?php echo $todayLabel; ?></span>
                </div>
                <div class="neo-hero__actions">
                    <div class="neo-search">
                        <input type="text" placeholder="Buscar en el panel...">
                        <i class='bx bx-search'></i>
                    </div>
                    <button class="neo-btn"><i class='bx bx-download' style="margin-right:6px;"></i>Reporte PDF</button>
                </div>
            </section>

            <section class="neo-grid neo-grid--primary">
                <article class="neo-card neo-card--progress">
                    <div class="neo-card__header">
                        <h3>Indicador general</h3>
                        <span style="color: var(--neo-muted); font-size: .85rem;">Actividad semanal</span>
                    </div>
                    <div style="display:flex; justify-content:center; position:relative;">
                        <svg class="neo-progress" viewBox="0 0 120 120">
                            <circle class="bg" cx="60" cy="60" r="54"></circle>
                            <circle class="meter" cx="60" cy="60" r="54" stroke-dasharray="<?php echo $engagementCircumference; ?>" stroke-dashoffset="<?php echo $engagementOffset; ?>"></circle>
                        </svg>
                        <div style="position:absolute; top:50%; left:50%; transform:translate(-50%, -50%); text-align:center;">
                            <div class="neo-progress__value"><?php echo $engagementScore; ?>%</div>
                            <div class="neo-progress__label">Participación</div>
                        </div>
                    </div>
                    <p style="text-align:center; color: var(--neo-muted); font-size:.9rem; margin:0;">Basado en asistencia y registros recientes</p>
                </article>

                <?php foreach ($statCards as $card): ?>
                    <article class="neo-card">
                        <div class="neo-stat" style="--accent: <?php echo $card['accent']; ?>;">
                            <div class="neo-stat__icon" style="background: rgba(255,255,255,0.08); color: <?php echo $card['accent']; ?>;">
                                <i class='bx <?php echo $card['icon']; ?>'></i>
                            </div>
                            <div>
                                <p class="neo-stat__value"><?php echo $card['value']; ?></p>
                                <p class="neo-stat__label"><?php echo $card['label']; ?></p>
                                <small style="color: var(--neo-muted); font-size: .8rem;"><?php echo $card['description']; ?></small>
                                <div class="neo-color-bar"></div>
                            </div>
                        </div>
                    </article>
                <?php endforeach; ?>
            </section>

            <section class="neo-grid neo-grid--secondary">
                <article class="neo-chart">
                    <div class="neo-card__header">
                        <h3>Rendimiento mensual</h3>
                        <span style="color: var(--neo-muted); font-size:.85rem;">Comparativo general</span>
                    </div>
                    <div class="neo-chart__body"></div>
                </article>
                <article class="neo-card">
                    <div class="neo-card__header">
                        <h3>Actividad rápida</h3>
                        <span style="color: var(--neo-muted); font-size:.85rem;">Últimos 7 días</span>
                    </div>
                    <div class="neo-mini-cards">
                        <div class="neo-mini-card">
                            <span>Registros nuevos</span>
                            <strong><?php echo number_format($totalUsers - $totalPatients); ?></strong>
                            <small style="color:#00cec9;">+8% respecto a la semana anterior</small>
                        </div>
                        <div class="neo-mini-card">
                            <span>Asistencias reportadas</span>
                            <strong>134</strong>
                            <small style="color:#ff8c32;">4% menos que ayer</small>
                        </div>
                        <div class="neo-mini-card">
                            <span>Participación diaria</span>
                            <strong>76%</strong>
                            <small style="color:#6c5ce7;">En rango esperado</small>
                        </div>
                        <div class="neo-mini-card">
                            <span>Foros activos</span>
                            <strong>18</strong>
                            <small style="color:#00cec9;">+3 nuevos foros</small>
                        </div>
                    </div>
                </article>
            </section>

            <section class="neo-grid neo-grid--tertiary">


                <article class="neo-card neo-card--table">
                    <div class="neo-card__header">
                        <h3>Últimos estudiantes</h3>
                        <span style="color: var(--neo-muted); font-size:.85rem;">Ingreso más reciente</span>
                    </div>
                    <?php if (count($latestPatients) > 0): ?>
                        <div class="neo-table">
                            <table>
                                <thead>
                                    <tr>
                                        <th>Nombre</th>
                                        <th>Modalidad</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($latestPatients as $patient): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($patient->nompa . ' ' . $patient->apepa); ?></td>
                                            <td><?php echo htmlspecialchars($patient->modalidad ?? 'N/D'); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <p class="neo-empty">No hay registros recientes.</p>
                    <?php endif; ?>
                </article>

                <article class="neo-card">
                    <div class="neo-card__header">
                        <h3>Calendario</h3>
                        <span style="color: var(--neo-muted); font-size:.85rem;">Eventos y recordatorios</span>
                    </div>
                    <div id="calendar" class="col-centered"></div>
                </article>
            </section>
        </main>
        <!-- MAIN -->
    </section>
    <!-- NAVBAR -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.0/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script src="../../backend/js/script.js"></script>

    <!-- Data Tables -->
        <script src="../../backend/vendor/datatables/dataTables.min.js"></script>
        <script src="../../backend/vendor/datatables/dataTables.bootstrap.min.js"></script>


        <!-- Custom Data tables -->
        <script src="../../backend/vendor/datatables/custom/custom-datatables.js"></script>
        <script src="../../backend/vendor/datatables/custom/fixedHeader.js"></script>


        <!-- FullCalendar -->
    <script src='../../backend/js/moment.min.js'></script>
    <script src='../../backend/js/fullcalendar/fullcalendar.min.js'></script>
    <script src='../../backend/js/fullcalendar/fullcalendar.js'></script>
    <script src='../../backend/js/fullcalendar/locale/es.js'></script>

<script>

  $(document).ready(function() {

    var date = new Date();
       var yyyy = date.getFullYear().toString();
       var mm = (date.getMonth()+1).toString().length == 1 ? "0"+(date.getMonth()+1).toString() : (date.getMonth()+1).toString();
       var dd  = (date.getDate()).toString().length == 1 ? "0"+(date.getDate()).toString() : (date.getDate()).toString();
    
    $('#calendar').fullCalendar({
      header: {
         language: 'es',
        left: 'prev,next today',
        center: 'title',
        right: 'month,basicWeek,basicDay',

      },
      defaultDate: yyyy+"-"+mm+"-"+dd,
      editable: true,
      eventLimit: true, // allow "more" link when too many events
      selectable: true,
      selectHelper: true,
      select: function(start, end) {
        
        $('#ModalAdd #start').val(moment(start).format('YYYY-MM-DD HH:mm:ss'));
        $('#ModalAdd #end').val(moment(end).format('YYYY-MM-DD HH:mm:ss'));
        $('#ModalAdd').modal('show');
      },
      eventRender: function(event, element) {
        element.bind('dblclick', function() {
          $('#ModalEdit #id').val(event.id);
          $('#ModalEdit #title').val(event.title);
          $('#ModalEdit #color').val(event.color);
          $('#ModalEdit').modal('show');
        });
      },
      eventDrop: function(event, delta, revertFunc) { // si changement de position

        edit(event);

      },
      eventResize: function(event,dayDelta,minuteDelta,revertFunc) { // si changement de longueur

        edit(event);

      },
      events: [
      <?php foreach($events as $event): 
      
        $start = explode(" ", $event['start']);
        $end = explode(" ", $event['end']);
        if($start[1] == '00:00:00'){
          $start = $start[0];
        }else{
          $start = $event['start'];
        }
        if($end[1] == '00:00:00'){
          $end = $end[0];
        }else{
          $end = $event['end'];
        }
      ?>
        {
          id: '<?php echo $event['id']; ?>',
          title: '<?php echo $event['title']; ?>',
          start: '<?php echo $start; ?>',
          end: '<?php echo $end; ?>',
          color: '<?php echo $event['color']; ?>',
        },
      <?php endforeach; ?>
      ]
    });
    
 
    
  });

</script>
</body>
</html>


