<?php
require '../../backend/bd/Conexion.php';

header('Content-Type: application/json');

// Campos disponibles para validación
$available_fields = [
    'modalidad', 'genero', 'zona', 'nivel_educativo', 
    'institucion_educativa', 'grado_actual'
];

// Obtener campos seleccionados
$field = isset($_GET['field']) ? $_GET['field'] : 'modalidad'; // Campo principal
$cross_field = isset($_GET['cross_field']) ? $_GET['cross_field'] : null; // Campo secundario (opcional)

// Validar campo principal
if (!in_array($field, $available_fields)) {
    $field = 'modalidad';
}

// Validar campo secundario
if ($cross_field && $cross_field !== 'none' && !in_array($cross_field, $available_fields)) {
    echo json_encode(['error' => 'Campo secundario inválido']);
    exit;
}

try {
    
    // Si hay campo secundario, hacer análisis cruzado
    if ($cross_field && $cross_field !== 'none' && $cross_field !== $field) {
        // Consulta para análisis cruzado
        $query = "SELECT 
                    `$field` as campo1, 
                    `$cross_field` as campo2, 
                    COUNT(*) as cantidad 
                 FROM registro_estudiantes 
                 WHERE `$field` IS NOT NULL AND `$field` <> ''
                   AND `$cross_field` IS NOT NULL AND `$cross_field` <> ''
                 GROUP BY `$field`, `$cross_field` 
                 ORDER BY `$field`, `$cross_field`";
        
        $stmt = $connect->prepare($query);
        $stmt->execute();
        
        $crossData = [];
        $field1Values = [];
        $field2Values = [];
        
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $val1 = empty($row['campo1']) ? 'No especificado' : $row['campo1'];
            $val2 = empty($row['campo2']) ? 'No especificado' : $row['campo2'];
            
            if (!in_array($val1, $field1Values)) {
                $field1Values[] = $val1;
            }
            if (!in_array($val2, $field2Values)) {
                $field2Values[] = $val2;
            }
            
            if (!isset($crossData[$val1])) {
                $crossData[$val1] = [];
            }
            $crossData[$val1][$val2] = $row['cantidad'];
        }
        
        // Construir matriz completa con ceros donde no hay datos
        $matrix = [];
        foreach ($field1Values as $val1) {
            $row = ['label' => $val1];
            foreach ($field2Values as $val2) {
                $row[$val2] = isset($crossData[$val1][$val2]) ? $crossData[$val1][$val2] : 0;
            }
            $matrix[] = $row;
        }
        
        echo json_encode([
            'type' => 'cross',
            'field1Values' => $field1Values,
            'field2Values' => $field2Values,
            'matrix' => $matrix,
            'crossData' => $crossData
        ]);
        
    } else {
        // Consulta simple para el campo seleccionado
        $query = "SELECT 
                    `$field` as campo, 
                    COUNT(*) as cantidad 
                 FROM registro_estudiantes 
                 WHERE `$field` IS NOT NULL AND `$field` <> ''
                 GROUP BY `$field` 
                 ORDER BY cantidad DESC";
        
        $stmt = $connect->prepare($query);
        $stmt->execute();
        
        $labels = [];
        $values = [];
        $data = [];
        
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $campo = empty($row['campo']) ? 'No especificado' : $row['campo'];
            $labels[] = $campo;
            $values[] = (int)$row['cantidad'];
            $data[] = [
                'campo' => $campo,
                'cantidad' => (int)$row['cantidad']
            ];
        }
        
        echo json_encode([
            'type' => 'simple',
            'labels' => $labels,
            'values' => $values,
            'data' => $data,
            'fieldName' => $field
        ]);
    }
    
} catch (PDOException $e) {
    echo json_encode(['error' => 'Error en la base de datos: ' . $e->getMessage()]);
}
?>