<?php
    ob_start();
    
    // Incluir sistema de control de acceso
    require '../../backend/php/check_access.php';
    
    // Verificar que tenga permiso para crear remisiones
    if(!hasModulePermission('remisiones') && !hasSubmenuPermission('remisiones_nueva')){
        header('location: ../acceso_denegado.php');
        exit;
    }
    
    $id = $_SESSION['id'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/6.6.9/sweetalert2.min.css">



    <title> EFAC | Nueva cita</title>
</head>
<body>
    <!-- SIDEBAR DINÁMICO -->
    <?php include '../../backend/php/sidebar_menu.php'; ?>

    <!-- NAVBAR -->
    <section id="content">

        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar' ></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Search...">
                    <i class='bx bx-search icon' ></i>
                </div>
            </form>
            
           
            <span class="divider"></span>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
                 <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon' ></i> Profile</a></li>
                    
                    <li>
                     <a href="../salir.php"><i class='bx bxs-log-out-circle' ></i> Logout</a>
                    </li>
                   
                </ul>
            </div>
        </nav>
        <!-- NAVBAR -->

        <!-- MAIN -->

        <main>
            <h1 class="title">Bienvenido <?php echo '<strong>'.$_SESSION['username'].'</strong>'; ?></h1>
            <ul class="breadcrumbs">
                <li><a href="../admin/escritorio.php">Home</a></li>
                <li class="divider">></li>
                <li><a href="../citas/mostrar.php">Listado de las citas</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Nueva cita</a></li>
            </ul>
           
           <!-- multistep form -->


<form action="" enctype="multipart/form-data" method="POST"  autocomplete="off">
  <div class="containerss">
    <h1>Nueva cita</h1>
   
    <div class="alert-danger">
  <span class="closebtn" onclick="this.parentElement.style.display='none';">&times;</span> 
  <strong>Importante!</strong> Es importante rellenar los campos con &nbsp;<span class="badge-warning">*</span><br>
 
</div>
    <hr>
<br>
    <label for="email"><b>Motivo de la cita</b></label><span class="badge-warning">*</span>
    <textarea name="appnam" style="height:200px" placeholder="Write something.."> </textarea>
  
    <label for="psw"><b>Nombre del Usuario</b></label><span class="badge-warning">*</span>
    <select required name="apppac" id="pati">
        <option>Seleccione</option>
    </select>

    <label for="psw"><b>Nombre del médico</b></label><span class="badge-warning">*</span>
    <select required name="appdoc" id="doc">
        <option>Seleccione</option>
    </select>

    <label for="email"><b>Especialidad del médico</b></label><span class="badge-warning">*</span>

     <select disabled id="spe">
        <option>Seleccione</option>
    </select>


    <label for="psw"><b>Laboratorio</b></label><span class="badge-warning">*</span>
    <select required name="applab" id="lab">
        <option>Seleccione</option>
    </select>

    <label for="psw"><b>Color</b></label><span class="badge-warning">*</span>
    <select required name="appco" id="gep">
        <option style="color:#CD5C5C;" value="#CD5C5C">&#9724; Indio Rojo</option>
        <option style="color:#F08080;" value="#F08080">&#9724; Coral claro</option>
        <option style="color:#8B0000;" value="#8B0000">&#9724; Rojo oscuro</option>
        <option style="color:#0071c5;" value="#0071c5">&#9724; Azul oscuro</option>
        <option style="color:#FFC0CB;" value="#FFC0CB">&#9724; Rosado</option>
        <option style="color:#FFB6C1;" value="#FFB6C1">&#9724; Rosa claro</option>
        <option style="color:#FF7F50;" value="#FF7F50">&#9724; Coral</option>
        <option style="color:#FF4500;" value="#FF4500">&#9724; Rojo naranja</option>
        <option style="color:#FFFF00;" value="#FFFF00">&#9724; Amarillo</option>
        <option style="color:#EE82EE;" value="#EE82EE">&#9724; Violeta</option>
        
          
    </select>

    <label for="email"><b>Fecha inicial</b></label><span class="badge-warning">*</span>
    <input type="datetime-local"  name="appini"required="">

    <label for="email"><b>Fecha final</b></label><span class="badge-warning">*</span>
    <input type="datetime-local"  name="appfin"required="">

     <label for="email"><b>Monto a pagar</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="S/. 0.00" name="appmont" required="" value="0.00">

     <label for="email"><b>Realiza pago</b></label><span class="badge-warning">*</span>
     <label>SI</label>
    <input type="checkbox" name="appreal"   value="1">


    <hr>
   
    <button type="submit" name="add_appointment" class="registerbtn">Guardar</button>
  </div>
  
</form>

        </main>
        <!-- MAIN -->
    </section>
    <script src="../../backend/js/jquery.min.js"></script>


    <!-- NAVBAR -->
    
    <script src="../../backend/js/script.js"></script>
    <script src="../../backend/js/multistep.js"></script>
    <script src="../../backend/js/vpat.js"></script>
    <script src="../../backend/js/patiens.js"></script>
    <script src="../../backend/js/doctor.js"></script>
    <script src="../../backend/js/laboratory.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js"></script>
     <?php include_once '../../backend/php/add_appointment.php' ?>
   
</body>
</html>


