<?php
    ob_start();
    session_start();
    
    if(!isset($_SESSION['user_type']) || $_SESSION['user_type'] != 'ciudadano'){
        header('location: ../login.php');
        exit;
    }
    
    require_once('../../backend/bd/Conexion.php');
    global $connect;
    
    $username = $_SESSION['username'];
    $name = $_SESSION['name'];
    $cedula = $_SESSION['email'];
    
    // Obtener cursos en los que está inscrito (Cursos Activos)
    $mis_inscripciones = [];
    try {
        $stmt = $connect->prepare("
            SELECT c.*, i.documento 
            FROM inscripciones i 
            INNER JOIN cursos c ON i.idcurso = c.idcurso 
            WHERE i.documento = :cedula
        ");
        $stmt->execute([':cedula' => $cedula]);
        $mis_inscripciones = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch(PDOException $e) {
        $error = "Error al cargar inscripciones: " . $e->getMessage();
    }
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <title>Área Virtual - Programa Persona Mayor</title>
    
    <style>
        :root {
            --font-main: 'Poppins', sans-serif;
            --primary-gradient: linear-gradient(135deg, #8E2DE2 0%, #4A00E0 100%);
            --btn-gradient: linear-gradient(45deg, #FF512F 0%, #DD2476 50%, #FF512F 100%);
            --bg-dark: #121212;
            --bg-card: #1e1e1e;
            --bg-input: #2d2d2d;
            --text-light: #f5f6fa;
            --text-grey: #a4b0be;
            --primary-color: #a29bfe;
            --danger-color: #ff7675;
            --success-color: #00b894;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: var(--bg-dark);
            min-height: 100vh;
            padding: 20px;
            color: var(--text-light);
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
        }

        .header {
            background: var(--bg-card);
            padding: 25px 30px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
            margin-bottom: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        .header h1 {
            font-size: 28px;
            color: var(--primary-color);
            margin: 0;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .btn-back {
            padding: 10px 20px;
            background: rgba(255, 255, 255, 0.05);
            color: var(--text-light);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn-back:hover {
            background: rgba(255, 255, 255, 0.1);
            color: white;
            border-color: var(--text-light);
        }

        .section {
            background: var(--bg-card);
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
            margin-bottom: 30px;
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        .section h2 {
            font-size: 24px;
            color: var(--primary-color);
            margin-bottom: 20px;
            border-bottom: 3px solid var(--primary-color);
            padding-bottom: 10px;
        }

        .cursos-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 20px;
            margin-top: 20px;
        }

        .curso-card {
            background: rgba(255, 255, 255, 0.03);
            border: 1px solid rgba(255, 255, 255, 0.05);
            border-radius: 12px;
            padding: 20px;
            transition: all 0.3s ease;
        }

        .curso-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.4);
            border-color: var(--primary-color);
            background: rgba(255, 255, 255, 0.05);
        }

        .curso-card h3 {
            font-size: 20px;
            color: var(--text-light);
            margin-bottom: 10px;
        }

        .curso-info {
            margin: 15px 0;
        }

        .curso-info-item {
            display: flex;
            align-items: center;
            margin-bottom: 8px;
            font-size: 14px;
            color: var(--text-grey);
        }

        .curso-info-item i {
            margin-right: 8px;
            color: var(--primary-color);
        }

        .btn-enter {
            width: 100%;
            padding: 12px;
            background: var(--btn-gradient);
            background-size: 200% auto;
            color: white;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.4s ease;
            text-align: center;
            text-decoration: none;
            display: inline-block;
        }

        .btn-enter:hover {
            background-position: right center;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(221, 36, 118, 0.4);
        }

        .badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
            margin-left: 10px;
        }

        .badge-titulado {
            background: rgba(0, 184, 148, 0.2);
            color: var(--success-color);
        }

        .badge-no-titulado {
            background: rgba(253, 203, 110, 0.2);
            color: #fdcb6e;
        }

        .empty-state {
            text-align: center;
            padding: 40px;
            color: var(--text-grey);
        }

        .empty-state i {
            font-size: 64px;
            margin-bottom: 20px;
            opacity: 0.3;
        }

        @media (max-width: 768px) {
            .cursos-grid {
                grid-template-columns: 1fr;
            }

            .header {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><i class='bx bxs-layer'></i> Área Virtual</h1>
            <a href="dashboard.php" class="btn-back">
                <i class='bx bx-arrow-back'></i> Volver al Dashboard
            </a>
        </div>

        <!-- Cursos Activos -->
        <div class="section">
            <h2><i class='bx bxs-check-circle'></i> EFAC - Mis Cursos Activos</h2>
            
            <?php if(count($mis_inscripciones) > 0): ?>
                <div class="cursos-grid">
                    <?php foreach($mis_inscripciones as $curso): ?>
                        <div class="curso-card">
                            <h3>
                                <?php echo htmlspecialchars($curso['nombre']); ?>
                                <?php if($curso['es_titulado'] == 'sí'): ?>
                                    <span class="badge badge-titulado">Titulado</span>
                                <?php else: ?>
                                    <span class="badge badge-no-titulado">No Titulado</span>
                                <?php endif; ?>
                            </h3>
                            
                            <div class="curso-info">
                                <div class="curso-info-item">
                                    <i class='bx bxs-user'></i>
                                    <span><strong>Profesor:</strong> <?php echo htmlspecialchars($curso['quien_lo_da']); ?></span>
                                </div>
                                
                                <?php if(!empty($curso['en_que'])): ?>
                                <div class="curso-info-item">
                                    <i class='bx bxs-info-circle'></i>
                                    <span><?php echo htmlspecialchars($curso['en_que']); ?></span>
                                </div>
                                <?php endif; ?>
                            </div>
                            
                            <a href="ver_curso.php?id=<?php echo $curso['idcurso']; ?>" class="btn-enter">
                                <i class='bx bx-log-in-circle'></i> Ingresar al Curso
                            </a>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <div class="empty-state">
                    <i class='bx bx-book-open'></i>
                    <p>No tienes cursos activos actualmente.</p>
                    <p>Visita la sección "Mis Cursos" para inscribirte.</p>
                    <a href="mis_cursos.php" style="display: inline-block; margin-top: 15px; color: var(--primary-color);">Ir a Mis Cursos</a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
