<?php
ob_start();
session_start();

if(!isset($_SESSION['user_type']) || $_SESSION['user_type'] != 'ciudadano'){
    header('location: ../login.php');
    exit;
}

require '../../backend/bd/Conexion.php';
require '../../backend/fpdf/fpdf.php';
date_default_timezone_set('America/Bogota');

$idcurso = isset($_GET['idcurso']) ? (int)$_GET['idcurso'] : 0;
$cedula = $_SESSION['email'];

if($idcurso <= 0) {
    die('Parámetros inválidos');
}

// Función auxiliar para convertir UTF-8 a ISO-8859-1
function convertText($text) {
    if(empty($text)) return '';
    return mb_convert_encoding($text, 'ISO-8859-1', 'UTF-8');
}

// Obtener datos del curso e inscripción
try {
    $stmt = $connect->prepare("
        SELECT c.*, i.fere as fecha_inscripcion, a.nombre as area_nombre, e.nombre as escuela_nombre
        FROM inscripciones i
        INNER JOIN cursos c ON i.idcurso = c.idcurso
        LEFT JOIN areas a ON c.id_area = a.id
        LEFT JOIN escuelas_formacion e ON a.id_escuela = e.id
        WHERE i.documento = :cedula AND i.idcurso = :idcurso AND i.state = '1'
    ");
    $stmt->execute([':cedula' => $cedula, ':idcurso' => $idcurso]);
    $data = $stmt->fetch(PDO::FETCH_ASSOC);

    if(!$data) {
        die('No se encontró una inscripción activa para este curso.');
    }

    // Obtener datos del estudiante
    $stmtUser = $connect->prepare("
        SELECT nombres, apellidos 
        FROM registro_estudiantes 
        WHERE numero_documento = :cedula
    ");
    $stmtUser->execute([':cedula' => $cedula]);
    $user = $stmtUser->fetch(PDO::FETCH_ASSOC);
    
    $nombre_completo = $user ? ($user['nombres'] . ' ' . $user['apellidos']) : $_SESSION['name'];

} catch(PDOException $e) {
    die('Error de base de datos: ' . $e->getMessage());
}

class PDF extends FPDF
{
    function Header()
    {
        // Marco decorativo
        $this->Rect(5, 5, 200, 287, 'D');
        $this->Rect(7, 7, 196, 283, 'D');
        
        $this->Image('../../backend/img/ico.png', 15, 15, 30);
        $this->Image('../../backend/img/neu.png', 165, 15, 30);
        
        $this->Ln(20);
        $this->SetFont('Arial', 'B', 22);
        $this->SetTextColor(74, 144, 226);
        $this->Cell(0, 15, convertText('PROGRAMA EFAC'), 0, 1, 'C');
        
        $this->SetFont('Arial', 'I', 12);
        $this->SetTextColor(100, 100, 100);
        $this->Cell(0, 5, convertText('Municipio de Sibaté - Cundinamarca'), 0, 1, 'C');
        $this->Ln(15);
    }

    function Footer()
    {
        $this->SetY(-30);
        $this->SetFont('Arial', 'I', 8);
        $this->SetTextColor(150, 150, 150);
        $this->Cell(0, 5, convertText('Este documento es un certificado oficial de inscripción emitido por el portal EFAC.'), 0, 1, 'C');
        $this->Cell(0, 5, convertText('Fecha de generación: ' . date('d/m/Y g:i a')), 0, 1, 'C');
        $this->Cell(0, 5, convertText('Página ') . $this->PageNo() . ' / {nb}', 0, 0, 'C');
    }
}

$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();

$pdf->Ln(10);
$pdf->SetFont('Arial', 'B', 26);
$pdf->SetTextColor(44, 62, 80);
$pdf->Cell(0, 20, convertText('CERTIFICADO DE INSCRIPCIÓN'), 0, 1, 'C');

$pdf->Ln(15);
$pdf->SetFont('Arial', '', 16);
$pdf->SetTextColor(50, 50, 50);
$pdf->MultiCell(0, 10, convertText('Por medio de la presente se certifica que el estudiante:'), 0, 'C');

$pdf->Ln(5);
$pdf->SetFont('Arial', 'B', 24);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(0, 15, convertText(strtoupper($nombre_completo)), 0, 1, 'C');

$pdf->Ln(5);
$pdf->SetFont('Arial', '', 16);
$pdf->SetTextColor(50, 50, 50);
$pdf->Cell(0, 10, convertText('Identificado con el documento No: ' . $cedula), 0, 1, 'C');

$pdf->Ln(15);
$pdf->SetFont('Arial', '', 16);
$pdf->MultiCell(0, 10, convertText('Se encuentra debidamente INSCRITO en el curso de formación:'), 0, 'C');

$pdf->Ln(5);
$pdf->SetFont('Arial', 'B', 20);
$pdf->SetTextColor(74, 144, 226);
$pdf->MultiCell(0, 12, convertText(strtoupper($data['nombre'])), 0, 'C');

$pdf->Ln(5);
$pdf->SetFont('Arial', '', 14);
$pdf->SetTextColor(100, 100, 100);
if($data['escuela_nombre']) {
    $pdf->Cell(0, 8, convertText('Escuela: ' . $data['escuela_nombre']), 0, 1, 'C');
}
if($data['area_nombre']) {
    $pdf->Cell(0, 8, convertText('Área: ' . $data['area_nombre']), 0, 1, 'C');
}

$pdf->Ln(20);
$pdf->SetFont('Arial', '', 14);
$pdf->SetTextColor(50, 50, 50);
$fecha_insc = date('d/m/Y', strtotime($data['fecha_inscripcion']));
$pdf->MultiCell(0, 10, convertText('Inscripción realizada el día ' . $fecha_insc . '.'), 0, 'C');

$pdf->Ln(30);
// Espacio para firma (opcional/decorativo)
$pdf->Line(60, $pdf->GetY(), 150, $pdf->GetY());
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, convertText('Coordinación EFAC'), 0, 1, 'C');
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(0, 5, convertText('Sibaté, Cundinamarca'), 0, 1, 'C');

ob_end_clean();
$pdf->Output('I', 'Certificado_Inscripcion_' . $cedula . '.pdf');
exit;
?>
