<?php
    ob_start();
    session_start();
    
    if(!isset($_SESSION['user_type']) || $_SESSION['user_type'] != 'ciudadano'){
        header('location: ../login.php');
        exit;
    }
    
    require_once('../../backend/bd/Conexion.php');
    global $connect;
    
    $username = $_SESSION['username'];
    $name = $_SESSION['name'];
    $user_id = $_SESSION['id'];
    $cedula = $_SESSION['email']; // La cédula está guardada en el campo email
    
    // Verificar estado de aprobación
    $estado_aprobacion = $_SESSION['estado_aprobacion'] ?? 'aprobado';
    $estado_aprobacion = 'aprobado'; // BYPASS: Desactivar proceso de aprobación
    $motivo_rechazo = $_SESSION['motivo_rechazo'] ?? null;
    
    // Verificar si el usuario ya completó la inscripción
    $inscripcion_completa = false;
    $datos_paciente = null;
    $foto_perfil = null;
    
    try {
        $stmt = $connect->prepare("SELECT * FROM registro_estudiantes WHERE numero_documento = :cedula");
        $stmt->execute([':cedula' => $cedula]);
        $datos_paciente = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if($datos_paciente) {
            $inscripcion_completa = true;
            // Obtener la foto de perfil si existe
            if(!empty($datos_paciente['foto_perfil'])) {
                $foto_perfil = '../../uploads/fotos_perfil/' . $datos_paciente['foto_perfil'];
            }
        }
    } catch(PDOException $e) {
        // Error al consultar
    }
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <title>Portal EFAC</title>
    <style>
        :root {
            --font-main: 'Poppins', sans-serif;
            --primary-gradient: linear-gradient(135deg, #8E2DE2 0%, #4A00E0 100%);
            --btn-gradient: linear-gradient(45deg, #FF512F 0%, #DD2476 50%, #FF512F 100%);
            --bg-dark: #121212;
            --bg-card: #1e1e1e;
            --bg-input: #2d2d2d;
            --text-light: #f5f6fa;
            --text-grey: #a4b0be;
            --primary-color: #a29bfe;
            --danger-color: #ff7675;
            --success-color: #00b894;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: var(--bg-dark);
            min-height: 100vh;
            padding: 20px;
            color: var(--text-light);
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
        }

        .header {
            background: var(--bg-card);
            padding: 25px 30px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
            margin-bottom: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        .header h1 {
            font-size: 28px;
            background: var(--primary-gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            margin: 0;
        }

        .header .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .header .user-avatar {
            width: 50px;
            height: 50px;
            background: var(--primary-gradient);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 24px;
            font-weight: bold;
            overflow: hidden;
            object-fit: cover;
            border: 2px solid var(--bg-dark);
        }
        
        .header .user-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .header .user-name {
            font-size: 16px;
            font-weight: 600;
            color: var(--text-light);
        }

        .btn-logout {
            padding: 10px 20px;
            background: linear-gradient(135deg, #ff416c 0%, #ff4b2b 100%);
            color: white;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(255, 65, 108, 0.3);
        }

        .btn-logout:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(255, 65, 108, 0.4);
        }

        .welcome-section {
            background: var(--bg-card);
            padding: 40px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
            margin-bottom: 30px;
            text-align: center;
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        .welcome-section h2 {
            font-size: 32px;
            color: var(--primary-color);
            margin-bottom: 15px;
        }

        .welcome-section p {
            font-size: 18px;
            color: var(--text-grey);
            line-height: 1.6;
        }

        .cards-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 25px;
            margin-bottom: 30px;
        }

        .card {
            background: var(--bg-card);
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
            transition: all 0.3s ease;
            cursor: pointer;
            text-align: center;
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        .card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.5);
            border-color: rgba(255, 255, 255, 0.1);
        }

        .card-icon {
            width: 80px;
            height: 80px;
            margin: 0 auto 20px;
            background: var(--btn-gradient);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 40px;
            box-shadow: 0 5px 15px rgba(221, 36, 118, 0.3);
        }

        .card h3 {
            font-size: 22px;
            color: var(--text-light);
            margin-bottom: 10px;
        }

        .card p {
            font-size: 14px;
            color: var(--text-grey);
            line-height: 1.5;
        }

        .info-section {
            background: var(--bg-card);
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        .info-section h3 {
            font-size: 24px;
            color: var(--primary-color);
            margin-bottom: 20px;
            border-bottom: 3px solid var(--primary-color);
            padding-bottom: 10px;
        }

        .info-item {
            padding: 15px;
            border-left: 4px solid #764ba2;
            background: rgba(255, 255, 255, 0.03);
            margin-bottom: 15px;
            border-radius: 8px;
        }

        .info-item h4 {
            font-size: 18px;
            color: var(--text-light);
            margin-bottom: 8px;
        }

        .info-item p {
            font-size: 14px;
            color: var(--text-grey);
            line-height: 1.6;
        }

        @media (max-width: 768px) {
            .header {
                flex-direction: column;
                gap: 20px;
                text-align: center;
            }

            .cards-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1><i class='bx bxs-heart'></i> EFAC</h1>
            <div class="user-info">
                <div class="user-avatar">
                    <?php if($foto_perfil && file_exists($foto_perfil)): ?>
                        <img src="<?php echo $foto_perfil; ?>" alt="Foto de perfil">
                    <?php else: ?>
                        <?php echo strtoupper(substr($name, 0, 1)); ?>
                    <?php endif; ?>
                </div>
                <div>
                    <div class="user-name"><?php echo $name; ?></div>
                    <small style="color: #999;">@<?php echo $username; ?></small>
                </div>
                <a href="../salir.php">
                    <button class="btn-logout">
                        <i class='bx bx-log-out'></i> Cerrar Sesión
                    </button>
                </a>
            </div>
        </div>

        <!-- Welcome Section -->
        <div class="welcome-section">
            <h2>¡Bienvenido, <?php echo $name; ?>!</h2>
            <p>Este es tu portal personal del Programa Persona Mayor.<br>
            Aquí podrás consultar tu información, actividades y servicios disponibles.</p>
            
            <?php if($estado_aprobacion == 'pendiente'): ?>
                <!-- Estado: Pendiente de Aprobación -->
                <div style="margin-top: 25px; padding: 30px; background: linear-gradient(135deg, #fff3cd 0%, #ffe8a1 100%); border-left: 5px solid #ffc107; border-radius: 12px; box-shadow: 0 4px 15px rgba(0,0,0,0.1);">
                    <h3 style="color: #856404; margin-bottom: 15px; font-size: 24px;">
                        <i class='bx bx-time-five' style="font-size: 28px; vertical-align: middle;"></i> Tu cuenta está pendiente de aprobación
                    </h3>
                    <p style="color: #856404; margin-bottom: 0; font-size: 16px; line-height: 1.6;">
                        Un funcionario del EFAC debe revisar y aprobar tu solicitud antes de que puedas acceder a todos los servicios.<br><br>
                        <strong>¿Qué puedes hacer mientras tanto?</strong><br>
                        • Espera la notificación de aprobación<br>
                        • Asegúrate de tener tus documentos listos<br>
                        • Contacta con la oficina del programa si tienes dudas
                    </p>
                </div>
            <?php elseif($estado_aprobacion == 'rechazado'): ?>
                <!-- Estado: Rechazado -->
                <div style="margin-top: 25px; padding: 30px; background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%); border-left: 5px solid #dc3545; border-radius: 12px; box-shadow: 0 4px 15px rgba(0,0,0,0.1);">
                    <h3 style="color: #721c24; margin-bottom: 15px; font-size: 24px;">
                        <i class='bx bx-x-circle' style="font-size: 28px; vertical-align: middle;"></i> Tu solicitud fue rechazada
                    </h3>
                    <p style="color: #721c24; margin-bottom: 15px; font-size: 16px; line-height: 1.6;">
                        Lamentablemente, tu solicitud de acceso al EFAC  no fue aprobada.
                    </p>
                    <?php if($motivo_rechazo): ?>
                        <div style="background: white; padding: 15px; border-radius: 8px; margin-top: 15px;">
                            <strong style="color: #721c24;">Motivo del rechazo:</strong><br>
                            <p style="color: #721c24; margin: 10px 0 0 0;"><?php echo htmlspecialchars($motivo_rechazo); ?></p>
                        </div>
                    <?php endif; ?>
                    <p style="color: #721c24; margin-top: 15px; font-size: 14px;">
                        Si consideras que esto es un error, por favor contacta con la oficina del programa.
                    </p>
                </div>
            <?php elseif(!$inscripcion_completa): ?>
                <div style="margin-top: 25px; padding: 20px; background: #fff3cd; border-left: 5px solid #ffc107; border-radius: 8px;">
                    <h3 style="color: #856404; margin-bottom: 10px;">
                        <i class='bx bx-info-circle'></i> Completa tu Inscripción
                    </h3>
                    <p style="color: #856404; margin-bottom: 15px;">
                        Para acceder a todos los servicios del programa, debes completar el formulario de inscripción con tus datos personales.
                    </p>
                    <a href="inscripcion.php" style="display: inline-block; padding: 12px 25px; background: #ffc107; color: #000; text-decoration: none; border-radius: 8px; font-weight: 600; transition: all 0.3s ease;">
                        <i class='bx bx-edit'></i> Completar Inscripción Ahora
                    </a>
                </div>
            <?php endif; ?>
        </div>

        <!-- Cards Grid (solo si está aprobado) -->
        <?php if($estado_aprobacion == 'aprobado'): ?>
        <div class="cards-grid">
            <div class="card" onclick="window.location.href='mi_informacion.php'">
                <div class="card-icon">
                    <i class='bx bxs-user-circle'></i>
                </div>
                <h3>Mi Información</h3>
                <p>Consulta y actualiza tus datos personales</p>
            </div>

            <?php if($inscripcion_completa): ?>
            <div class="card" onclick="window.location.href='mis_cursos.php'">
                <div class="card-icon">
                    <i class='bx bxs-book-alt'></i>
                </div>
                <h3>Inscripcion a cursos</h3>
                <p>Consulta e inscríbete en cursos disponibles, recuerda que solo podras inscribirte a maximo 3 cursos</p>
            </div>
            
            <div class="card" onclick="window.location.href='../cursos/area_virtual.php'">
                <div class="card-icon">
                    <i class='bx bxs-layer'></i>
                </div>
                <h3>Área Virtual</h3>
                <p>Accede a tus cursos matriculados</p>
            </div>

            <div class="card" onclick="window.open('mi_historia_clinica.php', '_blank')">
                <div class="card-icon">
                    <i class='bx bxs-heart-circle'></i>
                </div>
                <h3>Informe del Estudiante</h3>
                <p>Aqui descarga el Informe detallado del estudiante</p>
            </div>

            <div class="card" onclick="window.location.href='documentos_nuevo.php'">
                <div class="card-icon">
                    <i class='bx bxs-file'></i>
                </div>
                <h3>Mis Documentos</h3>
                <p>Sube los Documentos requeridos para el programa</p>
            </div>

            <div class="card" onclick="alert('Próximamente: Contactar soporte')">
                <div class="card-icon">
                    <i class='bx bxs-phone'></i>
                </div>
                <h3>Contacto</h3>
                <p>Comunícate con nosotros para ayuda</p>
            </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <!-- Info Section -->
        <div class="info-section">
            <h3><i class='bx bxs-info-circle'></i> Información Importante</h3>
            
            <div class="info-item">
                <h4>📍 Ubicación</h4>
                <p>EFAC - Sibate, Cundinamarca</p>
            </div>

            <div class="info-item">
                <h4>📞 Teléfono de Contacto</h4>
                <p>+57 302 729 4894</p>
            </div>

            <div class="info-item">
                <h4>🕐 Horario de Atención</h4>
                <p>Lunes a Viernes: 8:00 AM - 5:00 PM<br>
                Sábados: 8:00 AM - 12:00 PM</p>
            </div>

            <div class="info-item">
                <h4>💡 Recordatorio</h4>
                <p>Recuerda asistir puntualmente a tus actividades programadas y mantener tus datos actualizados.</p>
            </div>
        </div>
    </div>
</body>
</html>
