<?php
    ob_start();
    session_start();
    
    if(!isset($_SESSION['user_type']) || $_SESSION['user_type'] != 'ciudadano'){
        header('location: ../login.php');
        exit;
    }
    
    require_once('../../backend/bd/Conexion.php');
    global $connect;
    
    $user_id = $_SESSION['id'];
    $name = $_SESSION['name'];
    $username = $_SESSION['username'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <title>Mis Documentos | Portal EFAC</title>
    <style>
        :root {
            --bg-dark: #121212;
            --bg-card: #1e1e1e;
            --primary-gradient: linear-gradient(135deg, #8E2DE2 0%, #4A00E0 100%);
            --text-light: #f5f6fa;
            --text-grey: #a4b0be;
            --primary-color: #a29bfe;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: var(--bg-dark);
            color: var(--text-light);
            margin: 0;
            padding: 20px;
            min-height: 100vh;
        }

        .container {
            max-width: 1000px;
            margin: 0 auto;
        }

        .header {
            background: var(--bg-card);
            padding: 20px 30px;
            border-radius: 15px;
            margin-bottom: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        .header h1 {
            font-size: 24px;
            margin: 0;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .btn-back {
            padding: 8px 15px;
            background: rgba(255, 255, 255, 0.1);
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-size: 14px;
            transition: all 0.3s;
        }

        .btn-back:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        .content-card {
            background: var(--bg-card);
            padding: 40px;
            border-radius: 15px;
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        .upload-container {
            display: flex;
            gap: 20px;
            margin-bottom: 30px;
            flex-wrap: wrap;
            justify-content: flex-start;
        }

        .upload-box {
            background: #2d2d2d;
            border: 2px dashed #4a4a4a;
            border-radius: 12px;
            padding: 20px;
            width: 210px;
            text-align: center;
            transition: all 0.3s ease;
            position: relative;
            cursor: pointer;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 10px;
        }

        .upload-box:hover {
            border-color: var(--primary-color);
            background: #363636;
            transform: translateY(-5px);
        }

        .upload-box i {
            font-size: 40px;
            color: var(--primary-color);
        }

        .upload-box span {
            font-size: 13px;
            font-weight: 600;
            color: var(--text-light);
            display: block;
        }

        .upload-box input[type="file"] {
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            opacity: 0;
            cursor: pointer;
        }

        .upload-box.selected {
            border-style: solid;
            border-color: #00b894;
            background: rgba(0, 184, 148, 0.1);
        }

        .upload-box.selected i {
            color: #00b894;
        }

        .btn-save-docs {
            background: var(--primary-gradient);
            color: white;
            padding: 15px 40px;
            border-radius: 10px;
            border: none;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s;
            font-size: 16px;
            width: 100%;
            margin-top: 20px;
            box-shadow: 0 5px 15px rgba(142, 45, 226, 0.3);
        }

        .btn-save-docs:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(142, 45, 226, 0.4);
        }

        .box-actions {
            display: flex;
            gap: 8px;
            margin-top: 5px;
            z-index: 10;
        }

        .btn-action {
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 12px;
            border: none;
            cursor: pointer;
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><i class='bx bxs-file'></i> Mis Documentos</h1>
            <a href="dashboard.php" class="btn-back"><i class='bx bx-arrow-back'></i> Volver al Dashboard</a>
        </div>

        <div class="content-card">
            <p style="color: var(--text-grey); margin-bottom: 30px; text-align: center;">
                Sube los documentos requeridos para completar tu expediente. Puedes subirlos uno por uno o todos a la vez.
            </p>

            <?php 
            // Obtener documentos ya cargados
            $docs_cargados = [];
            $stmt_docs = $connect->prepare("SELECT nomfi, foto FROM document WHERE idpa = ?");
            $stmt_docs->execute([$user_id]);
            while($row = $stmt_docs->fetch(PDO::FETCH_ASSOC)) {
                $docs_cargados[$row['nomfi']] = $row['foto'];
            }

            $labels = [
                'doc_identidad' => 'Documento de identidad',
                'doc_eps' => 'Certificado de la EPS',
                'doc_vca' => 'Certificado de VCA o Discapacidad',
                'doc_carnet' => 'Carnet de la Institución educativa'
            ];
            $icons = [
                'doc_identidad' => 'bx bxs-id-card',
                'doc_eps' => 'bx bxs-certification',
                'doc_vca' => 'bx bxs-user-badge',
                'doc_carnet' => 'bx bxs-graduation'
            ];
            ?>

            <form enctype="multipart/form-data" method="POST" action="" autocomplete="off">
                <div class="upload-container">
                    <?php foreach($labels as $input_name => $label): 
                        $existe = isset($docs_cargados[$label]);
                        $foto_actual = $existe ? $docs_cargados[$label] : '';
                    ?>
                    <div class="upload-box <?php echo $existe ? 'selected' : ''; ?>" id="box-<?php echo $input_name; ?>">
                        <i class='<?php echo $icons[$input_name]; ?>'></i>
                        <span><?php echo $label; ?><?php echo $existe ? ' (Cargado)' : ''; ?></span>
                        
                        <?php if($existe): ?>
                            <div class="box-actions">
                                <a href="../../backend/img/subidas/<?php echo $foto_actual; ?>" class="btn-action" download title="Descargar" style="background: #00b894;">
                                    <i class='bx bxs-download'></i>
                                </a>
                                <button type="button" class="btn-action" onclick="triggerReplace('<?php echo $input_name; ?>')" title="Reemplazar" style="background: #fdcb6e;">
                                    <i class='bx bx-refresh'></i>
                                </button>
                            </div>
                        <?php endif; ?>

                        <input type="file" name="<?php echo $input_name; ?>" id="file-<?php echo $input_name; ?>" accept="image/*,.pdf" onchange="updateBoxStatus(this, 'box-<?php echo $input_name; ?>')" style="<?php echo $existe ? 'display:none;' : ''; ?>">
                    </div>
                    <?php endforeach; ?>
                </div>

                <input type="hidden" name="docidpa" value="<?php echo $user_id; ?>">
                <input type="hidden" name="docnopa" value="<?php echo htmlspecialchars($name); ?>">
                <input type="hidden" name="from_citizen" value="1">

                <button type="submit" name="add_docu" class="btn-save-docs">
                    <i class='bx bxs-save'></i> Guardar / Actualizar Documentos
                </button>
            </form>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js"></script>
    <script>
    function updateBoxStatus(input, boxId) {
        const box = document.getElementById(boxId);
        if (input.files && input.files[0]) {
            box.classList.add('selected');
            const span = box.querySelector('span');
            const originalText = span.innerText.split(' (')[0];
            span.innerText = originalText + ' (Seleccionado)';
        }
    }

    function triggerReplace(inputName) {
        const fileInput = document.getElementById('file-' + inputName);
        fileInput.style.display = 'block';
        fileInput.click();
    }
    </script>
    <?php include_once '../../backend/php/add_docu.php' ?>
</body>
</html>
