<?php
    ob_start();
    session_start();
    
    if(!isset($_SESSION['user_type']) || $_SESSION['user_type'] != 'ciudadano'){
        header('location: ../login.php');
        exit;
    }
    
    require_once('../../backend/bd/Conexion.php');
    global $connect;
    
    $username = $_SESSION['username'];
    $name = $_SESSION['name'];
    $cedula = $_SESSION['email']; // La cédula está guardada en el campo email
    $tipo_documento_usuario = 'C.C'; // Valor por defecto
    
    // Obtener el tipo de documento del usuario
    try {
        $stmt_user = $connect->prepare("SELECT tipo_documento FROM users WHERE email = :cedula");
        $stmt_user->execute([':cedula' => $cedula]);
        $user_data = $stmt_user->fetch(PDO::FETCH_ASSOC);
        if($user_data && !empty($user_data['tipo_documento'])) {
            $tipo_documento_usuario = $user_data['tipo_documento'];
        }
    } catch(PDOException $e) {
        // Error al consultar, usar valor por defecto
    }
    
    // Verificar si ya completó la inscripción
    try {
        $stmt = $connect->prepare("SELECT * FROM registro_estudiantes WHERE numero_documento = :cedula");
        $stmt->execute([':cedula' => $cedula]);
        $datos_paciente = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if($datos_paciente) {
            // Ya completó la inscripción, redirigir al dashboard
            header('location: dashboard.php');
            exit;
        }
    } catch(PDOException $e) {
        // Error al consultar
    }
    
    // Separar nombre y apellido
    $nombre_completo = explode(' ', $name, 2);
    $nombres = $nombre_completo[0] ?? '';
    $apellidos = $nombre_completo[1] ?? '';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/6.6.9/sweetalert2.min.css">
    
    <title>Inscripción - Programa Persona Mayor</title>
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            height: 100vh;
            overflow: hidden;
            padding: 20px;
        }

        .container {
            max-width: 900px;
            height: 95vh;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.2);
            overflow: hidden;
            display: flex;
            flex-direction: column;
        }

        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 40px 30px;
            text-align: center;
            color: white;
        }

        .header h1 {
            font-size: 32px;
            margin-bottom: 10px;
        }

        .header p {
            font-size: 16px;
            opacity: 0.9;
        }

        .form-content {
            padding: 10px 30px 25px 30px; /* Reduced top padding from 25px */
            flex: 1;
            overflow-y: auto;
            display: flex;
            flex-direction: column;
        }

        .form-section {
            margin-bottom: 15px;
            width: 100%;
            max-width: 100%;
        }

        .form-step.active .form-section:first-child h2 {
            margin-top: 0 !important;
            padding-top: 0 !important;
        }

        .form-section h2 {
            font-size: 20px;
            color: #667eea;
            margin-bottom: 15px;
            margin-top: 0;
            padding-bottom: 8px;
            border-bottom: 2px solid #667eea;
        }

        .step-indicator {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px; /* Reduced to 5px */
            padding: 0 20px;
        }

        .form-group label {
            display: block;
            font-size: 14px;
            font-weight: 600;
            color: #333;
            margin-bottom: 8px;
        }

        .form-group label .required {
            color: #e74c3c;
            margin-left: 3px;
        }

        .form-group input[type="text"],
        .form-group input[type="email"],
        .form-group input[type="date"],
        .form-group input[type="file"],
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 14px;
            transition: all 0.3s ease;
        }

        .form-group input:focus,
        .form-group select:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .form-group input:disabled {
            background: #f5f5f5;
            cursor: not-allowed;
        }

        .form-group textarea {
            resize: vertical;
            min-height: 80px;
        }

        .form-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 15px;
            margin-bottom: 12px;
        }

        .btn-submit {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 18px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
        }

        .btn-back {
            display: inline-block;
            padding: 12px 25px;
            background: transparent;
            border: 2px solid #667eea;
            color: #667eea;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
            margin-bottom: 20px;
        }

        .btn-back:hover {
            background: #667eea;
            color: white;
        }

        .img-preview {
            max-width: 200px;
            max-height: 200px;
            margin-top: 10px;
            border-radius: 10px;
            display: none;
        }

        .alert {
            padding: 15px 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-weight: 600;
        }

        .alert-success {
            background: #d4edda;
            color: #155724;
            border-left: 5px solid #28a745;
        }

        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border-left: 5px solid #dc3545;
        }

        hr {
            border: none;
            border-top: 2px solid #e0e0e0;
            margin: 30px 0;
        }

        /* Estilos para el wizard */
        .form-step {
            display: none;
            flex: 1;
            overflow: hidden;
            width: 100%;
        }

        .form-step.active {
            display: flex;
            flex-direction: column;
            animation: fadeIn 0.3s ease;
            overflow-y: auto;
            overflow-x: hidden;
            width: 100%;
            max-width: 100%;
            padding: 0 20px;
            justify-content: flex-start; /* Ensure content starts at the top */
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .step-indicator {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
            padding: 0 20px;
        }

        .step {
            flex: 1;
            text-align: center;
            padding: 10px;
            position: relative;
        }

        .step::before {
            content: '';
            position: absolute;
            top: 20px;
            left: 0;
            right: 0;
            height: 2px;
            background: #e0e0e0;
            z-index: -1;
        }

        .step:first-child::before {
            left: 50%;
        }

        .step:last-child::before {
            right: 50%;
        }

        .step-number {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #e0e0e0;
            color: #999;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            margin-bottom: 5px;
            transition: all 0.3s ease;
        }

        .step.active .step-number {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }

        .step.completed .step-number {
            background: #27ae60;
            color: white;
        }

        .step-title {
            font-size: 12px;
            color: #999;
            font-weight: 600;
        }

        .step.active .step-title {
            color: #667eea;
        }

        .step.completed .step-title {
            color: #27ae60;
        }

        .form-navigation {
            display: flex;
            justify-content: space-between;
            gap: 20px;
            margin-top: 25px;
            padding-top: 20px;
            border-top: 1px solid #e0e0e0;
            margin-bottom: 10px;
        }

        .btn-prev, .btn-next {
            flex: 1;
            padding: 15px;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .btn-prev {
            background: #e0e0e0;
            color: #666;
        }

        .btn-prev:hover {
            background: #d0d0d0;
        }

        .btn-next {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }

        .btn-next:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
        }

        /* Estilos para campos con error */
        input.error, select.error, textarea.error {
            border-color: #e74c3c !important;
            background-color: #fff5f5 !important;
        }

        input.error:focus, select.error:focus, textarea.error:focus {
            border-color: #e74c3c !important;
            box-shadow: 0 0 0 3px rgba(231, 76, 60, 0.1) !important;
        }

        /* Animación de spinner */
        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }

        .bx-spin {
            animation: spin 1s linear infinite;
        }

        @media (max-width: 768px) {
            .form-row {
                grid-template-columns: 1fr;
            }

            .header h1 {
                font-size: 24px;
            }

            .form-content {
                padding: 30px 20px;
            }

            .step-indicator {
                flex-wrap: wrap;
            }

            .step {
                flex-basis: 25%;
                margin-bottom: 10px;
            }

            .step-title {
                font-size: 10px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><i class='bx bxs-edit'></i> Formulario de Inscripción</h1>
            <p>EFAC</p>
            <p>Complete todos sus datos (7 pasos) para finalizar la inscripción al programa</p>
        </div>

        <div class="form-content">
            <a href="dashboard.php" class="btn-back">
                <i class='bx bx-arrow-back'></i> Volver al Dashboard
            </a>

            <?php include_once '../../backend/php/inscripcion_ciudadano.php'; ?>

            <!-- Indicador de Pasos -->
            <div class="step-indicator">
                <div class="step active" data-step="1">
                    <div class="step-number">1</div>
                    <div class="step-title">Información Básica</div>
                </div>
                <div class="step" data-step="2">
                    <div class="step-number">2</div>
                    <div class="step-title">Datos Personales</div>
                </div>
                <div class="step" data-step="3">
                    <div class="step-number">3</div>
                    <div class="step-title">Ubicación</div>
                </div>
                <div class="step" data-step="4">
                    <div class="step-number">4</div>
                    <div class="step-title">Contacto</div>
                </div>
                <div class="step" data-step="5">
                    <div class="step-number">5</div>
                    <div class="step-title">Cuidador</div>
                </div>
                <div class="step" data-step="6">
                    <div class="step-number">6</div>
                    <div class="step-title">Salud y Educación</div>
                </div>
                <div class="step" data-step="7">
                    <div class="step-number">7</div>
                    <div class="step-title">Población</div>
                </div>
            </div>

            <form action="inscripcion.php" method="POST" enctype="multipart/form-data" id="inscripcionForm" novalidate>
                <!-- Campo oculto necesario para que el backend procese el registro -->
                <input type="hidden" name="inscripcion_ciudadano" value="1">
                
                <!-- PASO 1: Información Básica -->
                <div class="form-step active" data-step="1">
                <div class="form-section">
                    <h2><i class='bx bxs-user'></i> Información Básica</h2>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>Tipo de Usuario <span class="required">*</span></label>
                            <select required name="tusuario">
                                <option value="">Seleccione</option>
                                <option value="Antiguo">Antiguo</option>
                                <option value="Nuevo" selected>Nuevo</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Tipo de Documento <span class="required">*</span></label>
                            <select required name="tdocumento" id="tdocumento">
                                <option value="">Seleccione tipo de documento</option>
                                <option value="R.C" <?php echo ($tipo_documento_usuario == 'R.C') ? 'selected' : ''; ?>>R.C - Registro Civil</option>
                                <option value="T.I" <?php echo ($tipo_documento_usuario == 'T.I') ? 'selected' : ''; ?>>T.I - Tarjeta de Identidad</option>
                                <option value="C.C" <?php echo ($tipo_documento_usuario == 'C.C') ? 'selected' : ''; ?>>C.C - Cédula de Ciudadanía</option>
                                <option value="PPT" <?php echo ($tipo_documento_usuario == 'PPT') ? 'selected' : ''; ?>>PPT - Permiso por Protección Temporal</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Número de Documento <span class="required">*</span></label>
                            <!-- Removed required from disabled input to prevent validation error -->
                            <input type="text" value="<?php echo $cedula; ?>" name="nhi_display" maxlength="30" disabled>
                            <input type="hidden" name="nhi" value="<?php echo $cedula; ?>">
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Nombres <span class="required">*</span></label>
                            <input type="text" value="<?php echo $nombres; ?>" placeholder="Nombres completos" name="namp" maxlength="50" required>
                        </div>

                        <div class="form-group">
                            <label>Apellidos <span class="required">*</span></label>
                            <input type="text" value="<?php echo $apellidos; ?>" placeholder="Apellidos completos" name="apep" maxlength="50" required>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Estado Civil <span class="required">*</span></label>
                            <select required name="ecivil" id="ecivil">
                                <option value="">Seleccione</option>
                                <option value="SOLTERO">Soltero(a)</option>
                                <option value="CASADO">Casado(a)</option>
                                <option value="UNION LIBRE">Unión Libre</option>
                                <option value="VIUDO">Viudo(a)</option>
                                <option value="DIVORCIADO">Divorciado(a)</option>
                            </select>
                        </div>
                    </div>
                </div>
                </div>

                <!-- PASO 2: Datos Personales -->
                <div class="form-step" data-step="2">
                <div class="form-section">
                    <h2><i class='bx bxs-user-detail'></i> Datos Personales</h2>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>Fecha de Expedición <span class="required">*</span></label>
                            <input type="date" name="fexpedicion" required>
                        </div>

                        <div class="form-group">
                            <label>Lugar de Expedición <span class="required">*</span></label>
                            <select name="lexpedicion" required>
                                <option value="">Seleccione ciudad</option>
                                <option value="Apartadó">Apartadó</option>
                                <option value="Armenia">Armenia</option>
                                <option value="Barranquilla">Barranquilla</option>
                                <option value="Bogotá D.C.">Bogotá D.C.</option>
                                <option value="Bucaramanga">Bucaramanga</option>
                                <option value="Cali">Cali</option>
                                <option value="Cartagena">Cartagena</option>
                                <option value="Caucasia">Caucasia</option>
                                <option value="Chía">Chía</option>
                                <option value="Cúcuta">Cúcuta</option>
                                <option value="Cumaribo">Cumaribo</option>
                                <option value="El Banco">El Banco</option>
                                <option value="Facatativá">Facatativá</option>
                                <option value="Fusagasugá">Fusagasugá</option>
                                <option value="Girardot">Girardot</option>
                                <option value="Ibagué">Ibagué</option>
                                <option value="Ipiales">Ipiales</option>
                                <option value="La Plata">La Plata</option>
                                <option value="Leticia">Leticia</option>
                                <option value="Manizales">Manizales</option>
                                <option value="Medellín">Medellín</option>
                                <option value="Mitú">Mitú</option>
                                <option value="Montería">Montería</option>
                                <option value="Neiva">Neiva</option>
                                <option value="Pasto">Pasto</option>
                                <option value="Pereira">Pereira</option>
                                <option value="Popayán">Popayán</option>
                                <option value="Puerto Asís">Puerto Asís</option>
                                <option value="Puerto Carreño">Puerto Carreño</option>
                                <option value="Riohacha">Riohacha</option>
                                <option value="Rionegro">Rionegro</option>
                                <option value="San Andrés">San Andrés</option>
                                <option value="Santa Marta">Santa Marta</option>
                                <option value="Sibaté">Sibaté</option>
                                <option value="Sincelejo">Sincelejo</option>
                                <option value="Soacha">Soacha</option>
                                <option value="Tumaco">Tumaco</option>
                                <option value="Turbo">Turbo</option>
                                <option value="Uribia">Uribia</option>
                                <option value="Valledupar">Valledupar</option>
                                <option value="Villavicencio">Villavicencio</option>
                                <option value="Zipaquirá">Zipaquirá</option>
                                <option value="OTRO">Otro</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Fecha de Nacimiento <span class="required">*</span></label>
                            <input type="date" name="cump" required>
                        </div>

                        <div class="form-group">
                            <label>Género <span class="required">*</span></label>
                            <select required name="gep" id="gep">
                                <option value="">Seleccione</option>
                                <option value="MASCULINO">Masculino</option>
                                <option value="FEMENINO">Femenino</option>
                                <option value="LGBTIQ+">LGBTIQ+</option>
                                <option value="OTRO">Otro</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Dirección <span class="required">*</span></label>
                            <input type="text" placeholder="Dirección completa" name="dip" required>
                        </div>

                        <div class="form-group">
                            <label>Teléfono <span class="required">*</span></label>
                            <input type="text" maxlength="13" placeholder="+57 300 123 4567" name="telp" required>
                        </div>
                    </div>
                </div>
                </div>


                <!-- PASO 3: Ubicación (Dynamic) -->
                <div class="form-step" data-step="3">
                <div class="form-section">
                    <h2><i class='bx bxs-map'></i> Ubicación</h2>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>Zona <span class="required">*</span></label>
                            <select required name="zona" id="zona">
                                <option value="">Seleccione</option>
                                <option value="Urbano">Urbano</option>
                                <option value="Rural">Rural</option>
                                <option value="CentroP">Centro Poblado</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Barrio, Vereda, Centro Poblado <span class="required">*</span></label>
                            <!-- Input de texto por defecto (para Rural/CentroP) -->
                            <input type="text" name="barrio" id="barrio" placeholder="Escriba su barrio, vereda o centro poblado" maxlength="100" required>
                            
                            <!-- Select para Urbano (oculto por defecto) -->
                            <select id="barrio_select" style="display: none;">
                                <option value="">Seleccione su barrio</option>
                                <option value="El Carmen">El Carmen</option>
                                <option value="El Progreso">El Progreso</option>
                                <option value="La Inmaculada">La Inmaculada</option>
                                <option value="La Paz">La Paz</option>
                                <option value="Parques del Muña">Parques del Muña</option>
                                <option value="San Jorge">San Jorge</option>
                                <option value="San José">San José</option>
                                <option value="San Juan">San Juan</option>
                                <option value="San Martín">San Martín</option>
                                <option value="San Rafael">San Rafael</option>
                                <option value="Santa Isabel">Santa Isabel</option>
                                <option value="Santa Teresa">Santa Teresa</option>
                                <option value="Pablo Neruda">Pablo Neruda</option>
                                <option value="García">García</option>
                                <option value="Villas de Santa Ana">Villas de Santa Ana</option>
                                <option value="El Mirador">El Mirador</option>
                                <option value="Balcones de San José">Balcones de San José</option>
                                <option value="La Reserva 12">La Reserva 12</option>
                            </select>

                            <!-- Select para Rural (oculto por defecto) -->
                            <select id="vereda_select" style="display: none;">
                                <option value="">Seleccione su vereda</option>
                                <option value="Alto Charco">Alto Charco</option>
                                <option value="Bradamonte">Bradamonte</option>
                                <option value="Chacua">Chacua</option>
                                <option value="Delicias">Delicias</option>
                                <option value="El Peñón">El Peñón</option>
                                <option value="La Unión">La Unión</option>
                                <option value="Perico">Perico</option>
                                <option value="Romeral">Romeral</option>
                                <option value="San Benito">San Benito</option>
                                <option value="San Eugenio">San Eugenio</option>
                                <option value="San Fortunato">San Fortunato</option>
                                <option value="San Miguel">San Miguel</option>
                                <option value="San Rafael">San Rafael</option>
                                <option value="Usaba">Usaba</option>
                            </select>

                            <!-- Select para Centro Poblado (oculto por defecto) -->
                            <select id="centrop_select" style="display: none;">
                                <option value="">Seleccione su centro poblado</option>
                                <option value="Sibaté (cabecera municipal)">Sibaté (cabecera municipal)</option>
                                <option value="San Benito Centro">San Benito Centro</option>
                                <option value="Chacua Centro">Chacua Centro</option>
                                <option value="Perico Sector La Honda">Perico Sector La Honda</option>
                                <option value="Perico Sector La Macarena">Perico Sector La Macarena</option>
                                <option value="San Fortunato Sector Los Zorros">San Fortunato Sector Los Zorros</option>
                                <option value="San Miguel">San Miguel</option>
                                <option value="La Unión Sector La Unión">La Unión Sector La Unión</option>
                                <option value="La Unión Sector Pie de Alto">La Unión Sector Pie de Alto</option>
                                <option value="San Benito Sector El Jazmín">San Benito Sector El Jazmín</option>
                            </select>
                        </div>
                    </div>
                </div>
                </div>

                <!-- PASO 4: Información de Contacto y Salud -->
                <div class="form-step" data-step="4">
                <div class="form-section">
                    <h2><i class='bx bxs-phone'></i> Información de Contacto</h2>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>¿Tiene WhatsApp? <span class="required">*</span></label>
                            <select required name="tiene_whatsapp" id="tiene_whatsapp">
                                <option value="">Seleccione</option>
                                <option value="SI">Sí</option>
                                <option value="NO">No</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Correo Electrónico <span class="required">*</span></label>
                            <input type="email" placeholder="correo@ejemplo.com" name="correo" maxlength="70" required>
                        </div>
                    </div>
                    
                        <div class="form-group">
                            <label>Grupo Sanguíneo <span class="required">*</span></label>
                            <select required name="grp" id="grp">
                                <option value="">Seleccione</option>
                                <option value="A+">A+</option>
                                <option value="A-">A-</option>
                                <option value="B+">B+</option>
                                <option value="B-">B-</option>
                                <option value="AB+">AB+</option>
                                <option value="AB-">AB-</option>
                                <option value="O+">O+</option>
                                <option value="O-">O-</option>
                                <option value="NO_SABE">No sabe</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="form-section">
                        <h2><i class='bx bxs-home-heart'></i> Autonomía y Apoyo</h2>
                        
                        <div class="form-group">
                            <label>¿Cuál considera que es su mayor fortaleza o talento? <span class="required">*</span></label>
                            <input type="text" placeholder="Describa su talento" name="talentof" maxlength="100" required>
                        </div>

                        <div class="form-row">
                            <div class="form-group">
                                <label>¿Ingresa y se va solo del programa? <span class="required">*</span></label>
                                <select required name="observacionsalida">
                                    <option value="">Seleccione</option>
                                    <option value="SI">SI</option>
                                    <option value="NO">NO</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label>¿Con quién vive? <span class="required">*</span></label>
                                <input type="text" placeholder="ejm: Solo, Con familia, etc." name="vivecomp" maxlength="50" required>
                            </div>
                        </div>

                        <div class="form-group">
                            <label>¿Posee red de apoyo? <span class="required">*</span></label>
                            <select required name="redapoyo">
                                <option value="">Seleccione</option>
                                <option value="SI">SI</option>
                                <option value="NO">NO</option>
                            </select>
                        </div>
                    </div>
                </div> <!-- End Step 4 -->

                <!-- PASO 5:Información del Acudiente / Contacto -->
                <div class="form-step" data-step="5">
                    <div class="form-section">
                        <h2><i class='bx bxs-user-check'></i> Información del Acudiente / Contacto</h2>
                    
                    <div class="form-group">
                        <label>Nombre y Apellido del Acudiente / Contacto <span class="required">*</span></label>
                        <input type="text" placeholder="Nombre completo" name="cuidador" maxlength="50" required>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Parentesco <span class="required">*</span></label>
                            <select required name="pcuidador">
                                <option value="">Seleccione</option>
                                <option value="CÓNYUGE y/o COMPAÑERO">Cónyuge y/o Compañero</option>
                                <option value="Hijo">Hijo</option>
                                <option value="Familia">Familia</option>
                                <option value="Vecino o Amigo">Vecino o Amigo</option>
                                <option value="Institucional">Institucional</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Zona del Cuidador <span class="required">*</span></label>
                            <select required name="zcuidador" id="zcuidador">
                                <option value="">Seleccione</option>
                                <option value="Urbano">Urbano</option>
                                <option value="Rural">Rural</option>
                                <option value="CentroP">Centro Poblado</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Barrio, Vereda, Centro Poblado del Cuidador <span class="required">*</span></label>
                        <!-- Input de texto por defecto (para Rural/CentroP) -->
                        <input type="text" name="bvccuidador" id="bvccuidador" placeholder="Escriba el barrio, vereda o centro poblado" maxlength="100" required>
                        
                        <!-- Select para Urbano (oculto por defecto) -->
                        <select id="bvccuidador_select" style="display: none;">
                            <option value="">Seleccione su barrio</option>
                            <option value="El Carmen">El Carmen</option>
                            <option value="El Progreso">El Progreso</option>
                            <option value="La Inmaculada">La Inmaculada</option>
                            <option value="La Paz">La Paz</option>
                            <option value="Parques del Muña">Parques del Muña</option>
                            <option value="San Jorge">San Jorge</option>
                            <option value="San José">San José</option>
                            <option value="San Juan">San Juan</option>
                            <option value="San Martín">San Martín</option>
                            <option value="San Rafael">San Rafael</option>
                            <option value="Santa Isabel">Santa Isabel</option>
                            <option value="Santa Teresa">Santa Teresa</option>
                            <option value="Pablo Neruda">Pablo Neruda</option>
                            <option value="García">García</option>
                            <option value="Villas de Santa Ana">Villas de Santa Ana</option>
                            <option value="El Mirador">El Mirador</option>
                            <option value="Balcones de San José">Balcones de San José</option>
                            <option value="La Reserva 12">La Reserva 12</option>
                        </select>

                        <!-- Select para Rural (oculto por defecto) -->
                        <select id="bvccuidador_vereda_select" style="display: none;">
                            <option value="">Seleccione su vereda</option>
                            <option value="Alto Charco">Alto Charco</option>
                            <option value="Bradamonte">Bradamonte</option>
                            <option value="Chacua">Chacua</option>
                            <option value="Delicias">Delicias</option>
                            <option value="El Peñón">El Peñón</option>
                            <option value="La Unión">La Unión</option>
                            <option value="Perico">Perico</option>
                            <option value="Romeral">Romeral</option>
                            <option value="San Benito">San Benito</option>
                            <option value="San Eugenio">San Eugenio</option>
                            <option value="San Fortunato">San Fortunato</option>
                            <option value="San Miguel">San Miguel</option>
                            <option value="San Rafael">San Rafael</option>
                            <option value="Usaba">Usaba</option>
                        </select>

                        <!-- Select para Centro Poblado (oculto por defecto) -->
                        <select id="bvccuidador_centrop_select" style="display: none;">
                            <option value="">Seleccione su centro poblado</option>
                            <option value="Sibaté (cabecera municipal)">Sibaté (cabecera municipal)</option>
                            <option value="San Benito Centro">San Benito Centro</option>
                            <option value="Chacua Centro">Chacua Centro</option>
                            <option value="Perico Sector La Honda">Perico Sector La Honda</option>
                            <option value="Perico Sector La Macarena">Perico Sector La Macarena</option>
                            <option value="San Fortunato Sector Los Zorros">San Fortunato Sector Los Zorros</option>
                            <option value="San Miguel">San Miguel</option>
                            <option value="La Unión Sector La Unión">La Unión Sector La Unión</option>
                            <option value="La Unión Sector Pie de Alto">La Unión Sector Pie de Alto</option>
                            <option value="San Benito Sector El Jazmín">San Benito Sector El Jazmín</option>
                        </select>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Dirección del Cuidador <span class="required">*</span></label>
                            <input type="text" placeholder="Dirección" name="dcuidador" maxlength="50" required>
                        </div>

                        <div class="form-group">
                            <label>Teléfono del Cuidador <span class="required">*</span></label>
                            <input type="text" placeholder="+57 300 123 4567" name="tcuidador" maxlength="30" required>
                        </div>
                    </div>
                </div>
                </div>

                <!-- PASO 6: Salud y Educación -->
                <div class="form-step" data-step="6">

                <!-- Salud -->
                <div class="form-section">
                    <h2><i class='bx bxs-heart'></i> Información de Salud</h2>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>SGSSS <span class="required">*</span></label>
                            <select required name="sgsss">
                                <option value="">Seleccione</option>
                                <option value="Contributivo">Contributivo</option>
                                <option value="Subsidiado">Subsidiado</option>
                                <option value="Regimen Especial">Regimen Especial</option>
                                <option value="No Asegurado">No Asegurado</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>EPS <span class="required">*</span></label>
                            <select required name="eps">
                                <option value="">Seleccione</option>
                                <optgroup label="Ambos regímenes (Contributivo y Subsidiado)">
                                    <option value="Coosalud EPS-S">Coosalud EPS-S</option>
                                    <option value="Nueva EPS">Nueva EPS</option>
                                    <option value="Mutual Ser">Mutual Ser</option>
                                    <option value="Salud Mía">Salud Mía</option>
                                </optgroup>
                                <optgroup label="Régimen Contributivo">
                                    <option value="Aliansalud">Aliansalud</option>
                                    <option value="Salud Total">Salud Total</option>
                                    <option value="Sanitas">Sanitas</option>
                                    <option value="Sura">Sura</option>
                                    <option value="Famisanar">Famisanar</option>
                                    <option value="SOS">SOS (Servicio Occidental de Salud)</option>
                                    <option value="Comfenalco Valle">Comfenalco Valle</option>
                                    <option value="Compensar">Compensar</option>
                                    <option value="EPM">EPM (Empresas Públicas de Medellín)</option>
                                    <option value="Fondo de Pasivo Social">Fondo de Pasivo Social de Ferrocarriles Nacionales de Colombia</option>
                                </optgroup>
                                <optgroup label="Régimen Subsidiado">
                                    <option value="Cajacopi Atlántico">Cajacopi Atlántico</option>
                                    <option value="Capresoca">Capresoca</option>
                                    <option value="Comfachocó">Comfachocó</option>
                                    <option value="Comfaoriente">Comfaoriente</option>
                                    <option value="EPS Familiar de Colombia">EPS Familiar de Colombia</option>
                                    <option value="Asmet Salud">Asmet Salud</option>
                                    <option value="Emssanar">Emssanar</option>
                                    <option value="Capital Salud EPS-S">Capital Salud EPS-S</option>
                                    <option value="Savia Salud">Savia Salud</option>
                                    <option value="Dusakawi EPSI">Dusakawi EPSI</option>
                                    <option value="Asociación Indígena del Cauca EPSI">Asociación Indígena del Cauca EPSI</option>
                                    <option value="Anas Wayuu EPSI">Anas Wayuu EPSI</option>
                                    <option value="Mallamas EPSI">Mallamas EPSI</option>
                                    <option value="Pijaos Salud EPSI">Pijaos Salud EPSI</option>
                                </optgroup>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Etnia <span class="required">*</span></label>
                        <select required name="etnia">
                            <option value="">Seleccione</option>
                            <option value="INDIGENA">INDIGENA</option>
                            <option value="AFRO COLOMBIANO">AFRO COLOMBIANO</option>
                            <option value="ROM-GITANO">ROM-GITANO</option>
                            <option value="PALENQUERO">PALENQUERO</option>
                            <option value="RAIZAL">RAIZAL</option>
                            <option value="NINGUNO">NINGUNO</option>
                        </select>
                    </div>
                </div>

                <!-- Educación -->
                <div class="form-section">
                    <h2><i class='bx bxs-book'></i> Educación y Tecnología</h2>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>Nivel Máximo Alcanzado <span class="required">*</span></label>
                            <select required name="educacion">
                                <option value="">Seleccione</option>
                                <option value="PRIMARIA">PRIMARIA</option>
                                <option value="SECUNDARIA">SECUNDARIA</option>
                                <option value="TECNICA">TECNICA</option>
                                <option value="SUPERIOR">SUPERIOR</option>
                                <option value="NINGUNO">NINGUNO</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>¿Sabe leer y escribir? <span class="required">*</span></label>
                            <select required name="leer">
                                <option value="">Seleccione</option>
                                <option value="SI">SI</option>
                                <option value="NO">NO</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Institución educativa a la que pertenece <span class="required">*</span></label>
                            <select required name="institucion_educativa" id="institucion_educativa" onchange="toggleOtraInstitucion()">
                                <option value="">Seleccione</option>
                                <option value="I.E.D General Santander">Institución Educativa Departamental General Santander</option>
                                <option value="I.E.D Pablo Neruda">Institución Educativa Departamental Pablo Neruda</option>
                                <option value="I.E.D San Miguel">Institución Educativa Departamental San Miguel</option>
                                <option value="I.E.D San Benito">Institución Educativa Departamental San Benito</option>
                                <option value="I.E.D Romeral">Institución Educativa Departamental Romeral</option>
                                <option value="Centro Educativo Infancia de Jesús">Centro Educativo Infancia de Jesús</option>
                                <option value="Liceo Psicopedagógico San Agustín">Liceo Psicopedagógico San Agustín</option>
                                <option value="Gimnasio Bilingüe de Sibaté">Gimnasio Bilingüe de Sibaté</option>
                                <option value="Escuela Rural La Unión">Escuela Rural La Unión</option>
                                <option value="Instituto Campestre de Sibaté">Instituto Campestre de Sibaté</option>
                                <option value="Colegio Liceo Samper Uribe">Colegio Liceo Samper Uribe</option>
                                <option value="Colegio Parroquial La Asunción">Colegio Parroquial La Asunción</option>
                                <option value="Liceo Campestre Bosque Andino">Liceo Campestre Bosque Andino</option>
                                <option value="Gimnasio Los Ángeles">Gimnasio Los Ángeles</option>
                                <option value="Colegio León de Greiff">Colegio León de Greiff</option>
                                <option value="Liceo Cristiano Kyrios">Liceo Cristiano Kyrios</option>
                                <option value="OTRA">Otra</option>
                            </select>
                            <input type="text" name="otra_institucion" id="otra_institucion" placeholder="Escriba el nombre de la institución" style="display: none; margin-top: 10px;" maxlength="150">
                        </div>

                        <div class="form-group">
                            <label>Grado que esta cursando actualmente <span class="required">*</span></label>
                            <select required name="grado_actual">
                                <option value="">Seleccione</option>
                                <option value="Pre-jardín">Pre-jardín</option>
                                <option value="Jardín">Jardín</option>
                                <option value="Transición">Transición</option>
                                <option value="Primero">Primero</option>
                                <option value="Segundo">Segundo</option>
                                <option value="Tercero">Tercero</option>
                                <option value="Cuarto">Cuarto</option>
                                <option value="Quinto">Quinto</option>
                                <option value="Sexto">Sexto</option>
                                <option value="Séptimo">Séptimo</option>
                                <option value="Octavo">Octavo</option>
                                <option value="Noveno">Noveno</option>
                                <option value="Décimo">Décimo</option>
                                <option value="Undécimo">Undécimo</option>
                                <option value="Técnico laboral">Técnico laboral</option>
                                <option value="Técnico profesional">Técnico profesional</option>
                                <option value="Tecnólogo">Tecnólogo</option>
                                <option value="Profesional / Universidad">Profesional / Universidad</option>
                                <option value="Ninguno">Ninguno</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>¿Hace uso de las tecnologías? <span class="required">*</span></label>
                        <select required name="utecnologia">
                            <option value="">Seleccione</option>
                            <option value="SI">SI</option>
                            <option value="NO">NO</option>
                        </select>
                    </div>
                </div>
                </div>

                <!-- PASO 7: Población Diferencial y Finalizar -->
                <div class="form-step" data-step="7">

                <!-- Población Diferencial -->
                <div class="form-section">
                    <h2><i class='bx bxs-group'></i> Población Diferencial</h2>
                    
                    <div class="form-group">
                        <label>¿Hace parte de una población diferencial o de inclusión? <span class="required">*</span></label>
                        <select required name="poblaciond">
                            <option value="">Seleccione</option>
                            <option value="discapacidad">Discapacidad</option>
                            <option value="situacion_especial">En situación de protección especial</option>
                            <option value="desplazada">Población desplazada</option>
                            <option value="vulnerable">En situación de vulneración</option>
                            <option value="cuidado_terceros">Persona que se encuentra al cuidado de tercero</option>
                            <option value="abandono">Situación de abandono</option>
                            <option value="habitante calle">Habitante de calle</option>
                            <option value="victima">Víctima del conflicto armado</option>
                            <option value="Reinsertado">Reinsertado</option>
                            <option value="ninguno">Ninguno</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>¿Hace parte de población diferencial por oficio? <span class="required">*</span></label>
                        <select required name="poblacionoficio">
                            <option value="">Seleccione</option>
                            <option value="Reciclador">Reciclador</option>
                            <option value="Bodegueros">Pequeños Bodegueros</option>
                            <option value="vendedor">Vendedor Ambulante</option>
                            <option value="ninguno">Ninguno</option>
                        </select>
                    </div>
                </div>

                </div>

                <!-- Botones de navegación (Fuera de los pasos para que sean globales) -->
                <div class="form-navigation">
                    <button type="button" class="btn-prev" onclick="previousStep()">
                        <i class='bx bx-chevron-left'></i> Anterior
                    </button>
                    <button type="button" class="btn-next" onclick="nextStep()">
                        Siguiente <i class='bx bx-chevron-right'></i>
                    </button>
                    <button type="submit" name="inscripcion_ciudadano" class="btn-submit" style="display: none; flex: 1; margin: 0;">
                        <i class='bx bx-check-circle'></i> Completar Inscripción
                    </button>
                </div>

            </form>
        </div>
    </div>

    <script src="../../backend/js/jquery.min.js"></script>

    <script>
        function toggleOtraInstitucion() {
            const select = document.getElementById('institucion_educativa');
            const input = document.getElementById('otra_institucion');
            
            if (select && input) {
                if (select.value === 'OTRA') {
                    input.style.display = 'block';
                    input.required = true;
                } else {
                    input.style.display = 'none';
                    input.required = false;
                    input.value = '';
                }
            }
        }

        let currentStep = 1;
        const totalSteps = 7;

        // Función para mostrar un paso específico
        function showStep(step) {
            // Ocultar todos los pasos
            document.querySelectorAll('.form-step').forEach(el => {
                el.classList.remove('active');
            });

            // Mostrar el paso actual
            document.querySelector(`.form-step[data-step="${step}"]`).classList.add('active');

            // Actualizar indicadores
            document.querySelectorAll('.step').forEach((el, index) => {
                el.classList.remove('active', 'completed');
                const stepNum = index + 1;
                if (stepNum < step) {
                    el.classList.add('completed');
                } else if (stepNum === step) {
                    el.classList.add('active');
                }
            });

            // Scroll al inicio
            window.scrollTo({ top: 0, behavior: 'smooth' });

            // Actualizar botones
            const prevBtn = document.querySelector('.btn-prev');
            const nextBtn = document.querySelector('.btn-next');
            const submitBtn = document.querySelector('.btn-submit');
            
            // Visibilidad del botón Anterior
            if (step === 1) {
                if(prevBtn) prevBtn.style.display = 'none';
            } else {
                if(prevBtn) prevBtn.style.display = 'inline-flex';
            }
            
            // Mostrar botón "Siguiente" o "Completar Registro"
            if (step === totalSteps) {
                if (nextBtn) nextBtn.style.display = 'none';
                if (submitBtn) submitBtn.style.display = 'inline-flex';
            } else {
                if (nextBtn) nextBtn.style.display = 'inline-flex';
                if (submitBtn) submitBtn.style.display = 'none';
            }
        }

        // Función para validar el paso actual
        function validateStep(step) {
            const currentStepElement = document.querySelector(`.form-step[data-step="${step}"]`);
            const requiredFields = currentStepElement.querySelectorAll('[required]');
            let isValid = true;
            let firstInvalidField = null;

            requiredFields.forEach(field => {
                // Remover estilos de error previos
                field.classList.remove('error');
                
                // Ignorar campos deshabilitados
                if (field.disabled) {
                    return;
                }
                
                // Validar si está vacío
                if (!field.value || field.value.trim() === '') {
                    isValid = false;
                    field.classList.add('error');
                    if (!firstInvalidField) {
                        firstInvalidField = field;
                    }
                }
                // Validar formato de email
                else if (field.type === 'email') {
                    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                    if (!emailRegex.test(field.value)) {
                        isValid = false;
                        field.classList.add('error');
                        if (!firstInvalidField) {
                            firstInvalidField = field;
                        }
                    }
                }
            });

            if (!isValid && firstInvalidField) {
                firstInvalidField.focus();
                firstInvalidField.scrollIntoView({ behavior: 'smooth', block: 'center' });
            }

            return isValid;
        }

        // Función para ir al siguiente paso
        function nextStep() {
            if (validateStep(currentStep)) {
                if (currentStep < totalSteps) {
                    currentStep++;
                    showStep(currentStep);
                }
            }
        }

        // Función para ir al paso anterior
        function previousStep() {
            if (currentStep > 1) {
                currentStep--;
                showStep(currentStep);
            }
        }

        // Lógica para Zona/Barrio dinámico
        document.addEventListener('DOMContentLoaded', function() {
            const zonaSelect = document.getElementById('zona');
            const barrioInput = document.getElementById('barrio');
            const barrioSelect = document.getElementById('barrio_select');
            const veredaSelect = document.getElementById('vereda_select');
            const centropSelect = document.getElementById('centrop_select');

            function toggleBarrioField() {
                // Reset all first
                barrioInput.style.display = 'none';
                barrioInput.removeAttribute('name');
                barrioInput.removeAttribute('required');

                barrioSelect.style.display = 'none';
                barrioSelect.removeAttribute('name');
                barrioSelect.removeAttribute('required');

                veredaSelect.style.display = 'none';
                veredaSelect.removeAttribute('name');
                veredaSelect.removeAttribute('required');

                centropSelect.style.display = 'none';
                centropSelect.removeAttribute('name');
                centropSelect.removeAttribute('required');

                if (zonaSelect.value === 'Urbano') {
                    // Mostrar Select Barrios
                    barrioSelect.style.display = 'block';
                    barrioSelect.setAttribute('name', 'barrio');
                    barrioSelect.setAttribute('required', 'required');
                } else if (zonaSelect.value === 'Rural') {
                    // Mostrar Select Veredas
                    veredaSelect.style.display = 'block';
                    veredaSelect.setAttribute('name', 'barrio');
                    veredaSelect.setAttribute('required', 'required');
                } else if (zonaSelect.value === 'CentroP') {
                    // Mostrar Select Centro Poblado
                    centropSelect.style.display = 'block';
                    centropSelect.setAttribute('name', 'barrio');
                    centropSelect.setAttribute('required', 'required');
                } else {
                    // Mostrar Input Texto (Fallback)
                    barrioInput.style.display = 'block';
                    barrioInput.setAttribute('name', 'barrio');
                    barrioInput.setAttribute('required', 'required');
                }
            }

            // Escuchar cambios
            if(zonaSelect) {
                zonaSelect.addEventListener('change', toggleBarrioField);
                // Ejecutar al cargar por si hay valor preseleccionado
                toggleBarrioField();
            }

            // Lógica para Zona/Barrio del Cuidador (Paso 5)
            const cuidadorZonaSelect = document.getElementById('zcuidador');
            const cuidadorBarrioInput = document.getElementById('bvccuidador');
            const cuidadorBarrioSelect = document.getElementById('bvccuidador_select');
            const cuidadorVeredaSelect = document.getElementById('bvccuidador_vereda_select');
            const cuidadorCentropSelect = document.getElementById('bvccuidador_centrop_select');

            function toggleCuidadorBarrioField() {
                // Reset all first
                if(cuidadorBarrioInput) {
                    cuidadorBarrioInput.style.display = 'none';
                    cuidadorBarrioInput.removeAttribute('name');
                    cuidadorBarrioInput.removeAttribute('required');
                }

                if(cuidadorBarrioSelect) {
                    cuidadorBarrioSelect.style.display = 'none';
                    cuidadorBarrioSelect.removeAttribute('name');
                    cuidadorBarrioSelect.removeAttribute('required');
                }

                if(cuidadorVeredaSelect) {
                    cuidadorVeredaSelect.style.display = 'none';
                    cuidadorVeredaSelect.removeAttribute('name');
                    cuidadorVeredaSelect.removeAttribute('required');
                }

                if(cuidadorCentropSelect) {
                    cuidadorCentropSelect.style.display = 'none';
                    cuidadorCentropSelect.removeAttribute('name');
                    cuidadorCentropSelect.removeAttribute('required');
                }

                if (!cuidadorZonaSelect) return;

                if (cuidadorZonaSelect.value === 'Urbano') {
                    // Mostrar Select Barrios
                    if(cuidadorBarrioSelect) {
                        cuidadorBarrioSelect.style.display = 'block';
                        cuidadorBarrioSelect.setAttribute('name', 'bvccuidador');
                        cuidadorBarrioSelect.setAttribute('required', 'required');
                    }
                } else if (cuidadorZonaSelect.value === 'Rural') {
                    // Mostrar Select Veredas
                    if(cuidadorVeredaSelect) {
                        cuidadorVeredaSelect.style.display = 'block';
                        cuidadorVeredaSelect.setAttribute('name', 'bvccuidador');
                        cuidadorVeredaSelect.setAttribute('required', 'required');
                    }
                } else if (cuidadorZonaSelect.value === 'CentroP') {
                    // Mostrar Select Centro Poblado
                    if(cuidadorCentropSelect) {
                        cuidadorCentropSelect.style.display = 'block';
                        cuidadorCentropSelect.setAttribute('name', 'bvccuidador');
                        cuidadorCentropSelect.setAttribute('required', 'required');
                    }
                } else {
                    // Mostrar Input Texto (Fallback)
                    if(cuidadorBarrioInput) {
                        cuidadorBarrioInput.style.display = 'block';
                        cuidadorBarrioInput.setAttribute('name', 'bvccuidador');
                        cuidadorBarrioInput.setAttribute('required', 'required');
                    }
                }
            }

            // Escuchar cambios
            if(cuidadorZonaSelect) {
                cuidadorZonaSelect.addEventListener('change', toggleCuidadorBarrioField);
                // Ejecutar al cargar por si hay valor preseleccionado
                toggleCuidadorBarrioField();
            }
        });

        // Inicializar el primer paso
        showStep(1);
    </script>
</body>
</html>
