<?php
    ob_start();
    session_start();
    
    if(!isset($_SESSION['user_type']) || $_SESSION['user_type'] != 'ciudadano'){
        header('location: ../login.php');
        exit;
    }
    
    require_once('../../backend/bd/Conexion.php');
    global $connect;
    
    $username = $_SESSION['username'];
    $name = $_SESSION['name'];
    $cedula = $_SESSION['email'];
    
    // Obtener los datos del estudiante de la nueva tabla
    $datos = null;
    $tiene_datos = false;
    
    try {
        $stmt = $connect->prepare("SELECT * FROM registro_estudiantes WHERE numero_documento = :cedula");
        $stmt->execute([':cedula' => $cedula]);
        $datos = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if($datos) {
            $tiene_datos = true;
        } else {
            // Si no tiene datos, redirigir a inscripción
            header('location: inscripcion.php');
            exit;
        }
    } catch(PDOException $e) {
        $error = "Error al cargar los datos: " . $e->getMessage();
    }
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <title>Mi Información - Programa Persona Mayor</title>
    
    <style>
        :root {
            --font-main: 'Poppins', sans-serif;
            --primary-gradient: linear-gradient(135deg, #8E2DE2 0%, #4A00E0 100%);
            --btn-gradient: linear-gradient(45deg, #FF512F 0%, #DD2476 50%, #FF512F 100%);
            --bg-dark: #121212;
            --bg-card: #1e1e1e;
            --bg-input: #2d2d2d;
            --text-light: #f5f6fa;
            --text-grey: #a4b0be;
            --primary-color: #a29bfe;
            --danger-color: #ff7675;
            --success-color: #00b894;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html, body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: var(--bg-dark);
            min-height: 100vh;
            padding: 20px;
            color: var(--text-light);
            overflow-y: auto !important;
            height: auto;
        }

        .container {
            max-width: 900px;
            margin: 0 auto;
            background: var(--bg-card);
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.5);
            /* overflow: hidden; Eliminado para evitar problemas de scroll */
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        .header {
            background: var(--primary-gradient);
            padding: 40px 30px;
            text-align: center;
            color: white;
        }

        .header h1 {
            font-size: 32px;
            margin-bottom: 10px;
        }

        .header p {
            font-size: 16px;
            opacity: 0.9;
        }

        .form-content {
            padding: 40px 30px;
        }

        .form-section {
            margin-bottom: 30px;
        }

        .form-section h2 {
            font-size: 22px;
            color: var(--primary-color);
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 3px solid var(--primary-color);
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            display: block;
            font-size: 14px;
            font-weight: 600;
            color: var(--text-light);
            margin-bottom: 8px;
        }

        .form-group label .required {
            color: var(--danger-color);
            margin-left: 3px;
        }

        .form-group input[type="text"],
        .form-group input[type="email"],
        .form-group input[type="date"],
        .form-group input[type="file"],
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 12px 15px;
            background: var(--bg-input);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            font-size: 14px;
            color: var(--text-light);
            transition: all 0.3s ease;
        }

        .form-group input:focus,
        .form-group select:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(162, 155, 254, 0.2);
            background: var(--bg-input);
        }

        .form-group input:disabled {
            background: rgba(255, 255, 255, 0.05);
            cursor: not-allowed;
            color: var(--text-grey);
            border-color: transparent;
        }

        .form-group textarea {
            resize: vertical;
            min-height: 80px;
        }

        .form-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
        }

        .btn-submit {
            width: 100%;
            padding: 15px;
            background: var(--btn-gradient);
            background-size: 200% auto;
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 18px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.4s ease;
            box-shadow: 0 4px 15px rgba(221, 36, 118, 0.3);
        }

        .btn-submit:hover {
            background-position: right center;
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(221, 36, 118, 0.5);
        }

        .btn-back {
            display: inline-block;
            padding: 12px 25px;
            background: transparent;
            border: 2px solid var(--primary-color);
            color: var(--primary-color);
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
            margin-bottom: 20px;
        }

        .btn-back:hover {
            background: var(--primary-color);
            color: white;
            box-shadow: 0 5px 15px rgba(162, 155, 254, 0.4);
        }

        .img-preview {
            max-width: 200px;
            max-height: 200px;
            margin-top: 10px;
            border-radius: 10px;
            border: 2px solid rgba(255, 255, 255, 0.1);
        }

        .alert {
            padding: 15px 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-weight: 600;
        }

        .alert-success {
            background: rgba(0, 184, 148, 0.2);
            color: var(--success-color);
            border-left: 5px solid var(--success-color);
        }

        .alert-error {
            background: rgba(255, 118, 117, 0.2);
            color: var(--danger-color);
            border-left: 5px solid var(--danger-color);
        }

        .alert-info {
            background: rgba(162, 155, 254, 0.2);
            color: var(--primary-color);
            border-left: 5px solid var(--primary-color);
        }

        hr {
            border: none;
            border-top: 2px solid rgba(255, 255, 255, 0.1);
            margin: 30px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><i class='bx bxs-user-circle'></i> Mi Información</h1>
            <p>EFAC</p>
            <p>Consulta y actualiza tus datos personales</p>
        </div>

        <div class="form-content">
            <a href="dashboard.php" class="btn-back">
                <i class='bx bx-arrow-back'></i> Volver al Dashboard
            </a>

            <div class="alert alert-info">
                <strong><i class='bx bx-info-circle'></i> Información:</strong>
                Aquí puedes consultar y actualizar tus datos personales del programa.
            </div>
            
            <?php include_once '../../backend/php/actualizar_datos_ciudadano.php'; ?>

            <form action="" method="POST" enctype="multipart/form-data" id="miInfoForm">
                
                <!-- Información del Programa -->
                <div class="form-section">
                    <h2><i class='bx bxs-bookmark'></i> Información del Programa</h2>
                    
                    <div class="form-row">
                        <!-- CAMPO OPCIONAL: MODALIDAD (eliminado de requeridos pero se muestra si existe) -->
                        <div class="form-group">
                            <label>Tipo de Usuario <span class="required">*</span></label>
                            <select required name="tipo_usuario">
                                <option value="">Seleccione</option>
                                <option value="Antiguo" <?php echo ($datos['tipo_usuario'] ?? '') == 'Antiguo' ? 'selected' : ''; ?>>Antiguo</option>
                                <option value="Nuevo" <?php echo ($datos['tipo_usuario'] ?? '') == 'Nuevo' ? 'selected' : ''; ?>>Nuevo</option>
                            </select>
                        </div>
                    </div>
                </div>

                <hr>

                <!-- Información Personal -->
                <div class="form-section">
                    <h2><i class='bx bxs-user'></i> Información Personal</h2>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>Tipo de Documento</label>
                            <input type="text" value="<?php echo $datos['tipo_documento'] ?? ''; ?>" disabled>
                        </div>

                        <div class="form-group">
                            <label>Número de Documento</label>
                            <input type="text" value="<?php echo $datos['numero_documento'] ?? ''; ?>" disabled>
                            <input type="hidden" name="numero_documento" value="<?php echo $datos['numero_documento'] ?? ''; ?>">
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Fecha de Expedición</label>
                            <input type="date" name="fecha_expedicion" value="<?php echo $datos['fecha_expedicion'] ?? ''; ?>">
                        </div>

                        <div class="form-group">
                            <label>Lugar de Expedición</label>
                            <input type="text" name="lugar_expedicion" value="<?php echo $datos['lugar_expedicion'] ?? ''; ?>">
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Nombres <span class="required">*</span></label>
                            <input type="text" value="<?php echo $datos['nombres'] ?? ''; ?>" name="nombres" required>
                        </div>

                        <div class="form-group">
                            <label>Apellidos <span class="required">*</span></label>
                            <input type="text" value="<?php echo $datos['apellidos'] ?? ''; ?>" name="apellidos" required>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Fecha de Nacimiento <span class="required">*</span></label>
                            <input type="date" name="fecha_nacimiento" value="<?php echo $datos['fecha_nacimiento'] ?? ''; ?>" required>
                        </div>
                        
                        <?php
                            // Calcular Edad y Rango
                            $rango_edad = 'No definido';
                            $edad = 0;
                            
                            if (!empty($datos['fecha_nacimiento'])) {
                                $fecha_nac = new DateTime($datos['fecha_nacimiento']);
                                $hoy = new DateTime();
                                $edad = $hoy->diff($fecha_nac)->y;
                                
                                // Intentar obtener rango de la base de datos
                                try {
                                    $stmt_ciclo = $connect->prepare("SELECT nombre_ciclo FROM ciclo_vital WHERE :edad BETWEEN min_edad AND max_edad LIMIT 1");
                                    $stmt_ciclo->execute([':edad' => $edad]);
                                    $ciclo_bd = $stmt_ciclo->fetch(PDO::FETCH_ASSOC);
                                    
                                    if ($ciclo_bd) {
                                        $rango_edad = $ciclo_bd['nombre_ciclo'];
                                    } else {
                                        // Fallback manual si no hay tabla o rango
                                        if ($edad <= 5) $rango_edad = 'Primera infancia';
                                        elseif ($edad <= 11) $rango_edad = 'Infancia';
                                        elseif ($edad <= 13) $rango_edad = 'Adolescencia temprana';
                                        elseif ($edad <= 17) $rango_edad = 'Adolescencia';
                                        elseif ($edad <= 28) $rango_edad = 'Juventud';
                                        elseif ($edad <= 50) $rango_edad = 'Adulto';
                                        elseif ($edad <= 59) $rango_edad = 'Adulto maduro';
                                        else $rango_edad = 'Adulto mayor';
                                    }
                                } catch (Exception $e) {
                                    // Fallback manual si falla la consulta
                                    if ($edad <= 5) $rango_edad = 'Primera infancia';
                                    elseif ($edad <= 11) $rango_edad = 'Infancia';
                                    elseif ($edad <= 13) $rango_edad = 'Adolescencia temprana';
                                    elseif ($edad <= 17) $rango_edad = 'Adolescencia';
                                    elseif ($edad <= 28) $rango_edad = 'Juventud';
                                    elseif ($edad <= 50) $rango_edad = 'Adulto';
                                    elseif ($edad <= 59) $rango_edad = 'Adulto maduro';
                                    else $rango_edad = 'Adulto mayor';
                                }
                            }
                        ?>

                        <div class="form-group">
                            <label>Ciclo Vital (Edad: <?php echo $edad; ?> años)</label>
                            <input type="text" value="<?php echo $rango_edad; ?>" disabled style="background-color: #2d2d2d; color: #a29bfe; font-weight: bold; border-color: #a29bfe;">
                        </div>

                        <div class="form-group">
                            <label>Género <span class="required">*</span></label>
                            <select required name="genero">
                                <option value="">Seleccione</option>
                                <option value="MASCULINO" <?php echo ($datos['genero'] ?? '') == 'MASCULINO' ? 'selected' : ''; ?>>Masculino</option>
                                <option value="FEMENINO" <?php echo ($datos['genero'] ?? '') == 'FEMENINO' ? 'selected' : ''; ?>>Femenino</option>
                                <option value="LGBTIQ+" <?php echo ($datos['genero'] ?? '') == 'LGBTIQ+' ? 'selected' : ''; ?>>LGBTIQ+</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Estado Civil <span class="required">*</span></label>
                        <select required name="estado_civil">
                            <option value="">Seleccione</option>
                            <option value="SOLTERO" <?php echo ($datos['estado_civil'] ?? '') == 'SOLTERO' ? 'selected' : ''; ?>>Soltero(a)</option>
                            <option value="CASADO" <?php echo ($datos['estado_civil'] ?? '') == 'CASADO' ? 'selected' : ''; ?>>Casado(a)</option>
                            <option value="UNION LIBRE" <?php echo ($datos['estado_civil'] ?? '') == 'UNION LIBRE' ? 'selected' : ''; ?>>Unión Libre</option>
                            <option value="VIUDO" <?php echo ($datos['estado_civil'] ?? '') == 'VIUDO' ? 'selected' : ''; ?>>Viudo(a)</option>
                            <option value="DIVORCIADO" <?php echo ($datos['estado_civil'] ?? '') == 'DIVORCIADO' ? 'selected' : ''; ?>>Divorciado(a)</option>
                        </select>
                    </div>

                    <?php if(!empty($datos['foto_perfil'])): ?>
                    <div class="form-group">
                        <label>Foto de Perfil Actual</label>
                        <img src="../../uploads/fotos_perfil/<?php echo $datos['foto_perfil']; ?>" class="img-preview" alt="Foto de perfil">
                    </div>
                    <?php endif; ?>

                    <div class="form-group">
                        <label>Cambiar Foto de Perfil</label>
                        <input type="file" name="foto_perfil" id="fotoperfil" accept="image/*">
                        <img id="img-preview-new" class="img-preview" style="display: none;" alt="Vista previa">
                    </div>

                </div>

                <hr>

                <!-- Información de Contacto -->
                <div class="form-section">
                    <h2><i class='bx bxs-phone'></i> Información de Contacto</h2>
                    
                    <div class="form-group">
                        <label>Dirección <span class="required">*</span></label>
                        <input type="text" value="<?php echo $datos['direccion'] ?? ''; ?>" name="direccion" required>
                    </div>
                    
                     <div class="form-row">
                        <div class="form-group">
                            <label>Zona <span class="required">*</span></label>
                            <select required name="zona">
                                <option value="">Seleccione</option>
                                <option value="Urbano" <?php echo ($datos['zona'] ?? '') == 'Urbano' ? 'selected' : ''; ?>>Urbano</option>
                                <option value="Rural" <?php echo ($datos['zona'] ?? '') == 'Rural' ? 'selected' : ''; ?>>Rural</option>
                                <option value="CentroP" <?php echo ($datos['zona'] ?? '') == 'CentroP' ? 'selected' : ''; ?>>Centro Poblado</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Barrio / Vereda <span class="required">*</span></label>
                            <input type="text" name="barrio" value="<?php echo $datos['barrio'] ?? ''; ?>" required>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Teléfono <span class="required">*</span></label>
                            <input type="text" maxlength="13" value="<?php echo $datos['telefono'] ?? ''; ?>" name="telefono" required>
                        </div>

                        <div class="form-group">
                            <label>¿Tiene WhatsApp? <span class="required">*</span></label>
                            <select required name="tiene_whatsapp">
                                <option value="">Seleccione</option>
                                <option value="SI" <?php echo ($datos['tiene_whatsapp'] ?? '') == 'SI' ? 'selected' : ''; ?>>Sí</option>
                                <option value="NO" <?php echo ($datos['tiene_whatsapp'] ?? '') == 'NO' ? 'selected' : ''; ?>>No</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Correo Electrónico <span class="required">*</span></label>
                        <input type="email" value="<?php echo $datos['correo'] ?? ''; ?>" name="correo" required>
                    </div>
                </div>
                
                <hr>
                
                <!-- Información de Salud -->
                <div class="form-section">
                    <h2><i class='bx bxs-heart'></i> Información de Salud</h2>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>SGSSS <span class="required">*</span></label>
                            <select required name="sgsss">
                                <option value="">Seleccione</option>
                                <option value="Contributivo" <?php echo ($datos['sgsss'] ?? '') == 'Contributivo' ? 'selected' : ''; ?>>Contributivo</option>
                                <option value="Subsidiado" <?php echo ($datos['sgsss'] ?? '') == 'Subsidiado' ? 'selected' : ''; ?>>Subsidiado</option>
                                <option value="Regimen Especial" <?php echo ($datos['sgsss'] ?? '') == 'Regimen Especial' ? 'selected' : ''; ?>>Regimen Especial</option>
                                <option value="No Asegurado" <?php echo ($datos['sgsss'] ?? '') == 'No Asegurado' ? 'selected' : ''; ?>>No Asegurado</option>
                            </select>
                        </div>

                        </div>

                        <div class="form-group">
                            <label>EPS <span class="required">*</span></label>
                            <select required name="eps">
                                <option value="">Seleccione</option>
                                <?php 
                                $epss = ['SANITAS', 'SALUD TOTAL', 'Compensar', 'Cruz verde', 'Nueva EPS'];
                                foreach($epss as $eps_item) {
                                    $selected = strtoupper($datos['eps'] ?? '') == strtoupper($eps_item) ? 'selected' : '';
                                    echo "<option value='$eps_item' $selected>$eps_item</option>";
                                }
                                ?>
                            </select>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Grupo Sanguíneo <span class="required">*</span></label>
                            <select required name="grupo_sanguineo">
                                <option value="">Seleccione</option>
                                <option value="O+" <?php echo ($datos['grupo_sanguineo'] ?? '') == 'O+' ? 'selected' : ''; ?>>O+</option>
                                <option value="O-" <?php echo ($datos['grupo_sanguineo'] ?? '') == 'O-' ? 'selected' : ''; ?>>O-</option>
                                <option value="A+" <?php echo ($datos['grupo_sanguineo'] ?? '') == 'A+' ? 'selected' : ''; ?>>A+</option>
                                <option value="A-" <?php echo ($datos['grupo_sanguineo'] ?? '') == 'A-' ? 'selected' : ''; ?>>A-</option>
                                <option value="B+" <?php echo ($datos['grupo_sanguineo'] ?? '') == 'B+' ? 'selected' : ''; ?>>B+</option>
                                <option value="B-" <?php echo ($datos['grupo_sanguineo'] ?? '') == 'B-' ? 'selected' : ''; ?>>B-</option>
                                <option value="AB+" <?php echo ($datos['grupo_sanguineo'] ?? '') == 'AB+' ? 'selected' : ''; ?>>AB+</option>
                                <option value="AB-" <?php echo ($datos['grupo_sanguineo'] ?? '') == 'AB-' ? 'selected' : ''; ?>>AB-</option>
                            </select>
                        </div>

                    <div class="form-group">
                        <label>Etnia <span class="required">*</span></label>
                        <select required name="etnia">
                            <option value="">Seleccione</option>
                            <option value="INDIGENA" <?php echo ($datos['etnia'] ?? '') == 'INDIGENA' ? 'selected' : ''; ?>>INDIGENA</option>
                            <option value="AFRO COLOMBIANO" <?php echo ($datos['etnia'] ?? '') == 'AFRO COLOMBIANO' ? 'selected' : ''; ?>>AFRO COLOMBIANO</option>
                            <option value="ROM-GITANO" <?php echo ($datos['etnia'] ?? '') == 'ROM-GITANO' ? 'selected' : ''; ?>>ROM-GITANO</option>
                            <option value="PALENQUERO" <?php echo ($datos['etnia'] ?? '') == 'PALENQUERO' ? 'selected' : ''; ?>>PALENQUERO</option>
                            <option value="RAIZAL" <?php echo ($datos['etnia'] ?? '') == 'RAIZAL' ? 'selected' : ''; ?>>RAIZAL</option>
                            <option value="NINGUNO" <?php echo ($datos['etnia'] ?? '') == 'NINGUNO' ? 'selected' : ''; ?>>NINGUNO</option>
                        </select>
                    </div>
                    
                </div>
                
                <hr>
                
                <!--Información del Acudiente / Contacto -->
                <div class="form-section">
                    <h2><i class='bx bxs-user-check'></i> Información del Acudiente / Contacto</h2>
                    
                    <div class="form-group">
                        <label>Nombre y Apellido del Acudiente / Contacto <span class="required">*</span></label>
                        <input type="text" name="nombre_cuidador" value="<?php echo $datos['nombre_cuidador'] ?? ''; ?>" placeholder="Nombre completo" maxlength="50" required>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Parentesco <span class="required">*</span></label>
                            <select required name="parentesco_cuidador">
                                <option value="">Seleccione</option>
                                <option value="CÓNYUGE y/o COMPAÑERO" <?php echo ($datos['parentesco_cuidador'] ?? '') == 'CÓNYUGE y/o COMPAÑERO' ? 'selected' : ''; ?>>Cónyuge y/o Compañero</option>
                                <option value="Hijo" <?php echo ($datos['parentesco_cuidador'] ?? '') == 'Hijo' ? 'selected' : ''; ?>>Hijo</option>
                                <option value="Familia" <?php echo ($datos['parentesco_cuidador'] ?? '') == 'Familia' ? 'selected' : ''; ?>>Familia</option>
                                <option value="Vecino o Amigo" <?php echo ($datos['parentesco_cuidador'] ?? '') == 'Vecino o Amigo' ? 'selected' : ''; ?>>Vecino o Amigo</option>
                                <option value="Institucional" <?php echo ($datos['parentesco_cuidador'] ?? '') == 'Institucional' ? 'selected' : ''; ?>>Institucional</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Zona del Cuidador <span class="required">*</span></label>
                            <select required name="zona_cuidador">
                                <option value="">Seleccione</option>
                                <option value="Urbano" <?php echo ($datos['zona_cuidador'] ?? '') == 'Urbano' ? 'selected' : ''; ?>>Urbano</option>
                                <option value="Rural" <?php echo ($datos['zona_cuidador'] ?? '') == 'Rural' ? 'selected' : ''; ?>>Rural</option>
                                <option value="Centro Poblado" <?php echo ($datos['zona_cuidador'] ?? '') == 'Centro Poblado' ? 'selected' : ''; ?>>Centro Poblado</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Barrio del Cuidador <span class="required">*</span></label>
                        <input type="text" name="barrio_cuidador" value="<?php echo $datos['barrio_cuidador'] ?? ''; ?>" maxlength="100" required>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Dirección del Cuidador <span class="required">*</span></label>
                            <input type="text" name="direccion_cuidador" value="<?php echo $datos['direccion_cuidador'] ?? ''; ?>" placeholder="Dirección" maxlength="50" required>
                        </div>

                        <div class="form-group">
                            <label>Teléfono del Cuidador <span class="required">*</span></label>
                            <input type="text" name="telefono_cuidador" value="<?php echo $datos['telefono_cuidador'] ?? ''; ?>" placeholder="+57 300 123 4567" maxlength="30" required>
                        </div>
                    </div>
                </div>
                
                <hr>
                
                <!-- Autonomía y Apoyo -->
                <div class="form-section">
                    <h2><i class='bx bxs-home-heart'></i> Autonomía y Apoyo</h2>
                    
                    <div class="form-group">
                        <label>¿Cuál considera que es su mayor fortaleza o talento? <span class="required">*</span></label>
                        <input type="text" name="talento_fortaleza" value="<?php echo $datos['talento_fortaleza'] ?? ''; ?>" placeholder="Describa su talento" maxlength="100" required>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>¿Ingresa y se va solo del programa? <span class="required">*</span></label>
                            <select required name="observacion_salida">
                                <option value="">Seleccione</option>
                                <option value="SI" <?php echo ($datos['observacion_salida'] ?? '') == 'SI' ? 'selected' : ''; ?>>SI</option>
                                <option value="NO" <?php echo ($datos['observacion_salida'] ?? '') == 'NO' ? 'selected' : ''; ?>>NO</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>¿Con quién vive? <span class="required">*</span></label>
                            <input type="text" name="vive_con" value="<?php echo $datos['vive_con'] ?? ''; ?>" placeholder="ejm: Solo, Con familia, etc." maxlength="50" required>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>¿Posee red de apoyo? <span class="required">*</span></label>
                        <select required name="red_apoyo">
                            <option value="">Seleccione</option>
                            <option value="SI" <?php echo ($datos['red_apoyo'] ?? '') == 'SI' ? 'selected' : ''; ?>>SI</option>
                            <option value="NO" <?php echo ($datos['red_apoyo'] ?? '') == 'NO' ? 'selected' : ''; ?>>NO</option>
                        </select>
                    </div>
                </div>
                
                <hr>
                
                <!-- Educación y Tecnología -->
                <div class="form-section">
                    <h2><i class='bx bxs-book'></i> Educación y Tecnología</h2>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>Nivel Máximo Alcanzado <span class="required">*</span></label>
                            <select required name="nivel_educativo">
                                <option value="">Seleccione</option>
                                <option value="PRIMARIA" <?php echo ($datos['nivel_educativo'] ?? '') == 'PRIMARIA' ? 'selected' : ''; ?>>PRIMARIA</option>
                                <option value="SECUNDARIA" <?php echo ($datos['nivel_educativo'] ?? '') == 'SECUNDARIA' ? 'selected' : ''; ?>>SECUNDARIA</option>
                                <option value="TECNICA" <?php echo ($datos['nivel_educativo'] ?? '') == 'TECNICA' ? 'selected' : ''; ?>>TECNICA</option>
                                <option value="SUPERIOR" <?php echo ($datos['nivel_educativo'] ?? '') == 'SUPERIOR' ? 'selected' : ''; ?>>SUPERIOR</option>
                                <option value="NINGUNO" <?php echo ($datos['nivel_educativo'] ?? '') == 'NINGUNO' ? 'selected' : ''; ?>>NINGUNO</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>¿Sabe leer y escribir? <span class="required">*</span></label>
                            <select required name="sabe_leer_escribir">
                                <option value="">Seleccione</option>
                                <option value="SI" <?php echo ($datos['sabe_leer_escribir'] ?? '') == 'SI' ? 'selected' : ''; ?>>SI</option>
                                <option value="NO" <?php echo ($datos['sabe_leer_escribir'] ?? '') == 'NO' ? 'selected' : ''; ?>>NO</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Institución educativa a la que pertenece <span class="required">*</span></label>
                            <select required name="institucion_educativa" id="institucion_educativa" onchange="toggleOtraInstitucion()">
                                <option value="">Seleccione</option>
                                <?php 
                                $instituciones = [
                                    "I.E.D General Santander" => "Institución Educativa Departamental General Santander",
                                    "I.E.D Pablo Neruda" => "Institución Educativa Departamental Pablo Neruda",
                                    "I.E.D San Miguel" => "Institución Educativa Departamental San Miguel",
                                    "I.E.D San Benito" => "Institución Educativa Departamental San Benito",
                                    "I.E.D Romeral" => "Institución Educativa Departamental Romeral",
                                    "Centro Educativo Infancia de Jesús" => "Centro Educativo Infancia de Jesús",
                                    "Liceo Psicopedagógico San Agustín" => "Liceo Psicopedagógico San Agustín",
                                    "Gimnasio Bilingüe de Sibaté" => "Gimnasio Bilingüe de Sibaté",
                                    "Escuela Rural La Unión" => "Escuela Rural La Unión",
                                    "Instituto Campestre de Sibaté" => "Instituto Campestre de Sibaté",
                                    "Colegio Liceo Samper Uribe" => "Colegio Liceo Samper Uribe",
                                    "Colegio Parroquial La Asunción" => "Colegio Parroquial La Asunción",
                                    "Liceo Campestre Bosque Andino" => "Liceo Campestre Bosque Andino",
                                    "Gimnasio Los Ángeles" => "Gimnasio Los Ángeles",
                                    "Colegio León de Greiff" => "Colegio León de Greiff",
                                    "Liceo Cristiano Kyrios" => "Liceo Cristiano Kyrios",
                                    "OTRA" => "Otra"
                                ];
                                
                                $saved_inst = strtoupper($datos['institucion_educativa'] ?? '');
                                $is_custom = $saved_inst && !array_key_exists($saved_inst, array_change_key_case($instituciones, CASE_UPPER));
                                // Si es custom (no está en la lista), seleccionamos OTRA
                                if($is_custom) {
                                    $saved_inst_value = $datos['institucion_educativa']; // Valor original
                                    $saved_inst = 'OTRA'; 
                                } else {
                                    $saved_inst_value = '';
                                }

                                foreach($instituciones as $val => $label) {
                                    $selected = $saved_inst == strtoupper($val) ? 'selected' : '';
                                    echo "<option value='$val' $selected>$label</option>";
                                }
                                ?>
                            </select>
                            <input type="text" name="otra_institucion" id="otra_institucion" 
                                   value="<?php echo $saved_inst_value; ?>"
                                   placeholder="Escriba el nombre de la institución" 
                                   style="display: none; margin-top: 10px;" maxlength="150">
                        </div>

                        <div class="form-group">
                            <label>Grado que esta cursando actualmente <span class="required">*</span></label>
                            <select required name="grado_actual">
                                <option value="">Seleccione</option>
                                <?php 
                                $grados = ["Pre-jardín", "Jardín", "Transición", "Primero", "Segundo", "Tercero", "Cuarto", "Quinto", "Sexto", "Séptimo", "Octavo", "Noveno", "Décimo", "Undécimo", "Técnico laboral", "Técnico profesional", "Tecnólogo", "Profesional / Universidad", "Ninguno"];
                                foreach($grados as $grado) {
                                    $selected = strtoupper($datos['grado_actual'] ?? '') == strtoupper($grado) ? 'selected' : '';
                                    echo "<option value='$grado' $selected>$grado</option>";
                                }
                                ?>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>¿Hace uso de las tecnologías? <span class="required">*</span></label>
                        <select required name="uso_tecnologia">
                            <option value="">Seleccione</option>
                            <option value="SI" <?php echo ($datos['uso_tecnologia'] ?? '') == 'SI' ? 'selected' : ''; ?>>SI</option>
                            <option value="NO" <?php echo ($datos['uso_tecnologia'] ?? '') == 'NO' ? 'selected' : ''; ?>>NO</option>
                        </select>
                    </div>
                </div>
                
                <hr>
                
                <!-- Población Diferencial -->
                <div class="form-section">
                    <h2><i class='bx bxs-group'></i> Población Diferencial</h2>
                    
                    <div class="form-group">
                        <label>¿Hace parte de una población diferencial o de inclusión? <span class="required">*</span></label>
                        <select required name="grupo_poblacional">
                            <option value="">Seleccione</option>
                            <option value="discapacidad" <?php echo ($datos['grupo_poblacional'] ?? '') == 'discapacidad' ? 'selected' : ''; ?>>Discapacidad</option>
                            <option value="situacion_especial" <?php echo ($datos['grupo_poblacional'] ?? '') == 'situacion_especial' ? 'selected' : ''; ?>>En situación de protección especial</option>
                            <option value="desplazada" <?php echo ($datos['grupo_poblacional'] ?? '') == 'desplazada' ? 'selected' : ''; ?>>Población desplazada</option>
                            <option value="vulnerable" <?php echo ($datos['grupo_poblacional'] ?? '') == 'vulnerable' ? 'selected' : ''; ?>>En situación de vulneración</option>
                            <option value="cuidado_terceros" <?php echo ($datos['grupo_poblacional'] ?? '') == 'cuidado_terceros' ? 'selected' : ''; ?>>Persona que se encuentra al cuidado de tercero</option>
                            <option value="abandono" <?php echo ($datos['grupo_poblacional'] ?? '') == 'abandono' ? 'selected' : ''; ?>>Situación de abandono</option>
                            <option value="habitante calle" <?php echo ($datos['grupo_poblacional'] ?? '') == 'habitante calle' ? 'selected' : ''; ?>>Habitante de calle</option>
                            <option value="victima" <?php echo ($datos['grupo_poblacional'] ?? '') == 'victima' ? 'selected' : ''; ?>>Víctima del conflicto armado</option>
                            <option value="Reinsertado" <?php echo ($datos['grupo_poblacional'] ?? '') == 'Reinsertado' ? 'selected' : ''; ?>>Reinsertado</option>
                            <option value="ninguno" <?php echo ($datos['grupo_poblacional'] ?? '') == 'ninguno' ? 'selected' : ''; ?>>Ninguno</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>¿Hace parte de población diferencial por oficio? <span class="required">*</span></label>
                        <select required name="poblacion_oficio">
                            <option value="">Seleccione</option>
                            <option value="Reciclador" <?php echo ($datos['poblacion_oficio'] ?? '') == 'Reciclador' ? 'selected' : ''; ?>>Reciclador</option>
                            <option value="Bodegueros" <?php echo ($datos['poblacion_oficio'] ?? '') == 'Bodegueros' ? 'selected' : ''; ?>>Pequeños Bodegueros</option>
                            <option value="vendedor" <?php echo ($datos['poblacion_oficio'] ?? '') == 'vendedor' ? 'selected' : ''; ?>>Vendedor Ambulante</option>
                            <option value="ninguno" <?php echo ($datos['poblacion_oficio'] ?? '') == 'ninguno' ? 'selected' : ''; ?>>Ninguno</option>
                        </select>
                    </div>
                </div>

                <button type="submit" name="actualizar_datos" class="btn-submit">
                    <i class='bx bx-save'></i> Guardar Cambios
                </button>
            </form>
        </div>
    </div>

    <script src="../../backend/js/jquery.min.js"></script>

    <script>
        // Previsualizar nueva imagen
        document.getElementById('fotoperfil').addEventListener('change', function(e) {
            const file = e.target.files[0];
            const preview = document.getElementById('img-preview-new');
            
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    preview.src = e.target.result;
                    preview.style.display = 'block';
                }
                reader.readAsDataURL(file);
            } else {
                preview.style.display = 'none';
            }
        });

        // Alternar campo de 'Otra Institución'
        function toggleOtraInstitucion() {
            const select = document.getElementById('institucion_educativa');
            const input = document.getElementById('otra_institucion');
            
            if (select && input) {
                if (select.value === 'OTRA') {
                    input.style.display = 'block';
                    input.required = true;
                } else {
                    input.style.display = 'none';
                    input.required = false;
                    // Solo limpiar si no se está cargando la página con un valor existente
                    // (Esta lógica simple asume que el usuario está cambiando activamente)
                    if (document.activeElement === select) {
                        input.value = '';
                    }
                }
            }
        }

        // Ejecutar al cargar
        document.addEventListener('DOMContentLoaded', function() {
            toggleOtraInstitucion();
        });
    </script>
</body>
</html>
