<?php
    session_start();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <title>Registro - Programa Persona Mayor</title>
    
    <style>
        :root {
            --font-main: 'Poppins', sans-serif;
            --primary-gradient: linear-gradient(135deg, #8E2DE2 0%, #4A00E0 100%);
            --btn-gradient: linear-gradient(45deg, #FF512F 0%, #DD2476 50%, #FF512F 100%);
            --bg-dark: #121212;
            --bg-card: #1e1e1e;
            --bg-input: #2d2d2d;
            --text-light: #f5f6fa;
            --text-grey: #a4b0be;
            --primary-color: #a29bfe;
            --danger-color: #ff7675;
            --success-color: #00b894;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: var(--bg-dark);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            color: var(--text-light);
        }

        .register-container {
            background: var(--bg-card);
            max-width: 850px; /* Wider for 2 columns */
            width: 100%;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.5);
            overflow: hidden;
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        .header {
            background: var(--primary-gradient);
            padding: 30px;
            text-align: center;
            color: white;
        }

        .form-content {
            padding: 30px;
        }

        /* Grid Layout for Form */
        #registerForm {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }

        .form-group {
            margin-bottom: 0; /* Handled by grid gap */
        }
        
        /* Full width elements */
        .full-width, .btn-submit, .password-strength {
            grid-column: span 2;
        }

        @media (max-width: 768px) {
            #registerForm {
                grid-template-columns: 1fr;
            }
            .full-width, .btn-submit, .password-strength {
                grid-column: span 1;
            }
        }

        .form-group label {
            display: block;
            font-size: 13px; /* Slightly smaller to fit */
            font-weight: 600;
            color: var(--text-light);
            margin-bottom: 6px;
        }

        .form-group label .required {
            color: var(--danger-color);
        }

        .input-wrapper {
            position: relative;
        }

        .input-wrapper input, .input-wrapper select {
            width: 100%;
            padding: 12px 15px 12px 45px;
            background: var(--bg-input);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            font-size: 14px;
            color: var(--text-light);
            transition: all 0.3s ease;
        }

        .input-wrapper input:focus, .input-wrapper select:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(162, 155, 254, 0.2);
            background: var(--bg-input);
        }

        .input-wrapper i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-grey);
            font-size: 18px;
        }

        .btn-submit {
            width: 100%;
            padding: 15px;
            background: var(--btn-gradient);
            background-size: 200% auto;
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.4s ease;
            box-shadow: 0 4px 15px rgba(221, 36, 118, 0.3);
        }

        .btn-submit:hover {
            transform: translateY(-2px);
            background-position: right center;
            box-shadow: 0 10px 30px rgba(221, 36, 118, 0.5);
        }

        .login-link {
            text-align: center;
            margin-top: 20px;
            font-size: 14px;
            color: var(--text-grey);
        }

        .login-link a {
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 600;
        }

        .login-link a:hover {
            text-decoration: underline;
        }

        .alert {
            padding: 15px 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-weight: 600;
        }

        .alert-success {
            background: rgba(0, 184, 148, 0.2);
            color: var(--success-color);
            border-left: 5px solid var(--success-color);
        }

        .alert-error {
            background: rgba(255, 118, 117, 0.2);
            color: var(--danger-color);
            border-left: 5px solid var(--danger-color);
        }

        .password-strength {
            margin-top: 8px;
            font-size: 12px;
        }

        .strength-bar {
            height: 4px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 2px;
            margin-top: 5px;
            overflow: hidden;
        }

        .strength-bar-fill {
            height: 100%;
            width: 0%;
            transition: all 0.3s ease;
        }

        .strength-weak { background: var(--danger-color); width: 33%; }
        .strength-medium { background: #f39c12; width: 66%; }
        .strength-strong { background: var(--success-color); width: 100%; }
    </style>
</head>
<body>
    <div class="register-container">
        <div class="header">
            <h1><i class='bx bxs-user-plus'></i> Crear Cuenta</h1>
            <p>EFAC</p>
            <p>Regístrate para acceder al programa</p>
        </div>

        <div class="form-content">
            <?php include_once '../../backend/php/register_ciudadano.php'; ?>

            <form action="" method="POST" id="registerForm">
                <div class="form-group">
                    <label>Tipo de Documento <span class="required">*</span></label>
                    <div class="input-wrapper">
                        <i class='bx bxs-id-card'></i>
                        <select name="tipo_documento" required>
                            <option value="">Seleccione tipo de documento</option>
                            <option value="R.C">R.C - Registro Civil</option>
                            <option value="T.I">T.I - Tarjeta de Identidad</option>
                            <option value="C.C">C.C - Cédula de Ciudadanía</option>
                            <option value="PPT">PPT - Permiso por Protección Temporal</option>
                        </select>
                    </div>
                </div>

                <div class="form-group">
                    <label>Número de Documento <span class="required">*</span></label>
                    <div class="input-wrapper">
                        <i class='bx bxs-id-card'></i>
                        <input type="text" name="cedula" id="cedula" placeholder="Solo números" maxlength="20" pattern="[0-9]+" title="Solo se permiten números" required>
                    </div>
                </div>

                <div class="form-group">
                    <label>Primer Nombre <span class="required">*</span></label>
                    <div class="input-wrapper">
                        <i class='bx bxs-user'></i>
                        <input type="text" name="primer_nombre" placeholder="Primer Nombre" maxlength="50" required>
                    </div>
                </div>

                <div class="form-group">
                    <label>Segundo Nombre</label>
                    <div class="input-wrapper">
                        <i class='bx bxs-user'></i>
                        <input type="text" name="segundo_nombre" placeholder="Segundo Nombre (Opcional)" maxlength="50">
                    </div>
                </div>

                <div class="form-group">
                    <label>Primer Apellido <span class="required">*</span></label>
                    <div class="input-wrapper">
                        <i class='bx bxs-user'></i>
                        <input type="text" name="primer_apellido" placeholder="Primer Apellido" maxlength="50" required>
                    </div>
                </div>

                <div class="form-group">
                    <label>Segundo Apellido</label>
                    <div class="input-wrapper">
                        <i class='bx bxs-user'></i>
                        <input type="text" name="segundo_apellido" placeholder="Segundo Apellido (Opcional)" maxlength="50">
                    </div>
                </div>

                <div class="form-group">
                    <label>Tipo de Estudiante <span class="required">*</span></label>
                    <div class="input-wrapper">
                        <i class='bx bxs-graduation'></i>
                        <select name="tipo_estudiante" required>
                            <option value="">Seleccione tipo de estudiante</option>
                            <option value="Nuevo">Nuevo</option>
                            <option value="Antiguo">Antiguo</option>
                        </select>
                    </div>
                </div>

                <div class="form-group">
                    <label>Usuario <span class="required">*</span></label>
                    <div class="input-wrapper">
                        <i class='bx bxs-user-circle'></i>
                        <input type="text" name="username" id="username" placeholder="Se completará automáticamente" maxlength="30" readonly style="background-color: #2d2d2d; opacity: 0.7; cursor: not-allowed; border-color: rgba(255, 255, 255, 0.05);">
                    </div>
                    <small style="color: #999; font-size: 12px;">Tu usuario será igual a tu número de documento</small>
                </div>

                <div class="form-group">
                    <label>Contraseña <span class="required">*</span></label>
                    <div class="input-wrapper">
                        <i class='bx bxs-lock'></i>
                        <input type="password" name="password" id="password" placeholder="Contraseña" minlength="6" required>
                    </div>
                    <div class="password-strength">
                        <div class="strength-bar">
                            <div class="strength-bar-fill" id="strengthBar"></div>
                        </div>
                        <small id="strengthText" style="color: #999;">Mínimo 6 caracteres</small>
                    </div>
                </div>

                <div class="form-group">
                    <label>Confirmar Contraseña <span class="required">*</span></label>
                    <div class="input-wrapper">
                        <i class='bx bxs-lock-alt'></i>
                        <input type="password" name="confirm_password" placeholder="Confirmar contraseña" required>
                    </div>
                </div>

                <button type="submit" name="register_ciudadano" class="btn-submit">
                    <i class='bx bx-check-circle'></i> Crear Cuenta
                </button>
            </form>

            <div class="login-link">
                ¿Ya tienes cuenta? <a href="../login.php">Inicia sesión aquí</a>
            </div>
        </div>
    </div>

    <script>
        // Sincronizar Cédula con Usuario
        document.getElementById('cedula').addEventListener('input', function() {
            document.getElementById('username').value = this.value;
        });

        // Validar fortaleza de contraseña
        const passwordInput = document.getElementById('password');
        const strengthBar = document.getElementById('strengthBar');
        const strengthText = document.getElementById('strengthText');

        passwordInput.addEventListener('input', function() {
            const password = this.value;
            let strength = 0;

            if (password.length >= 6) strength++;
            if (password.length >= 10) strength++;
            if (/[a-z]/.test(password) && /[A-Z]/.test(password)) strength++;
            if (/\d/.test(password)) strength++;
            if (/[^a-zA-Z\d]/.test(password)) strength++;

            strengthBar.className = 'strength-bar-fill';
            
            if (strength <= 2) {
                strengthBar.classList.add('strength-weak');
                strengthText.textContent = 'Contraseña débil';
                strengthText.style.color = '#e74c3c';
            } else if (strength <= 3) {
                strengthBar.classList.add('strength-medium');
                strengthText.textContent = 'Contraseña media';
                strengthText.style.color = '#f39c12';
            } else {
                strengthBar.classList.add('strength-strong');
                strengthText.textContent = 'Contraseña fuerte';
                strengthText.style.color = '#27ae60';
            }
        });

        // Validar que las contraseñas coincidan
        document.getElementById('registerForm').addEventListener('submit', function(e) {
            const password = document.querySelector('input[name="password"]').value;
            const confirmPassword = document.querySelector('input[name="confirm_password"]').value;

            if (password !== confirmPassword) {
                e.preventDefault();
                alert('Las contraseñas no coinciden');
            }
        });
    </script>
</body>
</html>
