<?php
session_start();

// Validar acceso ciudadano
if (!isset($_SESSION['user_type']) || $_SESSION['user_type'] != 'ciudadano') {
    header("Location: ../login.php");
    exit();
}

require '../../backend/bd/Conexion.php';

$id_curso = isset($_GET['id']) ? intval($_GET['id']) : 0;
// CRITICAL FIX: The registration system uses $_SESSION['email'] to store the 'cedula/documento', 
// not $_SESSION['username']. mirroring logic from inscribir_curso_ciudadano.php
$documento = $_SESSION['email'] ?? null; 

if ($id_curso <= 0 || empty($documento)) {
    header('Location: area_virtual.php');
    exit();
}

// Validar inscripción activa (sin requerir grupo)
$stmt = $connect->prepare("SELECT * FROM inscripciones WHERE documento = ? AND idcurso = ? AND state = '1' LIMIT 1");
$stmt->execute([$documento, $id_curso]);
$inscripcion = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$inscripcion) {
    // Si no está inscrito o inactivo
    header('Location: area_virtual.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <title>Aula Virtual | Ver Curso</title>
    <!-- Summernote CSS (solo para estilos de visualización si es necesario) -->
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
    
    <style>
        :root {
            --font-main: 'Poppins', sans-serif;
            --primary-gradient: linear-gradient(135deg, #8E2DE2 0%, #4A00E0 100%);
            --bg-dark: #121212;
            --bg-card: #1e1e1e;
            --text-light: #f5f6fa;
            --text-grey: #a4b0be;
            --primary-color: #a29bfe;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: var(--bg-dark);
            min-height: 100vh;
            color: var(--text-light);
            padding-bottom: 50px;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        /* Header */
        .course-header {
            background: var(--bg-card);
            padding: 25px 30px;
            border-radius: 15px;
            margin-bottom: 30px;
            border: 1px solid rgba(255, 255, 255, 0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .course-title {
            font-size: 24px;
            color: var(--primary-color);
            margin: 0;
        }

        .btn-back {
            padding: 8px 15px;
            background: rgba(255, 255, 255, 0.05);
            color: var(--text-light);
            text-decoration: none;
            border-radius: 8px;
            font-size: 14px;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        /* Layout */
        .grid-layout {
            display: grid;
            grid-template-columns: 280px 1fr;
            gap: 25px;
        }

        @media (max-width: 768px) {
            .grid-layout {
                grid-template-columns: 1fr;
            }
        }

        /* Sidebar Modules */
        .modules-sidebar {
            background: var(--bg-card);
            border-radius: 12px;
            padding: 15px;
            height: fit-content;
        }

        .modules-title {
            font-size: 16px;
            color: var(--text-grey);
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 1px solid rgba(255,255,255,0.05);
            font-weight: 600;
        }

        .module-item {
            display: block;
            padding: 12px 15px;
            margin-bottom: 8px;
            border-radius: 8px;
            cursor: pointer;
            color: var(--text-light);
            transition: all 0.2s;
            background: rgba(255,255,255,0.02);
            font-size: 14px;
        }

        .module-item:hover {
            background: rgba(255,255,255,0.05);
            padding-left: 20px;
        }

        .module-item.active {
            background: var(--primary-gradient);
            color: white;
            font-weight: 600;
            box-shadow: 0 4px 15px rgba(142, 45, 226, 0.3);
        }

        /* Content Area */
        .content-area {
            background: var(--bg-card);
            border-radius: 15px;
            padding: 30px;
            min-height: 500px;
        }

        /* LMS Cards */
        .lms-card {
            background: rgba(255,255,255,0.02);
            border: 1px solid rgba(255,255,255,0.05);
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
        }

        .lms-card h4 {
            font-size: 18px;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
            color: var(--text-light);
        }

        .item-content {
            font-size: 15px;
            line-height: 1.6;
            color: #dcdde1;
        }

        .item-content img {
            max-width: 100%;
            border-radius: 8px;
        }

        .badge-type {
            font-size: 11px;
            padding: 3px 8px;
            border-radius: 4px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
    </style>
</head>
<body>

    <div class="container">
        
        <div class="course-header">
            <div>
                <span style="font-size: 12px; color: var(--text-grey); text-transform: uppercase; letter-spacing: 1px;">Aula Virtual</span>
                <h1 class="course-title" id="courseTitle">Cargando...</h1>
            </div>
            <a href="area_virtual.php" class="btn-back">
                <i class='bx bx-arrow-back'></i> Volver
            </a>
        </div>

        <div class="grid-layout">
            
            <!-- Sidebar: Lista de Módulos -->
            <aside class="modules-sidebar">
                <div class="modules-title">MÓDULOS DEL CURSO</div>
                <div id="moduleList">
                    <div style="text-align: center; padding: 20px; color: var(--text-grey);">
                        <i class='bx bx-loader-alt bx-spin'></i>
                    </div>
                </div>
            </aside>

            <!-- Main: Contenido -->
            <main class="content-area" id="moduleContent">
                <div style="text-align:center; padding-top: 50px; color: var(--text-grey);">
                    <i class='bx bx-book-open' style="font-size: 48px; opacity: 0.5;"></i>
                    <p style="margin-top: 10px;">Selecciona un módulo para ver su contenido.</p>
                </div>
            </main>

        </div>

    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        const courseId = <?php echo $id_curso; ?>;
        let currentModuleId = null;

        $(document).ready(function() {
            loadCourseDetails();
            loadModules();
        });

        function loadCourseDetails() {
            // Reutilizamos el backend existente
            $.post('../../frontend/cursos/ajax_registro.php', { action: 'get_course', id: courseId }, function(response) {
                if (response.success) {
                    $('#courseTitle').text(response.data.nombre);
                }
            }, 'json');
        }

        function loadModules() {
            $.post('../../frontend/cursos/ajax_registro.php', { action: 'get_course_modules', id_curso: courseId }, function(response) {
                const container = $('#moduleList');
                container.empty();

                if (response.success && response.data.length > 0) {
                    response.data.forEach((mod, index) => {
                        // Auto-select first module if none selected
                        if (index === 0) {
                            loadModuleContent(mod.id);
                        }

                        // Create Item
                        const item = $(`
                            <a class="module-item" id="mod-link-${mod.id}">
                                ${mod.titulo}
                            </a>
                        `);
                        
                        item.click(function() {
                            loadModuleContent(mod.id);
                        });

                        container.append(item);
                    });
                } else {
                    container.html('<div style="padding:10px; font-size:13px; color:#666;">No hay módulos disponibles.</div>');
                }
            }, 'json');
        }

        function loadModuleContent(id) {
            currentModuleId = id;
            
            // UI Active State
            $('.module-item').removeClass('active');
            $(`#mod-link-${id}`).addClass('active');

            const contentDiv = $('#moduleContent');
            contentDiv.html('<div style="text-align:center; padding: 50px; color:#666;"><i class="bx bx-loader-alt bx-spin" style="font-size:24px;"></i> Cargando contenido...</div>');

            $.post('../../frontend/cursos/ajax_registro.php', { 
                action: 'get_module_content', 
                id_modulo: id 
            }, function(response) {
                contentDiv.empty();

                if (response.success && response.data.length > 0) {
                    response.data.forEach(item => {
                        const icon = getIconForType(item.tipo);
                        const color = getColorForType(item.tipo);
                        
                        // Render Content Card
                        let itemHtml = `
                            <div class="lms-card" id="card-${item.id}">
                                <h4>
                                    <i class='bx ${icon}' style="color:${color}; font-size: 20px;"></i>
                                    ${item.titulo}
                                    <span class="badge-type" style="background:${color}20; color:${color}; margin-left:auto;">${item.tipo}</span>
                                </h4>
                                <div class="item-content">
                                    ${item.contenido ? item.contenido : '<em style="color:#666;">Sin descripción.</em>'}
                                </div>
                        `;

                        // --- LOGIC FOR ASSIGNMENTS (TAREA) ---
                        if (item.tipo === 'tarea') {
                            const deadlineStr = item.fecha_limite ? new Date(item.fecha_limite).toLocaleString() : 'Sin fecha límite';
                            
                            // Check if already submitted
                            let submissionHtml = '';
                            if (item.archivo_entrega) {
                                // Submitted
                                submissionHtml = `
                                    <div style="margin-top:15px; padding:15px; background:rgba(46, 204, 113, 0.1); border-radius:8px; border-left: 3px solid #2ecc71;">
                                        <div style="color:#2ecc71; font-weight:600; margin-bottom:5px;">
                                            <i class='bx bx-check-circle'></i> Tarea Entregada
                                        </div>
                                        <div style="font-size:13px; margin-bottom:5px;">
                                            <strong>Archivo:</strong> <a href="../../backend/uploads/tareas/${item.archivo_entrega}" target="_blank" style="color:var(--primary-color); text-decoration:underline;">Ver Archivo</a>
                                        </div>
                                        <div style="font-size:13px; color:#aaa;">
                                            Entregado el: ${new Date(item.fecha_entrega).toLocaleString()}
                                        </div>
                                        ${item.calificacion ? `
                                            <div style="margin-top:10px; padding-top:10px; border-top:1px solid rgba(255,255,255,0.1);">
                                                <strong>Calificación:</strong> ${item.calificacion}<br>
                                                <strong>Feedback:</strong> ${item.feedback || 'Sin comentarios'}
                                            </div>
                                        ` : ''}
                                    </div>
                                `;
                            } else {
                                // Not submitted - Show Upload Form
                                submissionHtml = `
                                    <div style="margin-top:20px; padding:15px; background:rgba(255,255,255,0.03); border-radius:8px; border: 1px dashed rgba(255,255,255,0.1);">
                                        <div style="font-size:13px; margin-bottom:10px; color:var(--text-grey);">
                                            <strong><i class='bx bx-time'></i> Fecha límite:</strong> ${deadlineStr}
                                        </div>
                                        
                                        <form id="form-upload-${item.id}" onsubmit="submitAssignment(event, ${item.id})">
                                            <label style="display:block; margin-bottom:8px; font-size:13px;">Subir tu tarea (PDF, Doc, Imagen)</label>
                                            <input type="file" name="archivo" required style="width:100%; padding:8px; background:rgba(0,0,0,0.2); border:1px solid rgba(255,255,255,0.1); border-radius:5px; color:#fff; font-size:13px;">
                                            <button type="submit" class="btn-upload-${item.id}" style="margin-top:10px; padding:8px 15px; background:var(--primary-color); color:#fff; border:none; border-radius:5px; cursor:pointer; font-size:13px; width:100%;">
                                                <i class='bx bx-upload'></i> Enviar Tarea
                                            </button>
                                        </form>
                                        <div id="upload-msg-${item.id}" style="margin-top:10px; font-size:13px;"></div>
                                    </div>
                                `;
                            }
                            itemHtml += submissionHtml;
                        }

                        // --- LOGIC FOR FORUMS (FORO) ---
                        if (item.tipo === 'foro') {
                            itemHtml += `
                                <div style="margin-top:20px;">
                                    <button onclick="toggleForum(${item.id})" style="background:rgba(255,255,255,0.05); border:none; color:var(--primary-color); padding:8px 15px; border-radius:20px; cursor:pointer; font-size:13px;">
                                        <i class='bx bx-message-rounded-dots'></i> Ver Participaciones
                                    </button>
                                    
                                    <div id="forum-container-${item.id}" style="display:none; margin-top:15px; padding-top:15px; border-top:1px solid rgba(255,255,255,0.05);">
                                        <!-- Comments Load Here -->
                                        <div id="forum-comments-${item.id}" style="max-height:300px; overflow-y:auto; margin-bottom:15px;"></div>
                                        
                                        <!-- Add Comment -->
                                        <div style="display:flex; gap:10px;">
                                            <input type="text" id="comment-input-${item.id}" placeholder="Escribe un comentario..." style="flex:1; padding:10px; background:rgba(0,0,0,0.2); border:1px solid rgba(255,255,255,0.1); border-radius:8px; color:#fff;">
                                            <button onclick="postComment(${item.id})" style="background:var(--primary-color); color:#fff; border:none; padding:0 20px; border-radius:8px; cursor:pointer;">
                                                <i class='bx bx-send'></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            `;
                        }

                        itemHtml += `</div>`;
                        contentDiv.append(itemHtml);
                    });

                } else {
                    contentDiv.html(`
                        <div style="text-align:center; padding: 50px; opacity: 0.5;">
                            <i class='bx bxs-folder-open' style="font-size: 48px; margin-bottom: 10px;"></i>
                            <p>Este módulo aún no tiene contenido publicado.</p>
                        </div>
                    `);
                }
            }, 'json');
        }

        // --- SUBMISSION HANDLER ---
        function submitAssignment(e, idItem) {
            e.preventDefault();
            const form = document.getElementById(`form-upload-${idItem}`);
            const formData = new FormData(form);
            formData.append('action', 'upload_submission');
            formData.append('id_contenido', idItem);

            const btn = $(`.btn-upload-${idItem}`);
            const msg = $(`#upload-msg-${idItem}`);
            
            btn.prop('disabled', true).html('<i class="bx bx-loader-alt bx-spin"></i> Subiendo...');

            $.ajax({
                url: '../../frontend/cursos/ajax_registro.php',
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                success: function(response) {
                    if (response.success) {
                        msg.html(`<span style="color:#2ecc71;">${response.message}</span>`);
                        setTimeout(() => {
                            // Reload module content to show "Entregado" state
                            loadModuleContent(currentModuleId); 
                        }, 1000);
                    } else {
                        msg.html(`<span style="color:#e74c3c;">${response.message}</span>`);
                        btn.prop('disabled', false).html('<i class="bx bx-upload"></i> Reintentar');
                    }
                },
                error: function() {
                    msg.html(`<span style="color:#e74c3c;">Error de conexión.</span>`);
                    btn.prop('disabled', false).html('<i class="bx bx-upload"></i> Reintentar');
                }
            });
        }

        // --- FORUM HANDLERS ---
        function toggleForum(idItem) {
            const container = $(`#forum-container-${idItem}`);
            if (container.is(':visible')) {
                container.slideUp();
            } else {
                container.slideDown();
                loadForumComments(idItem);
            }
        }

        function loadForumComments(idItem) {
            const list = $(`#forum-comments-${idItem}`);
            list.html('<div style="padding:10px; color:#666;">Cargando comentarios...</div>');

            $.post('../../frontend/cursos/ajax_registro.php', { action: 'get_forum_comments', id_contenido: idItem }, function(response) {
                list.empty();
                if (response.success && response.data.length > 0) {
                    response.data.forEach(c => {
                        const html = `
                            <div style="margin-bottom:10px; padding:10px; background:rgba(255,255,255,0.02); border-radius:6px;">
                                <div style="font-size:12px; color:var(--primary-color); margin-bottom:3px; font-weight:600;">
                                    ${c.nombre_completo || 'Usuario'} <span style="color:#666; font-weight:400;">(${c.fecha_format})</span>
                                </div>
                                <div style="font-size:13px; color:#ddd;">${c.comentario}</div>
                            </div>
                        `;
                        list.append(html);
                    });
                } else {
                    list.html('<div style="padding:10px; font-size:13px; color:#666; font-style:italic;">No hay participaciones aún. Sé el primero.</div>');
                }
            }, 'json');
        }

        function postComment(idItem) {
            const input = $(`#comment-input-${idItem}`);
            const comment = input.val().trim();
            
            if (!comment) return;

            $.post('../../frontend/cursos/ajax_registro.php', { 
                action: 'add_forum_comment', 
                id_contenido: idItem, 
                comentario: comment 
            }, function(response) {
                if (response.success) {
                    input.val(''); // Clear
                    loadForumComments(idItem); // Reload
                } else {
                    alert('Error: ' + response.message);
                }
            }, 'json');
        }

        function getIconForType(type) {
            switch(type) {
                case 'tarea': return 'bx-task';
                case 'foro': return 'bx-chat';
                case 'evaluacion': return 'bx-check-square';
                default: return 'bx-book-content';
            }
        }
        
        function getColorForType(type) {
            switch(type) {
                case 'tarea': return '#e67e22'; // Orange
                case 'foro': return '#3498db'; // Blue
                case 'evaluacion': return '#e74c3c'; // Red
                default: return '#a29bfe'; // Purple
            }
        }
    </script>

</body>
</html>
