<?php
if(!isset($_SESSION)) { session_start(); }
// frontend/cursos/ajax_registro.php

require '../../backend/bd/Conexion.php';

// --- HELPER FUNCTION TO GET STUDENT ID ---
function getStudentId($connect) {
    if (isset($_SESSION['id_usuario'])) {
        return $_SESSION['id_usuario'];
    }
    if (isset($_SESSION['email'])) { // Documento for citizens or email
        $doc = $_SESSION['email'];
        // Try finding ID in users
        $stmt = $connect->prepare("SELECT id FROM users WHERE username = ? OR email = ?");
        $stmt->execute([$doc, $doc]);
        if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) return $row['id'];
        
        // If not in users, check registro_estudiantes?
        $stmt = $connect->prepare("SELECT id FROM registro_estudiantes WHERE numero_documento = ?");
        $stmt->execute([$doc]);
        if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) return $row['id']; 
        // Note: returning registro_estudiantes ID might mismatch if tables link to users.id. 
        // But if user has no user account, this is the best fallback.
    }
    return 0; 
}

header('Content-Type: application/json');

$action = $_POST['action'] ?? '';


try {
    switch ($action) {
        // --- ESCUELAS ---
        case 'get_escuelas':
            $stmt = $connect->query("SELECT * FROM escuelas_formacion ORDER BY id ASC");
            echo json_encode(['success' => true, 'data' => $stmt->fetchAll(PDO::FETCH_ASSOC)]);
            break;

        case 'add_escuela':
            $nombre = $_POST['nombre'];
            $descripcion = $_POST['descripcion'];

            // Auto-increment code logic
            $stmt = $connect->query("SELECT MAX(CAST(codigo AS UNSIGNED)) as max_code FROM escuelas_formacion");
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            $next_code = ($row['max_code']) ? $row['max_code'] + 1 : 1;
            $codigo = (string)$next_code;

            $stmt = $connect->prepare("INSERT INTO escuelas_formacion (codigo, nombre, descripcion) VALUES (?, ?, ?)");
            if ($stmt->execute([$codigo, $nombre, $descripcion])) {
                echo json_encode(['success' => true, 'message' => 'Escuela registrada correctamente. Código: ' . $codigo]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al registrar la escuela.']);
            }
            break;

        case 'edit_escuela':
            $id = $_POST['id'];
            $nombre = $_POST['nombre'];
            $descripcion = $_POST['descripcion'];

            $stmt = $connect->prepare("UPDATE escuelas_formacion SET nombre = ?, descripcion = ? WHERE id = ?");
            if ($stmt->execute([$nombre, $descripcion, $id])) {
                echo json_encode(['success' => true, 'message' => 'Escuela actualizada correctamente.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al actualizar la escuela.']);
            }
            break;

        // --- ÁREAS ---
        case 'get_areas':
            $id_escuela = $_POST['id_escuela'];
            $stmt = $connect->prepare("SELECT * FROM areas WHERE id_escuela = ? ORDER BY id ASC");
            $stmt->execute([$id_escuela]);
            echo json_encode(['success' => true, 'data' => $stmt->fetchAll(PDO::FETCH_ASSOC)]);
            break;

        case 'add_area':
            $id_escuela = $_POST['id_escuela'];
            $nombre = $_POST['nombre'];

             // Auto-increment code logic
             $stmt = $connect->query("SELECT MAX(CAST(codigo AS UNSIGNED)) as max_code FROM areas");
             $row = $stmt->fetch(PDO::FETCH_ASSOC);
             $next_code = ($row['max_code']) ? $row['max_code'] + 1 : 1;
             $codigo = (string)$next_code;

            $stmt = $connect->prepare("INSERT INTO areas (id_escuela, codigo, nombre) VALUES (?, ?, ?)");
            if ($stmt->execute([$id_escuela, $codigo, $nombre])) {
                echo json_encode(['success' => true, 'message' => 'Área registrada correctamente. Código: ' . $codigo]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al registrar el área.']);
            }
            break;

        case 'edit_area':
            $id = $_POST['id'];
            $nombre = $_POST['nombre'];

            $stmt = $connect->prepare("UPDATE areas SET nombre = ? WHERE id = ?");
            if ($stmt->execute([$nombre, $id])) {
                echo json_encode(['success' => true, 'message' => 'Área actualizada correctamente.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al actualizar el área.']);
            }
            break;

        // --- CURSOS ---
        case 'get_cursos':
            $id_area = $_POST['id_area'];
            // Subquery to count active enrollments (state = '1')
            $sql = "SELECT c.*, 
                           (SELECT COUNT(*) FROM inscripciones i WHERE i.idcurso = c.idcurso AND i.state = '1') as inscritos
                    FROM cursos c 
                    WHERE c.id_area = ? 
                    ORDER BY c.idcurso ASC";
            $stmt = $connect->prepare($sql);
            $stmt->execute([$id_area]);
            echo json_encode(['success' => true, 'data' => $stmt->fetchAll(PDO::FETCH_ASSOC)]);
            break;

        case 'add_curso':
            $id_area = $_POST['id_area'];
            $nombre = $_POST['nombre'];
            $quien_lo_da = $_POST['quien_lo_da'];
            $es_titulado = $_POST['es_titulado'];
            $en_que = $_POST['en_que'];
            $cupos = !empty($_POST['cupos']) ? $_POST['cupos'] : 0;
            
            // Handle Schedule
            $dias_clase = isset($_POST['dias']) ? implode(', ', $_POST['dias']) : null;
            $horario_clase = !empty($_POST['horario_clase']) ? $_POST['horario_clase'] : null;

            // Auto-increment code logic for cursos
            $stmt = $connect->query("SELECT MAX(CAST(codigo AS UNSIGNED)) as max_code FROM cursos");
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            $next_code = ($row['max_code']) ? $row['max_code'] + 1 : 1;
            $codigo = (string)$next_code;

            $stmt = $connect->prepare("INSERT INTO cursos (nombre, quien_lo_da, es_titulado, en_que, id_area, codigo, cupos, dias_clase, horario_clase) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            if ($stmt->execute([$nombre, $quien_lo_da, $es_titulado, $en_que, $id_area, $codigo, $cupos, $dias_clase, $horario_clase])) {
                echo json_encode(['success' => true, 'message' => 'Curso registrado correctamente. Código: ' . $codigo]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al registrar el curso.']);
            }
            break;

        case 'edit_curso':
            $id = $_POST['id'];
            $nombre = $_POST['nombre'];
            $quien_lo_da = $_POST['quien_lo_da'];
            $es_titulado = $_POST['es_titulado'];
            $en_que = $_POST['en_que'];
            $cupos = !empty($_POST['cupos']) ? $_POST['cupos'] : 0;
            
            // Handle Schedule
            $dias_clase = isset($_POST['dias']) ? implode(', ', $_POST['dias']) : null;
            $horario_clase = !empty($_POST['horario_clase']) ? $_POST['horario_clase'] : null;

            $stmt = $connect->prepare("UPDATE cursos SET nombre = ?, quien_lo_da = ?, es_titulado = ?, en_que = ?, cupos = ?, dias_clase = ?, horario_clase = ? WHERE idcurso = ?");
            if ($stmt->execute([$nombre, $quien_lo_da, $es_titulado, $en_que, $cupos, $dias_clase, $horario_clase, $id])) {
                echo json_encode(['success' => true, 'message' => 'Curso actualizado correctamente.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al actualizar el curso.']);
            }
            break;

        case 'get_grupo_assignments':
            $id_curso = $_POST['id_curso'];
            
            // 1. Get Groups
            $stmt = $connect->prepare("SELECT * FROM cursos_grupos WHERE id_curso = ? ORDER BY nombre ASC");
            $stmt->execute([$id_curso]);
            $grupos = $stmt->fetchAll(PDO::FETCH_ASSOC);

            // 2. Get Students (Grouped)
            // Join with other tables to get names, similar to get_inscritos
           $sql = "SELECT DISTINCT 
                        COALESCE(re.nombres, u.name, p.nompa) as nombres,
                        COALESCE(re.apellidos, '', p.apepa) as apellidos,
                        i.documento,
                        i.id_grupo,
                        re.fecha_nacimiento,
                        TIMESTAMPDIFF(YEAR, re.fecha_nacimiento, CURDATE()) as edad,
                        cv.nombre_ciclo
                    FROM inscripciones i
                    LEFT JOIN users u ON i.documento = u.username OR i.documento = u.email
                    LEFT JOIN registro_estudiantes re ON u.id = re.user_id
                    LEFT JOIN patients p ON i.documento = p.numhs
                    LEFT JOIN ciclo_vital cv ON TIMESTAMPDIFF(YEAR, re.fecha_nacimiento, CURDATE()) BETWEEN cv.min_edad AND cv.max_edad
                    WHERE i.idcurso = ? AND i.state = '1'
                    ORDER BY nombres, apellidos";
            
            $stmtStud = $connect->prepare("
                    SELECT DISTINCT 
                        COALESCE(re.nombres, u.name, p.nompa) as nombres,
                        COALESCE(re.apellidos, '', p.apepa) as apellidos,
                        i.documento,
                        i.id_grupo,
                        re.fecha_nacimiento,
                        TIMESTAMPDIFF(YEAR, re.fecha_nacimiento, CURDATE()) as edad,
                        cv.nombre_ciclo,
                        vr.niveldesempeño AS nivel_desempeno
                    FROM inscripciones i
                    LEFT JOIN users u ON i.documento = u.username OR i.documento = u.email
                    LEFT JOIN registro_estudiantes re ON u.id = re.user_id
                    LEFT JOIN patients p ON i.documento = p.numhs
                    LEFT JOIN ciclo_vital cv ON TIMESTAMPDIFF(YEAR, re.fecha_nacimiento, CURDATE()) BETWEEN cv.min_edad AND cv.max_edad
                    LEFT JOIN valoracionriesgo vr 
                        ON re.id = vr.id_estudiante
                        AND vr.id_valoracion = (
                            SELECT vr2.id_valoracion 
                            FROM valoracionriesgo vr2 
                            WHERE vr2.id_estudiante = re.id 
                            ORDER BY vr2.fere DESC 
                            LIMIT 1
                        )
                    WHERE i.idcurso = ? AND i.state = '1'
                    ORDER BY nombres, apellidos");
            $stmtStud->execute([$id_curso]);
            $allStudents = $stmtStud->fetchAll(PDO::FETCH_ASSOC);

            // 3. Structure Data
            $sinGrupo = [];
            $gruposMap = [];

            // Initialize groups with empty student lists
            foreach($grupos as $g) {
                $g['estudiantes'] = [];
                $gruposMap[$g['id']] = $g;
            }

            foreach($allStudents as $est) {
                if(empty($est['id_grupo']) || !isset($gruposMap[$est['id_grupo']])) {
                    $sinGrupo[] = $est;
                } else {
                    $gruposMap[$est['id_grupo']]['estudiantes'][] = $est;
                }
            }

            echo json_encode(['success' => true, 'data' => [
                'grupos' => array_values($gruposMap),
                'sin_grupo' => $sinGrupo
            ]]);
            break;

        case 'assign_group':
            $documento = $_POST['documento'];
            $id_curso = $_POST['id_curso'];
            $id_grupo = $_POST['id_grupo']; // '0' or ID
            
            $grupoVal = ($id_grupo == '0' || $id_grupo == 0) ? NULL : $id_grupo;

            $stmt = $connect->prepare("UPDATE inscripciones SET id_grupo = ? WHERE documento = ? AND idcurso = ?");
            if($stmt->execute([$grupoVal, $documento, $id_curso])) {
                echo json_encode(['success' => true]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al asignar']);
            }
            break;

        // --- GRUPOS (Modify get_grupos if needed, but get_grupo_assignments replaces it for the view) ---
        case 'get_grupos':
             // Legacy or simple list
            $id_curso = $_POST['id_curso'];
            $stmt = $connect->prepare("SELECT * FROM cursos_grupos WHERE id_curso = ? ORDER BY nombre ASC");
            $stmt->execute([$id_curso]);
            echo json_encode(['success' => true, 'data' => $stmt->fetchAll(PDO::FETCH_ASSOC)]);
            break;

        case 'add_grupo':
            $id_curso = $_POST['id_curso'];
            $nombre = $_POST['nombre'];
            $horario = !empty($_POST['horario']) ? $_POST['horario'] : null;
            $cupos = !empty($_POST['cupos']) ? intval($_POST['cupos']) : 0;

            // Validate quota availability
            // 1. Get course total quota
            $stmtCurso = $connect->prepare("SELECT cupos FROM cursos WHERE idcurso = ?");
            $stmtCurso->execute([$id_curso]);
            $curso = $stmtCurso->fetch(PDO::FETCH_ASSOC);
            
            if($curso && $curso['cupos'] > 0) {
                // 2. Get sum of all existing groups' quotas
                $stmtGrupos = $connect->prepare("SELECT COALESCE(SUM(cupos), 0) as total_asignado FROM cursos_grupos WHERE id_curso = ?");
                $stmtGrupos->execute([$id_curso]);
                $totalAsignado = $stmtGrupos->fetch(PDO::FETCH_ASSOC)['total_asignado'];
                
                $disponible = $curso['cupos'] - $totalAsignado;
                
                // 3. Validate requested quota
                if($cupos > $disponible) {
                    echo json_encode([
                        'success' => false, 
                        'message' => "Solo hay $disponible cupos disponibles. Este curso tiene {$curso['cupos']} cupos totales y ya se asignaron $totalAsignado."
                    ]);
                    break;
                }
            }

            // Process dias_clase from checkboxes
            $dias_clase = null;
            if(isset($_POST['dias_grupo']) && is_array($_POST['dias_grupo'])) {
                $dias_clase = implode(', ', $_POST['dias_grupo']);
            }

            $stmt = $connect->prepare("INSERT INTO cursos_grupos (id_curso, nombre, horario, dias_clase, cupos) VALUES (?, ?, ?, ?, ?)");
            if ($stmt->execute([$id_curso, $nombre, $horario, $dias_clase, $cupos])) {
                 echo json_encode(['success' => true, 'message' => 'Grupo creado correctamente.']);
            } else {
                 echo json_encode(['success' => false, 'message' => 'Error al crear el grupo.']);
            }
            break;

        case 'delete_grupo':
            $id = $_POST['id'];
            $stmt = $connect->prepare("DELETE FROM cursos_grupos WHERE id = ?");
            if($stmt->execute([$id])) {
                echo json_encode(['success' => true, 'message' => 'Grupo eliminado.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al eliminar grupo.']);
            }
            break;

        // --- VIRTUAL AREA (ALL COURSES) ---
        // --- VIRTUAL AREA (ALL COURSES) ---
        case 'get_virtual_area_courses':
            // Check if user is student/ciudadano to filter courses
            if (isset($_SESSION['user_type']) && $_SESSION['user_type'] == 'ciudadano') {
                $cedula = $_SESSION['email']; // Corrected constant for citizen document
                
                $sql = "SELECT c.*, a.nombre as area_nombre, e.nombre as escuela_nombre, i.id_grupo as id_grupo_asignado
                        FROM cursos c 
                        INNER JOIN inscripciones i ON c.idcurso = i.idcurso
                        LEFT JOIN areas a ON c.id_area = a.id 
                        LEFT JOIN escuelas_formacion e ON a.id_escuela = e.id 
                        WHERE i.documento = ? AND i.state = '1'
                        ORDER BY c.idcurso DESC";
                $stmt = $connect->prepare($sql);
                $stmt->execute([$cedula]);
            } else {
                // Admin/Teacher see all
                $sql = "SELECT c.*, a.nombre as area_nombre, e.nombre as escuela_nombre, NULL as id_grupo_asignado
                        FROM cursos c 
                        LEFT JOIN areas a ON c.id_area = a.id 
                        LEFT JOIN escuelas_formacion e ON a.id_escuela = e.id 
                        ORDER BY c.idcurso DESC";
                $stmt = $connect->prepare($sql);
                $stmt->execute();
            }

            $courses = $stmt->fetchAll(PDO::FETCH_ASSOC);

            if (!empty($courses)) {
                $courseIds = array_unique(array_filter(array_column($courses, 'idcurso')));

                if (!empty($courseIds)) {
                    $placeholders = implode(',', array_fill(0, count($courseIds), '?'));
                    $stmtGroups = $connect->prepare("
                        SELECT id, id_curso, nombre, horario, cupos, dias_clase 
                        FROM cursos_grupos 
                        WHERE id_curso IN ($placeholders)
                        ORDER BY nombre ASC
                    ");
                    $stmtGroups->execute($courseIds);

                    $groupsByCourse = [];
                    while ($group = $stmtGroups->fetch(PDO::FETCH_ASSOC)) {
                        $groupsByCourse[$group['id_curso']][] = $group;
                    }

                    foreach ($courses as &$course) {
                        $courseId = $course['idcurso'];
                        $course['grupos'] = $groupsByCourse[$courseId] ?? [];

                        $assignedGroup = null;
                        $assignedGroupId = $course['id_grupo_asignado'] ?? null;
                        if ($assignedGroupId) {
                            foreach ($course['grupos'] as $group) {
                                if ((string)$group['id'] === (string)$assignedGroupId) {
                                    $assignedGroup = $group;
                                    break;
                                }
                            }
                        }

                        $course['mi_grupo'] = $assignedGroup;
                    }
                    unset($course);
                } else {
                    foreach ($courses as &$course) {
                        $course['grupos'] = [];
                        $course['mi_grupo'] = null;
                    }
                    unset($course);
                }
            }

            echo json_encode(['success' => true, 'data' => $courses]);
            break;

        // --- PROFESIONALES ---
        case 'get_profesionales':
            $stmt = $connect->query("SELECT idodc, nodoc, apdoc FROM doctor ORDER BY nodoc ASC");
            echo json_encode(['success' => true, 'data' => $stmt->fetchAll(PDO::FETCH_ASSOC)]);
            break;

        // --- ENROLLMENT (INSCRIPCIÓN) ---
        case 'search_user':
            $documento = $_POST['documento'];
            
            // 1. Search in 'registro_estudiantes' (NEW PRIORITY)
            $stmt = $connect->prepare("SELECT nombres as nombre, apellidos as apellido, numero_documento as documento FROM registro_estudiantes WHERE numero_documento = ? LIMIT 1");
            $stmt->execute([$documento]);
            if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                // Fetch enrollments
                $stmtEnroll = $connect->prepare("SELECT c.nombre, c.codigo FROM inscripciones i JOIN cursos c ON i.idcurso = c.idcurso WHERE i.documento = ? AND i.state = '1'");
                $stmtEnroll->execute([$row['documento']]);
                $row['cursos_inscritos'] = $stmtEnroll->fetchAll(PDO::FETCH_ASSOC);

                echo json_encode(['success' => true, 'data' => $row]);
                exit;
            }

            // 2. Search in 'users' table
            $stmt = $connect->prepare("SELECT name as nombre, '' as apellido, username as documento FROM users WHERE username = ? LIMIT 1");
            $stmt->execute([$documento]);
            if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                // Fetch enrollments
                $stmtEnroll = $connect->prepare("SELECT c.nombre, c.codigo FROM inscripciones i JOIN cursos c ON i.idcurso = c.idcurso WHERE i.documento = ? AND i.state = '1'");
                $stmtEnroll->execute([$row['documento']]);
                $row['cursos_inscritos'] = $stmtEnroll->fetchAll(PDO::FETCH_ASSOC);

                echo json_encode(['success' => true, 'data' => $row]);
                exit; // Stop if found
            }
            
            // 2. Search in 'patients' table (Legacy/Citizen)
            $stmt = $connect->prepare("SELECT nompa as nombre, apepa as apellido, numhs as documento FROM patients WHERE numhs = ? LIMIT 1");
            $stmt->execute([$documento]);
            if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                // Fetch enrollments for this found user (regardless of which table they came from, we use the document)
                $stmtEnroll = $connect->prepare("
                    SELECT c.nombre, c.codigo 
                    FROM inscripciones i 
                    JOIN cursos c ON i.idcurso = c.idcurso 
                    WHERE i.documento = ? AND i.state = '1'
                ");
                $stmtEnroll->execute([$row['documento']]); // Use the found document to be sure
                $row['cursos_inscritos'] = $stmtEnroll->fetchAll(PDO::FETCH_ASSOC);

                echo json_encode(['success' => true, 'data' => $row]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Usuario no encontrado en Registros ni Pacientes']);
            }
            break;

        case 'enroll_student':
            $documento = $_POST['documento'];
            $idcurso = $_POST['idcurso'];
            
            // Check if already enrolled
            $stmt = $connect->prepare("SELECT idins FROM inscripciones WHERE documento = ? AND idcurso = ?");
            $stmt->execute([$documento, $idcurso]);
            if ($stmt->rowCount() > 0) {
                echo json_encode(['success' => false, 'message' => 'El usuario ya está inscrito en este curso.']);
                exit;
            }

            // Check max enrollments (Limit: 3)
            $stmt = $connect->prepare("SELECT COUNT(*) FROM inscripciones WHERE documento = ? AND state = '1'");
            $stmt->execute([$documento]);
            $currentEnrollments = $stmt->fetchColumn();

            if ($currentEnrollments >= 3) {
                echo json_encode(['success' => false, 'message' => 'El usuario ha alcanzado el límite máximo de 3 cursos inscritos.']);
                exit;
            }

            $stmt = $connect->prepare("INSERT INTO inscripciones (documento, idcurso, state) VALUES (?, ?, '1')");
            if ($stmt->execute([$documento, $idcurso])) {
                echo json_encode(['success' => true, 'message' => 'Inscripción realizada con éxito.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al inscribir.']);
            }
            break;

        case 'get_course':
            $id = $_POST['id'];
            $stmt = $connect->prepare("SELECT * FROM cursos WHERE idcurso = ?");
            $stmt->execute([$id]);
            $course = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($course) {
                echo json_encode(['success' => true, 'data' => $course]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Curso no encontrado']);
            }
            break;



        // --- MODULE MANAGEMENT ---
        case 'get_course_modules':
            $id_curso = $_POST['id_curso'];
            $stmt = $connect->prepare("SELECT * FROM curso_modulos WHERE id_curso = ? ORDER BY orden ASC, id ASC");
            $stmt->execute([$id_curso]);
            echo json_encode(['success' => true, 'data' => $stmt->fetchAll(PDO::FETCH_ASSOC)]);
            break;

        case 'add_course_module':
            $id_curso = $_POST['id_curso'];
            $titulo = $_POST['titulo'];
            
            $stmt = $connect->prepare("INSERT INTO curso_modulos (id_curso, titulo) VALUES (?, ?)");
            if ($stmt->execute([$id_curso, $titulo])) {
                echo json_encode(['success' => true, 'message' => 'Módulo creado.', 'id' => $connect->lastInsertId()]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al crear módulo.']);
            }
            break;



        // --- CONTENT MANAGEMENT (Multiple Items) ---
        case 'get_module_content':
            $id_modulo = $_POST['id_modulo'];
            $id_estudiante = getStudentId($connect);

            // Left Join to get submission status for this student
            $sql = "SELECT c.*, e.archivo as archivo_entrega, e.fecha_entrega, e.calificacion, e.comentario as feedback
                    FROM curso_contenido c 
                    LEFT JOIN curso_entregas e ON c.id = e.id_contenido AND e.id_estudiante = ?
                    WHERE c.id_modulo = ? 
                    ORDER BY c.id ASC";
            
            $stmt = $connect->prepare($sql);
            $stmt->execute([$id_estudiante, $id_modulo]);
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            echo json_encode(['success' => true, 'data' => $rows]);
            break;

        case 'add_content_item':
            $id_curso = $_POST['id_curso'];
            $id_modulo = $_POST['id_modulo'];
            $titulo = $_POST['titulo'];
            $tipo = $_POST['tipo'] ?? 'recurso'; // Default to resource
            $fecha_limite = !empty($_POST['fecha_limite']) ? $_POST['fecha_limite'] : null;

            $stmt = $connect->prepare("INSERT INTO curso_contenido (id_curso, id_modulo, titulo, tipo, fecha_limite, contenido) VALUES (?, ?, ?, ?, ?, '')");
            try {
                if ($stmt->execute([$id_curso, $id_modulo, $titulo, $tipo, $fecha_limite])) {
                    echo json_encode(['success' => true, 'message' => 'Contenido agregado.', 'id' => $connect->lastInsertId()]);
                } else {
                    $error = $stmt->errorInfo();
                    echo json_encode(['success' => false, 'message' => 'Error SQL: ' . $error[2]]);
                }
            } catch (PDOException $e) {
                echo json_encode(['success' => false, 'message' => 'Excepción: ' . $e->getMessage()]);
            }
            break;

        case 'save_content_item':
            $id_item = $_POST['id_item'];
            $contenido = $_POST['contenido'];
            // Optionally update title too if passed
            
            $stmt = $connect->prepare("UPDATE curso_contenido SET contenido = ? WHERE id = ?");
            if ($stmt->execute([$contenido, $id_item])) {
                echo json_encode(['success' => true, 'message' => 'Guardado correctamente.']);
            } else {
                 $error = $stmt->errorInfo();
                echo json_encode(['success' => false, 'message' => 'Error SQL: ' . $error[2]]);
            }
            break;

        case 'delete_content_item':
            $id_item = $_POST['id_item'];
            
            $stmt = $connect->prepare("DELETE FROM curso_contenido WHERE id = ?");
            if ($stmt->execute([$id_item])) {
                echo json_encode(['success' => true, 'message' => 'Eliminado correctamente.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al eliminar.']);
            }
            break;

        case 'upload_submission':
            $id_contenido = $_POST['id_contenido'];
            $id_estudiante = getStudentId($connect);
            
            if ($id_estudiante == 0) {
                // If ID is 0, maybe try to insert/find user? Or fail?
                // Let's fail for now to debug.
                echo json_encode(['success' => false, 'message' => 'Error: Usuario no identificado. ID=0']);
                exit;
            }

            if (!isset($_FILES['archivo']) || $_FILES['archivo']['error'] != UPLOAD_ERR_OK) {
                echo json_encode(['success' => false, 'message' => 'No se ha seleccionado ningún archivo o hubo un error.']);
                exit;
            }

            $uploadDir = '../../backend/uploads/tareas/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }

            $extension = pathinfo($_FILES['archivo']['name'], PATHINFO_EXTENSION);
            $fileName = 'entrega_' . $id_contenido . '_' . $id_estudiante . '_' . time() . '.' . $extension;
            $targetPath = $uploadDir . $fileName;

            if (move_uploaded_file($_FILES['archivo']['tmp_name'], $targetPath)) {
                $stmt = $connect->prepare("INSERT INTO curso_entregas (id_contenido, id_estudiante, archivo) VALUES (?, ?, ?)");
                if ($stmt->execute([$id_contenido, $id_estudiante, $fileName])) {
                    echo json_encode(['success' => true, 'message' => 'Tarea enviada correctamente.']);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Error al guardar en base de datos.']);
                }
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al mover el archivo al servidor.']);
            }
            break;

        // --- FORUM MANAGEMENT ---
        case 'get_forum_comments':
            $id_contenido = $_POST['id_contenido'];
            
            // Join with users table and registro_estudiantes for better names
            $sql = "SELECT f.*, 
                           COALESCE(re.nombres, u.name, 'Usuario') as nombres,
                           COALESCE(re.apellidos, '') as apellidos
                    FROM curso_foros f
                    LEFT JOIN users u ON f.id_usuario = u.id
                    LEFT JOIN registro_estudiantes re ON u.id = re.user_id
                    WHERE f.id_contenido = ? 
                    ORDER BY f.created_at ASC";
            
            $stmt = $connect->prepare($sql);
            $stmt->execute([$id_contenido]);
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            // Format dates
            foreach($rows as &$row) {
                $row['fecha_format'] = date('d M Y, h:i A', strtotime($row['created_at']));
            }
            
            echo json_encode(['success' => true, 'data' => $rows]);
            break;

        case 'add_forum_comment':
            $id_contenido = $_POST['id_contenido'];
            $comentario = $_POST['comentario'];
            $id_usuario = getStudentId($connect);

            if ($id_usuario == 0) {
                 echo json_encode(['success' => false, 'message' => 'Error: Usuario no identificado.']);
                 exit;
            }

            $stmt = $connect->prepare("INSERT INTO curso_foros (id_contenido, id_usuario, comentario) VALUES (?, ?, ?)");
            if ($stmt->execute([$id_contenido, $id_usuario, $comentario])) {
                echo json_encode(['success' => true, 'message' => 'Comentario agregado.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al agregar comentario.']);
            }
            break;

        // --- SUBMISSION MANAGEMENT (ADMIN) ---
        case 'get_task_submissions':
            $id_contenido = $_POST['id_contenido'];
            
            $sql = "SELECT e.*, 
                           COALESCE(re.nombres, u.name, 'Usuario') as nombres,
                           COALESCE(re.apellidos, '') as apellidos,
                           u.email as documento
                    FROM curso_entregas e
                    LEFT JOIN users u ON e.id_estudiante = u.id
                    LEFT JOIN registro_estudiantes re ON u.id = re.user_id
                    WHERE e.id_contenido = ? 
                    ORDER BY e.fecha_entrega DESC";
            
            $stmt = $connect->prepare($sql);
            $stmt->execute([$id_contenido]);
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

            // Format dates
            foreach($rows as &$row) {
                $row['fecha_format'] = date('d M Y, h:i A', strtotime($row['fecha_entrega']));
            }
            
            echo json_encode(['success' => true, 'data' => $rows]);
            break;

        // --- GROUP MANAGEMENT (Drag & Drop) ---
        case 'get_grupo_assignments':
            $id_curso = $_POST['id_curso'];
            
            // 1. Get Groups
            $stmt = $connect->prepare("SELECT * FROM cursos_grupos WHERE id_curso = ? ORDER BY nombre ASC");
            $stmt->execute([$id_curso]);
            $grupos = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            // Programs groups array
            $gruposMap = [];
            foreach($grupos as &$g) {
                $g['estudiantes'] = [];
                $gruposMap[$g['id']] = &$g;
            }
            
            // 2. Get Students
            $sql = "SELECT i.documento, i.id_grupo,
                           COALESCE(re.nombres, u.name, p.nompa) as nombres,
                           COALESCE(re.apellidos, '', p.apepa) as apellidos,
                           TIMESTAMPDIFF(YEAR, re.fecha_nacimiento, CURDATE()) as edad,
                           cv.nombre_ciclo,
                           vr.enfermedadd
                    FROM inscripciones i
                    LEFT JOIN users u ON i.documento = u.username OR i.documento = u.email
                    LEFT JOIN registro_estudiantes re ON u.id = re.user_id
                    LEFT JOIN patients p ON i.documento = p.numhs
                    LEFT JOIN valoracionriesgo vr ON re.id = vr.id_estudiante
                    LEFT JOIN ciclo_vital cv ON TIMESTAMPDIFF(YEAR, re.fecha_nacimiento, CURDATE()) BETWEEN cv.min_edad AND cv.max_edad
                    WHERE i.idcurso = ? AND i.state = '1'
                    ORDER BY nombres ASC";
            
            $stmt = $connect->prepare($sql);
            $stmt->execute([$id_curso]);
            $students = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            $sin_grupo = [];
            
            foreach($students as $est) {
                $gid = $est['id_grupo'];
                if($gid && isset($gruposMap[$gid])) {
                    $gruposMap[$gid]['estudiantes'][] = $est;
                } else {
                    $sin_grupo[] = $est;
                }
            }
            
            echo json_encode(['success' => true, 'data' => [
                'grupos' => array_values($gruposMap), // Re-index array
                'sin_grupo' => $sin_grupo
            ]]);
            break;

        case 'assign_group':
            $documento = $_POST['documento'];
            $id_curso = $_POST['id_curso'];
            $id_grupo = $_POST['id_grupo']; // 0 or ID
            
            $val = ($id_grupo == '0' || $id_grupo === 'null') ? NULL : $id_grupo;
            
            // Validate group capacity if assigning to a group (not removing from group)
            if($val !== NULL) {
                // 1. Get group capacity
                $stmtGrupo = $connect->prepare("SELECT cupos FROM cursos_grupos WHERE id = ?");
                $stmtGrupo->execute([$val]);
                $grupo = $stmtGrupo->fetch(PDO::FETCH_ASSOC);
                
                if($grupo && $grupo['cupos'] > 0) {
                    // 2. Count current students in this group
                    $stmtCount = $connect->prepare("SELECT COUNT(*) as total FROM inscripciones WHERE id_grupo = ? AND idcurso = ? AND state = '1'");
                    $stmtCount->execute([$val, $id_curso]);
                    $currentCount = $stmtCount->fetch(PDO::FETCH_ASSOC)['total'];
                    
                    // 3. Check if group is full
                    if($currentCount >= $grupo['cupos']) {
                        echo json_encode([
                            'success' => false, 
                            'message' => "Este grupo ya está lleno. Capacidad: {$grupo['cupos']}, Estudiantes actuales: {$currentCount}"
                        ]);
                        break;
                    }
                }
            }
            
            $stmt = $connect->prepare("UPDATE inscripciones SET id_grupo = ? WHERE documento = ? AND idcurso = ?");
            if($stmt->execute([$val, $documento, $id_curso])) {
                echo json_encode(['success' => true, 'message' => 'Actualizado']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error BD']);
            }
            break;

        // --- ENROLLMENT REPORT ---
        case 'get_inscritos':
            $tipo = $_POST['tipo']; // 'escuela', 'area', or 'curso'
            $id = $_POST['id'];
            
            $estudiantes = [];
            
            if ($tipo === 'curso') {
                // Get students enrolled in a specific course
                $sql = "SELECT DISTINCT 
                            COALESCE(re.nombres, u.name, p.nompa) as nombres,
                            COALESCE(re.apellidos, '', p.apepa) as apellidos,
                            i.documento,
                            c.nombre as curso_nombre,
                            cg.nombre as nombre_grupo,
                            re.fecha_nacimiento,
                            TIMESTAMPDIFF(YEAR, re.fecha_nacimiento, CURDATE()) as edad,
                            cv.nombre_ciclo,
                            vr.niveldesempeño
                        FROM inscripciones i
                        LEFT JOIN cursos c ON i.idcurso = c.idcurso
                        LEFT JOIN cursos_grupos cg ON i.id_grupo = cg.id
                        LEFT JOIN users u ON i.documento = u.username OR i.documento = u.email
                        LEFT JOIN registro_estudiantes re ON u.id = re.user_id
                        LEFT JOIN patients p ON i.documento = p.numhs
                        LEFT JOIN valoracionriesgo vr ON re.id = vr.id_estudiante
                        LEFT JOIN ciclo_vital cv ON TIMESTAMPDIFF(YEAR, re.fecha_nacimiento, CURDATE()) BETWEEN cv.min_edad AND cv.max_edad
                        WHERE i.idcurso = ? AND i.state = '1'
                        ORDER BY nombres, apellidos";
                $stmt = $connect->prepare($sql);
                $stmt->execute([$id]);
                
            } else if ($tipo === 'area') {
                // Get students enrolled in any course within an area
                $sql = "SELECT DISTINCT 
                            COALESCE(re.nombres, u.name, p.nompa) as nombres,
                            COALESCE(re.apellidos, '', p.apepa) as apellidos,
                            i.documento,
                            c.nombre as curso_nombre,
                            re.fecha_nacimiento,
                            TIMESTAMPDIFF(YEAR, re.fecha_nacimiento, CURDATE()) as edad,
                            cv.nombre_ciclo,
                            vr.niveldesempeño
                        FROM inscripciones i
                        LEFT JOIN cursos c ON i.idcurso = c.idcurso
                        LEFT JOIN users u ON i.documento = u.username OR i.documento = u.email
                        LEFT JOIN registro_estudiantes re ON u.id = re.user_id
                        LEFT JOIN patients p ON i.documento = p.numhs
                        LEFT JOIN valoracionriesgo vr ON re.id = vr.id_estudiante
                        LEFT JOIN ciclo_vital cv ON TIMESTAMPDIFF(YEAR, re.fecha_nacimiento, CURDATE()) BETWEEN cv.min_edad AND cv.max_edad
                        WHERE c.id_area = ? AND i.state = '1'
                        ORDER BY nombres, apellidos";
                $stmt = $connect->prepare($sql);
                $stmt->execute([$id]);
                
            } else if ($tipo === 'escuela') {
                // Get students enrolled in any course within a school
                $sql = "SELECT DISTINCT 
                            COALESCE(re.nombres, u.name, p.nompa) as nombres,
                            COALESCE(re.apellidos, '', p.apepa) as apellidos,
                            i.documento,
                            c.nombre as curso_nombre,
                            re.fecha_nacimiento,
                            TIMESTAMPDIFF(YEAR, re.fecha_nacimiento, CURDATE()) as edad,
                            cv.nombre_ciclo,
                            vr.niveldesempeño
                        FROM inscripciones i
                        LEFT JOIN cursos c ON i.idcurso = c.idcurso
                        LEFT JOIN areas a ON c.id_area = a.id
                        LEFT JOIN users u ON i.documento = u.username OR i.documento = u.email
                        LEFT JOIN registro_estudiantes re ON u.id = re.user_id
                        LEFT JOIN patients p ON i.documento = p.numhs
                        LEFT JOIN valoracionriesgo vr ON re.id = vr.id_estudiante
                        LEFT JOIN ciclo_vital cv ON TIMESTAMPDIFF(YEAR, re.fecha_nacimiento, CURDATE()) BETWEEN cv.min_edad AND cv.max_edad
                        WHERE a.id_escuela = ? AND i.state = '1'
                        ORDER BY nombres, apellidos";
                $stmt = $connect->prepare($sql);
                $stmt->execute([$id]);
            }
            
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            // Format data
            foreach ($rows as $row) {
                $nombreCompleto = trim($row['nombres'] . ' ' . $row['apellidos']);
                $estudiantes[] = [
                    'nombre' => $nombreCompleto,
                    'documento' => $row['documento'],
                    'curso_nombre' => $tipo !== 'curso' ? $row['curso_nombre'] : null,
                    'nombre_grupo' => $row['nombre_grupo'] ?? 'Sin Asignar',
                    'ciclo_vital' => $row['nombre_ciclo'] ?? 'N/A',
                    'edad' => $row['edad'] ?? null,
                    'nivel_desempeno' => $row['niveldesempeño'] ?? 'N/A'
                ];
            }
            
            echo json_encode([
                'success' => true, 
                'data' => [
                    'total' => count($estudiantes),
                    'estudiantes' => $estudiantes
                ]
            ]);
            break;

        default:
            echo json_encode(['success' => false, 'message' => 'Acción no válida.']);
            break;
    }
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Error de base de datos: ' . $e->getMessage()]);
}
?>
