<?php
session_start();
if (!isset($_SESSION['user_type'])) {
    header("Location: ../../index.php");
    exit();
}
// Only enforce strict admin check if NOT citizen
if ($_SESSION['user_type'] != 'ciudadano') {
    require '../../backend/php/check_access.php';
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=8.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <title>EFAC | Área Virtual</title>
    <style>
        /* Specific Styles for Area Virtual Grid */
        .courses-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(380px, 1fr));
            gap: 25px;
            margin-top: 30px;
        }

        .course-card {
            background: var(--bg-card);
            border-radius: 16px;
            padding: 25px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.2);
            border: 1px solid rgba(255,255,255,0.05);
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .course-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 35px rgba(0,0,0,0.4);
            border-color: rgba(255,255,255,0.1);
        }

        /* Decoration Strip */
        .course-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 4px;
            height: 100%;
            background: var(--btn-gradient);
            opacity: 0.7;
        }

        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 20px;
        }

        .course-info h3 {
            font-size: 1.2rem;
            color: var(--text-light);
            font-weight: 700;
            margin-bottom: 5px;
            line-height: 1.3;
        }

        .course-code {
            font-size: 0.9rem;
            color: var(--text-grey);
            font-family: monospace;
            background: rgba(255,255,255,0.05);
            padding: 2px 6px;
            border-radius: 4px;
        }

        .card-actions {
            display: flex;
            flex-direction: column;
            gap: 8px;
        }

        .action-btn {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 16px;
            border-radius: 8px;
            font-size: 0.85rem;
            font-weight: 600;
            cursor: pointer;
            text-decoration: none;
            transition: all 0.2s;
            border: 1px solid transparent;
        }

        .btn-participants {
            background: rgba(102, 126, 234, 0.15); /* Tint Blue */
            color: #a29bfe;
        }
        .btn-participants:hover { background: rgba(102, 126, 234, 0.25); }

        .btn-grades {
            background: rgba(0, 184, 148, 0.15); /* Tint Green */
            color: #00b894;
        }
        .btn-grades:hover { background: rgba(0, 184, 148, 0.25); }

        .pending-activities {
            background: rgba(255,255,255,0.03);
            border-radius: 8px;
            padding: 10px 15px;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            color: var(--text-light);
            font-size: 0.9rem;
            font-weight: 600;
            border: 1px solid rgba(255,255,255,0.05);
            margin-bottom: 20px;
        }

        .pending-activities i {
            font-size: 1.2rem;
            color: var(--text-muted);
        }

        .teacher-info {
            margin-bottom: 20px;
        }

        .teacher-label {
            font-size: 0.8rem;
            color: var(--text-grey);
            font-weight: 600;
            margin-bottom: 2px;
        }

        .teacher-name {
            font-size: 0.95rem;
            color: var(--text-light);
            font-weight: 500;
            text-transform: uppercase;
        }

        .teacher-email {
            font-size: 0.85rem;
            color: var(--text-muted);
            display: flex;
            align-items: center;
            gap: 5px;
            margin-top: 2px;
        }

        .progress-section {
            margin-top: auto;
        }

        .progress-label {
            display: flex;
            justify-content: flex-end;
            font-size: 0.85rem;
            color: var(--text-grey);
            margin-bottom: 5px;
        }

        .progress-bar {
            width: 100%;
            height: 8px;
            background: rgba(255,255,255,0.05);
            border-radius: 4px;
            overflow: hidden;
            position: relative;
        }

        .progress-fill {
            height: 100%;
            background: var(--btn-gradient);
            border-radius: 4px;
            width: 0%; /* Animate width */
            transition: width 1s ease-out;
        }

        .group-section {
            margin: 20px 0;
            padding: 15px;
            border-radius: 12px;
            background: rgba(255,255,255,0.03);
            border: 1px solid rgba(255,255,255,0.05);
        }

        .group-section h4 {
            margin: 0 0 10px;
            font-size: 0.95rem;
            color: var(--text-light);
            text-transform: uppercase;
            letter-spacing: 0.03em;
        }

        .group-assigned {
            padding: 10px 12px;
            border-radius: 10px;
            font-size: 0.9rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 12px;
            background: rgba(76, 175, 80, 0.12);
            color: #8bc34a;
            border: 1px solid rgba(139,195,74,0.4);
        }

        .group-assigned.empty {
            background: rgba(244, 180, 0, 0.12);
            color: #ffca28;
            border-color: rgba(255,202,40,0.4);
        }

        .group-chip-container {
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
        }

        .group-chip {
            padding: 6px 12px;
            border-radius: 999px;
            font-size: 0.85rem;
            color: var(--text-grey);
            background: rgba(255,255,255,0.05);
            border: 1px solid rgba(255,255,255,0.08);
            display: inline-flex;
            align-items: center;
            gap: 6px;
        }

        .group-chip small {
            font-size: 0.75rem;
            color: var(--text-muted);
        }

        .group-chip.active {
            background: rgba(76, 175, 80, 0.18);
            color: #a5d6a7;
            border-color: rgba(165,214,167,0.4);
        }

        .group-chip.muted {
            color: var(--text-muted);
            border-style: dashed;
        }

        /* Loading State */
        .loading-grid {
            text-align: center;
            color: var(--text-grey);
            padding: 40px;
            grid-column: 1 / -1;
        }
    </style>
</head>
<body>

    <!-- SIDEBAR -->
    <?php if($_SESSION['user_type'] != 'ciudadano') include '../../backend/php/sidebar_menu.php'; ?>
    <!-- SIDEBAR -->

    <section id="content" style="<?php echo ($_SESSION['user_type'] == 'ciudadano') ? 'left: 0; width: 100%;' : ''; ?>">
        <!-- NAVBAR -->
        <nav>
            <?php if($_SESSION['user_type'] == 'ciudadano'): ?>
                <a href="../ciudadano/dashboard.php" style="font-size: 24px; color: var(--dark); margin-right: 15px;"><i class='bx bx-arrow-back'></i></a>
            <?php else: ?>
                <i class='bx bx-menu toggle-sidebar' ></i>
            <?php endif; ?>

            <form action="#">
                <div class="form-group-search">
                    <input type="text" placeholder="Buscar curso...">
                    <i class='bx bx-search icon' ></i>
                </div>
            </form>
            <span class="divider"></span>
            <div class="profile">
                <img src="<?php echo isset($_SESSION['foto']) && !empty($_SESSION['foto']) ? '../../backend/uploads/fotos/'.$_SESSION['foto'] : '../../backend/img/user-default.png'; ?>" alt="">
                <ul class="profile-link">
                    <li><a href="<?php echo ($_SESSION['user_type'] == 'ciudadano') ? '../ciudadano/mi_informacion.php' : '../profile/mostrar.php'; ?>"><i class='bx bxs-user-circle icon' ></i> Perfil</a></li>
                    <li><a href="../salir.php"><i class='bx bxs-log-out-circle' ></i> Salir</a></li>
                </ul>
            </div>
        </nav>
        <!-- NAVBAR -->

        <main>
            <div class="head-title" style="display: flex; justify-content: space-between; align-items: center;">
                <div class="left">
                    <h1 class="title">Área Virtual</h1>
                    <ul class="breadcrumbs">
                        <?php if($_SESSION['user_type'] == 'ciudadano'): ?>
                            <li><a href="../ciudadano/dashboard.php">Inicio</a></li>
                            <li class="divider">></li>
                            <li><a href="#" class="active">Área Virtual</a></li>
                        <?php else: ?>
                            <li><a href="../admin/escritorio.php">Home</a></li>
                            <li class="divider">></li>
                            <li><a href="registro_esc_formacion.php">Escuelas</a></li>
                            <li class="divider">></li>
                            <li><a href="#" class="active">Área Virtual</a></li>
                        <?php endif; ?>
                    </ul>
                </div>
                <!-- Optional: Add New Course Button if needed here too -->
            </div>

            <?php if (isset($_SESSION['virtual_error'])): ?>
                <div style="margin-bottom:20px; padding:15px; border-radius:10px; border:1px solid rgba(255,0,0,0.3); background:rgba(220,53,69,0.1); color:#ff7675;">
                    <strong><i class='bx bx-error-circle'></i> Aviso:</strong>
                    <span><?php echo htmlspecialchars($_SESSION['virtual_error']); ?></span>
                </div>
                <?php unset($_SESSION['virtual_error']); ?>
            <?php endif; ?>

            <div class="courses-grid" id="coursesGrid">
                <div class="loading-grid">
                    <i class='bx bx-loader-alt bx-spin' style="font-size: 2rem;"></i>
                    <p>Cargando cursos...</p>
                </div>
            </div>

        </main>
    </section>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="../../backend/js/script.js"></script>
    <script>
        $(document).ready(function() {
            loadVirtualAreaCourses();
        });

        function loadVirtualAreaCourses() {
            $.post('ajax_registro.php', { action: 'get_virtual_area_courses' }, function(response) {
                if (response.success) {
                    const grid = $('#coursesGrid');
                    grid.empty();

                    if (response.data.length === 0) {
                        grid.append('<div class="loading-grid"><p>No hay cursos disponibles actualmente.</p></div>');
                        return;
                    }

                    response.data.forEach(course => {
                        // Mock Data Generation for Visual Completeness
                        const activitiesCount = Math.floor(Math.random() * 8) + 1; // 1-9 activities
                        const progress = Math.floor(Math.random() * 80) + 10; // 10-90%
                        const email = course.quien_lo_da.toLowerCase().replace(/ /g, '.') + '@efac.edu.co';
                        const grupos = Array.isArray(course.grupos) ? course.grupos : [];
                        const assignedGroup = course.mi_grupo || null;
                        const isCitizenship = "<?php echo $_SESSION['user_type'] ?? ''; ?>" === 'ciudadano';

                        const assignedHtml = assignedGroup
                            ? `<div class="group-assigned">
                                    <span><i class='bx bxs-flag-checkered'></i> Tu grupo: <strong>${assignedGroup.nombre}</strong></span>
                                    <small>${assignedGroup.horario || 'Horario sin definir'}</small>
                                </div>`
                            : `<div class="group-assigned empty">
                                    <span><i class='bx bx-time-five'></i> Aún no tienes un grupo asignado</span>
                                    <small>Consulta con tu docente</small>
                                </div>`;

                        const chipsHtml = grupos.length
                            ? grupos.map(g => `
                                <span class="group-chip ${assignedGroup && String(assignedGroup.id) === String(g.id) ? 'active' : ''}">
                                    ${g.nombre}
                                    ${g.horario ? `<small>${g.horario}</small>` : ''}
                                </span>
                              `).join('')
                            : `<span class="group-chip muted">No hay grupos registrados</span>`;

                        const groupSection = `
                            <div class="group-section">
                                <h4>Grupos del curso</h4>
                                ${assignedHtml}
                                <div class="group-chip-container">
                                    ${chipsHtml}
                                </div>
                            </div>
                        `;
                        
                        const card = `
                            <div class="course-card" onclick="handleCourseClick(${course.idcurso}, ${assignedGroup ? 'true' : 'false'}, ${isCitizenship ? 'true' : 'false'})" style="cursor:pointer;">
                                <div class="card-header">
                                    <div class="course-info">
                                        <h3>${course.nombre}</h3>
                                        <span class="course-code">${course.codigo || 'S/C'}</span>
                                    </div>
                                    <div class="card-actions">
                                        <button class="action-btn btn-participants" onclick="goToSpecificTab(${course.idcurso}, 'participantes', event)">
                                            <i class='bx bxs-group'></i> Participantes
                                        </button>
                                        <button class="action-btn btn-grades" onclick="goToSpecificTab(${course.idcurso}, 'calificaciones', event)">
                                            <i class='bx bxs-book-bookmark'></i> Calificaciones
                                        </button>
                                    </div>
                                </div>

                                <div class="pending-activities">
                                    <i class='bx bxs-folder-open'></i>
                                    <span>${activitiesCount} Actividades Pendientes</span>
                                </div>

                                <div class="teacher-info">
                                    <div class="teacher-label">Docente:</div>
                                    <div class="teacher-name">${course.quien_lo_da}</div>
                                    <div class="teacher-email">
                                        <i class='bx bx-envelope'></i> ${email}
                                    </div>
                                </div>

                                ${groupSection}

                                <div class="progress-section">
                                    <div class="progress-label">${progress}% Completado</div>
                                    <div class="progress-bar">
                                        <div class="progress-fill" style="width: ${progress}%"></div>
                                    </div>
                                </div>
                            </div>
                        `;
                        grid.append(card);
                    });
                }
            }, 'json').fail(function() {
                $('#coursesGrid').html('<div class="loading-grid"><p style="color:var(--danger-color)">Error al cargar cursos.</p></div>');
            });
        }

        function handleCourseClick(courseId, hasGroup, isCitizen) {
            if (isCitizen) {
                // Redirect to read-only view for citizens
                window.location.href = `../ciudadano/ver_curso.php?id=${courseId}`;
                return;
            }
            // Admins/Teachers go to full detail view
            window.location.href = `detalle_curso.php?id=${courseId}`;
        }

        function goToSpecificTab(courseId, tab, event) {
            event.stopPropagation();
            window.location.href = `detalle_curso.php?id=${courseId}&tab=${tab}`;
        }
    </script>
</body>
</html>
