<?php
header('Content-Type: text/plain');
require '../../backend/bd/Conexion.php';

try {
    echo "=== DATA AUDIT ===\n";
    
    // 1. List Courses with Enrollment Counts
    echo "\n[Course Enrollments]\n";
    $sql = "SELECT c.idcurso, c.nombre, COUNT(i.id) as total_inscritos 
            FROM cursos c 
            LEFT JOIN inscripciones i ON c.idcurso = i.idcurso AND i.state = '1'
            GROUP BY c.idcurso, c.nombre
            HAVING total_inscritos > 0
            LIMIT 10";
    $stmt = $connect->query($sql);
    $courses = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (empty($courses)) {
        echo "NO enrollments found in any course.\n";
    } else {
        foreach($courses as $row) {
            echo "ID: " . $row['idcurso'] . " | " . $row['nombre'] . " | Count: " . $row['total_inscritos'] . "\n";
            
            // Sample Students for this course
            echo "  -> Samples:\n";
            $sub = $connect->prepare("SELECT documento, id_grupo FROM inscripciones WHERE idcurso = ? AND state='1' LIMIT 3");
            $sub->execute([$row['idcurso']]);
            $samps = $sub->fetchAll(PDO::FETCH_ASSOC);
            foreach($samps as $s) {
                echo "     Doc: " . $s['documento'] . " | Grp: " . ($s['id_grupo'] ?? 'NULL') . "\n";
                
                // Check User/Patient Match
                $u = $connect->prepare("SELECT id, name FROM users WHERE username = ? OR email = ?");
                $u->execute([$s['documento'], $s['documento']]);
                $user = $u->fetch();
                
                $p = $connect->prepare("SELECT idpa, nompa FROM patients WHERE numhs = ?");
                $p->execute([$s['documento']]);
                $patient = $p->fetch();
                
                echo "     Match User: " . ($user ? "YES (".$user['name'].")" : "NO");
                echo " | Match Pat: " . ($patient ? "YES (".$patient['nompa'].")" : "NO") . "\n";
            }
        }
    }

} catch(Exception $e) {
    echo "ERROR: " . $e->getMessage();
}
?>
