<?php
session_start();

if (!isset($_SESSION['user_type'])) {
    header("Location: ../../index.php");
    exit();
}

if ($_SESSION['user_type'] != 'ciudadano') {
    require '../../backend/php/check_access.php';
}

require '../../backend/bd/Conexion.php';

$id_curso = isset($_GET['id']) ? intval($_GET['id']) : 0;
if ($id_curso <= 0) {
    $_SESSION['virtual_error'] = 'Curso no válido.';
    header('Location: area_virtual.php');
    exit();
}

if ($_SESSION['user_type'] == 'ciudadano') {
    $documento = $_SESSION['username'] ?? null;
    if (empty($documento)) {
        $_SESSION['virtual_error'] = 'No se pudo validar tu sesión, vuelve a iniciar sesión.';
        header('Location: area_virtual.php');
        exit();
    }

    $stmt = $connect->prepare("SELECT id_grupo FROM inscripciones WHERE documento = ? AND idcurso = ? AND state = '1' LIMIT 1");
    $stmt->execute([$documento, $id_curso]);
    $inscripcion = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$inscripcion || empty($inscripcion['id_grupo'])) {
        $_SESSION['virtual_error'] = 'Para ingresar al aula debes pertenecer a un grupo activo.';
        header('Location: area_virtual.php');
        exit();
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=8.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <title>EFAC | Detalle del Curso</title>
    <!-- Summernote CSS -->
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
    
    <style>
        /* Modern Dark LMS Theme */
        /* ... (previous styles) ... */
        
        /* Editor Styles */
        .note-editor.note-airframe, .note-editor.note-frame {
            border: 1px solid rgba(255,255,255,0.1);
            background: var(--bg-card);
        }
        .note-toolbar {
            background: var(--bg-dark) !important;
            border-bottom: 1px solid rgba(255,255,255,0.1) !important;
        }
        .note-editable {
            background: var(--bg-card);
            color: var(--text-light);
        }
        .note-btn {
            background: #333 !important;
            color: white !important;
            border: 1px solid #444 !important;
        }

        .edit-controls {
            display: flex;
            gap: 10px;
        }

        .btn-edit {
            background: #f39c12;
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 6px;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 5px;
            font-weight: 600;
        }

        .btn-save {
            background: #2ecc71;
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 6px;
            cursor: pointer;
            display: none; /* Hidden by default */
            align-items: center;
            gap: 5px;
            font-weight: 600;
        }
        
        /* Main Tabs (Top) */
        .main-tabs {
            display: flex;
            gap: 30px; /* Increased gap */
            border-bottom: 1px solid rgba(255,255,255,0.1);
            margin-bottom: 40px; /* Increased margin */
            padding-bottom: 0px;
        }

        .tab-link {
            padding: 15px 5px; /* Better touch area */
            font-size: 1.05rem;
            color: var(--text-grey);
            text-decoration: none;
            font-weight: 500;
            position: relative;
            cursor: pointer;
            transition: all 0.3s;
        }

        /* Module Navigation (Horizontal Scroll) */
        .module-nav-container {
            background: var(--bg-card);
            padding: 10px;
            border-radius: 12px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            overflow-x: auto;
            white-space: nowrap;
            border: 1px solid rgba(255,255,255,0.05);
            display: flex;
            gap: 15px; /* Increased gap between modules */
            align-items: center;
        }

        .module-link {
            display: inline-block;
            padding: 10px 20px; /* Larger pills */
            color: var(--text-grey);
            text-decoration: none;
            border-radius: 50px; /* Rounder pills */
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s;
            background: rgba(255,255,255,0.03); /* Subtle background */
            white-space: nowrap; /* Prevent breaking */
        }
    </style>
</head>
<body>

    <!-- SIDEBAR -->
    <?php include '../../backend/php/sidebar_menu.php'; ?>
    <!-- SIDEBAR -->

    <section id="content">
        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar' ></i>
            <form action="#">
                <div class="form-group-search">
                    <input type="text" placeholder="Buscar contenido...">
                    <i class='bx bx-search icon' ></i>
                </div>
            </form>
            <span class="divider"></span>
            <div class="profile">
                <img src="../../backend/img/user-default.png" alt="">
                <ul class="profile-link">
                    <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon' ></i> Perfil</a></li>
                    <li><a href="../salir.php"><i class='bx bxs-log-out-circle' ></i> Salir</a></li>
                </ul>
            </div>
        </nav>
        <!-- NAVBAR -->

        <main>
            
            <div class="course-header">
                <div style="display:flex; justify-content:space-between; align-items:flex-end;">
                    <div>
                        <ul class="breadcrumbs" style="margin-bottom: 10px;">
                            <li><a href="area_virtual.php">Área Virtual</a></li>
                            <li class="divider">></li>
                            <li><a href="#" class="active">Detalle del Curso</a></li>
                        </ul>
                        <h1 class="course-title" id="courseTitle">Cargando curso...</h1>
                    </div>
                    <div class="edit-controls">
                        <button class="btn-edit" id="btnEdit" onclick="enableEditMode()">
                            <i class='bx bxs-pencil'></i> Editar Contenido
                        </button>
                        <button class="btn-save" id="btnSave" onclick="saveContent()">
                            <i class='bx bxs-save'></i> Guardar Cambios
                        </button>
                    </div>
                </div>
            </div>

            <!-- Top Tabs -->
            <div class="main-tabs">
                <a class="tab-link active" onclick="switchTab('curso')">Curso</a>
                <a class="tab-link" onclick="switchTab('participantes')">Participantes</a>
                <a class="tab-link" onclick="switchTab('calificaciones')">Calificaciones</a>
                <a class="tab-link" onclick="switchTab('competencias')">Competencias</a>
            </div>

            <!-- TAB CONTENT: CURSO -->
            <div id="tab-curso" class="tab-content">
                
                <!-- Modules Navigation -->
                <div style="display:flex; gap:15px; align-items:center; margin-bottom:30px;">
                    <div class="module-nav-container" style="margin-bottom:0; flex-grow:1; display:flex; gap:10px; align-items:center; overflow-x:auto;" id="moduleList">
                        <!-- Loaded via JS -->
                        <span style="color:var(--text-grey); padding:10px;">Cargando módulos...</span>
                    </div>
                    <button class="btn-edit" onclick="addModule()" style="background:var(--btn-gradient); color:white; border:none; height:45px; width:45px; display:flex; align-items:center; justify-content:center; padding:0; border-radius:12px; box-shadow:0 4px 15px rgba(221, 36, 118, 0.4); flex-shrink:0;" title="Agregar Módulo">
                        <i class='bx bx-plus' style="font-size:1.5rem;"></i>
                    </button>
                </div>

                <!-- Dynamic Content Area -->
                <div class="content-area" id="moduleContent">
                    <div style="text-align:center; padding: 40px; color:#666;">
                        <p>Seleccione un módulo o cree uno nuevo.</p>
                    </div>
                </div>

            </div>
            
            <!-- Other tabs placeholders -->
            <div id="tab-participantes" class="tab-content" style="display:none;">
                <div class="content-area">
                    <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:20px;">
                        <h2>Lista de Participantes</h2>
                        <button onclick="loadParticipants()" class="btn-edit" style="background:#34495e; width:auto; padding:5px 15px; font-size:1.2rem;" title="Recargar">
                            <i class='bx bx-refresh'></i>
                        </button>
                    </div>
                    <div id="participantsList">
                        <!-- Loaded via JS -->
                        <p style="color:var(--text-grey)">Cargando...</p>
                    </div>
                </div>
            </div>
            <div id="tab-calificaciones" class="tab-content" style="display:none;">
                 <div class="content-area">
                    <h2>Calificaciones</h2>
                    <p style="color:var(--text-grey)">Funcionalidad en desarrollo...</p>
                </div>
            </div>
             <div id="tab-competencias" class="tab-content" style="display:none;">
                 <div class="content-area">
                    <h2>Competencias</h2>
                    <p style="color:var(--text-grey)">Funcionalidad en desarrollo...</p>
                </div>
            </div>

        </main>
    </section>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/6.6.9/sweetalert2.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/6.6.9/sweetalert2.min.css">
    <script src="../../backend/js/script.js"></script>
    <script>
        const courseId = <?php echo $id_curso; ?>;
        const isAdmin = <?php echo ($_SESSION['user_type'] != 'ciudadano') ? 'true' : 'false'; ?>;
        let currentModuleId = null;
        let isEditing = false;

        $(document).ready(function() {
            if(courseId > 0) {
                loadCourseDetails();
                loadModules();
                
                // Check for requested tab
                const urlParams = new URLSearchParams(window.location.search);
                const tabStart = urlParams.get('tab');
                if(tabStart) {
                    switchTab(tabStart);
                }
            }
        });

        function loadCourseDetails() {
            $.post('ajax_registro.php', { action: 'get_course', id: courseId }, function(response) {
                if (response.success) {
                    $('#courseTitle').text(response.data.nombre);
                }
            }, 'json');
        }

        function loadModules() {
            $.post('ajax_registro.php', { action: 'get_course_modules', id_curso: courseId }, function(response) {
                if (response.success) {
                    const container = $('#moduleList');
                    container.empty();
                    
                    if (response.data.length === 0) {
                        container.html('<span style="color:var(--text-grey); font-size:0.9rem;">No hay módulos. ¡Crea el primero!</span>');
                        $('#moduleContent').html('<div style="text-align:center; padding: 40px; color:#666;"><p>Crea un módulo para comenzar a agregar contenido.</p></div>');
                    } else {
                        response.data.forEach((mod, index) => {
                            const activeClass = (index === 0 && !currentModuleId) || (currentModuleId == mod.id) ? 'active' : '';
                            if (activeClass) currentModuleId = mod.id; // Default to first if none selected
                            
                            container.append(`
                                <a class="module-link ${activeClass}" onclick="loadModuleContent(${mod.id}, this)">
                                    ${mod.titulo}
                                </a>
                            `);
                        });
                        // Load content for the active module
                        if(currentModuleId) loadModuleContent(currentModuleId);
                    }
                }
            }, 'json');
        }

        function addModule() {
            swal({
                title: "Nuevo Módulo",
                text: "Ingrese el nombre del módulo o semana:",
                input: 'text',
                showCancelButton: true,
                confirmButtonText: 'Crear',
                cancelButtonText: 'Cancelar',
                showLoaderOnConfirm: true,
                preConfirm: function (text) {
                    return new Promise(function (resolve, reject) {
                        if (text === "") {
                            reject('El nombre no puede estar vacío');
                        } else {
                            resolve();
                        }
                    })
                }
            }).then(function (text) {
                $.post('ajax_registro.php', { 
                    action: 'add_course_module', 
                    id_curso: courseId, 
                    titulo: text 
                }, function(response) {
                    if (response.success) {
                        swal('Creado', response.message, 'success');
                        currentModuleId = response.id; // Select the new one
                        loadModules(); // Reload list
                    } else {
                        swal('Error', response.message, 'error');
                    }
                }, 'json');
            });
        }

        // Tab Switching
        window.switchTab = function(tabName) {
            $('.tab-link').removeClass('active');
            
            // Find the link that corresponds to this tab
            const link = $(`.tab-link[onclick*="${tabName}"]`);
            if(link.length) {
                link.addClass('active');
            }
            
            $('.tab-content').hide();
            $('#tab-' + tabName).fadeIn();
            
            if(tabName === 'participantes') {
                loadParticipants();
            }
        }
        
        // --- PARTICIPANTS LOGIC --- //
        let isParticipantsLoaded = false;
        
        function loadParticipants() {
            if(isParticipantsLoaded) return;
            
            const container = $('#participantsList'); 
            container.html('<div style="text-align:center; padding: 20px;"><i class="bx bx-loader-alt bx-spin" style="font-size:2rem; color:var(--text-grey);"></i></div>');
            
            $.post('ajax_registro.php', {
                action: 'get_inscritos',
                tipo: 'curso',
                id: courseId
            }, function(res) {
                if(res.success && res.data.estudiantes) {
                    const list = res.data.estudiantes;
                    container.empty();
                    
                    if(list.length === 0) {
                        container.html('<p style="text-align:center; color:var(--text-grey); padding:20px;">No hay participantes inscritos.</p>');
                    } else {
                        // Create Table
                        let tableHtml = `
                            <table style="width:100%; border-collapse:collapse; color:var(--text-grey);">
                                <thead>
                                    <tr style="border-bottom:1px solid rgba(255,255,255,0.1); text-align:left;">
                                        <th style="padding:15px;">Nombre</th>
                                        <th style="padding:15px;">Grupo</th>
                                        <th style="padding:15px;">Documento</th>
                                        <th style="padding:15px;">Ciclo Vital</th>
                                        <th style="padding:15px; text-align:center;">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                        `;
                        
                        list.forEach(std => {
                           // Group Badge Style
                           const groupBadge = std.nombre_grupo 
                                ? `<span style="background:rgba(255,255,255,0.05); padding:4px 8px; border-radius:4px; font-size:0.9rem;">${std.nombre_grupo}</span>` 
                                : '<span style="opacity:0.5; font-style:italic;">Sin Asignar</span>';

                           tableHtml += `
                                <tr style="border-bottom:1px solid rgba(255,255,255,0.05);">
                                    <td style="padding:15px; color:var(--text-light); font-weight:500;">
                                        ${std.nombre}
                                    </td>
                                    <td style="padding:15px;">${groupBadge}</td>
                                    <td style="padding:15px;">${std.documento}</td>
                                    <td style="padding:15px;">
                                        ${renderAgeAndLifecycle(std.edad, std.ciclo_vital)}
                                    </td>
                                    <td style="padding:15px; text-align:center;">
                                        <a href="../pacientes/historia.php?id=${std.documento}" target="_blank" class="btn-edit" style="background:var(--btn-gradient); width:40px; display:inline-flex; justify-content:center; text-decoration:none;" title="Ver Historia">
                                            <i class='bx bx-id-card'></i>
                                        </a>
                                    </td>
                                </tr>
                           `; 
                        });
                        
                        tableHtml += '</tbody></table>';
                        container.html(tableHtml);
                        isParticipantsLoaded = true;
                    }
                } else {
                     container.html('<p style="color:#e74c3c; text-align:center;">Error al cargar participantes.</p>');
                }
            }, 'json');
        }
        
        function renderAgeAndLifecycle(edad, ciclo) {
            let badgeColor = '#95a5a6';
            if(ciclo && ciclo.includes('Infancia')) badgeColor = '#e67e22';
            if(ciclo && ciclo.includes('Adolescencia')) badgeColor = '#9b59b6';
            if(ciclo && ciclo.includes('Juventud')) badgeColor = '#3498db';
            if(ciclo && ciclo.includes('Adultez')) badgeColor = '#2ecc71';
            
            return `
                <div style="display:flex; flex-direction:column;">
                    <span style="font-weight:600; color:${badgeColor};">${ciclo || 'N/A'}</span>
                    <small>${edad ? edad + ' años' : ''}</small>
                </div>
            `;
        }

        // Content Loading
        window.loadModuleContent = function(id, element) {
            currentModuleId = id;
            
            // UI Update
            if(element) {
                $('.module-link').removeClass('active');
                $(element).addClass('active');
            }

            const contentDiv = $('#moduleContent');
            contentDiv.html('<div style="text-align:center; padding: 40px; color:#666;"><i class="bx bx-loader-alt bx-spin" style="font-size:2rem;"></i></div>');

            // Fetch Items
            $.post('ajax_registro.php', { 
                action: 'get_module_content', 
                id_modulo: id 
            }, function(response) {
                if (response.success) {
                    contentDiv.empty();
                    
                    // Add "Add Content" Button at the top
                    contentDiv.append(`
                        <div style="margin-bottom:20px; text-align:right;">
                            <button class="btn-edit" onclick="addContentItem()" style="background:var(--btn-gradient); color:white; border:none; display:inline-flex; align-items:center; gap:8px; padding:10px 20px; border-radius:8px;">
                                <i class='bx bx-plus'></i> Agregar Contenido
                            </button>
                        </div>
                    `);

                    if (response.data.length === 0) {
                        contentDiv.append(`
                            <div style="text-align:center; padding: 20px; color:var(--text-grey);">
                                <i class='bx bxs-file-blank' style="font-size:3rem; margin-bottom:10px;"></i>
                                <p>Este módulo está vacío.</p>
                            </div>
                        `);
                    } else {
                        response.data.forEach(item => {
                            const icon = getIconForType(item.tipo);
                            const color = getColorForType(item.tipo);
                            let extraHtml = '';
                            
                            // Specific UI per Type
                            // Specific UI per Type
                            if (item.tipo === 'tarea') {
                                const deadlineStr = item.fecha_limite ? new Date(item.fecha_limite).toLocaleString() : 'Sin fecha límite';
                                
                                if (isAdmin) {
                                     // Admin View: See Submissions Button
                                    extraHtml = `
                                        <div style="margin-top:15px; padding:15px; background:rgba(52, 152, 219, 0.1); border-left:4px solid #3498db; border-radius:4px;">
                                            <p style="margin-bottom:10px; font-weight:600;"><i class='bx bx-time'></i> Fecha de entrega: ${deadlineStr}</p>
                                            <button onclick="viewSubmissions(${item.id})" class="btn-edit" style="background:#3498db; width:auto; padding:8px 20px;">
                                                <i class='bx bx-folder-open'></i> Ver Entregas
                                            </button>
                                        </div>
                                    `;
                                } else {
                                    // Student View
                                    if (item.archivo_entrega) {
                                        extraHtml = `
                                            <div style="margin-top:15px; padding:15px; background:rgba(46, 204, 113, 0.1); border-left:4px solid #2ecc71; border-radius:4px;">
                                                <p style="margin-bottom:5px; font-weight:600; color:#2ecc71;">
                                                    <i class='bx bx-check-circle'></i> Tarea Entregada
                                                </p>
                                                <p style="margin-bottom:10px; font-size:0.9rem;">
                                                    Archivo: <a href="../../backend/uploads/tareas/${item.archivo_entrega}" target="_blank" style="color:var(--text-light); text-decoration:underline;">${item.archivo_entrega}</a>
                                                    <br>
                                                    Fecha: ${new Date(item.fecha_entrega).toLocaleString()}
                                                </p>
                                                ${item.calificacion ? `<p style="font-weight:bold; color:#f1c40f;">Nota: ${item.calificacion}</p>` : '<small>Pendiente de calificación</small>'}
                                                
                                                <div style="margin-top:10px;">
                                                    <button onclick="openSubmissionModal(${item.id})" class="btn-edit" style="background:#27ae60; width:auto; padding:5px 15px; font-size:0.8rem;">
                                                        <i class='bx bx-revision'></i> Reenviar
                                                    </button>
                                                </div>
                                            </div>
                                        `;
                                    } else {
                                        extraHtml = `
                                            <div style="margin-top:15px; padding:15px; background:rgba(230, 126, 34, 0.1); border-left:4px solid #e67e22; border-radius:4px;">
                                                <p style="margin-bottom:10px; font-weight:600;"><i class='bx bx-time'></i> Fecha de entrega: ${deadlineStr}</p>
                                                <button onclick="openSubmissionModal(${item.id})" class="btn-edit" style="background:#e67e22; width:auto; padding:8px 20px;" title="Subir archivo">
                                                    <i class='bx bx-upload'></i> Subir Tarea
                                                </button>
                                            </div>
                                        `;
                                    }
                                }

                            } else if (item.tipo === 'foro') {
                                extraHtml = `
                                     <div style="margin-top:15px;">
                                        <button onclick="toggleForum(${item.id})" class="btn-edit" style="background:#3498db; width:auto; padding:8px 20px;">
                                            <i class='bx bx-chat'></i> Ir al Debate
                                        </button>
                                        
                                        <!-- Forum Container (Hidden by default) -->
                                        <div id="forum-container-${item.id}" style="display:none; margin-top:15px; background:rgba(0,0,0,0.2); padding:15px; border-radius:8px; border-left:3px solid #3498db;">
                                            <div id="forum-list-${item.id}" style="max-height:300px; overflow-y:auto; margin-bottom:15px;">
                                                <!-- Comments go here -->
                                            </div>
                                            <div style="display:flex; gap:10px;">
                                                <input type="text" id="comment-input-${item.id}" placeholder="Escribe tu aporte..." style="flex-grow:1; padding:10px; border-radius:6px; border:1px solid #444; background:#2c2c2c; color:white;">
                                                <button onclick="postComment(${item.id})" style="background:#3498db; color:white; border:none; padding:0 20px; border-radius:6px; cursor:pointer;"><i class='bx bx-send'></i></button>
                                            </div>
                                        </div>
                                     </div>
                                `;
                            } else if (item.tipo === 'evaluacion') {
                                extraHtml = `
                                     <div style="margin-top:15px;">
                                        <button class="btn-edit" style="background:#c0392b; width:auto; padding:8px 20px;">
                                            <i class='bx bx-play-circle'></i> Iniciar Intento
                                        </button>
                                     </div>
                                `;
                            }

                            contentDiv.append(`
                                <div class="lms-card" id="item-${item.id}">
                                    <div style="display:flex; justify-content:space-between; align-items:flex-start; margin-bottom:15px; border-bottom:1px solid rgba(255,255,255,0.05); padding-bottom:10px;">
                                        <h4 style="margin:0; font-size:1.1rem; color:var(--text-light); display:flex; align-items:center; gap:10px;">
                                            <i class='bx ${icon}' style="color:${color};"></i> 
                                            <span style="display:flex; flex-direction:column;">
                                                ${item.titulo}
                                                <small style="font-size:0.75rem; color:var(--text-grey); font-weight:400; text-transform:uppercase;">${item.tipo || 'recurso'}</small>
                                            </span>
                                        </h4>
                                        <div style="display:flex; gap:5px;">
                                            <button onclick="editItem(${item.id})" class="btn-edit" style="background:#f39c12; font-size:0.8rem; padding:5px 10px;">
                                                <i class='bx bxs-pencil'></i>
                                            </button>
                                            <button onclick="deleteItem(${item.id})" class="btn-edit" style="background:#e74c3c; font-size:0.8rem; padding:5px 10px;">
                                                <i class='bx bxs-trash'></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="item-content" id="content-${item.id}" style="color:var(--text-grey);">
                                        ${item.contenido ? item.contenido : '<em style="opacity:0.6">Sin descripción...</em>'}
                                    </div>
                                    ${extraHtml}
                                    <div class="editor-container" id="editor-${item.id}" style="display:none; margin-top:15px;">
                                        <div id="summernote-${item.id}"></div>
                                        <div style="margin-top:10px; display:flex; gap:10px; justify-content:flex-end;">
                                             <button onclick="cancelEdit(${item.id})" class="btn-edit" style="background:#555;">Cancelar</button>
                                             <button onclick="saveItem(${item.id})" class="btn-edit" style="background:#2ecc71;">Guardar Finalizar</button>
                                        </div>
                                    </div>
                                </div>
                            `);
                        });
                    }
                }
            }, 'json');
        }

        // --- RENDER LOGIC --- //
        
        function getIconForType(type) {
            switch(type) {
                case 'tarea': return 'bx-task';
                case 'foro': return 'bx-chat';
                case 'evaluacion': return 'bx-check-square';
                default: return 'bx-book-content';
            }
        }
        
        function getColorForType(type) {
            switch(type) {
                case 'tarea': return '#e67e22'; // Orange
                case 'foro': return '#3498db'; // Blue
                case 'evaluacion': return '#e74c3c'; // Red
                default: return '#a29bfe'; // Purple
            }
        }

        // --- CRUD LOGIC --- //

        function addContentItem() {
            // Updated SweetAlert for Type Selection
            swal({
                title: "Nuevo Contenido",
                html: `
                    <input id="swal-input1" class="swal2-input" placeholder="Título (ej: Tarea 1)" style="margin-bottom:15px; width:80%;">
                    <select id="swal-input2" class="swal2-input" style="margin-bottom:15px; width:80%;">
                        <option value="recurso">📄 Material / Recurso</option>
                        <option value="tarea">📝 Tarea (Entrega de Archivo)</option>
                        <option value="foro">💬 Foro de Discusión</option>
                        <option value="evaluacion">✅ Evaluación</option>
                    </select>
                    <div id="date-container" style="display:none;">
                        <label>Fecha Límite</label>
                        <input id="swal-input3" type="datetime-local" class="swal2-input" style="width:80%;">
                    </div>
                `,
                showCancelButton: true,
                confirmButtonText: 'Crear',
                cancelButtonText: 'Cancelar',
                preConfirm: function () {
                    return new Promise(function (resolve) {
                        resolve([
                            $('#swal-input1').val(),
                            $('#swal-input2').val(),
                            $('#swal-input3').val()
                        ])
                    })
                },
                onOpen: function () {
                    $('#swal-input2').change(function() {
                        if($(this).val() === 'tarea' || $(this).val() === 'evaluacion') {
                            $('#date-container').show();
                        } else {
                            $('#date-container').hide();
                        }
                    });
                }
            }).then(function (result) {
                const title = result[0];
                const type = result[1];
                const deadline = result[2];

                if(title) {
                    $.post('ajax_registro.php', {
                        action: 'add_content_item',
                        id_curso: courseId,
                        id_modulo: currentModuleId,
                        titulo: title,
                        tipo: type,
                        fecha_limite: deadline
                    }, function(res) {
                        if(res.success) {
                             loadModuleContent(currentModuleId); // Reload
                        } else {
                            swal("Error", res.message, "error");
                        }
                    }, 'json');
                }
            });
        }

        function editItem(id) {
            // Hide content, show editor
            $(`#content-${id}`).hide();
            $(`#editor-${id}`).show();
            
            // Fix: Destroy previous instance if any, then init
            $(`#summernote-${id}`).summernote({
                placeholder: 'Ingrese el contenido...',
                tabsize: 2,
                height: 200,
                toolbar: [
                  ['style', ['style']],
                  ['font', ['bold', 'underline', 'clear']],
                  ['color', ['color']],
                  ['para', ['ul', 'ol', 'paragraph']],
                  ['insert', ['link', 'picture', 'video', 'table']],
                  ['view', ['codeview']]
                ],
                callbacks: {
                    onInit: function() {
                        $('.note-editable').css('background-color', '#1e1e1e').css('color', '#f5f6fa');
                    }
                }
            });
            // Set content again just in case (though it should be in DOM)
            $(`#summernote-${id}`).summernote('code', $(`#content-${id}`).html());
        }

        function cancelEdit(id) {
            $(`#summernote-${id}`).summernote('destroy');
            $(`#editor-${id}`).hide();
            $(`#content-${id}`).show();
        }

        function saveItem(id) {
            const markup = $(`#summernote-${id}`).summernote('code');
            $.post('ajax_registro.php', {
                action: 'save_content_item',
                id_item: id,
                contenido: markup
            }, function(res) {
                if(res.success) {
                    $(`#content-${id}`).html(markup); // Update view
                    cancelEdit(id); // Close editor
                    swal("Guardado", "Contenido actualizado", "success");
                } else {
                    swal("Error", "No se pudo guardar", "error");
                }
            }, 'json');
        }

        function deleteItem(id) {
             swal({
                title: "¿Eliminar?",
                text: "No podrás revertir esto.",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                confirmButtonText: 'Sí, eliminar'
            }).then(function () {
                $.post('ajax_registro.php', {
                    action: 'delete_content_item',
                    id_item: id
                }, function(res) {
                    if(res.success) {
                        $(`#item-${id}`).remove();
                        swal("Eliminado", "El contenido ha sido borrado.", "success");
                    }
                }, 'json');
            });
        }

        // Legacy functions overrides or removed
        function enableEditMode() { /* Removed global edit */ }
        function saveContent() { /* Removed global save */ }

        // --- INTERACTION LOGIC --- //

        function openSubmissionModal(contentId) {
            swal({
                title: "Subir Tarea",
                html: `
                    <p style="margin-bottom:15px; color:#666;">Seleccione su archivo para entregar.</p>
                    <input type="file" id="submission-file" class="swal2-input" style="border:none;">
                `,
                showCancelButton: true,
                confirmButtonText: 'Enviar',
                cancelButtonText: 'Cancelar',
                showLoaderOnConfirm: true,
                preConfirm: function () {
                    return new Promise(function (resolve, reject) {
                        const fileInput = document.getElementById('submission-file');
                        if (fileInput.files.length === 0) {
                            reject('Debes seleccionar un archivo.');
                        } else {
                            resolve(fileInput.files[0]);
                        }
                    })
                }
            }).then(function (file) {
                const formData = new FormData();
                formData.append('action', 'upload_submission');
                formData.append('id_contenido', contentId);
                formData.append('archivo', file);

                $.ajax({
                    url: 'ajax_registro.php',
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    dataType: 'json',
                    success: function(response) {
                        if(response.success) {
                            swal("¡Enviado!", response.message, "success");
                        } else {
                            swal("Error", response.message, "error");
                        }
                    },
                    error: function() {
                        swal("Error", "Fallo al subir el archivo.", "error");
                    }
                });
            });
        }
        // --- GLOBAL SCOPE BINDING ---
        window.toggleForum = toggleForum;
        window.postComment = postComment;
        window.openSubmissionModal = openSubmissionModal;

        function toggleForum(contentId) {
            console.log("toggleForum called for", contentId);
            const container = $(`#forum-container-${contentId}`);
            const list = $(`#forum-list-${contentId}`);
            
            if (container.is(':visible')) {
                container.slideUp();
            } else {
                container.slideDown();
                // Load comments
                list.html('<div style="text-align:center; padding:10px;"><i class="bx bx-loader-alt bx-spin"></i> Cargando...</div>');
                
                $.post('ajax_registro.php', {
                    action: 'get_forum_comments',
                    id_contenido: contentId
                }, function(res) {
                    list.empty();
                    if(res.success && res.data.length > 0) {
                        res.data.forEach(comment => {
                            const name = comment.nombres ? `${comment.nombres} ${comment.apellidos}` : 'Estudiante';
                            list.append(`
                                <div style="margin-bottom:10px; padding:10px; background:rgba(255,255,255,0.05); border-radius:8px;">
                                    <div style="font-size:0.85rem; color:#3498db; margin-bottom:4px; font-weight:600;">
                                        ${name} <span style="color:#666; font-weight:400; font-size:0.75rem; float:right;">${comment.fecha_format}</span>
                                    </div>
                                    <div style="color:var(--text-light); font-size:0.95rem;">${comment.comentario}</div>
                                </div>
                            `);
                        });
                    } else {
                        list.html('<p style="text-align:center; color:#666; font-style:italic;">Sé el primero en comentar.</p>');
                    }
                }, 'json');
            }
        }

        function postComment(contentId) {
            console.log("postComment called for", contentId);
            const input = $(`#comment-input-${contentId}`);
            const text = input.val().trim();
            
            if(!text) {
                swal("Atención", "Escribe un comentario antes de enviar.", "warning");
                return;
            }

            // Disable button temporarily
            const btn = input.next('button');
            const originalIcon = btn.html();
            btn.prop('disabled', true).html('<i class="bx bx-loader-alt bx-spin"></i>');

            $.post('ajax_registro.php', {
                action: 'add_forum_comment',
                id_contenido: contentId,
                comentario: text
            }, function(res) {
                btn.prop('disabled', false).html(originalIcon);
                
                if(res.success) {
                    input.val('');
                    // Refresh comments
                    $(`#forum-container-${contentId}`).hide(); 
                    toggleForum(contentId); 
                } else {
                     swal("Error", res.message || "No se pudo publicar.", "error");
                }
            }, 'json').fail(function() {
                btn.prop('disabled', false).html(originalIcon);
                swal("Error", "Error de servidor.", "error");
            });
        }
        
        function viewSubmissions(contentId) {
            // Show loading
            swal({
                title: 'Cargando Entregas...',
                text: 'Por favor espere.',
                onOpen: function () {
                    swal.showLoading()
                }
            });

            $.post('ajax_registro.php', {
                action: 'get_task_submissions',
                id_contenido: contentId
            }, function(res) {
                if(res.success) {
                    let html = '<div style="max-height:400px; overflow-y:auto; text-align:left;">';
                    if(res.data.length === 0) {
                         html += '<p style="text-align:center; color:#666;">No hay entregas aún.</p>';
                    } else {
                        html += '<table style="width:100%; border-collapse:collapse; font-size:0.9rem;"><thead><tr style="border-bottom:1px solid #ddd;"><th style="padding:8px;">Estudiante</th><th style="padding:8px;">Fecha</th><th style="padding:8px;">Archivo</th></tr></thead><tbody>';
                        res.data.forEach(sub => {
                            const name = sub.nombres ? `${sub.nombres} ${sub.apellidos}` : sub.documento;
                            html += `
                                <tr style="border-bottom:1px solid #eee;">
                                    <td style="padding:8px;">${name}</td>
                                    <td style="padding:8px;">${sub.fecha_format}</td>
                                    <td style="padding:8px;">
                                        <a href="../../backend/uploads/tareas/${sub.archivo}" target="_blank" style="color:#3498db; text-decoration:none;">
                                            <i class='bx bx-download'></i> Ver Archivo
                                        </a>
                                    </td>
                                </tr>
                            `;
                        });
                        html += '</tbody></table>';
                    }
                    html += '</div>';

                    swal({
                        title: 'Entregas de Tarea',
                        html: html,
                        width: '600px',
                        confirmButtonText: 'Cerrar'
                    });
                } else {
                    swal("Error", "No se pudieron cargar las entregas.", "error");
                }
            }, 'json');
        }
    </script>
</body>
</html>
