```php
<?php
session_start();
require '../../backend/php/check_access.php';

// Check permissions
if(!hasModulePermission('cursos') && !hasSubmenuPermission('cursos_inscripcion')){
    header('location: ../acceso_denegado.php');
    exit;
}

require '../../backend/bd/Conexion.php';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Inscripción a Cursos</title>
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        /* Reusing styles from registro_esc_formacion.php */
        :root {
            --primary-color: #4a90e2;
            --secondary-color: #f5f6fa;
            --border-color: #dcdde1;
            --text-color: #2f3640;
            --success-color: #2ecc71;
            --warning-color: #f1c40f;
            --danger-color: #e74c3c;
            --card-shadow: 0 4px 6px rgba(0,0,0,0.1);
            --header-height: 60px;
        }

        .main-container {
            display: flex;
            gap: 20px;
            padding: 20px;
            height: calc(100vh - 100px);
            overflow-x: auto;
        }

        .column-card {
            flex: 1;
            min-width: 300px;
            background: #fff;
            border-radius: 12px;
            box-shadow: var(--card-shadow);
            display: flex;
            flex-direction: column;
            overflow: hidden;
            border: 1px solid var(--border-color);
        }

        .column-header {
            padding: 15px 20px;
            background: #fff;
            border-bottom: 2px solid var(--secondary-color);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .column-header h2 {
            font-size: 1.1rem;
            color: var(--text-color);
            margin: 0;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .column-body {
            flex: 1;
            overflow-y: auto;
            padding: 10px;
            background: #fdfdfd;
        }

        /* Lists */
        .item-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .list-item {
            padding: 15px;
            margin-bottom: 10px;
            background: #fff;
            border: 1px solid var(--border-color);
            border-radius: 8px;
            cursor: pointer;
            transition: all 0.2s ease;
            position: relative;
        }

        .list-item:hover {
            transform: translateY(-2px);
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            border-color: var(--primary-color);
        }

        .list-item.active {
            background: #eef2ff;
            border-color: var(--primary-color);
            border-left: 4px solid var(--primary-color);
        }

        .item-title {
            font-weight: 600;
            color: var(--text-color);
            display: block;
        }

        .item-meta {
            font-size: 0.85rem;
            color: #7f8fa6;
            margin-top: 5px;
        }

        /* User Search Styles */
        .search-box {
            padding: 15px;
            background: #f8f9fa;
            border-bottom: 1px solid var(--border-color);
        }
        .search-input-group {
            display: flex;
            gap: 10px;
            margin-bottom: 10px;
        }
        .search-input-group input {
            flex: 1;
            padding: 8px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        .search-btn {
            padding: 8px 15px;
            background: var(--primary-color);
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        .user-info {
            padding: 15px;
            background: #e8f5e9;
            border-radius: 8px;
            margin-top: 10px;
            display: none;
        }
        .user-info.visible {
            display: block;
        }

        /* Enroll Button */
        .enroll-btn {
            width: 100%;
            padding: 10px;
            background: #27ae60;
            color: white;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-weight: bold;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            margin-top: 10px;
        }
        .enroll-btn:hover {
            background: #219150;
        }

        /* Badges */
        .count-badge {
            background: #e1ecf4;
            color: var(--primary-color);
            padding: 2px 8px;
            border-radius: 12px;
            font-size: 0.8rem;
        }
    </style>
</head>
<body>

    <!-- SIDEBAR -->
    <?php include '../../backend/php/sidebar_menu.php'; ?>
    <!-- SIDEBAR -->

    <section id="content">
        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar'></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Search...">
                    <i class='bx bx-search icon'></i>
                </div>
            </form>
            <span class="divider"></span>
            <div class="profile">
                <img src="../../backend/img/user-default.png" alt="">
                <ul class="profile-link">
                    <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon'></i> Perfil</a></li>
                    <li><a href="../salir.php"><i class='bx bxs-log-out-circle'></i> Salir</a></li>
                </ul>
            </div>
        </nav>
        <!-- NAVBAR -->

        <main>
            <h1 class="title">Inscripción a Cursos</h1>
            <ul class="breadcrumbs">
                <li><a href="../admin/escritorio.php">Home</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Inscripción</a></li>
            </ul>

            <div class="main-container">
                
                <!-- 1. USUARIO (User Search) -->
                <div class="column-card">
                    <div class="column-header">
                        <h2><i class='bx bxs-user'></i> Estudiantes</h2>
                    </div>
                    <div class="column-body">
                        <div class="search-box">
                            <label>Documento de Identidad</label>
                            <div class="search-input-group">
                                <input type="text" id="searchCedula" placeholder="Ingrese cédula...">
                                <button class="search-btn" onclick="buscarUsuario()"><i class='bx bx-search'></i></button>
                            </div>
                        </div>
                        <div id="userInfo" class="user-info">
                            <h4 id="userName" style="margin: 0 0 5px 0;"></h4>
                            <p id="userDoc" style="margin: 0; color: #666; font-size: 0.9em;"></p>
                            <input type="hidden" id="selectedUserDoc">
                            
                            <!-- Enrolled Courses Section -->
                            <div id="enrolledCourses" style="margin-top: 15px; border-top: 1px solid #ccc; padding-top: 10px;">
                                <h5 style="margin: 0 0 10px 0; font-size: 0.9em; color: #333;"><i class='bx bx-check-circle'></i> Cursos Inscritos:</h5>
                                <ul id="enrolledList" style="list-style: none; padding: 0; margin: 0; font-size: 0.85em;"></ul>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- 2. ESCUELAS -->
                <div class="column-card">
                    <div class="column-header">
                        <h2><i class='bx bxs-institution'></i> Escuelas</h2>
                    </div>
                    <div class="column-body">
                        <ul class="item-list" id="list-escuelas">
                            <!-- Populated via JS -->
                        </ul>
                    </div>
                </div>

                <!-- 3. ÁREAS -->
                <div class="column-card">
                    <div class="column-header">
                        <h2><i class='bx bx-grid-alt'></i> Áreas</h2>
                    </div>
                    <div class="column-body">
                        <div id="empty-area" style="text-align: center; color: #ccc; margin-top: 50px;">
                            Selecciona una Escuela
                        </div>
                        <ul class="item-list" id="list-areas"></ul>
                    </div>
                </div>

                <!-- 4. CURSOS (Enroll) -->
                <div class="column-card">
                    <div class="column-header">
                        <h2><i class='bx bxs-book'></i> Cursos</h2>
                    </div>
                    <div class="column-body">
                        <div id="empty-curso" style="text-align: center; color: #ccc; margin-top: 50px;">
                            Selecciona un Área
                        </div>
                        <ul class="item-list" id="list-cursos"></ul>
                    </div>
                </div>

            </div>
        </main>
    </section>

    <script src="../../backend/js/script.js"></script>
    <script>
        // State variables
        let currentEscuela = null;
        let currentArea = null;
        let currentUser = null;

        $(document).ready(function() {
            loadEscuelas();
        });

        // --- USER SEARCH ---
        function buscarUsuario() {
            const cedula = $('#searchCedula').val();
            if(!cedula) {
                Swal.fire('Error', 'Ingrese un número de documento', 'warning');
                return;
            }

            $.post('ajax_registro.php', { action: 'search_user', documento: cedula }, function(response) {
                if(response.success) {
                    currentUser = response.data;
                    $('#userName').text(currentUser.nombre + ' ' + currentUser.apellido);
                    $('#userDoc').text('CC: ' + currentUser.documento);
                    $('#selectedUserDoc').val(currentUser.documento);
                    
                    // Display Enrolled Courses
                    const enrolledList = $('#enrolledList');
                    enrolledList.empty();
                    
                    if (currentUser.cursos_inscritos && currentUser.cursos_inscritos.length > 0) {
                        currentUser.cursos_inscritos.forEach(curso => {
                            enrolledList.append(`
                                <li style="padding: 5px 0; border-bottom: 1px dashed #eee; color: #555;">
                                    <b>${curso.nombre}</b> <span style="color:#888; font-size:0.9em;">(${curso.codigo})</span>
                                </li>
                            `);
                        });
                    } else {
                        enrolledList.append('<li style="color: #999; font-style: italic;">Ningún curso inscrito.</li>');
                    }

                    $('#userInfo').addClass('visible');
                    
                    Swal.fire({
                        toast: true,
                        position: 'top-end',
                        icon: 'success',
                        title: 'Usuario encontrado',
                        showConfirmButton: false,
                        timer: 1500
                    });
                } else {
                    $('#userInfo').removeClass('visible');
                    currentUser = null;
                    Swal.fire('No encontrado', 'No se encontró un usuario con ese documento', 'error');
                }
            }, 'json');
        }

        // --- LOADERS (Reuse logic from registration but adapted) ---
        function loadEscuelas() {
            $.post('ajax_registro.php', { action: 'get_escuelas' }, function(response) {
                if (response.success) {
                    const list = $('#list-escuelas');
                    list.empty();
                    response.data.forEach(item => {
                        list.append(`
                            <li class="list-item" onclick="selectEscuela(this, ${item.id})">
                                <span class="item-title">${item.nombre}</span>
                                <div class="item-meta">Código: ${item.codigo}</div>
                            </li>
                        `);
                    });
                }
            }, 'json');
        }

        function selectEscuela(el, id) {
            $('.list-item').removeClass('active'); // Global clear might be too aggressive, better scope it
            $(el).siblings().removeClass('active');
            $(el).addClass('active');

            currentEscuela = id;
            currentArea = null;
            
            // UI Reset
            $('#list-areas').empty();
            $('#list-cursos').empty();
            $('#empty-area').hide();
            $('#empty-curso').show();

            loadAreas(id);
        }

        function loadAreas(idEscuela) {
            $.post('ajax_registro.php', { action: 'get_areas', id_escuela: idEscuela }, function(response) {
                const list = $('#list-areas');
                list.empty();
                if (response.success && response.data.length > 0) {
                    response.data.forEach(item => {
                        list.append(`
                            <li class="list-item" onclick="selectArea(this, ${item.id})">
                                <span class="item-title">${item.nombre}</span>
                                <div class="item-meta">Código: ${item.codigo}</div>
                            </li>
                        `);
                    });
                } else {
                    list.append('<p style="text-align:center; padding:20px; color:#aaa">No hay áreas registradas</p>');
                }
            }, 'json');
        }

        function selectArea(el, id) {
            $(el).siblings().removeClass('active');
            $(el).addClass('active');
            currentArea = id;
            $('#empty-curso').hide();
            loadCursos(id);
        }

        function loadCursos(idArea) {
            $.post('ajax_registro.php', { action: 'get_cursos', id_area: idArea }, function(response) {
                const list = $('#list-cursos');
                list.empty();
                if (response.success && response.data.length > 0) {
                    response.data.forEach(item => {
                        // Calculate slots
                        const totalCupos = parseInt(item.cupos) || 0;
                        const inscritos = parseInt(item.inscritos) || 0;
                        const disponibles = totalCupos - inscritos;
                        
                        // DB might have 0 cupos for old courses, treat as 0 available or unlimited?
                        // Assuming strict limit based on user request.
                        
                        const isFull = disponibles <= 0;
                        const btnState = isFull ? 'disabled style="background:#ccc; cursor:not-allowed;"' : '';
                        const btnText = isFull ? 'Agotado' : 'Inscribir';
                        const badgeColor = isFull ? '#e74c3c' : '#2ecc71';
                        const badgeText = isFull ? 'Sin cupos' : `${disponibles} Disp.`;

                        list.append(`
                            <li class="list-item" style="cursor: default;">
                                <div style="display:flex; justify-content:space-between; align-items:start;">
                                    <span class="item-title">${item.nombre}</span>
                                    <span class="count-badge" style="background:${badgeColor}; color:white;">${badgeText}</span>
                                </div>
                                <div class="item-meta">
                                    Prof: ${item.quien_lo_da} <br>
                                    Código: ${item.codigo} <br>
                                    ${item.dias_clase ? `<i class='bx bx-calendar'></i> ${item.dias_clase} <br>` : ''}
                                    ${item.horario_clase ? `<i class='bx bx-time'></i> ${item.horario_clase} <br>` : ''}
                                    <small>Cupos: ${inscritos} / ${totalCupos}</small>
                                </div>
                                <button class="enroll-btn" onclick="inscribirCurso(${item.idcurso}, '${item.nombre}', ${disponibles})" ${btnState}>
                                    ${btnText} <i class='bx ${isFull ? "bx-x-circle" : "bx-check-circle"}'></i>
                                </button>
                            </li>
                        `);
                    });
                } else {
                    list.append('<p style="text-align:center; padding:20px; color:#aaa">No hay cursos registrados</p>');
                }
            }, 'json');
        }

        // --- ENROLL ACTION ---
        function inscribirCurso(idCurso, nombreCurso, disponibles) {
            if (!currentUser) {
                Swal.fire('Atención', 'Primero debes buscar y seleccionar un usuario', 'warning');
                return;
            }

            if (disponibles !== undefined && disponibles <= 0) {
                Swal.fire('Error', 'No hay cupos disponibles para este curso', 'error');
                return;
            }

            Swal.fire({
                title: '¿Confirmar inscripción?',
                text: `Vas a inscribir a ${currentUser.nombre} en el curso "${nombreCurso}"`,
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Sí, inscribir'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.post('ajax_registro.php', {
                        action: 'enroll_student',
                        documento: currentUser.documento,
                        idcurso: idCurso
                    }, function(response) {
                        if (response.success) {
                            Swal.fire('¡Inscrito!', response.message, 'success');
                        } else {
                            Swal.fire('Error', response.message, 'error');
                        }
                    }, 'json');
                }
            });
        }
    </script>
</body>
</html>
```