<?php
/**
 * Migration Script: Add dias_clase column to cursos_grupos table
 * This moves the schedule information from curso level to grupo level
 */

require_once '../../backend/bd/Conexion.php';

try {
    // Check if column already exists
    $checkStmt = $connect->query("SHOW COLUMNS FROM cursos_grupos LIKE 'dias_clase'");
    
    if($checkStmt->rowCount() == 0) {
        // Add dias_clase column
        $connect->exec("ALTER TABLE cursos_grupos ADD COLUMN dias_clase VARCHAR(255) DEFAULT NULL AFTER horario");
        echo "✅ Column 'dias_clase' added to 'cursos_grupos' table successfully.\n";
    } else {
        echo "ℹ️  Column 'dias_clase' already exists in 'cursos_grupos' table.\n";
    }
    
    echo "\n✅ Migration completed successfully!\n";
    echo "\nNOTE: Old curso-level schedule data (dias_clase, horario_clase) is still in 'cursos' table.\n";
    echo "You can manually remove these columns later if needed.\n";
    
} catch(PDOException $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>
