<?php
/**
 * Router de Dashboard - Redirige al dashboard correcto según el rol del usuario
 * Este archivo debe ser usado en lugar de admin/escritorio.php en los enlaces
 */

session_start();

// Verificar si hay sesión activa
if(!isset($_SESSION['rol']) || !isset($_SESSION['id'])) {
    header('Location: login.php');
    exit();
}

// Redirigir según el rol del usuario
switch($_SESSION['rol']) {
    case 1: // Administrador
    case 2: // Auxiliar
        header('Location: admin/escritorio.php');
        break;
    
    case 3: // Profesor
    case 4: // Profesor
        header('Location: profesionales/dashboard_profesor.php');
        break;

    
    case 5: // Fisioterapeuta
        // Verificar si existe el dashboard de fisioterapeuta
        if(file_exists('profesionales/dashboard_fisioterapeuta.php')) {
            header('Location: profesionales/dashboard_fisioterapeuta.php');
        } else {
            // Si no existe, usar el de enfermería como template
            header('Location: profesionales/dashboard_enfermeria.php');
        }
        break;
    
    case 6: // Enfermería
        header('Location: profesionales/dashboard_enfermeria.php');
        break;
    
    default:
        // Rol no reconocido, cerrar sesión
        session_destroy();
        header('Location: login.php');
        break;
}

exit();
?>
