<?php 
session_start();
include_once '../backend/php/login.php'
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>EFAC | Iniciar Sesión</title>
    <link rel="stylesheet" href="../backend/css/style.css">
    <link rel="icon" type="image/png" sizes="96x96" href="../backend/img/ico.svg">
</head>
<body class="bg-light">
    <style>
        body.bg-light {
            background: url('../backend/img/spectrum_bg.png') no-repeat center center fixed !important;
            background-size: cover !important;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            filter: hue-rotate(40deg); /* Shift pink to orange/yellow */
        }
        
        .login-wrapper {
            filter: hue-rotate(-40deg); /* Counter-rotate */
            width: 100%;
            display: flex;
            justify-content: center;
            padding: 20px;
        }

        .login-card-container {
            display: flex;
            background: #1a1a2e; /* Dark purple/black tone */
            width: 1000px;
            max-width: 100%;
            height: 600px;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
        }

        /* Left Side - Image */
        .left-panel {
            flex: 1;
            position: relative;
            background: #000;
            overflow: hidden;
            border-radius: 20px 0 0 20px;
        }

        .slide {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-size: cover;
            background-position: center;
            opacity: 0;
            transition: opacity 1s ease-in-out;
            z-index: 1;
        }

        .slide.active {
            opacity: 1;
        }
        
        .slide::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(rgba(0,0,0,0.3), rgba(0,0,0,0.5));
        }

        .left-panel-content {
            position: relative;
            z-index: 2;
            height: 100%;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            padding: 40px;
            color: white;
        }
        
        .brand-logo {
            font-size: 24px;
            font-weight: 700;
            letter-spacing: 1px;
            text-transform: uppercase;
        }

        .left-panel-text h2 {
            font-size: 32px;
            font-weight: 600;
            line-height: 1.2;
            margin-bottom: 20px;
        }
        
        .slider-dots {
            display: flex;
            gap: 8px;
            margin-top: 20px;
        }
        .dot {
            width: 30px;
            height: 4px;
            background: rgba(255,255,255,0.3);
            border-radius: 2px;
            cursor: pointer;
            transition: background 0.3s;
        }
        .dot.active {
            background: white;
        }

        /* Right Side - Form */
        .right-panel {
            flex: 1;
            padding: 60px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            background: #232336; /* Slightly lighter dark */
            color: #fff;
            position: relative;
            z-index: 5;
        }

        .form-header {
            margin-bottom: 40px;
        }
        
        .form-header h1 {
            font-size: 32px;
            font-weight: 600;
            margin-bottom: 10px;
            color: #fff;
        }
        
        .form-header p {
            color: #a0a0b0;
            font-size: 14px;
        }
        
        .form-header a {
            color: #6c5ce7;
            text-decoration: none;
        }

        .input-group-dark {
            margin-bottom: 20px;
        }
        
        .form-control-dark {
            background: #2d2d44;
            border: 1px solid #3f3f56;
            color: white;
            padding: 15px;
            border-radius: 8px;
            width: 100%;
            font-size: 14px;
            transition: all 0.3s;
        }
        
        .form-control-dark:focus {
            background: #32324a;
            border-color: #6c5ce7;
            outline: none;
        }
        
        .form-control-dark::placeholder {
            color: #6c6c80;
        }

        .btn-primary-dark {
            background: #6c5ce7; /* Purple accent like image */
            color: white;
            padding: 15px;
            border-radius: 8px;
            width: 100%;
            border: none;
            font-weight: 600;
            cursor: pointer;
            margin-top: 10px;
            transition: background 0.2s;
        }
        
        .btn-primary-dark:hover {
            background: #5b4cc4;
        }

        .divider {
            display: flex;
            align-items: center;
            margin: 30px 0;
            color: #6c6c80;
            font-size: 13px;
        }
        
        .divider:before, .divider:after {
            content: "";
            flex: 1;
            border-bottom: 1px solid #3f3f56;
        }
        
        .divider span {
            padding: 0 15px;
        }

        .social-buttons {
            display: flex;
            gap: 15px;
        }
        
        .social-btn {
            flex: 1;
            background: #2d2d44;
            border: 1px solid #3f3f56;
            padding: 12px;
            border-radius: 8px;
            display: flex;
            justify-content: center;
            align-items: center;
            cursor: pointer;
            transition: all 0.2s;
            color: white;
            font-size: 14px;
            gap: 10px;
        }
        
        .social-btn:hover {
            background: #32324a;
            border-color: #555;
        }

        .alert-error {
            background: rgba(231, 76, 60, 0.1);
            border: 1px solid rgba(231, 76, 60, 0.3);
            color: #e74c3c;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 14px;
        }

        /* Mobile Responsive */
        @media (max-width: 900px) {
            .login-card-container {
                flex-direction: column;
                height: auto;
                max-width: 500px;
            }
            .left-panel {
                height: 200px;
                padding: 20px;
            }
            .left-panel-text {
                display: none;
            }
            .right-panel {
                padding: 40px 30px;
            }
        }
    </style>

    <div class="login-wrapper">
        <div class="login-card-container">
            <!-- Left Panel -->
            <div class="left-panel">
                <!-- Slides Backgrounds -->
                <div class="slide active" style="background-image: url('../backend/img/slider/slider1.jpg');"></div>
                <div class="slide" style="background-image: url('../backend/img/slider/slider2.jpg');"></div>
                <div class="slide" style="background-image: url('../backend/img/slider/slider3.jpg');"></div>

                <div class="left-panel-content">
                    <div class="brand-logo">EFAC</div>
                    <div class="left-panel-text">
                        <h2 id="sliderText">Capturando Momentos,<br>Creando Memorias.</h2>
                        <div class="slider-dots">
                            <span class="dot active" onclick="currentSlide(1)"></span>
                            <span class="dot" onclick="currentSlide(2)"></span>
                            <span class="dot" onclick="currentSlide(3)"></span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Panel -->
            <div class="right-panel">
                <div class="form-header">
                    <h1>Iniciar Sesión</h1>
                </div>

                <?php 
                if (isset($errMsg)) {
                    echo '<div class="alert-error">'.$errMsg.'</div>';
                }
                ?>

                <form action="" method="post" autocomplete="off">
                    <div class="input-group-dark">
                        <input type="text" name="username" class="form-control-dark" value="<?php if(isset($_POST['username'])) echo $_POST['username'] ?>" required placeholder="Usuario o Documento">
                    </div>
                    
                    <div class="input-group-dark">
                        <input type="password" name="password" class="form-control-dark" value="<?php if(isset($_POST['password'])) echo $_POST['password'] ?>" required placeholder="Contraseña">
                    </div>

                    <div style="display: flex; justify-content: flex-end; margin-bottom: 20px; font-size: 13px; color: #a0a0b0;">
                        <a href="#" style="color: #a0a0b0; text-decoration: none;">¿Olvidaste tu contraseña?</a>
                    </div>

                    <button class="btn-primary-dark" type="submit" name="login">Ingresar</button>
                    
                    <div style="margin-top: 15px; text-align: left; font-size: 14px; color: #a0a0b0;">
                        ¿No tienes cuenta? <a href="ciudadano/registro.php" style="color: #6c5ce7; text-decoration: none;">Regístrate</a>
                    </div>
                    

                </form>
            </div>
        </div>
    </div>
    <script>
        let slideIndex = 0;
        const slides = document.querySelectorAll(".slide");
        const dots = document.querySelectorAll(".dot");
        const texts = [
            "Capturando Momentos,<br>Creando Memorias.",
            "Cultura y Arte<br>para Todos.",
            "Formando el Futuro<br>de nuestra Región."
        ];
        const textElement = document.getElementById("sliderText");
        let sliderInterval;

        function showSlides() {
            // Hide all slides
            slides.forEach(slide => slide.classList.remove("active"));
            dots.forEach(dot => dot.classList.remove("active"));

            // Increment index
            slideIndex++;
            if (slideIndex > slides.length) { slideIndex = 1 }

            // Show current
            slides[slideIndex - 1].classList.add("active");
            dots[slideIndex - 1].classList.add("active");
            
            // Update Text with fade effect
            textElement.style.opacity = 0;
            setTimeout(() => {
                textElement.innerHTML = texts[slideIndex - 1];
                textElement.style.opacity = 1;
            }, 500);

            // Auto advance
            sliderInterval = setTimeout(showSlides, 5000); // Change image every 5 seconds
        }

        function currentSlide(n) {
            clearTimeout(sliderInterval);
            slideIndex = n - 1; // Adjust because showSlides increments
            showSlides();
        }

        // Initialize
        document.addEventListener('DOMContentLoaded', () => {
             // Initial text set
             textElement.innerHTML = texts[0];
             // Start slider
             showSlides();
        });
    </script>
</body>
</html>
