<?php
    ob_start();
     session_start();
    
    if(!isset($_SESSION['rol']) || $_SESSION['rol'] != 1){
    header('location: ../login.php');

    $id=$_SESSION['id'];
  }
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/6.6.9/sweetalert2.min.css">
    <title>Actualizar Profesional</title>
    
    <style>
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
            font-size: 14px;
        }
        .form-group input[type="text"],
        .form-group input[type="date"],
        .form-group select {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e8e8e8;
            border-radius: 8px;
            font-size: 14px;
            transition: all 0.3s ease;
            background: white;
        }
        .form-group input:focus,
        .form-group select:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        .form-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
        }
        .badge-warning {
            color: #ff6b6b;
            margin-left: 5px;
        }
        @media (max-width: 768px) {
            .form-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <?php include '../../backend/php/sidebar_menu.php'; ?>

    <!-- CONTENT -->
    <section id="content">
        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar'></i>
            <span class="divider"></span>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
                    <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon'></i> Profile</a></li>
                    <li><a href="../salir.php"><i class='bx bxs-log-out-circle'></i> Logout</a></li>
                </ul>
            </div>
        </nav>
        <!-- NAVBAR -->

        <!-- MAIN -->
        <main>
            <h1 class="title">Actualizar Profesional</h1>
            <ul class="breadcrumbs">
                <li><a href="../admin/escritorio.php">Home</a></li>
                <li class="divider">></li>
                <li><a href="mostrar.php">Profesionales</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Editar</a></li>
            </ul>

            <div class="data">
                <div class="content-data">
                    <?php 
                    require '../../backend/bd/Conexion.php';
                    $id = $_GET['id'];
                    $sentencia = $connect->prepare("SELECT * FROM doctor WHERE idodc = ?");
                    $sentencia->execute([$id]);
                    
                    $data = array();
                    if($sentencia){
                        while($r = $sentencia->fetchObject()){
                            $data[] = $r;
                        }
                    }
                    ?>
                    
                    <?php if(count($data) > 0): ?>
                        <?php foreach($data as $d): ?>
                        <form action="" enctype="multipart/form-data" method="POST" autocomplete="off" style="padding: 20px;">
                            <input type="hidden" name="midp" value="<?php echo $d->idodc; ?>">
                            
                            <div class="form-grid">
                                <div class="form-group">
                                    <label for="docce">Cédula <span class="badge-warning">*</span></label>
                                    <input type="text" id="docce" maxlength="15" name="docce" value="<?php echo $d->ceddoc; ?>" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="docna">Nombre <span class="badge-warning">*</span></label>
                                    <input type="text" id="docna" name="docna" value="<?php echo $d->nodoc; ?>" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="docap">Apellido <span class="badge-warning">*</span></label>
                                    <input type="text" id="docap" name="docap" value="<?php echo $d->apdoc; ?>" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="doces">Especialidad <span class="badge-warning">*</span></label>
                                    <select required name="doces" id="doces">
                                        <option value="<?php echo $d->nomesp; ?>"><?php echo $d->nomesp; ?></option>
                                        <option value="">--Seleccione--</option>
                                        <option value="Cardiología">Cardiología</option>
                                        <option value="Dermatología">Dermatología</option>
                                        <option value="Endocrinología">Endocrinología</option>
                                        <option value="Gastroenterología">Gastroenterología</option>
                                        <option value="Geriatría">Geriatría</option>
                                        <option value="Medicina General">Medicina General</option>
                                        <option value="Neurología">Neurología</option>
                                        <option value="Neumología">Neumología</option>
                                        <option value="Oftalmología">Oftalmología</option>
                                        <option value="Pediatría">Pediatría</option>
                                        <option value="Psiquiatría">Psiquiatría</option>
                                        <option value="Rehabilitación">Rehabilitación</option>
                                        <option value="Reumatología">Reumatología</option>
                                        <option value="Traumatología">Traumatología</option>
                                    </select>
                                </div>
                                
                                <div class="form-group">
                                    <label for="docdi">Dirección <span class="badge-warning">*</span></label>
                                    <input type="text" id="docdi" name="docdi" value="<?php echo $d->direcd; ?>" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="docge">Género <span class="badge-warning">*</span></label>
                                    <select required name="docge" id="docge">
                                        <option value="<?php echo $d->sexd; ?>"><?php echo $d->sexd; ?></option>
                                        <option value="">--Seleccione--</option>
                                        <option value="Masculino">Masculino</option>
                                        <option value="Femenino">Femenino</option>
                                    </select>
                                </div>
                                
                                <div class="form-group">
                                    <label for="docte">Teléfono <span class="badge-warning">*</span></label>
                                    <input type="text" id="docte" maxlength="13" name="docte" value="<?php echo $d->phd; ?>" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="docda">Fecha de Nacimiento <span class="badge-warning">*</span></label>
                                    <input type="date" id="docda" name="docda" value="<?php echo $d->nacd; ?>" required>
                                </div>
                            </div>
                            
                            <hr style="margin: 30px 0;">
                            
                            <button type="submit" name="upd_doctors" class="registerbtn">
                                💾 Actualizar Profesional
                            </button>
                        </form>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p class="alert alert-warning">No hay datos</p>
                    <?php endif; ?>
                </div>
            </div>
        </main>
        <!-- MAIN -->
    </section>
    <!-- CONTENT -->
    <script src="../../backend/js/jquery.min.js"></script>
    <script src="../../backend/js/script.js"></script>
    <script src="../../backend/js/multistep.js"></script>
    <script src="../../backend/js/vpat.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js"></script>
    
    <script>
        // Toggle sidebar
        const toggleSidebar = document.querySelector('.toggle-sidebar');
        const sidebar = document.getElementById('sidebar');
        
        if(toggleSidebar) {
            toggleSidebar.addEventListener('click', function() {
                sidebar.classList.toggle('hide');
            });
        }
    </script>
    
    <?php include_once '../../backend/php/upd_doctor.php' ?>
</body>
</html>


