<?php
ob_start();
session_start();

if(!isset($_SESSION['rol']) || $_SESSION['rol'] != 1){
    header('location: ../login.php');
    exit();
}

require '../../backend/bd/Conexion.php';

$userId = isset($_GET['id']) ? $_GET['id'] : 0;

// Obtener datos del usuario
$stmtUser = $connect->prepare("SELECT * FROM users WHERE id = ?");
$stmtUser->execute([$userId]);
$user = $stmtUser->fetch(PDO::FETCH_ASSOC);

if(!$user) {
    header('location: mostrar.php');
    exit();
}

// Obtener permisos actuales
$stmtPerms = $connect->prepare("SELECT * FROM user_permissions WHERE user_id = ?");
$stmtPerms->execute([$userId]);
$perms = $stmtPerms->fetch(PDO::FETCH_ASSOC);

// Si no tiene permisos, crear registro vacío
if(!$perms) {
    $perms = [
        'view_valoracion_riesgo' => 0,
        'edit_valoracion_riesgo' => 0,
        'view_salud_oral' => 0,
        'edit_salud_oral' => 0,
        'view_salud_mental' => 0,
        'edit_salud_mental' => 0,
        'view_medicamentos' => 0,
        'edit_medicamentos' => 0,
        'view_signos_vitales' => 0,
        'edit_signos_vitales' => 0,
        'view_diagnostico' => 0,
        'edit_diagnostico' => 0,
        'view_antecedentes' => 0,
        'edit_antecedentes' => 0,
        'view_examenes' => 0,
        'edit_examenes' => 0
    ];
}

// Procesar formulario
if(isset($_POST['update_permissions'])) {
    try {
        // Verificar si ya existe un registro
        $checkPerms = $connect->prepare("SELECT id FROM user_permissions WHERE user_id = ?");
        $checkPerms->execute([$userId]);
        $exists = $checkPerms->fetch();
        
        if($exists) {
            // Actualizar permisos existentes
            $updatePerms = $connect->prepare("UPDATE user_permissions SET
                view_valoracion_riesgo = ?,
                edit_valoracion_riesgo = ?,
                view_salud_oral = ?,
                edit_salud_oral = ?,
                view_salud_mental = ?,
                edit_salud_mental = ?,
                view_medicamentos = ?,
                edit_medicamentos = ?,
                view_signos_vitales = ?,
                edit_signos_vitales = ?,
                view_diagnostico = ?,
                edit_diagnostico = ?,
                view_antecedentes = ?,
                edit_antecedentes = ?,
                view_examenes = ?,
                edit_examenes = ?
                WHERE user_id = ?");
            
            $updatePerms->execute([
                isset($_POST['perm_view_valoracion']) ? 1 : 0,
                isset($_POST['perm_edit_valoracion']) ? 1 : 0,
                isset($_POST['perm_view_salud_oral']) ? 1 : 0,
                isset($_POST['perm_edit_salud_oral']) ? 1 : 0,
                isset($_POST['perm_view_salud_mental']) ? 1 : 0,
                isset($_POST['perm_edit_salud_mental']) ? 1 : 0,
                isset($_POST['perm_view_medicamentos']) ? 1 : 0,
                isset($_POST['perm_edit_medicamentos']) ? 1 : 0,
                isset($_POST['perm_view_signos']) ? 1 : 0,
                isset($_POST['perm_edit_signos']) ? 1 : 0,
                isset($_POST['perm_view_diagnostico']) ? 1 : 0,
                isset($_POST['perm_edit_diagnostico']) ? 1 : 0,
                isset($_POST['perm_view_antecedentes']) ? 1 : 0,
                isset($_POST['perm_edit_antecedentes']) ? 1 : 0,
                isset($_POST['perm_view_examenes']) ? 1 : 0,
                isset($_POST['perm_edit_examenes']) ? 1 : 0,
                $userId
            ]);
        } else {
            // Insertar nuevos permisos
            $insertPerms = $connect->prepare("INSERT INTO user_permissions (
                user_id, view_valoracion_riesgo, edit_valoracion_riesgo,
                view_salud_oral, edit_salud_oral, view_salud_mental, edit_salud_mental,
                view_medicamentos, edit_medicamentos, view_signos_vitales, edit_signos_vitales,
                view_diagnostico, edit_diagnostico, view_antecedentes, edit_antecedentes,
                view_examenes, edit_examenes
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            
            $insertPerms->execute([
                $userId,
                isset($_POST['perm_view_valoracion']) ? 1 : 0,
                isset($_POST['perm_edit_valoracion']) ? 1 : 0,
                isset($_POST['perm_view_salud_oral']) ? 1 : 0,
                isset($_POST['perm_edit_salud_oral']) ? 1 : 0,
                isset($_POST['perm_view_salud_mental']) ? 1 : 0,
                isset($_POST['perm_edit_salud_mental']) ? 1 : 0,
                isset($_POST['perm_view_medicamentos']) ? 1 : 0,
                isset($_POST['perm_edit_medicamentos']) ? 1 : 0,
                isset($_POST['perm_view_signos']) ? 1 : 0,
                isset($_POST['perm_edit_signos']) ? 1 : 0,
                isset($_POST['perm_view_diagnostico']) ? 1 : 0,
                isset($_POST['perm_edit_diagnostico']) ? 1 : 0,
                isset($_POST['perm_view_antecedentes']) ? 1 : 0,
                isset($_POST['perm_edit_antecedentes']) ? 1 : 0,
                isset($_POST['perm_view_examenes']) ? 1 : 0,
                isset($_POST['perm_edit_examenes']) ? 1 : 0
            ]);
        }
        
        $successMessage = "Permisos actualizados correctamente";
        
        // Recargar permisos
        $stmtPerms->execute([$userId]);
        $perms = $stmtPerms->fetch(PDO::FETCH_ASSOC);
        
    } catch(PDOException $e) {
        $errorMessage = "Error al actualizar permisos: " . $e->getMessage();
    }
}

$roles = [1 => 'Administrador', 3 => 'Profesor', 4 => 'Psicólogo', 5 => 'Fisioterapeuta', 6 => 'Enfermería'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <title>Editar Permisos | <?php echo $user['name']; ?></title>
</head>
<body>
    <?php include '../../backend/php/sidebar_menu.php'; ?>

    <section id="content">
        <nav>
            <i class='bx bx-menu toggle-sidebar'></i>
            <span class="divider"></span>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
                    <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon'></i> Profile</a></li>
                    <li><a href="../salir.php"><i class='bx bxs-log-out-circle'></i> Logout</a></li>
                </ul>
            </div>
        </nav>

        <main>
            <h1 class="title">Editar Permisos de Acceso</h1>
            <ul class="breadcrumbs">
                <li><a href="../admin/escritorio.php">Home</a></li>
                <li class="divider">></li>
                <li><a href="mostrar.php">Profesionales</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Editar Permisos</a></li>
            </ul>

            <?php if(isset($successMessage)): ?>
            <div style="background: #e6f7ee; padding: 15px; border-radius: 8px; border-left: 4px solid #28a745; margin-bottom: 20px;">
                <p style="margin: 0; color: #155724;"><strong>✅ <?php echo $successMessage; ?></strong></p>
            </div>
            <?php endif; ?>

            <?php if(isset($errorMessage)): ?>
            <div style="background: #fee; padding: 15px; border-radius: 8px; border-left: 4px solid #c33; margin-bottom: 20px;">
                <p style="margin: 0; color: #721c24;"><strong>❌ <?php echo $errorMessage; ?></strong></p>
            </div>
            <?php endif; ?>

            <div class="data">
                <div class="content-data">
                    <div class="head">
                        <h3>👤 <?php echo $user['name']; ?></h3>
                        <p style="margin: 5px 0 0 0; color: #666;">
                            <strong>Usuario:</strong> <?php echo $user['username']; ?> | 
                            <strong>Rol:</strong> <?php echo $roles[$user['rol']] ?? 'Desconocido'; ?>
                        </p>
                    </div>

                    <form method="POST" style="padding: 20px;">
                        <div style="background: #f8f9fc; padding: 20px; border-radius: 8px; margin-bottom: 20px;">
                            <h3 style="margin-top: 0; color: #667eea;">🔐 Configurar Permisos de Acceso</h3>
                            <p style="color: #666; margin-bottom: 20px;">
                                Seleccione qué secciones del historial puede ver y modificar este profesional
                            </p>

                            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 15px;">
                                <!-- Valoración del Riesgo Social -->
                                <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                                    <h4 style="margin-bottom: 10px; color: #333;">📋 Valoración del Riesgo Social</h4>
                                    <label style="display: flex; align-items: center; margin-bottom: 8px; cursor: pointer;">
                                        <input type="checkbox" name="perm_view_valoracion" value="1" style="margin-right: 8px;" <?php echo $perms['view_valoracion_riesgo'] ? 'checked' : ''; ?>>
                                        <span>Puede ver</span>
                                    </label>
                                    <label style="display: flex; align-items: center; cursor: pointer;">
                                        <input type="checkbox" name="perm_edit_valoracion" value="1" style="margin-right: 8px;" <?php echo $perms['edit_valoracion_riesgo'] ? 'checked' : ''; ?>>
                                        <span>Puede modificar</span>
                                    </label>
                                </div>

                                <!-- TAMIZAJE Salud Oral -->
                                <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                                    <h4 style="margin-bottom: 10px; color: #333;">🦷 Tamizaje Salud Oral</h4>
                                    <label style="display: flex; align-items: center; margin-bottom: 8px; cursor: pointer;">
                                        <input type="checkbox" name="perm_view_salud_oral" value="1" style="margin-right: 8px;" <?php echo $perms['view_salud_oral'] ? 'checked' : ''; ?>>
                                        <span>Puede ver</span>
                                    </label>
                                    <label style="display: flex; align-items: center; cursor: pointer;">
                                        <input type="checkbox" name="perm_edit_salud_oral" value="1" style="margin-right: 8px;" <?php echo $perms['edit_salud_oral'] ? 'checked' : ''; ?>>
                                        <span>Puede modificar</span>
                                    </label>
                                </div>

                                <!-- TAMIZAJE Salud Mental -->
                                <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                                    <h4 style="margin-bottom: 10px; color: #333;">🧠 Tamizaje Salud Mental</h4>
                                    <label style="display: flex; align-items: center; margin-bottom: 8px; cursor: pointer;">
                                        <input type="checkbox" name="perm_view_salud_mental" value="1" style="margin-right: 8px;" <?php echo $perms['view_salud_mental'] ? 'checked' : ''; ?>>
                                        <span>Puede ver</span>
                                    </label>
                                    <label style="display: flex; align-items: center; cursor: pointer;">
                                        <input type="checkbox" name="perm_edit_salud_mental" value="1" style="margin-right: 8px;" <?php echo $perms['edit_salud_mental'] ? 'checked' : ''; ?>>
                                        <span>Puede modificar</span>
                                    </label>
                                </div>

                                <!-- Medicamentos -->
                                <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                                    <h4 style="margin-bottom: 10px; color: #333;">💊 Medicamentos</h4>
                                    <label style="display: flex; align-items: center; margin-bottom: 8px; cursor: pointer;">
                                        <input type="checkbox" name="perm_view_medicamentos" value="1" style="margin-right: 8px;" <?php echo $perms['view_medicamentos'] ? 'checked' : ''; ?>>
                                        <span>Puede ver</span>
                                    </label>
                                    <label style="display: flex; align-items: center; cursor: pointer;">
                                        <input type="checkbox" name="perm_edit_medicamentos" value="1" style="margin-right: 8px;" <?php echo $perms['edit_medicamentos'] ? 'checked' : ''; ?>>
                                        <span>Puede modificar</span>
                                    </label>
                                </div>

                                <!-- Signos Vitales -->
                                <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                                    <h4 style="margin-bottom: 10px; color: #333;">💓 Signos Vitales</h4>
                                    <label style="display: flex; align-items: center; margin-bottom: 8px; cursor: pointer;">
                                        <input type="checkbox" name="perm_view_signos" value="1" style="margin-right: 8px;" <?php echo $perms['view_signos_vitales'] ? 'checked' : ''; ?>>
                                        <span>Puede ver</span>
                                    </label>
                                    <label style="display: flex; align-items: center; cursor: pointer;">
                                        <input type="checkbox" name="perm_edit_signos" value="1" style="margin-right: 8px;" <?php echo $perms['edit_signos_vitales'] ? 'checked' : ''; ?>>
                                        <span>Puede modificar</span>
                                    </label>
                                </div>

                                <!-- Diagnóstico Médico -->
                                <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                                    <h4 style="margin-bottom: 10px; color: #333;">🩺 Diagnóstico Médico</h4>
                                    <label style="display: flex; align-items: center; margin-bottom: 8px; cursor: pointer;">
                                        <input type="checkbox" name="perm_view_diagnostico" value="1" style="margin-right: 8px;" <?php echo $perms['view_diagnostico'] ? 'checked' : ''; ?>>
                                        <span>Puede ver</span>
                                    </label>
                                    <label style="display: flex; align-items: center; cursor: pointer;">
                                        <input type="checkbox" name="perm_edit_diagnostico" value="1" style="margin-right: 8px;" <?php echo $perms['edit_diagnostico'] ? 'checked' : ''; ?>>
                                        <span>Puede modificar</span>
                                    </label>
                                </div>

                                <!-- Antecedentes -->
                                <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                                    <h4 style="margin-bottom: 10px; color: #333;">📝 Antecedentes</h4>
                                    <label style="display: flex; align-items: center; margin-bottom: 8px; cursor: pointer;">
                                        <input type="checkbox" name="perm_view_antecedentes" value="1" style="margin-right: 8px;" <?php echo $perms['view_antecedentes'] ? 'checked' : ''; ?>>
                                        <span>Puede ver</span>
                                    </label>
                                    <label style="display: flex; align-items: center; cursor: pointer;">
                                        <input type="checkbox" name="perm_edit_antecedentes" value="1" style="margin-right: 8px;" <?php echo $perms['edit_antecedentes'] ? 'checked' : ''; ?>>
                                        <span>Puede modificar</span>
                                    </label>
                                </div>

                                <!-- Exámenes -->
                                <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                                    <h4 style="margin-bottom: 10px; color: #333;">🔬 Exámenes</h4>
                                    <label style="display: flex; align-items: center; margin-bottom: 8px; cursor: pointer;">
                                        <input type="checkbox" name="perm_view_examenes" value="1" style="margin-right: 8px;" <?php echo $perms['view_examenes'] ? 'checked' : ''; ?>>
                                        <span>Puede ver</span>
                                    </label>
                                    <label style="display: flex; align-items: center; cursor: pointer;">
                                        <input type="checkbox" name="perm_edit_examenes" value="1" style="margin-right: 8px;" <?php echo $perms['edit_examenes'] ? 'checked' : ''; ?>>
                                        <span>Puede modificar</span>
                                    </label>
                                </div>
                            </div>

                            <div style="margin-top: 15px; padding: 12px; background: #fff3cd; border-radius: 6px; border-left: 4px solid #ffc107;">
                                <p style="margin: 0; font-size: 13px; color: #856404;">
                                    <strong>Nota:</strong> Los permisos de "modificar" solo funcionan si también tiene permiso de "ver".
                                </p>
                            </div>
                        </div>

                        <div style="display: flex; gap: 10px;">
                            <button type="submit" name="update_permissions" class="registerbtn" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                                💾 Guardar Cambios
                            </button>
                            <a href="mostrar.php" class="button" style="background: #6c757d; color: white; text-decoration: none; padding: 12px 30px; border-radius: 8px; display: inline-block;">
                                ← Volver
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </section>

    <script src="../../backend/js/script.js"></script>
</body>
</html>
