<?php
    ob_start();
    session_start();
    
    // Incluir sistema de control de acceso
    require '../../backend/php/check_access.php';
    
    // Verificar si tiene sesión activa
    if(!isset($_SESSION['rol']) || !isset($_SESSION['id'])){
        header('location: ../login.php');
        exit();
    }
    
    // Si no es admin, verificar permisos personalizados
    if($_SESSION['rol'] != 1) {
        // Verificar permiso para ver documentos de usuarios
        if(!isset($_SESSION['menu_permissions']['usuarios_documentos']) || $_SESSION['menu_permissions']['usuarios_documentos'] != 1) {
            header('location: ../acceso_denegado.php');
            exit();
        }
    }
    
    $id = $_SESSION['id'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    



    <title>EFAC| Documentos del USUARIO</title>
    <style>
        .upload-container {
            display: flex;
            gap: 20px;
            margin-bottom: 30px;
            flex-wrap: wrap;
            justify-content: flex-start;
        }
        .upload-box {
            background: #fff;
            border: 2px dashed #cbd5e0;
            border-radius: 12px;
            padding: 20px;
            width: 220px;
            text-align: center;
            transition: all 0.3s ease;
            position: relative;
            cursor: pointer;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 10px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.05);
        }
        .upload-box:hover {
            border-color: #4c51bf;
            background: #f7fafc;
            transform: translateY(-5px);
            box-shadow: 0 10px 15px rgba(0,0,0,0.1);
        }
        .upload-box i {
            font-size: 40px;
            color: #4c51bf;
        }
        .upload-box span {
            font-size: 14px;
            font-weight: 600;
            color: #4a5568;
            display: block;
        }
        .upload-box input[type="file"] {
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            opacity: 0;
            cursor: pointer;
        }
        .upload-box.selected {
            border-style: solid;
            border-color: #48bb78;
            background: #f0fff4;
        }
        .upload-box.selected i {
            color: #48bb78;
        }
        .save-button-container {
            text-align: center;
            margin-top: 20px;
            margin-bottom: 40px;
        }
        .btn-save-docs {
            background: #4c51bf;
            color: white;
            padding: 12px 30px;
            border-radius: 8px;
            border: none;
            font-weight: 700;
            cursor: pointer;
            transition: background 0.3s;
            font-size: 16px;
            box-shadow: 0 4px 6px rgba(76, 81, 191, 0.2);
        }
        .btn-save-docs:hover {
            background: #434190;
        }
    </style>
</head>
<body>

       <!-- SIDEBAR -->
   <!-- SIDEBAR DINÁMICO -->
    <?php include '../../backend/php/sidebar_menu.php'; ?>


    <!-- NAVBAR -->
    <section id="content">

        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar' ></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Search...">
                    <i class='bx bx-search icon' ></i>
                </div>
            </form>
            
           
            <span class="divider"></span>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
                    <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon' ></i> Profile</a></li>
                    
                    <li>
                     <a href="../salir.php"><i class='bx bxs-log-out-circle' ></i> Logout</a>
                    </li>
                   
                </ul>
            </div>
        </nav>
        <!-- NAVBAR -->

        <!-- MAIN -->

        <main>
            <h1 class="title">Bienvenido <?php echo '<strong>'.$_SESSION['username'].'</strong>'; ?></h1>
            <ul class="breadcrumbs">
                <li><a href="../admin/escritorio.php">Home</a></li>
                <li class="divider">></li>
                <li><a href="../pacientes/documentos.php">Documentos de los Usuarios</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Nuevo documento</a></li>
            </ul>
           <br>

           <?php 
require '../../backend/bd/Conexion.php';
 $id_user = $_GET['id'];
 $sentencia = $connect->prepare("
    SELECT u.id, u.username, u.name, u.email,
           re.nombres, re.apellidos, re.telefono, re.genero, re.modalidad,
           re.numero_documento, re.direccion, re.fecha_nacimiento
    FROM users u
    LEFT JOIN registro_estudiantes re ON u.id = re.user_id
    WHERE u.id = ?
 ");
 $sentencia->execute([$id_user]);
 $d = $sentencia->fetch(PDO::FETCH_OBJ);
   ?>
   <?php if($d):?>
<div class="input-block">

                    <div class="wrap-line">

                                <!-- Inputs -->
        <div class="brise-input">
            
            <input type="text" value="<?php echo htmlspecialchars($d->numero_documento ?? $d->email ?? 'N/A'); ?>" name="text" readonly>
            
            <span class="line"></span>
        </div>
        <div class="brise-input">
            
            <input type="text" value="<?php echo htmlspecialchars($d->nombres ?? $d->name ?? 'N/A'); ?>" name="text" readonly>
           
            <span class="line"></span>
        </div>

                <!-- Inputs -->
        <div class="brise-input">
            
            <input type="text" value="<?php echo htmlspecialchars($d->apellidos ?? ''); ?>" name="text" readonly>
            
            <span class="line"></span>
        </div>
        <div class="brise-input">
           
            <input type="text" value="<?php echo htmlspecialchars($d->direccion ?? 'N/A'); ?>" name="text" readonly>
            
            <span class="line"></span>
        </div>

        <div class="brise-input">
          
            <input type="text" value="<?php echo htmlspecialchars($d->fecha_nacimiento ?? 'N/A'); ?>" name="text" readonly>
            
            <span class="line"></span>
        </div>


        <div class="brise-input">
          
            <input type="text" value="<?php echo htmlspecialchars($d->genero ?? 'N/A'); ?>" name="text" readonly>
            
            <span class="line"></span>
        </div>

                <div class="brise-input">
            
            <input type="text" value="<?php echo htmlspecialchars($d->modalidad ?? 'N/A'); ?>" name="text" readonly>
            
            <span class="line"></span>
        </div>

        <div class="brise-input">
           
            <input type="text" value="<?php echo htmlspecialchars($d->telefono ?? 'N/A'); ?>" name="text" readonly>
            
            <span class="line"></span>
        </div>
                        
                    </div>

</div>


<div class="data">
    <div class="content-data">
        <div class="head">
            <h3>Cargar Documentos Obligatorios</h3>
        </div>
        
        <?php 
        // Obtener documentos ya cargados para este paciente
        $docs_cargados = [];
        $stmt_docs = $connect->prepare("SELECT nomfi, foto FROM document WHERE idpa = ?");
        $stmt_docs->execute([$id_user]);
        while($row = $stmt_docs->fetch(PDO::FETCH_ASSOC)) {
            $docs_cargados[$row['nomfi']] = $row['foto'];
        }

        $labels = [
            'doc_identidad' => 'Documento de identidad',
            'doc_eps' => 'Certificado de la EPS',
            'doc_vca' => 'Certificado de VCA o Discapacidad',
            'doc_carnet' => 'Carnet de la Institución educativa'
        ];
        $icons = [
            'doc_identidad' => 'bx bxs-id-card',
            'doc_eps' => 'bx bxs-certification',
            'doc_vca' => 'bx bxs-user-badge',
            'doc_carnet' => 'bx bxs-graduation'
        ];
        ?>

        <form enctype="multipart/form-data" method="POST" action="" autocomplete="off">
            <div class="upload-container">
                <?php foreach($labels as $input_name => $label): 
                    $existe = isset($docs_cargados[$label]);
                    $foto_actual = $existe ? $docs_cargados[$label] : '';
                ?>
                <div class="upload-box <?php echo $existe ? 'selected' : ''; ?>" id="box-<?php echo $input_name; ?>">
                    <i class='<?php echo $icons[$input_name]; ?>'></i>
                    <span><?php echo $label; ?><?php echo $existe ? ' (Cargado)' : ''; ?></span>
                    
                    <?php if($existe): ?>
                        <div class="box-actions" style="display: flex; gap: 10px; margin-top: 10px; z-index: 10;">
                            <a href="../../backend/img/subidas/<?php echo $foto_actual; ?>" class="btn-action download" download title="Descargar" style="background: #48bb78; color: white; padding: 5px 10px; border-radius: 4px; font-size: 12px;">
                                <i class='bx bxs-download' style="font-size: 16px; color: white;"></i>
                            </a>
                            <button type="button" class="btn-action replace" onclick="triggerReplace('<?php echo $input_name; ?>')" title="Reemplazar" style="background: #ed8936; color: white; padding: 5px 10px; border-radius: 4px; font-size: 12px; border: none; cursor: pointer;">
                                <i class='bx bx-refresh' style="font-size: 16px; color: white;"></i>
                            </button>
                        </div>
                    <?php endif; ?>

                    <input type="file" name="<?php echo $input_name; ?>" id="file-<?php echo $input_name; ?>" accept="image/*,.pdf" onchange="updateBoxStatus(this, 'box-<?php echo $input_name; ?>')" style="<?php echo $existe ? 'display:none;' : ''; ?>">
                </div>
                <?php endforeach; ?>
            </div>

            <input type="hidden" name="docidpa" value="<?php echo $d->id; ?>">
            <input type="hidden" name="docnopa" value="<?php echo htmlspecialchars(trim(($d->nombres ?? $d->name ?? '') . ' ' . ($d->apellidos ?? ''))); ?>">

            <div class="save-button-container">
                <button type="submit" name="add_docu" class="btn-save-docs">
                    <i class='bx bxs-save'></i> Guardar / Actualizar Documentos
                </button>
            </div>
        </form>

        <?php endif; ?>


        </main>
        <!-- MAIN -->
    </section>
   <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>


    <!-- NAVBAR -->
    
    <script src="../../backend/js/script.js"></script>
    <script src="../../backend/js/multistep.js"></script>
    <script src="../../backend/js/vpat.js"></script>
    


<script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js"></script>
<script>
function updateBoxStatus(input, boxId) {
    const box = document.getElementById(boxId);
    if (input.files && input.files[0]) {
        box.classList.add('selected');
        const span = box.querySelector('span');
        const originalText = span.innerText.split(' (')[0];
        span.innerText = originalText + ' (Seleccionado)';
    }
}

function triggerReplace(inputName) {
    const fileInput = document.getElementById('file-' + inputName);
    fileInput.style.display = 'block';
    fileInput.click();
}
</script>
<?php // include_once '../../backend/modal/md_docu.php' ?>
<?php include_once '../../backend/php/add_docu.php' ?>




</body>
</html>


