<?php
    ob_start();
    session_start();
    
    // Incluir sistema de control de acceso
    require '../../backend/php/check_access.php';
    
    // Verificar si tiene sesión activa
    if(!isset($_SESSION['rol']) || !isset($_SESSION['id'])){
        header('location: ../login.php');
        exit();
    }
    
    // Si no es admin, verificar permisos
    if($_SESSION['rol'] != 1) {
        if(!isset($_SESSION['menu_permissions']['usuarios_lista']) || $_SESSION['menu_permissions']['usuarios_lista'] != 1) {
            header('location: ../acceso_denegado.php');
            exit();
        }
    }
    
    require '../../backend/bd/Conexion.php';
    
    // Obtener ID del estudiante
    if(!isset($_GET['id'])) {
        header('location: mostrar.php');
        exit();
    }
    
    $id_estudiante = $_GET['id'];
    
    // Obtener datos del estudiante (Tabla Nueva: registro_estudiantes)
    $stmt = $connect->prepare("SELECT * FROM registro_estudiantes WHERE id = ?");
    $stmt->execute([$id_estudiante]);
    $d = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if(!$d) {
        echo "<script>alert('Estudiante no encontrado en el nuevo registro.'); window.location='mostrar.php';</script>";
        exit();
    }

    // Helpers para separar nombres y apellidos si están unidos
    $nombres_parts = explode(' ', $d['nombres']);
    $primer_nombre = $nombres_parts[0] ?? '';
    $segundo_nombre = isset($nombres_parts[1]) ? implode(' ', array_slice($nombres_parts, 1)) : '';

    $apellidos_parts = explode(' ', $d['apellidos']);
    $primer_apellido = $apellidos_parts[0] ?? '';
    $segundo_apellido = isset($apellidos_parts[1]) ? implode(' ', array_slice($apellidos_parts, 1)) : '';

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/6.6.9/sweetalert2.min.css">
    
    <!-- QR -->
     <script src="https://cdn.jsdelivr.net/npm/qrcode@1.5.1/build/qrcode.min.js"></script>

    <title>Actualizar Estudiante</title>
</head>
<body>

    <!-- SIDEBAR -->
    <?php include '../../backend/php/sidebar_menu.php'; ?>

    <!-- NAVBAR -->
    <section id="content">
        <nav>
            <i class='bx bx-menu toggle-sidebar' ></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Search...">
                    <i class='bx bx-search icon' ></i>
                </div>
            </form>
            <span class="divider"></span>
            <div class="profile">
                <img src="../../backend/img/user-default.png" alt="">
                <ul class="profile-link">
                    <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon' ></i> Perfil</a></li>
                    <li><a href="../salir.php"><i class='bx bxs-log-out-circle' ></i> Salir</a></li>
                </ul>
            </div>
        </nav>

        <!-- MAIN -->
        <main>
            <h1 class="title">Actualizar Estudiante: <?php echo $d['nombres']; ?></h1>
            <ul class="breadcrumbs">
                <li><a href="../admin/escritorio.php">Home</a></li>
                <li class="divider">></li>
                <li><a href="../pacientes/mostrar.php">Listado de Estudiantes</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Editar</a></li>
            </ul>
           
           <!-- UNIFIED FORM -->
            <form action="../../backend/php/admin_update_student.php" enctype="multipart/form-data" method="POST" autocomplete="off">
              <input type="hidden" name="update_student_admin" value="1">
              <input type="hidden" name="id_estudiante" value="<?php echo $d['id']; ?>">
              
              <div class="containerss">
                <h1>Editar Información del Estudiante</h1>

                <!-- SECCIÓN 2: INFORMACIÓN DEL PROGRAMA -->
                <h3><i class='bx bxs-bookmark'></i> Información del Programa</h3>
                <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label for="tusuario"><b>Tipo de Usuario</b> <span class="badge-warning">*</span></label>
                        <select required name="tusuario" id="tusuario">
                            <option value="<?php echo $d['tipo_usuario']; ?>"><?php echo $d['tipo_usuario']; ?></option>
                            <option value="Nuevo">Nuevo</option>
                            <option value="Antiguo">Antiguo</option>
                        </select>
                    </div>
                </div>
                <hr>

                <!-- SECCIÓN 3: INFORMACIÓN PERSONAL -->
                <h3><i class='bx bxs-user-detail'></i> Información Personal</h3>
                <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label for="tdocumento"><b>Tipo de Documento</b> <span class="badge-warning">*</span></label>
                        <select required name="tdocumento" id="tdocumento">
                            <option value="<?php echo $d['tipo_documento']; ?>"><?php echo $d['tipo_documento']; ?></option>
                            <option value="R.C">R.C - Registro Civil</option>
                            <option value="T.I">T.I - Tarjeta de Identidad</option>
                            <option value="C.C">C.C - Cédula de Ciudadanía</option>
                            <option value="PPT">PPT - Permiso por Protección Temporal</option>
                        </select>
                    </div>

                    <div class="form-group" style="flex: 1;">
                        <label for="nhi"><b>Número de Documento</b> <span class="badge-warning">*</span></label>
                        <input type="text" value="<?php echo $d['numero_documento']; ?>" name="nhi" maxlength="20" required pattern="[0-9]+" title="Solo números">
                    </div>
                </div>

                <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label for="primer_nombre"><b>Primer Nombre</b> <span class="badge-warning">*</span></label>
                        <input type="text" value="<?php echo $primer_nombre; ?>" name="primer_nombre" required>
                    </div>

                    <div class="form-group" style="flex: 1;">
                        <label for="segundo_nombre"><b>Segundo Nombre</b></label>
                        <input type="text" value="<?php echo $segundo_nombre; ?>" name="segundo_nombre">
                    </div>
                </div>

                <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label for="primer_apellido"><b>Primer Apellido</b> <span class="badge-warning">*</span></label>
                        <input type="text" value="<?php echo $primer_apellido; ?>" name="primer_apellido" required>
                    </div>

                    <div class="form-group" style="flex: 1;">
                        <label for="segundo_apellido"><b>Segundo Apellido</b></label>
                        <input type="text" value="<?php echo $segundo_apellido; ?>" name="segundo_apellido">
                    </div>
                </div>

                <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label for="fexpedicion"><b>Fecha de Expedición</b></label>
                        <input type="date" name="fexpedicion" value="<?php echo $d['fecha_expedicion']; ?>">
                    </div>
                    <div class="form-group" style="flex: 1;">
                        <label for="lexpedicion"><b>Lugar de Expedición</b></label>
                        <input type="text" name="lexpedicion" value="<?php echo $d['lugar_expedicion']; ?>">
                    </div>
                </div>

                 <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label for="cump"><b>Fecha de Nacimiento</b> <span class="badge-warning">*</span></label>
                        <input type="date" name="cump" value="<?php echo $d['fecha_nacimiento']; ?>" required>
                    </div>
                    <div class="form-group" style="flex: 1;">
                        <label for="gep"><b>Género</b> <span class="badge-warning">*</span></label>
                         <select required name="gep" id="gep">
                            <option value="<?php echo $d['genero']; ?>"><?php echo $d['genero']; ?></option>
                            <option value="MASCULINO">Masculino</option>
                            <option value="FEMENINO">Femenino</option>
                            <option value="LGBTIQ+">LGBTIQ+</option>
                            <option value="OTRO">Otro</option>
                        </select>
                    </div>
                </div>
                 <div class="form-group">
                    <label for="fotoperfil"><b>Foto de Perfil (Dejar vacío para no cambiar)</b></label>
                    <input type="file" name="fotoperfil" id="fotoperfil" accept="image/*">
                    <br>
                    <!-- Previsualización -->
                    <?php 
                        $fotoSrc = !empty($d['foto_perfil']) ? '../../uploads/fotos_perfil/' . $d['foto_perfil'] : '#';
                        $displayStyle = !empty($d['foto_perfil']) ? 'block' : 'none';
                    ?>
                    <img id="img-preview" src="<?php echo $fotoSrc; ?>" alt="Vista previa" style="display:<?php echo $displayStyle; ?>; width: 150px; height: 150px; object-fit: cover; margin-top: 10px; border-radius: 50%; border: 3px solid #ddd;">
                </div>
                <hr>

                <!-- SECCIÓN 4: INFORMACIÓN DE CONTACTO -->
                 <h3><i class='bx bxs-phone'></i> Información de Contacto</h3>
                 <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label for="dip"><b>Dirección</b> <span class="badge-warning">*</span></label>
                        <input type="text" name="dip" value="<?php echo $d['direccion']; ?>" required>
                    </div>
                     <div class="form-group" style="flex: 1;">
                        <label for="zona"><b>Zona</b> <span class="badge-warning">*</span></label>
                        <select required name="zona">
                            <option value="<?php echo $d['zona']; ?>"><?php echo $d['zona']; ?></option>
                            <option value="Urbano">Urbano</option>
                            <option value="Rural">Rural</option>
                            <option value="CentroP">Centro Poblado</option>
                        </select>
                    </div>
                </div>
                 <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                     <div class="form-group" style="flex: 1;">
                        <label for="barrio"><b>Barrio / Vereda</b></label>
                        <input type="text" name="barrio" value="<?php echo $d['barrio']; ?>">
                    </div>
                    <div class="form-group" style="flex: 1;">
                        <label for="telp"><b>Teléfono</b> <span class="badge-warning">*</span></label>
                        <input type="text" name="telp" value="<?php echo $d['telefono']; ?>" required>
                    </div>
                 </div>
                 <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                     <div class="form-group" style="flex: 1;">
                         <label for="tiene_whatsapp"><b>¿Tiene WhatsApp?</b></label>
                        <select name="tiene_whatsapp">
                            <option value="<?php echo $d['tiene_whatsapp']; ?>"><?php echo $d['tiene_whatsapp']; ?></option>
                            <option value="SI">Sí</option>
                            <option value="NO">No</option>
                        </select>
                     </div>
                     <div class="form-group" style="flex: 1;">
                        <label for="correo"><b>Correo Electrónico</b></label>
                        <input type="email" name="correo" value="<?php echo $d['correo']; ?>">
                     </div>
                 </div>
                 <hr>

                 <!-- SECCIÓN 5: INFORMACIÓN SOCIAL Y ACADÉMICA -->
                 <h3><i class='bx bxs-school'></i> Información Social y Académica</h3>
                 <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                      <div class="form-group" style="flex: 1;">
                        <label for="grp"><b>Grupo Sanguíneo</b></label>
                        <select name="grp">
                            <option value="<?php echo $d['grupo_sanguineo']; ?>"><?php echo $d['grupo_sanguineo']; ?></option>
                            <option value="A+">A+</option>
                            <option value="A-">A-</option>
                            <option value="B+">B+</option>
                            <option value="B-">B-</option>
                            <option value="AB+">AB+</option>
                            <option value="AB-">AB-</option>
                            <option value="O+">O+</option>
                            <option value="O-">O-</option>
                        </select>
                    </div>
                    <div class="form-group" style="flex: 1;">
                        <label for="etnia"><b>Etnia</b></label>
                         <select name="etnia">
                            <option value="<?php echo $d['etnia']; ?>"><?php echo $d['etnia']; ?></option>
                            <option value="INDIGENA">INDIGENA</option>
                            <option value="AFROCOLOMBIANO">AFRO COLOMBIANO</option>
                            <option value="ROM-GITANO">ROM-GITANO</option>
                            <option value="PALENQUERO">PALENQUERO</option>
                            <option value="RAIZAL">RAIZAL</option>
                            <option value="NINGUNO">NINGUNO</option>
                        </select>
                    </div>
                 </div>

                 <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                     <div class="form-group" style="flex: 1;">
                        <label for="eps"><b>EPS</b></label>
                        <select name="eps">
                             <option value="<?php echo $d['eps']; ?>"><?php echo $d['eps']; ?></option>
                            <option value="SANITAS">SANITAS</option>
                            <option value="SALUD TOTAL">SALUD TOTAL</option>
                            <option value="Compensar">Compensar</option>
                            <option value="Nueva EPS">Nueva EPS</option>
                            <option value="Famisanar EPS">Famisanar EPS</option>
                            <option value="SISBEN">SISBEN</option>
                             <option value="OTRA">OTRA</option>
                        </select>
                     </div>
                      <div class="form-group" style="flex: 1;">
                         <label for="grupo_poblacional"><b>Grupo Poblacional</b></label>
                         <select name="grupo_poblacional">
                            <option value="<?php echo $d['grupo_poblacional']; ?>"><?php echo $d['grupo_poblacional']; ?></option>
                            <option value="Ninguno">Ninguno</option>
                            <option value="Víctima del conflicto armado">Víctima del conflicto armado</option>
                            <option value="Discapacidad">Discapacidad</option>
                            <option value="Indígena">Indígena</option>
                            <option value="Afrodescendiente">Afrodescendiente</option>
                            <option value="Otro">Otro</option>
                        </select>
                      </div>
                 </div>

                 <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <div class="form-group" style="flex: 1;">
                        <label for="educacion"><b>Nivel Educativo</b></label>
                         <select name="educacion">
                            <option value="<?php echo $d['nivel_educativo']; ?>"><?php echo $d['nivel_educativo']; ?></option>
                            <option value="PRIMARIA">PRIMARIA</option>
                            <option value="SECUNDARIA">SECUNDARIA</option>
                            <option value="TECNICA">TECNICA</option>
                            <option value="SUPERIOR">SUPERIOR</option>
                            <option value="NINGUNO">NINGUNO</option>
                        </select>
                    </div>
                    <div class="form-group" style="flex: 1;">
                        <label for="institucion_educativa"><b>Institución Educativa</b></label>
                        <input type="text" name="institucion_educativa" value="<?php echo $d['institucion_educativa']; ?>">
                    </div>
                 </div>
                  <div class="form-group">
                        <label for="grado_actual"><b>Grado Actual (Modalidad)</b></label>
                         <select name="grado_actual">
                            <option value="<?php echo $d['grado_actual']; ?>"><?php echo $d['grado_actual']; ?></option>
                            <option value="Preescolar">Preescolar</option>
                            <option value="Primero">Primero</option>
                            <option value="Segundo">Segundo</option>
                            <option value="Tercero">Tercero</option>
                            <option value="Cuarto">Cuarto</option>
                            <option value="Quinto">Quinto</option>
                            <option value="Sexto">Sexto</option>
                            <option value="Séptimo">Séptimo</option>
                            <option value="Octavo">Octavo</option>
                            <option value="Noveno">Noveno</option>
                            <option value="Décimo">Décimo</option>
                            <option value="Once">Once</option>
                            <option value="Técnico">Técnico</option>
                            <option value="Universitario">Universitario</option>
                            <option value="Otro">Otro</option>
                        </select>
                  </div>

                <hr>
                <!-- SECCIÓN 6: CARNET -->
                <h3><i class='bx bxs-id-card'></i> Carnetización</h3>
                <div class="form-row" style="display: flex; gap: 20px; flex-wrap: wrap; align-items: center;">
                    <div class="form-group">
                        <label>Generar Carnet Digital</label>
                        <br>
                        <button type="button" class="btn-success" onclick="generarCarnet()" id="btnGenerarCarnet" style="padding: 10px 20px; background: #27ae60; color: white; border: none; border-radius: 5px; cursor: pointer; display: flex; align-items: center; gap: 10px;">
                            <i class='bx bx-id-card'></i> Generar y Descargar Carnet
                        </button>
                    </div>
                </div>
                
                <div id="qrCode" style="margin-top: 20px; display: none;"></div>
                <input type="hidden" id="qrInput">
                <hr>

                <div class="form-group" style="margin-top: 30px;">
                    <button type="submit" name="update_student_admin" class="registerbtn">Guardar Cambios</button>
                </div>
            </form>
            

        </main>
        <!-- MAIN -->
    </section>
    <script src="../../backend/js/jquery.min.js"></script>
    <script src="../../backend/js/script.js"></script>
    <script src="../../backend/js/vpat.js"></script>

<!-- Script para previsualizar la imagen -->
<script>
document.getElementById('fotoperfil').addEventListener('change', function(e) {
    const file = e.target.files[0];
    const preview = document.getElementById('img-preview');
    
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            preview.src = e.target.result;
            preview.style.display = 'block';
        }
        reader.readAsDataURL(file);
    }
});
</script>

<!-- Script de generación Carnet Unificado -->
<script>
    async function generarCarnet() {
        const btn = document.getElementById('btnGenerarCarnet');
        const originalText = btn.innerHTML;
        
        try {
            // 1. Obtener y validar datos
            const nombre = (document.querySelector('input[name="primer_nombre"]').value + ' ' + document.querySelector('input[name="segundo_nombre"]').value).trim();
            const apellido = (document.querySelector('input[name="primer_apellido"]').value + ' ' + document.querySelector('input[name="segundo_apellido"]').value).trim();
            const documento = document.querySelector('input[name="nhi"]').value;
            const tipoDoc = document.querySelector('select[name="tdocumento"]').value;
            const modalidad = document.querySelector('select[name="grado_actual"]')?.value || 'N/A';
            const imgPreview = document.getElementById('img-preview');
            const fotoInput = document.getElementById('fotoperfil');

            if (!documento || !nombre || !apellido || !tipoDoc) {
                alert("Por favor asegúrese de tener completos los datos personales (Nombre, Apellido, Documento).");
                return;
            }

            // Cambiar estado del botón
            btn.innerHTML = "<i class='bx bx-loader-alt bx-spin'></i> Generando...";
            btn.disabled = true;

            // 2. Generar QR
            const qrUrl = await new Promise((resolve, reject) => {
                QRCode.toDataURL(documento, {
                    width: 150,
                    margin: 1,
                    color: { dark: "#000000", light: "#FFFFFF" }
                }, (err, url) => err ? reject(err) : resolve(url));
            });

            // 3. Cargar imágenes
            const loadImage = (src) => new Promise((resolve, reject) => {
                const img = new Image();
                img.crossOrigin = 'anonymous';
                img.onload = () => resolve(img);
                img.onerror = () => reject(new Error(`Error cargando imagen: ${src}`));
                img.src = src;
            });

            const [carnetFrontal, carnetPosterior, qrImg] = await Promise.all([
                loadImage('../../backend/img/1-carnet.jpg'),
                loadImage('../../backend/img/2-carnet2.jpg'),
                loadImage(qrUrl)
            ]);

            // 4. Preparar canvas frontal
            const canvasFront = document.createElement('canvas');
            const ctxFront = canvasFront.getContext('2d');
            canvasFront.width = carnetFrontal.width;
            canvasFront.height = carnetFrontal.height;
            ctxFront.drawImage(carnetFrontal, 0, 0);

            // 5. Procesar foto usuario
            let fotoUsuario = null;
            try {
                let fotoSrc = '../../backend/img/foto-perfil.png'; // Default
                if (fotoInput?.files?.[0]) {
                    fotoSrc = await new Promise(r => {
                        const reader = new FileReader();
                        reader.onload = e => r(e.target.result);
                        reader.readAsDataURL(fotoInput.files[0]);
                    });
                } else if (imgPreview?.src && imgPreview.style.display !== 'none' && !imgPreview.src.includes('#')) {
                    fotoSrc = imgPreview.src;
                }
                fotoUsuario = await loadImage(fotoSrc);
            } catch (e) {
                console.warn("Usando foto por defecto", e);
                fotoUsuario = await loadImage('../../backend/img/foto-perfil.png');
            }

            if (fotoUsuario) {
                const targetW = 175, targetH = 175;
                const centerX = canvasFront.width / 2;
                const centerY = 215;
                
                // Calcular dimensiones manteniendo aspecto
                const ratio = fotoUsuario.width / fotoUsuario.height;
                let drawW = targetW, drawH = targetH;
                
                if (ratio > 1) { // Más ancha
                    drawW = targetH * ratio;
                    if (drawW > targetW) { drawW = targetW; drawH = drawW / ratio; }
                } else { // Más alta
                    drawH = targetW / ratio;
                    if (drawH > targetH) { drawH = targetH; drawW = drawH * ratio; }
                }
                
                ctxFront.save();
                ctxFront.beginPath();
                ctxFront.arc(centerX, centerY, targetW/2, 0, Math.PI * 2);
                ctxFront.closePath();
                ctxFront.clip();
                ctxFront.drawImage(fotoUsuario, centerX - drawW/2, centerY - drawH/2, drawW, drawH);
                ctxFront.restore();
            }

            // 6. Dibujar Texto
            const drawText = (text, y, fontSize = 16) => {
                ctxFront.font = `bold ${fontSize}px Arial`;
                ctxFront.fillStyle = '#000000';
                ctxFront.textAlign = 'center';
                ctxFront.fillText(text.toUpperCase(), canvasFront.width / 2, y);
            };

            const nombreCompleto = `${nombre} ${apellido}`;
            let nombreY = 340;
            // Manejo simplificado de nombre largo
            if (nombreCompleto.length > 25) {
                const words = nombreCompleto.split(' ');
                const mid = Math.ceil(words.length / 2);
                drawText(words.slice(0, mid).join(' '), nombreY, 16);
                drawText(words.slice(mid).join(' '), nombreY + 20, 16);
                nombreY += 20;
            } else {
                drawText(nombreCompleto, nombreY, 18);
            }

            drawText(`${tipoDoc}: ${documento}`, nombreY + 30, 16);
            drawText(modalidad, nombreY + 55, 14);

            // 7. Preparar canvas posterior
            const canvasBack = document.createElement('canvas');
            const ctxBack = canvasBack.getContext('2d');
            canvasBack.width = carnetPosterior.width;
            canvasBack.height = carnetPosterior.height;
            ctxBack.drawImage(carnetPosterior, 0, 0);

            // Dibujar QR
            const qrSize = 180;
            const qrX = (canvasBack.width - qrSize) / 2;
            const qrY = (canvasBack.height - qrSize) / 2 - 50;
            ctxBack.drawImage(qrImg, qrX, qrY, qrSize, qrSize);

            // 8. Combinar y Descargar
            const finalCanvas = document.createElement('canvas');
            const ctxFinal = finalCanvas.getContext('2d');
            finalCanvas.width = canvasFront.width;
            finalCanvas.height = canvasFront.height * 2 + 20;
            
            ctxFinal.drawImage(canvasFront, 0, 0);
            ctxFinal.drawImage(canvasBack, 0, canvasFront.height + 20);

            const link = document.createElement('a');
            link.download = `Carnet_${documento}.png`;
            link.href = finalCanvas.toDataURL('image/png');
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);

        } catch (error) {
            console.error(error);
            alert('Error generando el carnet: ' + error.message);
        } finally {
            btn.innerHTML = originalText;
            btn.disabled = false;
        }
    }
</script>

<style>
/* Convertir texto de todos los select a mayúsculas */
select, select option {
    text-transform: uppercase;
}
</style>

</body>
</html>
