<?php
    // TEMP DEBUG: Show all errors
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    
    ob_start();
    session_start();
    
    // Incluir sistema de control de acceso
    require '../../backend/php/check_access.php';
    
    // Verificar que tenga permiso para ver historial
    if(!hasModulePermission('usuarios') && !hasSubmenuPermission('usuarios_historial')){
        header('location: ../acceso_denegado.php');
        exit;
    }
    
    require '../../backend/bd/Conexion.php';
    
    /**
     * Devuelve el nombre de la columna que relaciona la tabla con registro_estudiantes.
     * Prioriza id_estudiante (nueva estructura) y cae en idpa para tablas antiguas.
     */
    function getStudentColumn(PDO $connection, string $table): string {
        static $cache = [];
        if(isset($cache[$table])) {
            return $cache[$table];
        }
        
        $allowedTables = [
            'valoracionriesgo','toral','saludmental','medicamentos',
            'consult','genogram','treatment','fisioterapia'
        ];
        if(!in_array($table, $allowedTables, true)) {
            throw new InvalidArgumentException("Tabla no permitida: {$table}");
        }
        
        try {
            $stmt = $connection->query("SHOW COLUMNS FROM {$table} LIKE 'id_estudiante'");
            if($stmt && $stmt->fetch()) {
                return $cache[$table] = 'id_estudiante';
            }
        } catch (Throwable $e) {
            // Silenciar: si la tabla no existe o falla el SHOW COLUMNS, continuamos con fallback
        }
        
        return $cache[$table] = 'idpa';
    }
    
    // Obtener permisos del usuario desde menu_permissions
    $userId = $_SESSION['id'];
    $userPermissions = [];
    
    // Admin siempre tiene acceso total
    if($_SESSION['rol'] == 1) {
        $userPermissions = [
            'view_valoracion_riesgo' => 1,
            'edit_valoracion_riesgo' => 1,
            'view_salud_oral' => 1,
            'edit_salud_oral' => 1,
            'view_salud_mental' => 1,
            'edit_salud_mental' => 1,
            'view_signos_vitales' => 1,
            'edit_signos_vitales' => 1,
            'view_medicamentos' => 1,
            'edit_medicamentos' => 1,
            'view_diagnostico' => 1,
            'edit_diagnostico' => 1,
            'view_antecedentes' => 1,
            'edit_antecedentes' => 1,
            'view_examenes' => 1,
            'edit_examenes' => 1,
            'view_fisioterapia' => 1,
            'edit_fisioterapia' => 1
        ];
    } else {
        // Obtener permisos de menu_permissions
        if(isset($_SESSION['menu_permissions'])) {
            $menuPerms = $_SESSION['menu_permissions'];
            
            $userPermissions = [
                'view_valoracion_riesgo' => isset($menuPerms['historia_riesgo_social_ver']) ? $menuPerms['historia_riesgo_social_ver'] : 0,
                'edit_valoracion_riesgo' => isset($menuPerms['historia_riesgo_social_modificar']) ? $menuPerms['historia_riesgo_social_modificar'] : 0,
                'view_salud_oral' => isset($menuPerms['historia_salud_oral_ver']) ? $menuPerms['historia_salud_oral_ver'] : 0,
                'edit_salud_oral' => isset($menuPerms['historia_salud_oral_modificar']) ? $menuPerms['historia_salud_oral_modificar'] : 0,
                'view_salud_mental' => isset($menuPerms['historia_salud_mental_ver']) ? $menuPerms['historia_salud_mental_ver'] : 0,
                'edit_salud_mental' => isset($menuPerms['historia_salud_mental_modificar']) ? $menuPerms['historia_salud_mental_modificar'] : 0,
                'view_signos_vitales' => isset($menuPerms['historia_signos_vitales_ver']) ? $menuPerms['historia_signos_vitales_ver'] : 0,
                'edit_signos_vitales' => isset($menuPerms['historia_signos_vitales_modificar']) ? $menuPerms['historia_signos_vitales_modificar'] : 0,
                'view_medicamentos' => isset($menuPerms['historia_medicamentos_ver']) ? $menuPerms['historia_medicamentos_ver'] : 0,
                'edit_medicamentos' => isset($menuPerms['historia_medicamentos_modificar']) ? $menuPerms['historia_medicamentos_modificar'] : 0,
                'view_diagnostico' => isset($menuPerms['historia_diagnostico_ver']) ? $menuPerms['historia_diagnostico_ver'] : 0,
                'edit_diagnostico' => isset($menuPerms['historia_diagnostico_modificar']) ? $menuPerms['historia_diagnostico_modificar'] : 0,
                'view_antecedentes' => isset($menuPerms['historia_antecedentes_ver']) ? $menuPerms['historia_antecedentes_ver'] : 0,
                'edit_antecedentes' => isset($menuPerms['historia_antecedentes_modificar']) ? $menuPerms['historia_antecedentes_modificar'] : 0,
                'view_examenes' => isset($menuPerms['historia_examenes_ver']) ? $menuPerms['historia_examenes_ver'] : 0,
                'edit_examenes' => isset($menuPerms['historia_examenes_modificar']) ? $menuPerms['historia_examenes_modificar'] : 0,
                'view_fisioterapia' => isset($menuPerms['historia_fisioterapia_ver']) ? $menuPerms['historia_fisioterapia_ver'] : 0,
                'edit_fisioterapia' => isset($menuPerms['historia_fisioterapia_modificar']) ? $menuPerms['historia_fisioterapia_modificar'] : 0
            ];
        } else {
            // Sin permisos configurados
            $userPermissions = [
                'view_valoracion_riesgo' => 0,
                'edit_valoracion_riesgo' => 0,
                'view_salud_oral' => 0,
                'edit_salud_oral' => 0,
                'view_salud_mental' => 0,
                'edit_salud_mental' => 0,
                'view_signos_vitales' => 0,
                'edit_signos_vitales' => 0,
                'view_medicamentos' => 0,
                'edit_medicamentos' => 0,
                'view_diagnostico' => 0,
                'edit_diagnostico' => 0,
                'view_antecedentes' => 0,
                'edit_antecedentes' => 0,
                'view_examenes' => 0,
                'edit_examenes' => 0,
                'view_fisioterapia' => 0,
                'edit_fisioterapia' => 0
            ];
        }
    }
    
    // Hacer disponible para el helper
    $GLOBALS['userPermissions'] = $userPermissions;
    
    // Incluir helper de permisos
    require '../../backend/php/apply_permissions_historia.php';
    
    $loggedUserId = $_SESSION['id'];
    $studentId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
    
    if($studentId <= 0) {
        header('location: ../pacientes/mostrar.php');
        exit;
    }
    
    $forceShowAllSections = true;
    
    $id=$_SESSION['id'];
?>
<!DOCTYPE html>
<html lang="es">
<head>


<style>
/* Estilos para el checkbox y modal */

#btns-riesgo {
    display: none;
}

#btns-riesgo:checked ~ .container-modal {
    display: flex;
}

#btns-medicamentos {
    display: none;
}

#btns-medicamentos:checked ~ .container-modal {
    display: flex;
}


#btns-toral {
    display: none;
}

#btns-toral:checked ~ .container-modal {
    display: flex;
}

#btns-saludmental {
    display: none;
}

#btns-saludmental:checked ~ .container-modal {
    display: flex;
}



/* Ajustes adicionales para el modal */
.container-modal {
    width: 100%;
    height: 100vh;
    position: fixed;
    top: 0;
    left: 0;
    background-color: rgba(53, 9, 73, 0.8);
    display: none;
    justify-content: center;
    align-items: center;
    z-index: 99100;
    overflow-y: auto;
}

/* Accordion Styles */
.accordion {
    background-color: var(--bg-card);
    color: var(--text-light);
    cursor: pointer;
    padding: 18px;
    width: 100%;
    border: none;
    text-align: left;
    outline: none;
    font-size: 15px;
    transition: 0.4s;
    border-radius: 12px;
    margin-bottom: 5px;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.accordion .permission-badge {
    margin-left: auto;
}

.student-info-card {
    background: var(--bg-card);
    border-radius: 20px;
    padding: 24px;
    margin-bottom: 32px;
    box-shadow: 0 15px 35px rgba(0,0,0,0.25);
}

.student-card-header {
    display: flex;
    flex-wrap: wrap;
    justify-content: space-between;
    gap: 16px;
    align-items: flex-start;
    margin-bottom: 20px;
}

.student-card-header .eyebrow {
    text-transform: uppercase;
    letter-spacing: 0.12em;
    font-size: 11px;
    color: var(--text-grey);
    margin: 0 0 4px 0;
}

.student-card-header h2 {
    margin: 0;
    font-size: 26px;
    color: var(--text-light);
}

.student-card-header .meta {
    margin: 4px 0 0;
    color: var(--text-grey);
}

.student-card-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    gap: 16px;
}

.info-pill {
    background: rgba(255,255,255,0.04);
    border: 1px solid rgba(255,255,255,0.06);
    border-radius: 16px;
    padding: 14px 16px;
    display: flex;
    flex-direction: column;
}

.info-pill .label {
    font-size: 12px;
    text-transform: uppercase;
    color: var(--text-grey);
    letter-spacing: 0.08em;
}

.info-pill .value {
    font-size: 15px;
    color: var(--text-light);
    margin-top: 4px;
    font-weight: 600;
}

.button-outline {
    border: 1px solid var(--primary);
    color: var(--primary);
    border-radius: 999px;
    padding: 10px 22px;
    text-decoration: none;
    transition: background 0.2s ease, color 0.2s ease;
}

.button-outline:hover {
    background: var(--primary);
    color: #fff;
}

.swal-overlay,
.swal2-container {
    z-index: 999999 !important;
}

.swal-modal,
.swal2-popup {
    z-index: 1000000 !important;
}

.active, .accordion:hover {
    background-color: rgba(255, 255, 255, 0.05); 
}

.accordion:after {
    content: '\002B'; /* Plus symbol */
    color: var(--text-light);
    font-weight: bold;
    float: right;
    margin-left: 5px;
    font-size: 20px;
}

.accordion.active:after {
    content: "\2212"; /* Minus symbol */
}

.panel {
    padding: 0 18px;
    background-color: transparent;
    max-height: 0;
    overflow: hidden;
    margin-bottom: 10px;
    opacity: 0;
    transition: opacity 0.3s ease, max-height 0.3s ease;
    display: none;
}

.panel.show-panel {
    display: block;
    max-height: 2000px; /* Arbitrary large height */
    opacity: 1;
}

/* Normalized Button Modal Styles */
.botons-modals label,
.botons-modal label,
.boton-modal label {
    display: inline-block;
    padding: 10px 20px;
    background: var(--btn-gradient); /* Use theme gradient */
    color: white;
    cursor: pointer;
    border-radius: 12px; /* Match theme radius */
    font-weight: 600;
    text-align: center;
    box-shadow: 0 4px 15px rgba(221, 36, 118, 0.3);
    transition: all 0.3s ease;
    margin: 15px 0;
}

.botons-modals label:hover,
.botons-modal label:hover,
.boton-modal label:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(221, 36, 118, 0.5);
}
</style>




    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    



    <title>EFAC | Historia EFAC</title>
</head>
<body>

    <?php include '../../backend/php/sidebar_menu.php'; ?>


    <!-- NAVBAR -->
    <section id="content">

        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar' ></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Search...">
                    <i class='bx bx-search icon' ></i>
                </div>
            </form>
            
           
            <span class="divider"></span>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
              <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon' ></i> Profile</a></li>
                    
                    <li>
                     <a href="../salir.php"><i class='bx bxs-log-out-circle' ></i> Logout</a>
                    </li>
                   
                </ul>
            </div>
        </nav>
        <!-- NAVBAR -->

        <!-- MAIN -->

        <main>
            <h1 class="title">Bienvenido <?php echo '<strong>'.$_SESSION['username'].'</strong>'; ?></h1>
            <ul class="breadcrumbs">
                <li><a href="../admin/escritorio.php">Home</a></li>
                <li class="divider">></li>
                <li><a href="../pacientes/mostrar.php">Listado de los Abuelos</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Informe del Estudiante  </a></li>
            </ul>
           <br>

           <?php 
 // Updated query to fetch from registro_estudiantes
 $sentencia = $connect->prepare("SELECT * FROM registro_estudiantes WHERE id = ?");
 $sentencia->execute([$studentId]);

$data =  array();
if($sentencia){
  while($r = $sentencia->fetchObject()){
    $data[] = $r;
  }
}
   ?>
   <?php if(count($data)>0):?>
        <?php foreach($data as $d):?>
<div class="student-info-card">
    <div class="student-card-header">
        <div>
            <p class="eyebrow">Ficha del estudiante</p>
            <h2><?php echo htmlspecialchars(trim(($d->nombres ?? '') . ' ' . ($d->apellidos ?? '')) ?: 'Estudiante'); ?></h2>
            <p class="meta"><?php echo $d->modalidad ?? 'Modalidad no definida'; ?></p>
        </div>
        <a href="../pacientes/imprimir.php?id=<?php echo $d->id; ?>" class="button-outline">Imprimir reporte</a>
    </div>
    <div class="student-card-grid">
        <div class="info-pill">
            <span class="label">Documento</span>
            <span class="value"><?php echo $d->numero_documento ?? '—'; ?></span>
        </div>
        <div class="info-pill">
            <span class="label">Nombres</span>
            <span class="value"><?php echo $d->nombres ?? '—'; ?></span>
        </div>
        <div class="info-pill">
            <span class="label">Apellidos</span>
            <span class="value"><?php echo $d->apellidos ?? '—'; ?></span>
        </div>
        <div class="info-pill">
            <span class="label">Dirección</span>
            <span class="value"><?php echo $d->direccion ?? '—'; ?></span>
        </div>
        <div class="info-pill">
            <span class="label">Fecha de nacimiento</span>
            <span class="value"><?php echo $d->fecha_nacimiento ?? '—'; ?></span>
        </div>
        <div class="info-pill">
            <span class="label">Género</span>
            <span class="value"><?php echo $d->genero ?? '—'; ?></span>
        </div>
        <div class="info-pill">
            <span class="label">Grupo sanguíneo</span>
            <span class="value"><?php echo $d->grupo_sanguineo ?? '—'; ?></span>
        </div>
        <div class="info-pill">
            <span class="label">Teléfono</span>
            <span class="value"><?php echo $d->telefono ?? '—'; ?></span>
        </div>
    </div>
</div>





<div class="data">



    <div class="content-data">



    <?php if(!shouldHideSection('valoracion_riesgo')): ?>
    <button class="accordion">Diagnostico Inicial<?php echo showPermissionBadge('valoracion_riesgo'); ?></button>
<div class="panel">
    <div class="botons-modals">
        <label for="btns-riesgo" <?php echo getButtonStyle('valoracion_riesgo'); ?>>
            Nuevo
        </label>
    </div>

    <div class="table-responsive" style="overflow-x:auto;">
        <?php 
        $studentColumn = getStudentColumn($connect, 'valoracionriesgo');
        $query = "SELECT * FROM valoracionriesgo WHERE {$studentColumn} = ?";
        $sentencia = $connect->prepare($query);
        $sentencia->execute([$studentId]);
$data =  array();
if($sentencia){
  while($r = $sentencia->fetchObject()){
    $data[] = $r;
  }
}
         ?>
         <?php if(count($data)>0):?>
        <table class="responsive-table">
            <thead>
                <tr>
                    <th scope="col">Fecha</th>
                    <th scope="col">Nivel Desempeño</th>
                    <th scope="col">Conocimientos Consolidados</th>
                    <th scope="col">Conocimientos Previos</th>
                    <th scope="col">Gestion Cognitivo</th>
                    <th scope="col">Gestion procedimental</th>
                    <th scope="col">fallas de aprendizaje</th>
                    <th scope="col">Estrategias estudiantiles</th>
                    <th scope="col">modo de aprendizaje</th>
                    <th scope="col">proceso de aprendizaje</th>
                    <th scope="col">Grado de autonomia</th>
                    <th scope="col">Obsevacion pedagogica</th>
                   
                </tr>
            </thead>

            <tbody>
                <?php foreach($data as $f):?>
                <tr>
                     <th scope="row"><?php echo $f->fere; ?></th>
                     <th scope="row"><?php echo $f->niveldesempeño; ?></th>
                     <td data-title="Conocimientosconsolidados"><?php echo $f->Conocimientosconsolidados; ?></td>
                     <td data-title="Conocimientosprevios"><?php echo $f->Conocimientosprevios; ?></td>
                     <td data-title="Habilidadescognitivas"><?php echo $f->Habilidadescognitivas; ?></td>
                     <td data-title="Habilidadesprocedimentales"><?php echo $f->Habilidadesprocedimentales; ?></td>
                     <td data-title="Dificultadesaprendizaje"><?php echo $f->Dificultadesaprendizaje; ?></td>
                     <td data-title="estrategiasestudiante"><?php echo $f->estrategiasestudiante; ?></td>
                     <td data-title="estiloaprendizaje"><?php echo $f->estiloaprendizaje; ?></td>
                     <td data-title="Procesoaprendizaje"><?php echo $f->Procesoaprendizaje; ?></td>
                     <td data-title="Autonomiaacademica"><?php echo $f->Autonomiaacademica; ?></td>
                     <td data-title="Observacionespedagogicas"><?php echo $f->Observacionespedagogicas; ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else:?>
      <p class="alert alert-warning">No hay datos</p>
    <?php endif; ?>
    </div>

</div>
<?php endif; // Fin de valoracion_riesgo ?>


 <!-- *//AQUI EMPIAZA CODIGO INGRESADO* -->
 
 <?php if(!shouldHideSection('salud_oral')): ?>
 <button class="accordion">Desarrollo de Habilidades Artísticas <?php echo showPermissionBadge('salud_oral'); ?></button>
<div class="panel">
    <div class="botons-modal">
        <label for="btns-toral" <?php echo getButtonStyle('salud_oral'); ?>>
            Nuevo
        </label>
    </div>

    <div class="table-responsive" style="overflow-x:auto;">
        <?php 
        $studentColumn = getStudentColumn($connect, 'toral');
        $query = "SELECT * FROM toral WHERE {$studentColumn} = ?";
        $sentencia = $connect->prepare($query);
        $sentencia->execute([$studentId]);
$data =  array();
if($sentencia){
  while($r = $sentencia->fetchObject()){
    $data[] = $r;
  }
}
         ?>
         <?php if(count($data)>0):?>
        <table class="responsive-table">
            <thead>
                <tr>
                    <th scope="col">Creatividad</th>
                    <th scope="col">Expresión artística</th>
                    <th scope="col">Técnica</th>
                    <th scope="col">Sensibilidad estética</th>
                    <th scope="col">Disciplina y constancia</th>
                    <th scope="col">Trabajo en equipo</th>
                    <th scope="col">Interpretación</th>
                    <th scope="col">Coordinación y control corporal / motriz</th>
                    <th scope="col">Ritmo y musicalidad</th>
                    <th scope="col">Observación y percepción</th>
                    <th scope="col">Imaginación</th>
                    <th scope="col">Comunicación</th>
                    <th scope="col">observaciones</th>
                </tr>
            </thead>

            <tbody>
                <?php foreach($data as $f):?>
                <tr>

                     <th scope="row"><?php echo $f->Creatividad; ?></th>
                     <td data-title="Expresionartistica"><?php echo $f->Expresionartistica; ?></td>
                     <td data-title="Tecnica"><?php echo $f->Tecnica; ?></td>
                     <td data-title="Sensibilidadestetica"><?php echo $f->Sensibilidadestetica; ?></td>
                     <td data-title="Disciplinaconstancia"><?php echo $f->Disciplinaconstancia; ?></td>
                     <td data-title="trabajoequipo"><?php echo $f->trabajoequipo; ?></td>
                     <td data-title="Interpretacion"><?php echo $f->Interpretacion; ?></td>
                     <td data-title="Controlcorporal"><?php echo $f->Controlcorporal; ?></td>
                     <td data-title="Ritmomusica"><?php echo $f->Ritmomusica; ?></td>
                     <td data-title="Observacionpersep"><?php echo $f->Observacionpersep; ?></td>
                     <td data-title="Imaginacion"><?php echo $f->Imaginacion; ?></td>
                     <td data-title="Comunicacion"><?php echo $f->Autonomia; ?></td>
                     <td data-title="observaciones"><?php echo $f->observaciones; ?></td>


                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else:?>
      <p class="alert alert-warning">No hay datos</p>
    <?php endif; ?>
    </div>
  
</div>
<?php endif; // Fin de salud_oral ?>


<!-- *//AQUI EMPIAZA CODIGO INGRESADO* -->
 
<?php if(!shouldHideSection('salud_mental')): ?>
<button class="accordion">Disciplina y Actitud <?php echo showPermissionBadge('salud_mental'); ?></button>
<div class="panel">
    <div class="botons-modal">
        <label for="btns-saludmental" <?php echo getButtonStyle('salud_mental'); ?>>
            Nuevo
        </label>
    </div>

    <div class="table-responsive" style="overflow-x:auto;">
        <?php 
        $studentColumn = getStudentColumn($connect, 'saludmental');
        $query = "SELECT * FROM saludmental WHERE {$studentColumn} = ?";
        $sentencia = $connect->prepare($query);
        $sentencia->execute([$studentId]);
$data =  array();
if($sentencia){
  while($r = $sentencia->fetchObject()){
    $data[] = $r;
  }
}
         ?>
         <?php if(count($data)>0):?>
        <table class="responsive-table">
            <thead>
                <tr>
                    <th scope="col">Puntualidad</th>
                    <th scope="col">Asistencia</th>
                    <th scope="col">Responsabilidad</th>
                    <th scope="col">Respeto</th>
                    <th scope="col">Compromiso</th>
                    <th scope="col">Actitud positiva</th>
                    <th scope="col">Trabajo en equipo</th>
                    <th scope="col">Seguimiento de instrucciones</th>
                    <th scope="col">Autocontrol</th>
                    <th scope="col">orden y cuidado de materiales</th>
                    <th scope="col">Participacion activa</th>
                    <th scope="col">Esfuerzo y dedicacion</th>
                    <th scope="col">Tolerancia</th>
                    <th scope="col">Disposicion al cambio</th>
                    <th scope="col">Convivencia</th>
                    <th scope="col">Presentacion personal</th>
                    <th scope="col">Honestidad</th>
                    <th scope="col">Etica</th>
                    <th scope="col">Empatia</th>
                    <th scope="col">Comunicación asertiva</th>
                    <th scope="col">Cooperacion</th>
                    <th scope="col">Proactividad</th>
                    <th scope="col">Perseverancia</th>
                    <th scope="col">Cumplimiento de normas</th>
                    <th scope="col">Organización personal</th>
                    <th scope="col">Manejo del tiempo</th>
                    <th scope="col">Resolución de conflictos</th>
                    <th scope="col">Adaptabilidad</th>
                    <th scope="col">Iniciativa</th>
                    <th scope="col">Respeto por la autoridad</th>
                    <th scope="col">Responsabilidad social</th>
                    <th scope="col">Escucha activa</th>
                    <th scope="col">Toma de decisiones</th>
                    <th scope="col">Control de impulsos</th>
                    <th scope="col">Constancia</th>
                    <th scope="col">Actitud de servicio</th>
                    <th scope="col">Liderazgo positivo</th>
                </tr>
            </thead>

            <tbody>
                <?php foreach($data as $f):?>
                <tr>
                     <td data-title="Puntualidad"><?php echo $f->Puntualidad; ?></td>
                     <td data-title="Asistencia"><?php echo $f->Asistencia; ?></td>
                     <td data-title="Responsabilidad"><?php echo $f->Responsabilidad; ?></td>
                     <td data-title="respeto"><?php echo $f->respeto; ?></td>
                     <td data-title="Compromiso"><?php echo $f->Compromiso; ?></td>
                     <td data-title="actitudpositiva"><?php echo $f->actitudpositiva; ?></td>
                     <td data-title="trabajoequipo"><?php echo $f->trabajoequipo; ?></td>
                     <td data-title="seguimientoinstruciones"><?php echo $f->seguimientoinstruciones; ?></td>
                     <td data-title="Autocontrol"><?php echo $f->Autocontrol; ?></td>
                     <td data-title="cuidadomateriales"><?php echo $f->cuidadomateriales; ?></td>
                     <td data-title="participacionactiva"><?php echo $f->participacionactiva; ?></td>
                     <td data-title="esfuerzodedicacion"><?php echo $f->esfuerzodedicacion; ?></td>
                     <td data-title="Tolerancia"><?php echo $f->Tolerancia; ?></td>
                     <td data-title="Disposioncambio"><?php echo $f->Disposioncambio; ?></td>
                     <td data-title="Convivencia"><?php echo $f->Convivencia; ?></td>
                     <td data-title="Prevencionpersonal"><?php echo $f->Prevencionpersonal; ?></td>
                     <td data-title="Honestidad"><?php echo $f->Honestidad; ?></td>
                     <td data-title="etica"><?php echo $f->etica; ?></td>
                     <td data-title="empatia"><?php echo $f->empatia; ?></td>
                     <td data-title="comunidadasertiva"><?php echo $f->comunidadasertiva; ?></td>
                     <td data-title="Cooperacion"><?php echo $f->Cooperacion; ?></td>
                     <td data-title="proactividad"><?php echo $f->proactividad; ?></td>
                     <td data-title="Perseverancia"><?php echo $f->Perseverancia; ?></td>
                     <td data-title="Cumplimientonormas"><?php echo $f->Cumplimientonormas; ?></td>
                     <td data-title="Organizaciónpersonal"><?php echo $f->Organizaciónpersonal; ?></td>
                     <td data-title="Manejotiempo"><?php echo $f->Manejotiempo; ?></td>
                     <td data-title="Resoluciónconflictos"><?php echo $f->Resoluciónconflictos; ?></td>
                     <td data-title="Adaptabilidad"><?php echo $f->Adaptabilidad; ?></td>
                     <td data-title="Iniciativa"><?php echo $f->Iniciativa; ?></td>
                     <td data-title="Respetoautoridad"><?php echo $f->Respetoautoridad; ?></td>
                     <td data-title="Responsabilidadsocial"><?php echo $f->Responsabilidadsocial; ?></td>
                     <td data-title="Escuchaactiva"><?php echo $f->Escuchaactiva; ?></td>
                     <td data-title="Tomadecisiones"><?php echo $f->Tomadecisiones; ?></td>
                     <td data-title="Controlimpulsos"><?php echo $f->Controlimpulsos; ?></td>
                     <td data-title="Constancia"><?php echo $f->Constancia; ?></td>
                     <td data-title="Actitudservicio"><?php echo $f->Actitudservicio; ?></td>
                     <td data-title="Liderazgopositivo"><?php echo $f->Liderazgopositivo; ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else:?>
      <p class="alert alert-warning">No hay datos</p>
    <?php endif; ?>
    </div>
  
</div>
<?php endif; // Fin de salud_mental ?>


<!-- Aqui Finaliza* -->


<!-- *//AQUI EMPIAZA CODIGO INGRESADO* -->
 
<?php if(!shouldHideSection('medicamentos')): ?>
<button class="accordion">Trabajo en Equipo y Convivencia <?php echo showPermissionBadge('medicamentos'); ?></button>
<div class="panel">
    <div class="botons-modal">
        <label for="btns-medicamentos" <?php echo getButtonStyle('medicamentos'); ?>>
            Nuevo
        </label>
    </div>

    <div class="table-responsive" style="overflow-x:auto;">
        <?php 
        $studentColumn = getStudentColumn($connect, 'medicamentos');
        $query = "SELECT * FROM medicamentos WHERE {$studentColumn} = ? AND state = 1 ORDER BY fere DESC";
        $sentencia = $connect->prepare($query);
        $sentencia->execute([$studentId]);
$data = array();
if($sentencia){
  while($r = $sentencia->fetchObject()){
    $data[] = $r;
  }
}
         ?>
         <?php if(count($data)>0):?>
        <table class="responsive-table">
            <thead>
                <tr>
                    <th scope="col">Comunicación asertiva</th>
                    <th scope="col">Respeto mutuo</th>
                    <th scope="col">Colaboración</th>
                    <th scope="col">Resolución pacífica</th>
                    <th scope="col">Empatía</th>
                    <th scope="col">Responsabilidad compartida</th>
                    <th scope="col">Liderazgo participativo</th>
                    <th scope="col">Toma decisiones</th>
                    <th scope="col">Escucha activa</th>
                    <th scope="col">Confianza interpersonal</th>
                    <th scope="col">Manejo de emociones</th>
                    <th scope="col">Solidaridad</th>
                    <th scope="col">Compromiso colectivo</th>
                    <th scope="col">Inclusión y diversidad</th>
                    <th scope="col">Cumplimiento normas</th>
                    <th scope="col">Cooperación</th>
                    <th scope="col">Sentido pertenencia</th>
                    <th scope="col">Trabajo colaborativo</th>
                    <th scope="col">Adaptabilidad</th>
                    <th scope="col">Ética y valores</th>
                    <th scope="col">Apoyo mutuo</th>
                    <th scope="col">Clima organizacional</th>
                </tr>
            </thead>

            <tbody>
                <?php foreach($data as $f):?>
                <tr>
                     <td data-title="Comunicación asertiva"><?php echo $f->tomam; ?></td>
                     <td data-title="Respeto mutuo"><?php echo $f->cualm; ?></td>
                     <td data-title="Colaboración"><?php echo $f->prescripcion; ?></td>
                     <td data-title="Resolución pacífica"><?php echo $f->automedicacion; ?></td>
                     <td data-title="Empatía"><?php echo $f->quirurgicos; ?></td>
                     <td data-title="Responsabilidad compartida"><?php echo $f->hospitalizacion; ?></td>
                     <td data-title="Liderazgo participativo"><?php echo $f->traumaticos; ?></td>
                     <td data-title="Toma decisiones"><?php echo $f->hipertencion; ?></td>
                     <td data-title="Escucha activa"><?php echo $f->toxico; ?></td>
                     <td data-title="Confianza interpersonal"><?php echo $f->alergico; ?></td>
                     <td data-title="Manejo de emociones"><?php echo $f->infeccioso; ?></td>
                     <td data-title="Solidaridad"><?php echo $f->enfermedadr; ?></td>
                     <td data-title="Compromiso colectivo"><?php echo $f->ulcera; ?></td>
                     <td data-title="Inclusión y diversidad"><?php echo $f->lepra; ?></td>
                     <td data-title="Cumplimiento normas"><?php echo $f->diabetes; ?></td>
                     <td data-title="Cooperación"><?php echo $f->asma; ?></td>
                     <td data-title="Sentido pertenencia"><?php echo $f->cancer; ?></td>
                     <td data-title="Trabajo colaborativo"><?php echo $f->epoc; ?></td>
                     <td data-title="Adaptabilidad"><?php echo $f->epilepsia; ?></td>
                     <td data-title="Ética y valores"><?php echo $f->autoinmunes; ?></td>
                     <td data-title="Apoyo mutuo"><?php echo $f->ingresourgencias; ?></td>
                     <td data-title="Clima organizacional"><?php echo $f->otrom; ?></td>


                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else:?>
      <p class="alert alert-warning">No hay datos</p>
    <?php endif; ?>
    </div>
  
</div>
<?php endif; // Fin de medicamentos ?>


<!-- Aqui Finaliza* -->


<?php if(!shouldHideSection('signos_vitales')): ?>
<button class="accordion">Presentaciones y Participación en Eventos <?php echo showPermissionBadge('signos_vitales'); ?></button>
<div class="panel">
    <div class="botons-modal">
        <label for="btns-modal" <?php echo getButtonStyle('signos_vitales'); ?>>
            Nuevo
        </label>
    </div>

    <div class="table-responsive" style="overflow-x:auto;">
        <?php 
        $studentColumn = getStudentColumn($connect, 'consult');
        $query = "SELECT * FROM consult WHERE {$studentColumn} = ? AND state = 1 ORDER BY fere DESC";
        $sentencia = $connect->prepare($query);
        $sentencia->execute([$studentId]);
$data = array();
if($sentencia){
  while($r = $sentencia->fetchObject()){
    $data[] = $r;
  }
}
         ?>
         <?php if(count($data)>0):?>
        <table class="responsive-table">
            <thead>
                <tr>
                    <th scope="col">Fecha</th>    
                    <th scope="col">Expresión oral</th>
                    <th scope="col">Dominio del tema</th>
                    <th scope="col">Preparación contenidos</th>
                    <th scope="col">Uso del lenguaje</th>
                    <th scope="col">Comunicación verbal</th>
                    <th scope="col">Com. no verbal</th>
                    <th scope="col">Manejo del tiempo</th>
                    <th scope="col">Claridad mensaje</th>
                    <th scope="col">Ayudas visuales</th>
                    <th scope="col">Creatividad</th>
                    <th scope="col">Seguridad escénica</th>
                    <th scope="col">Capacidad argumentación</th>
                    <th scope="col">Interacción público</th>
                    <th scope="col">Participación activa</th>
                    <th scope="col">Investigación previa</th>
                    <th scope="col">Organización ideas</th>
                    <th scope="col">Adaptación contexto</th>
                    <th scope="col">Manejo recursos</th>
                    <th scope="col">Improvisación</th>
                    <th scope="col">Respeto normas</th>
                    <th scope="col">Trabajo en equipo</th>
                    <th scope="col">Retroalimentación</th>
                  
                </tr>
            </thead>

            <tbody>
                <?php foreach($data as $f):?>
                <tr>
                    
                    <td data-title="Fecha"><?php echo $f->fere; ?></td>
                     <td data-title="Expresión oral"><?php echo $f->mtcl; ?></td>
                     <td data-title="Dominio del tema"><?php echo $f->SV; ?></td>
                     <td data-title="Preparación contenidos"><?php echo $f->FC; ?></td>
                     <td data-title="Uso del lenguaje"><?php echo $f->FR; ?></td>
                     <td data-title="Comunicación verbal"><?php echo $f->TMP; ?></td>
                     <td data-title="Com. no verbal"><?php echo $f->T; ?></td>
                     <td data-title="Manejo del tiempo"><?php echo $f->P; ?></td>
                     <td data-title="Claridad mensaje"><?php echo $f->IMC; ?></td>
                     <td data-title="Ayudas visuales"><?php echo $f->PA; ?></td>
                     <td data-title="Creatividad"><?php echo $f->PC; ?></td>
                     <td data-title="Seguridad escénica"><?php echo $f->GL; ?></td>
                     <td data-title="Capacidad argumentación"><?php echo $f->TV; ?></td>
                     <td data-title="Interacción público"><?php echo $f->TA; ?></td>
                     <td data-title="Participación activa"><?php echo $f->CB_CL; ?></td>
                     <td data-title="Investigación previa"><?php echo $f->NEU; ?></td>
                     <td data-title="Organización ideas"><?php echo $f->TRX; ?></td>
                     <td data-title="Adaptación contexto"><?php echo $f->DOR; ?></td>
                     <td data-title="Manejo recursos"><?php echo $f->ABD; ?></td>
                     <td data-title="Improvisación"><?php echo $f->PIE; ?></td>
                     <td data-title="Respeto normas"><?php echo $f->GUN; ?></td>
                     <td data-title="Trabajo en equipo"><?php echo $f->EXT; ?></td>
                     <td data-title="Retroalimentación"><?php echo $f->LIM; ?></td>

                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else:?>
      <p class="alert alert-warning">No hay datos</p>
    <?php endif; ?>
    </div>
  
</div>
<?php endif; // Fin de signos_vitales ?>


<?php if(!shouldHideSection('diagnostico')): ?>
       <button class="accordion">Acompañamiento Familiar y Trabajo en Casa <?php echo showPermissionBadge('diagnostico'); ?></button>
<div class="panel">
    <div class="boton-modal">
        <label for="btn-modal" <?php echo getButtonStyle('diagnostico'); ?>>
            Nuevo
        </label>
    </div>


<div class="timeline">
    <?php 
    $studentColumn = getStudentColumn($connect, 'genogram');
    $query = "SELECT * FROM genogram WHERE {$studentColumn} = ?";
    $sentencia = $connect->prepare($query);
    $sentencia->execute([$studentId]);

$data =  array();
if($sentencia){
  while($r = $sentencia->fetchObject()){
    $data[] = $r;
  }
}

 ?>
 <?php  if(count($data)>0):?>

        <?php foreach($data as $e):?>
    <div class="entry" style="margin-top: 20px;" id="tbody">
      <div class="core">
      <h3><?php echo $e->fere; ?></h3>
        <?php echo $e->detage; ?>
      </div>
    </div>

<?php endforeach; ?>
  
    <?php else:?>
      <p class="alert alert-warning">No hay datos</p>
    <?php endif; ?>
   
</div>


</div>
<?php endif; // Fin de diagnostico ?>


<?php if(!shouldHideSection('antecedentes')): ?>
<button class="accordion">Compromiso y Responsabilidad<?php echo showPermissionBadge('antecedentes'); ?></button>
<div class="panel">

    <div class="botons-modals">

        <label for="btns-modals" <?php echo getButtonStyle('antecedentes'); ?>>
            Nuevo
        </label>
    </div>

    <div class="table-responsive" style="overflow-x:auto;">
<?php 
        $studentColumn = getStudentColumn($connect, 'treatment');
        $query = "SELECT * FROM treatment WHERE {$studentColumn} = ?";
        $sentencia = $connect->prepare($query);
        $sentencia->execute([$studentId]);
$data =  array();
if($sentencia){
  while($r = $sentencia->fetchObject()){
    $data[] = $r;
  }
}
         ?>
         <?php if(count($data)>0):?>
        <table class="responsive-table">
            <thead>
                <tr>
                    <th scope="col">USUARIO</th>
                    <th scope="col">Tratamiento</th>
                    <th scope="col">Fecha</th>
                    
                </tr>
            </thead>

            <tbody>
                 <?php foreach($data as $a):?>
                 <tr>
                     <th scope="row"><?php echo $a->nompa; ?></th>
                     <td data-title="Motivo"><?php echo $a->nomtra; ?></td>
                     <td data-title="Fecha"><?php echo $a->fere; ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <?php else:?>
      <p class="alert alert-warning">No hay datos</p>
    <?php endif; ?>
    </div>

</div> 

<?php endif; // Fin de antecedentes ?>


<!-- FISIOTERAPIA -->
<?php if(!shouldHideSection('fisioterapia')): ?>
<button class="accordion">FISIOTERAPIA <?php echo showPermissionBadge('fisioterapia'); ?></button>
<div class="panel">
    <div class="botons-modal">
        <label for="btns-fisioterapia" <?php echo getButtonStyle('fisioterapia'); ?>>
            Nuevo
        </label>
    </div>

    <div class="table-responsive" style="overflow-x:auto;">
        <?php 
        $studentColumn = getStudentColumn($connect, 'fisioterapia');
        $query = "SELECT * FROM fisioterapia WHERE {$studentColumn} = ? AND state = 1 ORDER BY fere DESC";
        $sentencia = $connect->prepare($query);
        $sentencia->execute([$studentId]);
        $data = array();
        if($sentencia){
            while($r = $sentencia->fetchObject()){
                $data[] = $r;
            }
        }
        ?>
        <?php if(count($data)>0):?>
        <table class="responsive-table">
            <thead>
                <tr>
                    <th scope="col">Fecha</th>
                    <th scope="col">Usuario</th>
                    <th scope="col">Sentarse y Levantarse</th>
                    <th scope="col">Flexiones de Brazo</th>
                    <th scope="col">Flexión de Tronco</th>
                    <th scope="col">Juntar Manos Atrás</th>
                    <th scope="col">Romberg</th>
                    <th scope="col">IPAQ</th>
                    <th scope="col">Alcance Funcional</th>
                    <th scope="col">BARTHEL</th>
                    <th scope="col">Funcionalidad</th>
                </tr>
            </thead>

            <tbody>
                <?php foreach($data as $f):?>
                <tr>
                    <td data-title="Fecha"><?php echo $f->fere; ?></td>
                    <td data-title="Usuario"><?php echo $f->nompa; ?></td>
                    <td data-title="Sentarse y Levantarse"><?php echo $f->sentarse_levantarse; ?></td>
                    <td data-title="Flexiones de Brazo"><?php echo $f->flexiones_brazo; ?></td>
                    <td data-title="Flexión de Tronco"><?php echo $f->flexion_tronco; ?></td>
                    <td data-title="Juntar Manos Atrás"><?php echo $f->juntar_manos_atras; ?></td>
                    <td data-title="Romberg"><?php echo $f->romberg; ?></td>
                    <td data-title="IPAQ"><?php echo $f->ipaq; ?></td>
                    <td data-title="Alcance Funcional"><?php echo $f->alcance_funcional; ?></td>
                    <td data-title="BARTHEL"><?php echo $f->barthel; ?></td>
                    <td data-title="Funcionalidad"><?php echo $f->funcionalidad; ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <?php else:?>
            <p class="alert alert-warning">No hay datos</p>
        <?php endif; ?>
    </div>
</div>
<?php endif; // Fin de fisioterapia ?>
<!-- FIN FISIOTERAPIA -->

    </div>
    
</div>

        <?php endforeach; ?>
  
    <?php else:?>
      <p class="alert alert-warning">No hay datos</p>
    <?php endif; ?>

        </main>
        <!-- MAIN -->
    </section>
<?php
    $modalStudent = $data[0] ?? null;
    if(!$modalStudent) {
        $modalStudent = (object)[];
    }
    if(!isset($modalStudent->idpa) || !$modalStudent->idpa) {
        $modalStudent->idpa = $studentId;
    }
    if(!isset($modalStudent->nompa) || !$modalStudent->nompa) {
        $fullName = trim(($modalStudent->nombres ?? '') . ' ' . ($modalStudent->apellidos ?? ''));
        $modalStudent->nompa = $fullName !== '' ? $fullName : ($_SESSION['username'] ?? 'Usuario');
    }
    $d = $modalStudent;
    $id_estudiante = $studentId;
?>
   <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>


    <!-- NAVBAR -->
    
    <script src="../../backend/js/script.js"></script>
    <script src="../../backend/js/multistep.js"></script>
    <script src="../../backend/js/vpat.js"></script>
    

    <script type="text/javascript">
    const popUp = document.getElementById("cookiePopup");
    const acceptCookieBtn = document.getElementById("acceptCookie");

    if (popUp && acceptCookieBtn) {
        //When user clicks the accept button
        acceptCookieBtn.addEventListener("click", () => {
          let d = new Date();
          d.setMinutes(2 + d.getMinutes());
          document.cookie = "myCookieName=thisIsMyCookie; expires = " + d + ";";
          popUp.classList.add("hide");
          popUp.classList.remove("shows");
        });
        
        //Check if cookie is already present
        const checkCookie = () => {
          let input = document.cookie.split("=");
          if (input[0] == "myCookieName") {
            popUp.classList.add("hide");
            popUp.classList.remove("shows");
          } else {
            popUp.classList.add("shows");
            popUp.classList.remove("hide");
          }
        };
        
        //Check if cookie exists when page loads
        window.addEventListener("load", () => {
          setTimeout(checkCookie, 2000);
        });
    }
    </script>

    <script>
const accordions = document.getElementsByClassName("accordion");
for (let i = 0; i < accordions.length; i++) {
  accordions[i].addEventListener("click", function() {
    this.classList.toggle("active");
    const panel = this.nextElementSibling;
    panel.classList.toggle("show-panel");
  });
}
</script>
<script>
(function() {
  function log(msg) {
    console.log(`[Historia|Accordion] ${msg}`);
  }

  document.addEventListener('DOMContentLoaded', function() {
    const sections = document.querySelectorAll('.accordion');
    log(`Secciones detectadas: ${sections.length}`);

    sections.forEach((btn, idx) => {
      log(`Sección ${idx + 1}: ${btn.textContent.trim()}`);
      btn.addEventListener('click', () => {
        log(`Click en: ${btn.textContent.trim()}`);
      });
    });
  });
})();
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js"></script>
<?php include_once '../../backend/modal/md_geog.php' ?>
<?php include_once '../../backend/modal/md_consul.php' ?>
<?php include_once '../../backend/modal/md_trat.php' ?>
<?php include_once '../../backend/modal/md_riesgo.php' ?>
<?php include_once '../../backend/modal/md_toral.php' ?>
<?php include_once '../../backend/modal/md_saludmental.php' ?>
<?php include_once '../../backend/modal/md_medicamentos.php' ?>
<?php include_once '../../backend/modal/md_fisioterapia.php' ?>



<script type="text/javascript">
    $(document).ready(function(){
$("#submit").click(function(){
var gedet = $("#gedet").val();
var geidpa = $("#geidpa").val();
var genopa = $("#genopa").val();

// Returns successful data submission message when the entered information is stored in database.
var dataString = 'det1='+ gedet + '&pa1='+ geidpa + '&nomp1='+ genopa;
if(gedet==''||geidpa==''||genopa=='')
{
alert("Please Fill All Fields");
}
else
{
// AJAX Code To Submit Form.
$.ajax({
type: "POST",
url: "add_ge.php",
data: dataString,
cache: false,
success: function(result){

alert(result);
$('#tbody').html(result);
}
});
}
return false;
});
});


  
</script>

<script type="text/javascript">
   function enviar(){
    var consl = document.getElementById('consl').value;
    var CSV = document.getElementById('CSV').value;
    var CFC = document.getElementById('CFC').value;
    var CFR = document.getElementById('CFR').value;
    var CTMP = document.getElementById('CTMP').value;
    var CT = document.getElementById('CT').value;
    var CP = document.getElementById('CP').value;
    var CIMC = document.getElementById('CIMC').value;
    var CPA = document.getElementById('CPA').value;
    var CPC = document.getElementById('CPC').value;
    var CGL = document.getElementById('CGL').value;
    var CTV = document.getElementById('CTV').value;
    var CTA = document.getElementById('CTA').value;
    var CB_CL = document.getElementById('CCB_CL').value;
    var CNEU = document.getElementById('CNEU').value;
    var CTRX = document.getElementById('CTRX').value;
    var CDOR = document.getElementById('CDOR').value;
    var CABD = document.getElementById('CABD').value;
    var CPIE = document.getElementById('CPIE').value;
    var CGUN = document.getElementById('CGUN').value;
    var CEXT = document.getElementById('CEXT').value;
    var CLIM = document.getElementById('CLIM').value;
    var csidpa = document.getElementById('csidpa').value;
    var csnopa = document.getElementById('csnopa').value;


    console.log("consl:", consl);
    console.log("CSV:", CSV);
    console.log("CFC:", CFC);
    console.log("CFR:", CFR);
    console.log("CTMP:", CTMP);
    console.log("CT:", CT);
    console.log("CP:", CP);
    console.log("CIMC:", CIMC);
    console.log("CPA:", CPA);
    console.log("CPC:", CPC);
    console.log("CGL:", CGL);
    console.log("CTV:", CTV);
    console.log("CTA:", CTA);
    console.log("CCB_CL:", CCB_CL);
    console.log("CNEU:", CNEU);
    console.log("CTRX:", CTRX);
    console.log("CDOR:", CDOR);
    console.log("CABD:", CABD);
    console.log("CPIE:", CPIE);
    console.log("CGUN:", CGUN);
    console.log("CEXT:", CEXT);
    console.log("CLIM:", CLIM);

    console.log("csidpa:", csidpa);
    console.log("csnopa:", csnopa);

    var dataen = 'consl='+consl + '&csidpa='+csidpa +'&csnopa='+csnopa +'&CSV='+CSV +'&CFC='+CFC +'&CFR='+CFR +'&CTMP='+CTMP +'&CT='+CT +'&CP='+CP   
    +'&CIMC='+CIMC +'&CPA='+CPA +'&CPC='+CPC +'&CGL='+CGL +'&CTV='+CTV +'&CTA='+CTA +'&CCB_CL='+CCB_CL +'&CNEU='+CNEU +'&CTRX='+CTRX +'&CDOR='+CDOR +'&CABD='+CABD +'&CPIE='+CPIE +'&CGUN='+CGUN + '&CEXT='+CEXT + '&CLIM='+CLIM 
    
    
    ;
    console.log("dataen:", dataen);
    
    $.ajax({
        type: "POST",
        url: "add_consut.php",
        data: dataen,
        cache: false,
        success: function(result){
            console.log("Respuesta:", result);
            if(result.includes('Agregado correctamente')) {
                swal(
                    'Agregado correctamente',
                    'Buen trabajo',
                    'success'
                ).then(function() {
                    location.reload();
                });
            } else {
                swal(
                    'Error',
                    result,
                    'error'
                );
            }
        },
        error: function(xhr, status, error) {
            console.error("Error:", error);
            swal(
                'Error',
                'Ha ocurrido un problema: ' + error,
                'error'
            )
        }
    });
}
</script>

<script type="text/javascript">
    function trata(){
       var trat = document.getElementById('trat').value; 
       var tratdpa = document.getElementById('tratdpa').value; 
       var tratnopa = document.getElementById('tratnopa').value;

       var dataens = 'trat='+trat +'&tratdpa='+tratdpa +'&tratnopa='+tratnopa;

       $.ajax({
                    type: "POST", //definimos el método de envío
                    url: "add_trat.php", //el archivo al cual se enviaran
                    data:dataens,
                    cache: false,
                    success: function(result){

                    swal(
                            'Agregado correctamente',
                            'Buen trabajo',
                            'success'
                          )
}
                }); 
    };
</script>






<script type="text/javascript">
    // MEDICAMENTOS
   function insertarmedicamentos(){
    var formulariom= $("#formmedicamentos").serialize();

   
    $.ajax({
        type: "POST",
        url: "add_medicamentos.php",
        data: formulariom,
        cache: false,
        success: function(result){
            console.log("Respuesta:", result);
            if(result.includes('Agregado correctamente')) {
                swal(
                    'Agregado correctamente',
                    'Buen trabajo',
                    'success'
                ).then(function() {
                    location.reload();
                });
            } else {
                swal(
                    'Error',
                    result,
                    'error'
                );
            }
        },
        error: function(xhr, status, error) {
            console.error("Error:", error);
            swal(
                'Error',
                'Ha ocurrido un problema: ' + error,
                'error'
            )
        }
    });
}
</script>




<script type="text/javascript">
   function insertariesgo(){
    
    var consl = document.getElementById('consl').value;
    var venfermedadd = document.getElementById('venfermedadd').value;
    var vfuma = document.getElementById('vfuma').value;
    var vhumo = document.getElementById('vhumo').value;
    var vconsumo = document.getElementById('vconsumo').value;
    var vsal = document.getElementById('vsal').value;
    var vcocina = document.getElementById('vcocina').value;
    var vvestir = document.getElementById('vvestir').value;
    var vdiahoy = document.getElementById('vdiahoy').value;
    var vmeshoy = document.getElementById('vmeshoy').value;
    var vanohoy = document.getElementById('vanohoy').value;
    var vmunicipio = document.getElementById('vmunicipio').value;
    var csidpa = document.getElementById('csidpa').value;
    var csnopa = document.getElementById('csnopa').value;
    var idEstudiante = document.getElementById('id_estudiante').value;

    console.log("consl:", consl);
    console.log("venfermedadd:", venfermedadd);
    console.log("vfuma:", vfuma);
    console.log("vhumo:", vhumo);
    console.log("vconsumo:", vconsumo);
    console.log("vsal:", vsal);
    console.log("vcocina:", vcocina);
    console.log("vvestir:", vvestir);
    console.log("vdiahoy:", vdiahoy);
    console.log("vmeshoy:", vmeshoy);
    console.log("vanohoy:", vanohoy);
    console.log("vmunicipio:", vmunicipio);
    
    console.log("csidpa:", csidpa);
    console.log("csnopa:", csnopa);

    var dataen = 'consl='+consl + '&csidpa='+csidpa +'&csnopa='+csnopa +'&id_estudiante='+idEstudiante +'&venfermedadd='+venfermedadd +'&vfuma='+vfuma +'&vhumo='+vhumo +'&vconsumo='+vconsumo +'&vsal='+vsal +'&vcocina='+vcocina +'&vvestir='+vvestir   
    +'&vdiahoy='+vdiahoy +'&vmeshoy='+vmeshoy +'&vanohoy='+vanohoy +'&vmunicipio='+vmunicipio ;
    console.log("dataen:", dataen);
    
    $.ajax({
        type: "POST",
        url: "add_riesgo.php",
        data: dataen,
        cache: false,
        success: function(result){
            console.log("Respuesta:", result);
            swal(
                'Agregado correctamente',
                'Buen trabajo',
                'success'
            )
        },
        error: function(xhr, status, error) {
            console.error("Error:", error);
            swal(
                'Error',
                'Ha ocurrido un problema: ' + error,
                'error'
            )
        }
    });
}
</script>




<script type="text/javascript">
   function insertartoral(){
    
    var formulario= $("#formtoral").serialize();

   
    $.ajax({
        type: "POST",
        url: "add_toral.php",
        data: formulario,
        cache: false,
        success: function(result){
            console.log("Respuesta:", result);
            swal(
                'Agregado correctamente',
                'Buen trabajo',
                'success'
            )
        },
        error: function(xhr, status, error) {
            console.error("Error:", error);
            swal(
                'Error',
                'Ha ocurrido un problema: ' + error,
                'error'
            )
        }
    });
}
</script>



<script type="text/javascript">
   function insertarsaludmental(){
    
    var formularios= $("#formsaludmental").serialize();

   
    $.ajax({
        type: "POST",
        url: "add_saludmental.php",
        data: formularios,
        cache: false,
        success: function(result){
            console.log("Respuesta:", result);
            swal(
                'Agregado correctamente',
                'Buen trabajo',
                'success'
            )
        },
        error: function(xhr, status, error) {
            console.error("Error:", error);
            swal(
                'Error',
                'Ha ocurrido un problema: ' + error,
                'error'
            )
        }
    });
}
</script>


<script type="text/javascript">
   function insertarfisioterapia(){
    
    var formulariof = $("#formfisioterapia").serialize();

   
    $.ajax({
        type: "POST",
        url: "add_fisioterapia.php",
        data: formulariof,
        cache: false,
        success: function(result){
            console.log("Respuesta:", result);
            if(result.includes('Agregado correctamente')) {
                swal(
                    'Agregado correctamente',
                    'Buen trabajo',
                    'success'
                ).then(function() {
                    location.reload();
                });
            } else {
                swal(
                    'Error',
                    result,
                    'error'
                );
            }
        },
        error: function(xhr, status, error) {
            console.error("Error:", error);
            swal(
                'Error',
                'Ha ocurrido un problema: ' + error,
                'error'
            )
        }
    });
}
</script>


<style>
.scroll-buttons {
    text-align: center;
    margin: 10px 0;
}
.scroll-buttons button {
    background-color: #007bff;
    border: none;
    color: white;
    padding: 8px 16px;
    font-size: 16px;
    border-radius: 5px;
    cursor: pointer;
    margin: 0 5px;
}
.scroll-buttons button:hover {
    background-color: #0056b3;
}
</style>



</body>
</html>
