<?php
    ob_start();
    session_start();
    
    // Incluir sistema de control de acceso
    require '../../backend/php/check_access.php';
    
    // Permitir acceso a: Administrador, Psicólogo, Fisioterapeuta, Enfermería
    checkAccess([1, 4, 5, 6]);
    
    $id=$_SESSION['id'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">

    <!-- Data Tables -->
    <link rel="stylesheet" type="text/css" href="../../backend/css/datatable.css">
    <link rel="stylesheet" type="text/css" href="../../backend/css/buttonsdataTables.css">
    <link rel="stylesheet" type="text/css" href="../../backend/css/font.css">




    <title>EFAC | Informe Estudiantes</title>
</head>
<body>
    
    <?php include '../../backend/php/sidebar_menu.php'; ?>


    <!-- NAVBAR -->
    <section id="content">
        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar' ></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Search...">
                    <i class='bx bx-search icon' ></i>
                </div>
            </form>
            
           
            <span class="divider"></span>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
              <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon' ></i> Profile</a></li>
                    
                    <li>
                     <a href="../salir.php"><i class='bx bxs-log-out-circle' ></i> Logout</a>
                    </li>
                   
                </ul>
            </div>
        </nav>
        <!-- NAVBAR -->

        <!-- MAIN -->
        <main>
            <h1 class="title">Bienvenido <?php echo '<strong>'.$_SESSION['username'].'</strong>'; ?></h1>
            <ul class="breadcrumbs">
                <li><a href="../dashboard.php">Home</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Informe Estudiantes</a></li>
            </ul>
            
            <div class="data">
                <div class="content-data">
                    <div class="head">
                        <h3>Estudiantes</h3>
                       
                    </div>
                    
                    <!-- Filtro por Modalidad -->
                    <div style="padding: 20px; background: white; margin-bottom: 20px; border-radius: 8px;">
                        <label for="filtroModalidad" style="font-weight: 600; margin-right: 10px; color: #333;">Filtrar por Modalidad:</label>
                        <select id="filtroModalidad" style="padding: 8px 15px; border: 2px solid #e8e8e8; border-radius: 6px; font-size: 14px; min-width: 250px;">
                            <option value="">Todas las modalidades</option>
                            <?php 
                            require '../../backend/bd/Conexion.php';
                            // Obtener modalidades únicas de la nueva tabla
                            $modalidades = $connect->query("SELECT DISTINCT modalidad FROM registro_estudiantes WHERE modalidad != '' ORDER BY modalidad");
                            while($mod = $modalidades->fetch(PDO::FETCH_ASSOC)) {
                                echo '<option value="'.htmlspecialchars($mod['modalidad']).'">'.htmlspecialchars($mod['modalidad']).'</option>';
                            }
                            ?>
                        </select>
                    </div>
                    
                   <div class="table-responsive" style="overflow-x:auto;">
                       <?php 
// Nueva consulta uniendo registro_estudiantes con users (opcional, si se necesita info de login)
// Asumimos que todos los estudiantes están en registro_estudiantes
$sentencia = $connect->prepare("SELECT * FROM registro_estudiantes ORDER BY id DESC;");
 $sentencia->execute();
$data =  array();
if($sentencia){
  while($r = $sentencia->fetchObject()){
    $data[] = $r;
  }
}
     ?>
     <?php if(count($data)>0):?>
         <table id="example" class="responsive-table">
            <thead>
                <tr>
                    <th scope="col">Documento</th>
                    <th scope="col">Estudiantes</th>
                    
                    <th scope="col">Género</th>
                    <th scope="col">Modalidad</th>
                    <th scope="col">Teléfono</th>
                    <th scope="col">Estado</th>
                    <th scope="col">Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($data as $d):?>
                    <tr data-modalidad="<?php echo htmlspecialchars($d->modalidad); ?>">
                        <th scope="row"><?php echo $d->numero_documento ?></th>
                        <td data-title="USUARIO"><?php echo strtoupper($d->nombres) ?>&nbsp;<?php echo strtoupper($d->apellidos) ?></td>
                        
                        <td data-title="Género"><?php echo strtoupper($d->genero) ?></td>
                        <td data-title="Modalidad"><?php echo strtoupper($d->modalidad) ?></td>
                        <td data-title="Teléfono"><a href="tel:<?php echo $d->telefono ?>"><?php echo $d->telefono ?></a></td>
                        
                        <td data-title="Estado">
    
                        <?php if($d->estado == 'aprobado' || $d->estado == '1' || $d->estado == 'Activo'): ?>
                            <span style="background: #27ae60; color: white; padding: 5px 10px; border-radius: 20px; font-size: 12px;">Activo</span>
                        <?php else: ?>
                            <span style="background: #e74c3c; color: white; padding: 5px 10px; border-radius: 20px; font-size: 12px;"><?php echo $d->estado; ?></span>
                        <?php endif; ?>

                        </td>
                        <td style="white-space: nowrap;">
                            <a title="Actualizar" href="../pacientes/editar.php?id=<?php echo $d->id ?>" class="fa fa-pencil tooltip" style="margin-right: 8px;"></a>
                            <a title="Información" href="../pacientes/info.php?id=<?php echo $d->id ?>" class="fa fa-info" style="margin-right: 8px;"></a>
                            <a title="Historial médico" href="../pacientes/historia.php?id=<?php echo $d->id ?>" class="fa fa-stethoscope" style="margin-right: 8px;"></a>
                            
                            <!-- Botón de eliminar actualizado -->
                            <form style="display: inline-block; margin: 0;" onsubmit="return confirm('¿Realmente desea eliminar/desactivar este registro?');" method='POST' action='<?php $_SERVER['PHP_SELF'] ?>'>
                                <input type='hidden' name='id_student_delete' value="<?php echo $d->id; ?>">
                                <button name='delete_student' title="Eliminar" style="cursor: pointer; margin: 0; background: none; border: none; color: #e74c3c;" class="fa fa-trash"></button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
            </tbody>
         </table> 
         <?php else:?>
  
    <div class="alert">
      <span class="closebtn" onclick="this.parentElement.style.display='none';">&times;</span> 
      <strong>Info!</strong> No hay estudiantes registrados.
    </div>
    <?php endif; ?>
                    </div>
                </div>
            </div>  

        </main>
        <!-- MAIN -->
    </section>
    <?php include_once '../../backend/php/delete_patients.php' ?>
    <!-- NAVBAR -->
    <script src="../../backend/js/jquery.min.js"></script>
    
    <script src="../../backend/js/script.js"></script>
    
    <!-- Data Tables -->
    <script type="text/javascript" src="../../backend/js/datatable.js"></script>
    <script type="text/javascript" src="../../backend/js/datatablebuttons.js"></script>
    <script type="text/javascript" src="../../backend/js/jszip.js"></script>
    <script type="text/javascript" src="../../backend/js/pdfmake.js"></script>
    <script type="text/javascript" src="../../backend/js/vfs_fonts.js"></script>
    <script type="text/javascript" src="../../backend/js/buttonshtml5.js"></script>
    <script type="text/javascript" src="../../backend/js/buttonsprint.js"></script>
    <script type="text/javascript">
$(document).ready(function() {
    $('#example').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );
    
    // Filtro por modalidad
    $('#filtroModalidad').on('change', function() {
        var modalidadSeleccionada = $(this).val().toUpperCase();
        
        $('#example tbody tr').each(function() {
            var modalidadFila = $(this).attr('data-modalidad').toUpperCase();
            
            if (modalidadSeleccionada === '' || modalidadFila === modalidadSeleccionada) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    });
} );
    </script>

 <script type="text/javascript">
    let popUp = document.getElementById("cookiePopup");
//When user clicks the accept button
document.getElementById("acceptCookie").addEventListener("click", () => {
  //Create date object
  let d = new Date();
  //Increment the current time by 1 minute (cookie will expire after 1 minute)
  d.setMinutes(2 + d.getMinutes());
  //Create Cookie withname = myCookieName, value = thisIsMyCookie and expiry time=1 minute
  document.cookie = "myCookieName=thisIsMyCookie; expires = " + d + ";";
  //Hide the popup
  popUp.classList.add("hide");
  popUp.classList.remove("shows");
});
//Check if cookie is already present
const checkCookie = () => {
  //Read the cookie and split on "="
  let input = document.cookie.split("=");
  //Check for our cookie
  if (input[0] == "myCookieName") {
    //Hide the popup
    popUp.classList.add("hide");
    popUp.classList.remove("shows");
  } else {
    //Show the popup
    popUp.classList.add("shows");
    popUp.classList.remove("hide");
  }
};
//Check if cookie exists when page loads
window.onload = () => {
  setTimeout(() => {
    checkCookie();
  }, 2000);
};
    </script>

</body>
</html>


