<?php 
ob_start(); // Capturar cualquier output no deseado
session_start();
require '../../backend/fpdf/fpdf.php';
date_default_timezone_set('America/Lima');

// Función auxiliar para convertir UTF-8 a ISO-8859-1 (reemplazo de utf8_decode)
function convertText($text) {
    if(empty($text)) return '';
    return mb_convert_encoding($text, 'ISO-8859-1', 'UTF-8');
}

class PDF extends FPDF
{
    function Header()
    {
        $this->Image('../../backend/img/ico.png',15,5,25);
        $this->Image('../../backend/img/neu.png',170,5,25);
        
        $this->SetFont('Arial', 'B', 14);
        $this->Cell(0, 10, convertText('PROGRAMA EFAC'), 0, 1, 'C');
        $this->SetFont('Arial', '', 10);
        $this->Cell(0, 5, convertText('Dr(a): '.$_SESSION['name']), 0, 1, 'C');
        $this->Cell(0, 5, convertText('Tel: 3229060608'), 0, 1, 'C');
        $this->Cell(0, 5, convertText('jhon.rubiano@sibate-cundinamarca.gov.co'), 0, 1, 'C');
        $this->Ln(3);
    }

    function Footer()
    {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(95,5,convertText('Página ').$this->PageNo().' / {nb}',0,0,'L');
        $this->Cell(95,5,date('d/m/Y | g:i:a'),0,1,'R');
        $this->Cell(0,5,convertText('© Todos los derechos reservados.'),0,0,'C');
    }
    
    function SectionTitle($title) {
        $this->SetFont('Arial', 'B', 11);
        $this->SetFillColor(102, 126, 234);
        $this->SetTextColor(255, 255, 255);
        $this->Cell(0, 8, convertText($title), 0, 1, 'L', true);
        $this->SetTextColor(0, 0, 0);
        $this->Ln(2);
    }
}
$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();

$pdf->SetAutoPageBreak(true, 20);
$pdf->SetTopMargin(15);
$pdf->SetLeftMargin(10);
$pdf->SetRightMargin(10);

require '../../backend/bd/Conexion.php';

function getStudentColumn(PDO $connection, string $table): string {
    static $cache = [];
    if(isset($cache[$table])) {
        return $cache[$table];
    }

    $allowedTables = [
        'valoracionriesgo','toral','saludmental','medicamentos',
        'consult','genogram','treatment','fisioterapia'
    ];
    if(!in_array($table, $allowedTables, true)) {
        throw new InvalidArgumentException("Tabla no permitida: {$table}");
    }

    try {
        $stmt = $connection->query("SHOW COLUMNS FROM {$table} LIKE 'id_estudiante'");
        if($stmt && $stmt->fetch()) {
            return $cache[$table] = 'id_estudiante';
        }
    } catch (Throwable $e) {
        // ignorar y continuar con fallback
    }

    return $cache[$table] = 'idpa';
}

$studentId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if($studentId <= 0) {
    die('ID inválido');
}

$id = $studentId;

// ========== DATOS DEL USUARIO ==========
$pdf->SectionTitle('DATOS DEL USUARIO');

$stmt = $connect->prepare("SELECT * FROM registro_estudiantes WHERE id = :id");
$stmt->execute([':id' => $id]);
$patient = $stmt->fetch(PDO::FETCH_ASSOC);

if($patient) {
    $pdf->SetFont('Arial','B',9);
    $pdf->Cell(30, 8, convertText('Documento'),1,0,'C',true);
    $pdf->Cell(50, 8, convertText('Nombre'),1,0,'C',true);
    $pdf->Cell(50, 8, convertText('Apellido'),1,0,'C',true);
    $pdf->Cell(30, 8, convertText('Nacimiento'),1,0,'C',true);
    $pdf->Cell(20, 8, convertText('Género'),1,0,'C',true);
    $pdf->Cell(10, 8, convertText('Sangre'),1,1,'C',true);
    
    $pdf->SetFont('Arial','',9);
    $pdf->Cell(30, 8, convertText($patient['numero_documento']),1,0,'C');
    $pdf->Cell(50, 8, convertText($patient['nombres']),1,0,'L');
    $pdf->Cell(50, 8, convertText($patient['apellidos']),1,0,'L');
    $pdf->Cell(30, 8, convertText($patient['fecha_nacimiento']),1,0,'C');
    $pdf->Cell(20, 8, convertText($patient['genero']),1,0,'C');
    $pdf->Cell(10, 8, convertText($patient['grupo_sanguineo']),1,1,'C');
    $pdf->Ln(5);
}

// ========== VALORACION DEL RIESGO SOCIAL ==========
$pdf->SectionTitle('DIAGNOSTICO INICIAL');

$riesgoColumn = getStudentColumn($connect, 'valoracionriesgo');
$riesgo = $connect->prepare("SELECT * FROM valoracionriesgo WHERE {$riesgoColumn} = :id ORDER BY fere DESC");
$riesgo->execute([':id' => $id]);
$dataRiesgo = $riesgo->fetchAll(PDO::FETCH_ASSOC);

if(count($dataRiesgo) > 0) {
    foreach($dataRiesgo as $r) {
        // Separador entre registros
        $pdf->SetFillColor(230, 230, 230);
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(190, 5, convertText('Registro del: ' . $r['fere']), 0, 1, 'C', true);
        $pdf->Ln(1);
        
        $pdf->SetFont('Arial','B',7);
        // Fila 1
        $pdf->Cell(30, 5, convertText('Nivel Desempeño'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($r['niveldesempeño']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Conocimientos Consolidados'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(70, 5, convertText($r['Conocimientosconsolidados']),1,1,'L');
        
        // Fila 2
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Conocimientos previos'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($r['Conocimientosprevios']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Gestión Cognitivo'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(70, 5, convertText($r['Habilidadescognitivas']),1,1,'L');
        
        // Fila 3
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Gestión procedimental'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($r['Habilidadesprocedimentales']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Fallas de aprendizaje'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(70, 5, convertText($r['Dificultadesaprendizaje']),1,1,'L');
        
        // Fila 4
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Estrategias estudiantiles'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($r['estrategiasestudiante']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Modo de aprendizaje'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(70, 5, convertText($r['estiloaprendizaje']),1,1,'L');
        
        // Fila 5
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Proceso de aprendizaje'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($r['Procesoaprendizaje']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Grado de autonomía'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(70, 5, convertText($r['Autonomiaacademica']),1,1,'L');
        
        // Fila 6
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Observación pedagógica'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(160, 5, convertText($r['Observacionespedagogicas']),1,1,'L');
        
        $pdf->Ln(2);
    }
    $pdf->Ln(3);
} else {
    $pdf->SetFont('Arial','I',9);
    $pdf->Cell(0, 6, convertText('No hay datos registrados'),0,1,'L');
    $pdf->Ln(3);
}

// ========== TAMIZAJE SALUD ORAL ==========
$pdf->SectionTitle('DESARROLLO DE HABILIDADES ARTISTICAS');

$oralColumn = getStudentColumn($connect, 'toral');
$oral = $connect->prepare("SELECT * FROM toral WHERE {$oralColumn} = :id ORDER BY fere DESC");
$oral->execute([':id' => $id]);
$dataOral = $oral->fetchAll(PDO::FETCH_ASSOC);

if(count($dataOral) > 0) {
    foreach($dataOral as $o) {
        // Separador entre registros
        $pdf->SetFillColor(230, 230, 230);
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(190, 5, convertText('Registro del: ' . $o['fere']), 0, 1, 'C', true);
        $pdf->Ln(1);
        
        $pdf->SetFont('Arial','B',7);
        // Fila 1
        $pdf->Cell(35, 5, convertText('Creatividad'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['Creatividad']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Expresion artistica'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['Expresionartistica']),1,1,'L');
        
        // Fila 2
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Tecnica'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['Tecnica']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Sensibilidad estetica'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['Sensibilidadestetica']),1,1,'L');
        
        // Fila 3
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Disciplina y constancia'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['Disciplinaconstancia']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Trabajo en equipo'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['trabajoequipo']),1,1,'L');
        
        // Fila 4
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Interpretacion'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['Interpretacion']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Control corporal'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['Controlcorporal']),1,1,'L');
        
        // Fila 5
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Ritmo y musica'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['Ritmomusica']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Observacion y percepcion.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['Observacionpersep']),1,1,'L');
        
        // Fila 6
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Imaginacion'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['Imaginacion']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Autonomia'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['Autonomia']),1,1,'L');
        
        // Fila 7
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Comunicacion.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(155, 5, convertText($o['comunicacion']),1,1,'L');
        
        // Fila 8 - Observaciones
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Observaciones'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->MultiCell(155, 5, convertText($o['observaciones']),1,'L');
        
        $pdf->Ln(2);
    }
    $pdf->Ln(3);
} else {
    $pdf->SetFont('Arial','I',9);
    $pdf->Cell(0, 6, convertText('No hay datos registrados'),0,1,'L');
    $pdf->Ln(3);
}

// ========== TAMIZAJE SALUD MENTAL ==========
$pdf->SectionTitle('DISCIPLINA Y ACTITUD');

$mentalColumn = getStudentColumn($connect, 'saludmental');
$mental = $connect->prepare("SELECT * FROM saludmental WHERE {$mentalColumn} = :id ORDER BY fere DESC");
$mental->execute([':id' => $id]);
$dataMental = $mental->fetchAll(PDO::FETCH_ASSOC);

if(count($dataMental) > 0) {
    foreach($dataMental as $sm) {
        // Separador entre registros
        $pdf->SetFillColor(230, 230, 230);
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(190, 5, convertText('Registro del: ' . $sm['fere']), 0, 1, 'C', true);
        $pdf->Ln(1);
        
        $pdf->SetFont('Arial','B',6);
        // Fila 1
        $pdf->Cell(47, 4, convertText('Puntualidad'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Puntualidad']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Asistencia'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Asistencia']),1,1,'L');
        
        // Fila 2
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Responsabilidad'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Responsabilidad']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('respeto'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['respeto']),1,1,'L');
        
        // Fila 3
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Compromiso'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Compromiso']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Actitud Positiva'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['actitudpositiva']),1,1,'L');
        
        // Fila 4
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Trabajo en equipo'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['trabajoequipo']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Seguimiento de instrucciones'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['seguimientoinstruciones']),1,1,'L');
        
        // Fila 5
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Autocontrol'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Autocontrol']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('cuidado de materiales'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['cuidadomateriales']),1,1,'L');
        
        // Fila 6
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Participacion activa'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['participacionactiva']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Esfuerzo y dedicacion'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['esfuerzodedicacion']),1,1,'L');
        
        // Fila 7
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Tolerancia'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Tolerancia']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Dispocision al cambio'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Disposioncambio']),1,1,'L');
        
        // Fila 8
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Convivencia'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Convivencia']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Prevencion personal'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Prevencionpersonal']),1,1,'L');
        
        // Fila 9
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Honestidad'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Honestidad']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('etica'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['etica']),1,1,'L');
        
        // Fila 10
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('empatia'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['empatia']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Comunidad,asertiva'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['comunidadasertiva']),1,1,'L');
        
        // Fila 11
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Cooperacion'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Cooperacion']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Proactividad'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['proactividad']),1,1,'L');
        
        // Fila 12
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Perseverancia'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Perseverancia']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Cumplimiento de normas'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Cumplimientonormas']),1,1,'L');
        
        // Fila 13
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Organización personal'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Organizaciónpersonal']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Manejo del tiempo'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Manejotiempo']),1,1,'L');
        
        // Fila 14
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Resolución de conflictos'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Resoluciónconflictos']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Adaptabilidad'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Adaptabilidad']),1,1,'L');
        
        // Fila 15
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Iniciativa'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Iniciativa']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Respeto por la autoridad'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Respetoautoridad']),1,1,'L');
        
        // Fila 16
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Responsabilidad social'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Responsabilidadsocial']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Escucha activa'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Escuchaactiva']),1,1,'L');
        
        // Fila 17
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Toma de decisiones'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Tomadecisiones']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Control de impulsos'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Controlimpulsos']),1,1,'L');
        
        // Fila 18
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Constancia'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Constancia']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Actitud de servicio'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['Actitudservicio']),1,1,'L');
        
        // Fila 19
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Liderazgo positivo'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(143, 4, convertText($sm['Liderazgopositivo']),1,1,'L');
        
        $pdf->Ln(2);
    }
    $pdf->Ln(3);
} else {
    $pdf->SetFont('Arial','I',9);
    $pdf->Cell(0, 6, convertText('No hay datos registrados'),0,1,'L');
    $pdf->Ln(3);
}

// ========== MEDICAMENTOS ==========
$pdf->SectionTitle('TRABAJO EN EQUIPO Y CONVIVENCIA');

$medicColumn = getStudentColumn($connect, 'medicamentos');
$medic = $connect->prepare("SELECT * FROM medicamentos WHERE {$medicColumn} = :id ORDER BY fere DESC");
$medic->execute([':id' => $id]);
$dataMedic = $medic->fetchAll(PDO::FETCH_ASSOC);

if(count($dataMedic) > 0) {
    foreach($dataMedic as $m) {
        // Separador entre registros
        $pdf->SetFillColor(230, 230, 230);
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(190, 5, convertText('Registro del: ' . $m['fere']), 0, 1, 'C', true);
        $pdf->Ln(1);
        
        $pdf->SetFont('Arial','B',7);
        // Fila 1
        $pdf->Cell(40, 5, convertText('Comunicación asertiva'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['tomam']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Respeto mutuo'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['cualm']),1,1,'L');
        
        // Fila 2
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Colaboración'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['prescripcion']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Resolución pacífica'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['automedicacion']),1,1,'L');
        
        // Fila 3
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Empatía'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['quirurgicos']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Responsabilidad comp.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['hospitalizacion']),1,1,'L');
        
        // Fila 4
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Liderazgo particip.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['traumaticos']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Toma de decisiones'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['hipertencion']),1,1,'L');
        
        // Fila 5
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Escucha activa'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['toxico']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Confianza interper.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['alergico']),1,1,'L');
        
        // Fila 6
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Manejo de emociones'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['infeccioso']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Solidaridad'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['enfermedadr']),1,1,'L');
        
        // Fila 7
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Compromiso colec.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['ulcera']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Inclusión y div.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['lepra']),1,1,'L');
        
        // Fila 8
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Cumplimiento normas'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['diabetes']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Cooperación'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['asma']),1,1,'L');
        
        // Fila 9
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Sentido pertenencia'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['cancer']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Trabajo colaborat.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['epoc']),1,1,'L');
        
        // Fila 10
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Adaptabilidad'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['epilepsia']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Ética y valores'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['autoinmunes']),1,1,'L');
        
        // Fila 11
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Apoyo mutuo'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['ingresourgencias']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Clima organizacional'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['otrom']),1,1,'L');
        
        $pdf->Ln(2);
    }
    $pdf->Ln(3);
} else {
    $pdf->SetFont('Arial','I',9);
    $pdf->Cell(0, 6, convertText('No hay datos registrados'),0,1,'L');
    $pdf->Ln(3);
}

// ========== VALORACION FISICA Y DE SEGUIMIENTO ==========
$pdf->SectionTitle('PRESENTACIONES Y PARTICIPACION DE EVENTOS');

$consultColumn = getStudentColumn($connect, 'consult');
$consult = $connect->prepare("SELECT * FROM consult WHERE {$consultColumn} = :id ORDER BY fere DESC");
$consult->execute([':id' => $id]);
$dataConsult = $consult->fetchAll(PDO::FETCH_ASSOC);

if(count($dataConsult) > 0) {
    foreach($dataConsult as $c) {
        // Separador entre registros
        $pdf->SetFillColor(230, 230, 230);
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(190, 5, convertText('Registro del: ' . $c['fere']), 0, 1, 'C', true);
        $pdf->Ln(1);
        
        // Fecha y Motivo
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Fecha'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(145, 5, convertText($c['fere']),1,1,'L');
        
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Expresión oral'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->MultiCell(145, 5, convertText($c['mtcl']),1,'L');
        
        // Fila 1 - Signos Vitales
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Dominio del tema'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['SV']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Preparación conten.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['FC']),1,1,'L');
        
        // Fila 2
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Uso del lenguaje'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['FR']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Comunicación verb.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['TMP']),1,1,'L');
        
        // Fila 3
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Com. no verbal'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['T']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Manejo del tiempo'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['P']),1,1,'L');
        
        // Fila 4
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Claridad y coher.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['IMC']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Ayudas visuales'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['PA']),1,1,'L');
        
        // Fila 5
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Creatividad'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['PC']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Seguridad y confi.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['GL']),1,1,'L');
        
        // Fila 6
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Capacidad argum.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['TV']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Interacción pública'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['TA']),1,1,'L');
        
        // Fila 7
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Participación act.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['CB_CL']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Investigación prev.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['NEU']),1,1,'L');
        
        // Fila 8
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Organización ideas'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['TRX']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Adaptación cont.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['DOR']),1,1,'L');
        
        // Fila 9
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Manejo recursos'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['ABD']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Improvisación'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['PIE']),1,1,'L');
        
        // Fila 10
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Respeto normas'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['GUN']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Trabajo en equipo'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['EXT']),1,1,'L');
        
        // Fila 11
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Retroalimentación'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(145, 5, convertText($c['LIM']),1,1,'L');
        
        $pdf->Ln(2);
    }
    $pdf->Ln(3);
} else {
    $pdf->SetFont('Arial','I',9);
    $pdf->Cell(0, 6, convertText('No hay datos registrados'),0,1,'L');
    $pdf->Ln(3);
}

// ========== EVOLUCIONES ==========
$pdf->SectionTitle('ACOMPAÑAMIENTO FAMILIAR Y TRABAJO EN CASA ');

$genogramColumn = getStudentColumn($connect, 'genogram');
$genogram = $connect->prepare("SELECT * FROM genogram WHERE {$genogramColumn} = :id ORDER BY fere DESC");
$genogram->execute([':id' => $id]);
$dataGeno = $genogram->fetchAll(PDO::FETCH_ASSOC);

if(count($dataGeno) > 0) {
    foreach($dataGeno as $g) {
        // Separador entre registros
        $fechaRegistro = (!empty($g['fere']) && $g['fere'] != '0000-00-00 00:00:00') ? $g['fere'] : 'Sin fecha registrada';
        $pdf->SetFillColor(230, 230, 230);
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(190, 5, convertText('Registro del: ' . $fechaRegistro), 0, 1, 'C', true);
        $pdf->Ln(1);
        
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(30, 6, convertText('Fecha'),1,0,'L',true);
        $pdf->SetFont('Arial','',8);
        $pdf->Cell(160, 6, convertText($fechaRegistro),1,1,'L');
        
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(30, 6, convertText('Detalle'),1,0,'L',true);
        $pdf->SetFont('Arial','',8);
        $pdf->MultiCell(160, 6, convertText($g['detage']),1,'L');
        
        $pdf->Ln(2);
    }
    $pdf->Ln(3);
} else {
    $pdf->SetFont('Arial','I',9);
    $pdf->Cell(0, 6, convertText('No hay datos registrados'),0,1,'L');
    $pdf->Ln(3);
}

// ========== TRATAMIENTOS ==========
$pdf->SectionTitle('COMPROMISO Y RESPONSABILIDAD');

$treatmentColumn = getStudentColumn($connect, 'treatment');
$treatment = $connect->prepare("SELECT * FROM treatment WHERE {$treatmentColumn} = :id ORDER BY fere DESC");
$treatment->execute([':id' => $id]);
$dataTreat = $treatment->fetchAll(PDO::FETCH_ASSOC);

if(count($dataTreat) > 0) {
    foreach($dataTreat as $t) {
        // Separador entre registros
        $fechaRegistro = (!empty($t['fere']) && $t['fere'] != '0000-00-00 00:00:00') ? $t['fere'] : 'Sin fecha registrada';
        $pdf->SetFillColor(230, 230, 230);
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(190, 5, convertText('Registro del: ' . $fechaRegistro), 0, 1, 'C', true);
        $pdf->Ln(1);
        
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(30, 6, convertText('Fecha'),1,0,'L',true);
        $pdf->SetFont('Arial','',8);
        $pdf->Cell(160, 6, convertText($fechaRegistro),1,1,'L');
        
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(30, 6, convertText('Paciente'),1,0,'L',true);
        $pdf->SetFont('Arial','',8);
        $pdf->Cell(160, 6, convertText($t['nompa']),1,1,'L');
        
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(30, 6, convertText('Tratamiento'),1,0,'L',true);
        $pdf->SetFont('Arial','',8);
        $pdf->MultiCell(160, 6, convertText($t['nomtra']),1,'L');
        
        $pdf->Ln(2);
    }
    $pdf->Ln(3);
} else {
    $pdf->SetFont('Arial','I',9);
    $pdf->Cell(0, 6, convertText('No hay datos registrados'),0,1,'L');
    $pdf->Ln(3);
}

// ========== FISIOTERAPIA ==========
$pdf->SectionTitle('FISIOTERAPIA');

$fisioColumn = getStudentColumn($connect, 'fisioterapia');
$fisio = $connect->prepare("SELECT * FROM fisioterapia WHERE {$fisioColumn} = :id AND state = 1 ORDER BY fere DESC");
$fisio->execute([':id' => $id]);
$dataFisio = $fisio->fetchAll(PDO::FETCH_ASSOC);

if(count($dataFisio) > 0) {
    foreach($dataFisio as $f) {
        // Separador entre registros
        $fechaRegistro = (!empty($f['fere']) && $f['fere'] != '0000-00-00 00:00:00') ? $f['fere'] : 'Sin fecha registrada';
        $pdf->SetFillColor(230, 230, 230);
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(190, 5, convertText('Registro del: ' . $fechaRegistro), 0, 1, 'C', true);
        $pdf->Ln(1);
        
        // Fecha y Usuario
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Fecha'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(145, 5, convertText($fechaRegistro),1,1,'L');
        
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Usuario'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(145, 5, convertText($f['nompa']),1,1,'L');
        
        // Fila 1
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Sentarse/Levantarse'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($f['sentarse_levantarse']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Flexiones de Brazo'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($f['flexiones_brazo']),1,1,'L');
        
        // Fila 2
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Flexión de Tronco'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($f['flexion_tronco']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Juntar Manos Atrás'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($f['juntar_manos_atras']),1,1,'L');
        
        // Fila 3
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Test de Romberg'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($f['romberg']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('IPAQ'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($f['ipaq']),1,1,'L');
        
        // Fila 4
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Alcance Funcional'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($f['alcance_funcional']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Índice de BARTHEL'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($f['barthel']),1,1,'L');
        
        // Fila 5 - Funcionalidad (full width)
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Funcionalidad'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->MultiCell(145, 5, convertText($f['funcionalidad']),1,'L');
        
        $pdf->Ln(2);
    }
    $pdf->Ln(3);
} else {
    $pdf->SetFont('Arial','I',9);
    $pdf->Cell(0, 6, convertText('No hay datos registrados'),0,1,'L');
    $pdf->Ln(3);
}

    // Limpiar el buffer de salida antes de generar el PDF
    ob_end_clean();
    $pdf->Output('efac.pdf', 'D');
 ?>